/*
 * Decompiled with CFR 0.152.
 */
package net.sf.okapi.filters.openxml;

import java.io.Reader;
import java.util.LinkedHashMap;
import java.util.Map;
import javax.xml.stream.XMLEventFactory;
import javax.xml.stream.XMLInputFactory;
import javax.xml.stream.XMLStreamException;
import net.sf.okapi.filters.openxml.ConditionalParameters;
import net.sf.okapi.filters.openxml.Markup;
import net.sf.okapi.filters.openxml.ParagraphBlockProperties;
import net.sf.okapi.filters.openxml.PresentationNotesStyleDefinition;
import net.sf.okapi.filters.openxml.PresentationNotesStyleDefinitionsReader;
import net.sf.okapi.filters.openxml.RunProperties;
import net.sf.okapi.filters.openxml.StyleDefinitions;

class PresentationNotesStyleDefinitions
implements StyleDefinitions {
    private final ConditionalParameters conditionalParameters;
    private final XMLInputFactory inputFactory;
    private final XMLEventFactory eventFactory;
    private PresentationNotesStyleDefinition documentDefaults;
    private Map<String, PresentationNotesStyleDefinition> stylesByStyleIds;

    PresentationNotesStyleDefinitions(ConditionalParameters conditionalParameters, XMLInputFactory inputFactory, XMLEventFactory eventFactory) {
        this.conditionalParameters = conditionalParameters;
        this.inputFactory = inputFactory;
        this.eventFactory = eventFactory;
    }

    @Override
    public void readWith(Reader reader) throws XMLStreamException {
        this.stylesByStyleIds = new LinkedHashMap<String, PresentationNotesStyleDefinition>();
        PresentationNotesStyleDefinitionsReader styleDefinitionsReader = new PresentationNotesStyleDefinitionsReader(this.conditionalParameters, this.inputFactory, this.eventFactory, reader);
        this.documentDefaults = styleDefinitionsReader.readDocumentDefaults();
        while (styleDefinitionsReader.hasNextParagraphLevel()) {
            this.place(styleDefinitionsReader.readNextParagraphLevel());
        }
    }

    private void place(PresentationNotesStyleDefinition styleDefinition) {
        this.stylesByStyleIds.put(styleDefinition.id(), styleDefinition);
    }

    @Override
    public void place(String parentId, ParagraphBlockProperties paragraphBlockProperties, RunProperties runProperties) {
    }

    @Override
    public String placedId() {
        return null;
    }

    @Override
    public RunProperties combinedRunProperties(String paragraphLevelId, String runStyle, RunProperties runProperties) {
        RunProperties combinedRunProperties = RunProperties.copiedRunProperties(this.getParagraphLevelProperties(paragraphLevelId));
        combinedRunProperties = combinedRunProperties.combineDistinct(RunProperties.copiedRunProperties(runProperties), StyleDefinitions.TraversalStage.DIRECT);
        return combinedRunProperties;
    }

    private RunProperties getParagraphLevelProperties(String paragraphLevelId) {
        if (null == paragraphLevelId) {
            return this.documentDefaults.runProperties();
        }
        int id = Integer.valueOf(paragraphLevelId) + 1;
        return this.stylesByStyleIds.get(String.valueOf(id)).runProperties();
    }

    @Override
    public Markup toMarkup() {
        throw new UnsupportedOperationException();
    }
}

