/*
 * Decompiled with CFR 0.152.
 */
package net.sf.okapi.filters.openxml;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Deque;
import java.util.Iterator;
import java.util.LinkedList;
import javax.xml.namespace.QName;
import javax.xml.stream.XMLEventReader;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.events.Attribute;
import javax.xml.stream.events.Characters;
import javax.xml.stream.events.EndElement;
import javax.xml.stream.events.StartElement;
import javax.xml.stream.events.XMLEvent;
import net.sf.okapi.common.IdGenerator;
import net.sf.okapi.common.resource.TextFragment;
import net.sf.okapi.filters.openxml.Block;
import net.sf.okapi.filters.openxml.BlockParser;
import net.sf.okapi.filters.openxml.BlockSkippableElements;
import net.sf.okapi.filters.openxml.Chunk;
import net.sf.okapi.filters.openxml.ConsumableXMLEventsReader;
import net.sf.okapi.filters.openxml.MarkupComponentFactory;
import net.sf.okapi.filters.openxml.MarkupComponentParser;
import net.sf.okapi.filters.openxml.Namespaces;
import net.sf.okapi.filters.openxml.ParagraphBlockProperties;
import net.sf.okapi.filters.openxml.Parser;
import net.sf.okapi.filters.openxml.Run;
import net.sf.okapi.filters.openxml.RunBuilder;
import net.sf.okapi.filters.openxml.RunContainer;
import net.sf.okapi.filters.openxml.RunProperties;
import net.sf.okapi.filters.openxml.RunPropertiesParser;
import net.sf.okapi.filters.openxml.RunProperty;
import net.sf.okapi.filters.openxml.RunSkippableElements;
import net.sf.okapi.filters.openxml.SkippableElement;
import net.sf.okapi.filters.openxml.SkippableElements;
import net.sf.okapi.filters.openxml.StartElementContext;
import net.sf.okapi.filters.openxml.StartElementContextFactory;
import net.sf.okapi.filters.openxml.StrippableAttributes;
import net.sf.okapi.filters.openxml.StyleDefinitions;
import net.sf.okapi.filters.openxml.StyleOptimisation;
import net.sf.okapi.filters.openxml.TranslatableAttributeText;
import net.sf.okapi.filters.openxml.XMLEventHelpers;
import net.sf.okapi.filters.openxml.XMLEventsReader;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class RunParser
implements Parser<RunBuilder> {
    private final Logger LOGGER = LoggerFactory.getLogger(this.getClass());
    private static final String UNEXPECTED_STRUCTURE = "Unexpected structure: ";
    private static final int COMPLEX_FIELD_INITIAL_NESTING_LEVEL = 1;
    private static final QName COMPLEX_FIELD_CHARACTER_TYPE = Namespaces.WordProcessingML.getQName("fldCharType");
    private static final String COMPLEX_FIELD_CHARACTER = "fldChar";
    private static final String COMPLEX_FIELD_INSTRUCTION = "instrText";
    private static final String BEGIN = "begin";
    private static final String SEPARATE = "separate";
    private static final String END = "end";
    private final StartElementContext startElementContext;
    private final IdGenerator nestedTextualIds;
    private final StyleDefinitions styleDefinitions;
    private final StyleOptimisation styleOptimisation;
    private final String paragraphStyle;
    private final RunBuilder runBuilder;
    private final StrippableAttributes.General generalStrippableAttributes;
    private final StrippableAttributes.RunRevisions runRevisions;
    private final StrippableAttributes.ParagraphRevisions paragraphRevisions;
    private final SkippableElements defaultSkippableElements;
    private final SkippableElements blockPropertiesSkippableElements;
    private final RunSkippableElements runSkippableElements;
    private final BlockSkippableElements blockSkippableElements;
    private int complexFieldNestingLevel;

    RunParser(StartElementContext startElementContext, IdGenerator nestedTextualIds, StyleDefinitions styleDefinitions, StyleOptimisation styleOptimisation, String paragraphStyle, boolean hidden) {
        this.generalStrippableAttributes = new StrippableAttributes.General(startElementContext.getConditionalParameters(), startElementContext.getEventFactory());
        this.runRevisions = new StrippableAttributes.RunRevisions(startElementContext.getEventFactory());
        this.paragraphRevisions = new StrippableAttributes.ParagraphRevisions(startElementContext.getEventFactory());
        this.startElementContext = StartElementContextFactory.createStartElementContext(this.runRevisions.strip(startElementContext.getStartElement()), startElementContext);
        this.nestedTextualIds = nestedTextualIds;
        this.styleDefinitions = styleDefinitions;
        this.styleOptimisation = styleOptimisation;
        this.paragraphStyle = paragraphStyle;
        this.runBuilder = new RunBuilder(this.startElementContext, styleDefinitions);
        this.runBuilder.setHidden(hidden);
        this.defaultSkippableElements = new SkippableElements.Default(new SkippableElement[0]);
        this.blockPropertiesSkippableElements = new SkippableElements.RevisionProperty(new SkippableElements.Property(new SkippableElements.Default(SkippableElement.BlockProperty.BLOCK_PROPERTY_BIDI, SkippableElement.RunProperty.RUN_PROPERTY_RTL, SkippableElement.RunProperty.RUN_PROPERTY_LANGUAGE, SkippableElement.RevisionProperty.RUN_PROPERTY_INSERTED_PARAGRAPH_MARK, SkippableElement.RevisionProperty.RUN_PROPERTY_MOVED_PARAGRAPH_TO, SkippableElement.RevisionProperty.RUN_PROPERTY_MOVED_PARAGRAPH_FROM, SkippableElement.RevisionProperty.PARAGRAPH_PROPERTIES_CHANGE, SkippableElement.RevisionProperty.RUN_PROPERTIES_CHANGE), startElementContext.getConditionalParameters()), startElementContext.getConditionalParameters());
        this.runSkippableElements = new RunSkippableElements(startElementContext);
        this.blockSkippableElements = new BlockSkippableElements(startElementContext);
    }

    @Override
    public RunBuilder parse() throws XMLStreamException {
        this.log("startRun: " + this.startElementContext.getStartElement());
        XMLEvent firstChild = this.startElementContext.getEventReader().nextTag();
        if (XMLEventHelpers.isRunPropsStartEvent(firstChild)) {
            this.parseRunProperties(firstChild.asStartElement());
        } else {
            if (XMLEventHelpers.isEndElement(firstChild, this.startElementContext.getStartElement())) {
                return this.endRunParsing(firstChild.asEndElement());
            }
            this.startRunParsing(firstChild);
            if (!(this.paragraphStyle != null && !this.paragraphStyle.isEmpty() || this.startElementContext.getConditionalParameters().getTranslateWordInExcludeStyleMode() || this.runBuilder.isHidden())) {
                this.runBuilder.setHidden(true);
            }
            if (!this.startElementContext.getConditionalParameters().getTranslateWordInExcludeHighlightMode() && !this.runBuilder.isHidden()) {
                this.runBuilder.setHidden(true);
            }
        }
        while (this.startElementContext.getEventReader().hasNext()) {
            XMLEvent e = this.startElementContext.getEventReader().nextEvent();
            this.log("processRun: " + e);
            if (XMLEventHelpers.isEndElement(e, this.startElementContext.getStartElement())) {
                return this.endRunParsing(e.asEndElement());
            }
            this.startRunParsing(e);
        }
        throw new IllegalStateException("Invalid content? Unterminated run");
    }

    private RunBuilder endRunParsing(EndElement e) {
        this.runBuilder.flushText();
        this.runBuilder.flushMarkup();
        this.runBuilder.setEndEvent(e);
        if (!this.runBuilder.hasNonWhitespaceText() && this.startElementContext.getConditionalParameters().getCleanupAggressively()) {
            this.runBuilder.setRunProperties(RunProperties.copiedRunProperties(this.runBuilder.getRunProperties(), true, false, false));
        }
        return this.runBuilder;
    }

    private void startRunParsing(XMLEvent e) throws XMLStreamException {
        if (XMLEventHelpers.isParagraphStartEvent(e)) {
            this.parseNestedBlock(e.asStartElement());
        } else if (RunParser.isComplexFieldBegin(e)) {
            this.parseComplexField(e.asStartElement());
            this.runBuilder.setContainsComplexFields(true);
        } else if (!this.parseSkippableElements(e)) {
            this.parseContent(this.processTranslatableAttributes(e), this.startElementContext.getEventReader());
        }
    }

    private void parseRunProperties(StartElement startElement) throws XMLStreamException {
        StartElementContext runPropertiesElementContext = StartElementContextFactory.createStartElementContext(startElement, this.runBuilder.getStartElementContext());
        RunProperties direct = new RunPropertiesParser(runPropertiesElementContext, this.runSkippableElements).parse();
        String runStyle = null == direct.getRunStyleProperty() ? null : direct.getRunStyleProperty().getValue();
        this.runBuilder.setRunProperties(direct.minified(this.styleDefinitions.combinedRunProperties(this.paragraphStyle, runStyle, new RunProperties.Empty())));
        RunProperty.HighlightRunProperty highlightRunProperty = this.runBuilder.getRunProperties().getHighlightProperty();
        RunProperty.ColorRunProperty colorRunProperty = this.runBuilder.getRunProperties().getRunColorProperty();
        if (runStyle != null) {
            this.runBuilder.setRunStyle(runStyle);
            if (this.startElementContext.getConditionalParameters().getTranslateWordInExcludeStyleMode()) {
                this.runBuilder.setHidden(this.startElementContext.getConditionalParameters().isWordExcludedStyle(runStyle));
            } else {
                this.runBuilder.setHidden(!this.startElementContext.getConditionalParameters().isWordExcludedStyle(runStyle));
            }
        }
        if (highlightRunProperty != null) {
            if (this.startElementContext.getConditionalParameters().getTranslateWordInExcludeHighlightMode() && !this.runBuilder.isHidden()) {
                this.runBuilder.setHidden(this.startElementContext.getConditionalParameters().isWordHighlightColor(highlightRunProperty.getValue()));
            } else {
                this.runBuilder.setHidden(!this.startElementContext.getConditionalParameters().isWordHighlightColor(highlightRunProperty.getValue()));
            }
        }
        if (colorRunProperty != null && this.startElementContext.getConditionalParameters().getTranslateWordExcludeColors() && !this.runBuilder.isHidden()) {
            this.runBuilder.setHidden(this.startElementContext.getConditionalParameters().isWordExcludedColor(colorRunProperty.getValue()));
        }
    }

    private void parseNestedBlock(StartElement startElement) throws XMLStreamException {
        StyleOptimisation styleOptimisation;
        StyleDefinitions styleDefinitions;
        this.log("Nested block start event: " + startElement);
        this.runBuilder.flushText();
        StartElementContext blockElementContext = StartElementContextFactory.createStartElementContext(startElement, this.startElementContext);
        if ("a".equals(startElement.getName().getPrefix())) {
            styleDefinitions = new StyleDefinitions.Empty();
            styleOptimisation = new StyleOptimisation.Default(new StyleOptimisation.Bypass(), this.startElementContext.getConditionalParameters(), this.startElementContext.getEventFactory(), new QName(startElement.getName().getNamespaceURI(), "pPr", startElement.getName().getPrefix()), new QName(startElement.getName().getNamespaceURI(), "defRPr", startElement.getName().getPrefix()), Collections.emptyList(), styleDefinitions);
        } else {
            styleDefinitions = this.runBuilder.getStyleDefinitions();
            styleOptimisation = this.styleOptimisation;
        }
        BlockParser nestedBlockParser = new BlockParser(blockElementContext, this.nestedTextualIds, styleDefinitions, styleOptimisation);
        Block nested = nestedBlockParser.parse();
        nested.optimiseStyles();
        this.runBuilder.setContainsNestedItems(true);
        if (nested.hasVisibleRunContent()) {
            this.runBuilder.addToMarkup(this.startElementContext.getEventFactory().createCharacters(TextFragment.makeRefMarker(this.nestedTextualIds.createId())));
            this.runBuilder.getNestedTextualItems().add(nested);
        } else {
            for (XMLEvent nestedEvent : nested.getEvents()) {
                this.runBuilder.addToMarkup(nestedEvent);
            }
            for (Chunk chunk : nested.getChunks()) {
                if (chunk instanceof Run) {
                    this.runBuilder.getNestedTextualItems().addAll(((Run)chunk).getNestedTextualItems());
                    continue;
                }
                if (!(chunk instanceof RunContainer)) continue;
                for (Chunk nestedChunk : ((RunContainer)chunk).getChunks()) {
                    if (!(nestedChunk instanceof Run)) continue;
                    this.runBuilder.getNestedTextualItems().addAll(((Run)nestedChunk).getNestedTextualItems());
                }
            }
        }
    }

    private void parseComplexField(StartElement startElement) throws XMLStreamException {
        boolean extractable = false;
        boolean atComplexFieldResult = false;
        LinkedList<XMLEvent> deferredEvents = new LinkedList<XMLEvent>();
        ++this.complexFieldNestingLevel;
        this.parseComplexFieldBegin(startElement);
        while (this.startElementContext.getEventReader().hasNext()) {
            XMLEvent e = this.startElementContext.getEventReader().nextEvent();
            if (RunParser.isComplexFieldEnd(e)) {
                if (!extractable) {
                    this.parseSimpleElement(e.asStartElement());
                } else {
                    this.endComplexFieldParsing(e.asStartElement(), deferredEvents);
                }
                --this.complexFieldNestingLevel;
                return;
            }
            if (RunParser.isComplexFieldInstruction(e)) {
                extractable = this.parseComplexFieldCode(e.asStartElement());
                continue;
            }
            if (RunParser.isComplexFieldSeparate(e)) {
                this.parseSimpleElement(e.asStartElement());
                atComplexFieldResult = true;
                continue;
            }
            if (RunParser.isComplexFieldBegin(e)) {
                if (extractable && !deferredEvents.isEmpty()) {
                    this.parseContentFrom(deferredEvents);
                }
                this.parseComplexField(e.asStartElement());
                continue;
            }
            if (!extractable || !atComplexFieldResult) {
                if (this.parseSkippableElements(e)) continue;
                this.runBuilder.addToMarkup(this.stripRevisionAttributes(e));
                continue;
            }
            if (XMLEventHelpers.isParagraphEndEvent(e)) {
                if (!deferredEvents.isEmpty()) {
                    this.parseContentFrom(deferredEvents);
                }
                deferredEvents.add(e);
                continue;
            }
            if (!deferredEvents.isEmpty()) {
                if (XMLEventHelpers.isParagraphPropertiesStartEvent(e)) {
                    StartElementContext blockPropertiesElementContext = StartElementContextFactory.createStartElementContext(e.asStartElement(), this.startElementContext);
                    ParagraphBlockProperties blockProperties = new MarkupComponentParser().parseParagraphBlockProperties(blockPropertiesElementContext, this.generalStrippableAttributes, this.blockPropertiesSkippableElements);
                    deferredEvents.addAll(blockProperties.getEvents());
                    continue;
                }
                if (this.parseSkippableElements(e)) continue;
                deferredEvents.add(e);
                continue;
            }
            this.parseContent(this.processTranslatableAttributes(this.stripRevisionAttributes(e)), this.startElementContext.getEventReader());
        }
    }

    private static boolean isComplexFieldBegin(XMLEvent e) {
        return XMLEventHelpers.isStartElement(e, COMPLEX_FIELD_CHARACTER) && BEGIN.equals(XMLEventHelpers.getAttributeValue(e.asStartElement(), COMPLEX_FIELD_CHARACTER_TYPE));
    }

    private static boolean isComplexFieldInstruction(XMLEvent e) {
        return XMLEventHelpers.isStartElement(e, COMPLEX_FIELD_INSTRUCTION);
    }

    private static boolean isComplexFieldSeparate(XMLEvent e) {
        return XMLEventHelpers.isStartElement(e, COMPLEX_FIELD_CHARACTER) && SEPARATE.equals(XMLEventHelpers.getAttributeValue(e.asStartElement(), COMPLEX_FIELD_CHARACTER_TYPE));
    }

    private static boolean isComplexFieldEnd(XMLEvent e) {
        return XMLEventHelpers.isStartElement(e, COMPLEX_FIELD_CHARACTER) && END.equals(XMLEventHelpers.getAttributeValue(e.asStartElement(), COMPLEX_FIELD_CHARACTER_TYPE));
    }

    private void parseComplexFieldBegin(StartElement startElement) throws XMLStreamException {
        this.runBuilder.addToMarkup(startElement);
        while (this.startElementContext.getEventReader().hasNext()) {
            XMLEvent event = this.startElementContext.getEventReader().nextEvent();
            this.runBuilder.addToMarkup(event);
            if (!event.isEndElement() || !event.asEndElement().getName().equals(startElement.getName())) continue;
            return;
        }
        throw new IllegalStateException(UNEXPECTED_STRUCTURE + startElement);
    }

    private void parseSimpleElement(StartElement startElement) throws XMLStreamException {
        this.runBuilder.addToMarkup(startElement);
        XMLEvent event = this.startElementContext.getEventReader().nextEvent();
        if (!event.isEndElement() || !event.asEndElement().getName().equals(startElement.getName())) {
            throw new IllegalStateException(UNEXPECTED_STRUCTURE + event);
        }
        this.runBuilder.addToMarkup(event);
    }

    private boolean parseSkippableElements(XMLEvent e) throws XMLStreamException {
        if (this.runSkippableElements.skip(e)) {
            return true;
        }
        return this.blockSkippableElements.skip(e);
    }

    private void endComplexFieldParsing(StartElement startElement, Deque<XMLEvent> deferredEvents) throws XMLStreamException {
        if (this.goesAfterAnotherRun(deferredEvents)) {
            this.parseContentFrom(deferredEvents);
            this.parseSimpleElement(startElement);
        } else {
            Deque<XMLEvent> subtractedEvents = this.subtractAllFromLastOpeningRun(deferredEvents);
            this.parseContentFrom(subtractedEvents);
            this.parseSimpleElement(startElement);
            if (1 == this.complexFieldNestingLevel) {
                this.runBuilder.addDeferredEvents(deferredEvents);
            } else {
                this.parseToFirstClosingRun();
                this.parseContentFrom(deferredEvents);
            }
        }
    }

    private boolean goesAfterAnotherRun(Deque<XMLEvent> deferredEvents) {
        Iterator<XMLEvent> deferredEventsIterator = deferredEvents.descendingIterator();
        while (deferredEventsIterator.hasNext()) {
            XMLEvent event = deferredEventsIterator.next();
            if (!event.isEndElement() || !"r".equals(event.asEndElement().getName().getLocalPart())) continue;
            return true;
        }
        return false;
    }

    private void parseContentFrom(Collection<XMLEvent> deferredEvents) throws XMLStreamException {
        ConsumableXMLEventsReader eventReader = new ConsumableXMLEventsReader(new XMLEventsReader(deferredEvents));
        while (eventReader.hasNext()) {
            this.parseContent(this.processTranslatableAttributes(this.stripRevisionAttributes(eventReader.nextEvent())), eventReader);
        }
    }

    private Deque<XMLEvent> subtractAllFromLastOpeningRun(Deque<XMLEvent> deferredEvents) {
        LinkedList<XMLEvent> subtraction = new LinkedList<XMLEvent>();
        Iterator<XMLEvent> deferredEventsIterator = deferredEvents.descendingIterator();
        while (deferredEventsIterator.hasNext()) {
            XMLEvent event = deferredEventsIterator.next();
            subtraction.addFirst(event);
            deferredEventsIterator.remove();
            if (!XMLEventHelpers.isRunStartEvent(event)) continue;
            break;
        }
        return subtraction;
    }

    private void parseToFirstClosingRun() throws XMLStreamException {
        while (this.startElementContext.getEventReader().hasNext()) {
            XMLEvent event = this.startElementContext.getEventReader().nextEvent();
            this.parseContent(this.processTranslatableAttributes(this.stripRevisionAttributes(event)), this.startElementContext.getEventReader());
            if (!event.isEndElement() || !"r".equals(event.asEndElement().getName().getLocalPart())) continue;
            return;
        }
    }

    private boolean parseComplexFieldCode(StartElement startElement) throws XMLStreamException {
        this.runBuilder.addToMarkup(startElement);
        boolean extractable = false;
        while (this.startElementContext.getEventReader().hasNext()) {
            XMLEvent event = this.startElementContext.getEventReader().nextEvent();
            this.runBuilder.addToMarkup(event);
            if (event.isEndElement() && event.asEndElement().getName().equals(startElement.getName())) {
                return extractable;
            }
            if (extractable || !event.isCharacters()) continue;
            extractable = this.isComplexFieldCodeExtractable(event.asCharacters());
        }
        throw new IllegalStateException(UNEXPECTED_STRUCTURE + startElement);
    }

    private boolean isComplexFieldCodeExtractable(Characters characters) {
        String data = characters.getData().trim();
        int fieldCodeNameLength = data.indexOf(" ");
        String fieldCodeName = fieldCodeNameLength > 0 ? data.substring(0, fieldCodeNameLength) : data;
        return this.startElementContext.getConditionalParameters().tsComplexFieldDefinitionsToExtract.contains(fieldCodeName);
    }

    private XMLEvent stripRevisionAttributes(XMLEvent e) {
        if (XMLEventHelpers.isParagraphStartEvent(e)) {
            return this.paragraphRevisions.strip(e.asStartElement());
        }
        if (XMLEventHelpers.isRunStartEvent(e)) {
            return this.runRevisions.strip(e.asStartElement());
        }
        return e;
    }

    private void parseContent(XMLEvent e, XMLEventReader eventReader) throws XMLStreamException {
        if (XMLEventHelpers.isTextStartEvent(e)) {
            this.runBuilder.flushMarkup();
            this.parseText(e.asStartElement(), eventReader);
        } else if (this.startElementContext.getConditionalParameters().getAddTabAsCharacter() && XMLEventHelpers.isTabStartEvent(e) && !this.runBuilder.isHidden()) {
            this.runBuilder.flushMarkup();
            this.runBuilder.addText("\t", e.asStartElement());
            this.defaultSkippableElements.skip(StartElementContextFactory.createStartElementContext(e.asStartElement(), this.startElementContext.getEventReader(), null, this.startElementContext.getConditionalParameters()));
        } else if (this.startElementContext.getConditionalParameters().getAddLineSeparatorCharacter() && XMLEventHelpers.isLineBreakStartEvent(e) && !XMLEventHelpers.isPageBreak(e.asStartElement()) && !this.runBuilder.isHidden()) {
            this.runBuilder.flushMarkup();
            char replacement = this.startElementContext.getConditionalParameters().getLineSeparatorReplacement();
            this.runBuilder.addText(String.valueOf(replacement), e.asStartElement());
            this.defaultSkippableElements.skip(StartElementContextFactory.createStartElementContext(e.asStartElement(), this.startElementContext.getEventReader(), null, this.startElementContext.getConditionalParameters()));
        } else if (this.startElementContext.getConditionalParameters().getReplaceNoBreakHyphenTag() && XMLEventHelpers.isNoBreakHyphenStartEvent(e)) {
            this.runBuilder.flushMarkup();
            this.runBuilder.addText("-", e.asStartElement());
            this.defaultSkippableElements.skip(StartElementContextFactory.createStartElementContext(e.asStartElement(), this.startElementContext.getEventReader(), null, this.startElementContext.getConditionalParameters()));
        } else if (!XMLEventHelpers.isWhitespace(e) || this.runBuilder.preservingWhitespace()) {
            this.runBuilder.flushText();
            this.runBuilder.setTextPreservingWhitespace(false);
            if (XMLEventHelpers.isParagraphStartEvent(e)) {
                this.runBuilder.addToMarkup(MarkupComponentFactory.createStartMarkupComponent(this.startElementContext.getEventFactory(), e.asStartElement()));
            } else if (XMLEventHelpers.isParagraphPropertiesStartEvent(e)) {
                this.runBuilder.addToMarkup(new MarkupComponentParser().parseParagraphBlockProperties(StartElementContextFactory.createStartElementContext(e.asStartElement(), eventReader, this.startElementContext.getEventFactory(), this.startElementContext.getConditionalParameters()), this.generalStrippableAttributes, this.blockPropertiesSkippableElements));
            } else if (XMLEventHelpers.isParagraphEndEvent(e)) {
                this.runBuilder.addToMarkup(MarkupComponentFactory.createEndMarkupComponent(e.asEndElement()));
            } else if (!this.parseSkippableElements(e)) {
                this.runBuilder.addToMarkup(e);
            }
        }
    }

    private void parseText(StartElement startEvent, XMLEventReader events) throws XMLStreamException {
        this.runBuilder.setTextPreservingWhitespace(this.runBuilder.isTextPreservingWhitespace() || XMLEventHelpers.hasPreserveWhitespace(startEvent));
        while (events.hasNext()) {
            XMLEvent e = events.nextEvent();
            if (XMLEventHelpers.isEndElement(e, startEvent)) {
                return;
            }
            if (!e.isCharacters()) continue;
            String text = e.asCharacters().getData();
            if (text.trim().length() > 0) {
                this.runBuilder.setNonWhitespaceText(true);
            }
            this.runBuilder.addText(text, startEvent);
        }
    }

    private XMLEvent processTranslatableAttributes(XMLEvent e) {
        if (!e.isStartElement()) {
            return e;
        }
        StartElement startEl = e.asStartElement();
        if (XMLEventHelpers.isGraphicsProperty(startEl) && !this.startElementContext.getConditionalParameters().getTranslateWordExcludeGraphicMetaData()) {
            startEl = this.processTranslatableAttribute(startEl, "name");
        } else if (XMLEventHelpers.isTextPath(startEl)) {
            startEl = this.processTranslatableAttribute(startEl, "string");
        }
        return startEl;
    }

    private StartElement processTranslatableAttribute(StartElement startEl, String attrName) {
        ArrayList<Attribute> newAttrs = new ArrayList<Attribute>();
        Iterator<Attribute> it = startEl.getAttributes();
        boolean dirty = false;
        while (it.hasNext()) {
            Attribute a = it.next();
            if (a.getName().getLocalPart().equals(attrName)) {
                this.runBuilder.setContainsNestedItems(true);
                this.runBuilder.getNestedTextualItems().add(new TranslatableAttributeText(a.getValue()));
                newAttrs.add(this.startElementContext.getEventFactory().createAttribute(a.getName(), TextFragment.makeRefMarker(this.nestedTextualIds.createId())));
                dirty = true;
                continue;
            }
            newAttrs.add(a);
        }
        return dirty ? this.startElementContext.getEventFactory().createStartElement(startEl.getName(), newAttrs.iterator(), startEl.getNamespaces()) : startEl;
    }

    private void log(String s) {
        this.LOGGER.debug(s);
    }
}

