/*
 * Decompiled with CFR 0.152.
 */
package net.sf.okapi.filters.table.csv;

import net.sf.okapi.common.IParameters;
import net.sf.okapi.common.LocaleId;
import net.sf.okapi.common.encoder.EncoderManager;
import net.sf.okapi.common.layerprovider.ILayerProvider;
import net.sf.okapi.common.resource.ITextUnit;
import net.sf.okapi.common.resource.Property;
import net.sf.okapi.common.resource.StartDocument;
import net.sf.okapi.common.resource.TextContainer;
import net.sf.okapi.common.resource.TextFragment;
import net.sf.okapi.common.resource.TextPart;
import net.sf.okapi.common.skeleton.GenericSkeletonWriter;
import net.sf.okapi.filters.table.csv.Parameters;

public class CSVSkeletonWriter
extends GenericSkeletonWriter {
    Parameters params = new Parameters();

    @Override
    public String processStartDocument(LocaleId outputLocale, String outputEncoding, ILayerProvider layer, EncoderManager encoderManager, StartDocument resource) {
        IParameters params = resource.getFilterParameters();
        if (params instanceof net.sf.okapi.filters.table.Parameters) {
            params = ((net.sf.okapi.filters.table.Parameters)params).getActiveParameters();
        }
        this.params = (Parameters)params;
        return super.processStartDocument(outputLocale, outputEncoding, layer, encoderManager, resource);
    }

    @Override
    public String processTextUnit(ITextUnit tu) {
        if (tu.hasProperty("qualified") && "yes".equals(tu.getProperty("qualified").getValue())) {
            return super.processTextUnit(tu);
        }
        boolean isTarget = tu.hasTarget(this.outputLoc);
        TextContainer tc = isTarget ? tu.getTarget(this.outputLoc) : tu.getSource();
        if (tc == null || !this.params.addQualifiers) {
            return super.processTextUnit(tu);
        }
        TextFragment tf = tc.getUnSegmentedContentCopy();
        String text = tf.toText();
        if (text.contains(this.params.fieldDelimiter) || text.contains("\n")) {
            if (tc.hasBeenSegmented()) {
                tc.insert(0, new TextPart(this.params.textQualifier));
                tc.append(new TextPart(this.params.textQualifier));
            } else {
                tf.insert(0, new TextFragment(this.params.textQualifier));
                tf.append(this.params.textQualifier);
                tc.setContent(tf);
            }
            tu.setProperty(new Property("qualified", "yes"));
        }
        return super.processTextUnit(tu);
    }
}

