/*
 * Decompiled with CFR 0.152.
 */
package net.sf.okapi.filters.transifex;

import java.io.BufferedReader;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import net.sf.okapi.common.Base64;
import net.sf.okapi.common.LocaleId;
import net.sf.okapi.common.exceptions.OkapiIOException;
import net.sf.okapi.lib.transifex.ResourceInfo;
import net.sf.okapi.lib.transifex.TransifexClient;

public class Project {
    public static final String HOST = "host";
    public static final String USER = "user";
    public static final String PASSWORD = "password";
    public static final String PROJECTID = "projectId";
    public static final String SOURCELOCALE = "sourceLocale";
    public static final String TARGETLOCALE = "targetLocale";
    public static final String PROTECTAPPROVED = "protectApproved";
    public static final String PROJECT_EXTENSION = ".txp";
    private static final String PO_TYPE = "PO";
    private String path;
    private String host;
    private String user;
    private String password;
    private String projectId;
    private LocaleId sourceLocale;
    private LocaleId targetLocale;
    private List<ResourceInfo> resources;
    private TransifexClient cli;
    private boolean protectApproved;

    public Project() {
        this.reset(LocaleId.ENGLISH, LocaleId.FRENCH);
    }

    private void reset(LocaleId srcLoc, LocaleId trgLoc) {
        this.path = null;
        this.resources = new ArrayList<ResourceInfo>();
        this.setHost("http://www.transifex.net");
        this.setUser("");
        this.setPassword("");
        this.setProjectId("");
        this.cli = null;
        this.sourceLocale = srcLoc;
        this.targetLocale = trgLoc;
        this.protectApproved = false;
    }

    public String getHost() {
        return this.host;
    }

    public void setHost(String host) {
        if (host.endsWith("\\")) {
            host = host.substring(0, host.length() - 1) + "/";
        } else if (!host.endsWith("/")) {
            host = host + "/";
        }
        this.host = host;
    }

    public LocaleId getSourceLocale() {
        return this.sourceLocale;
    }

    public void setSourceLocale(LocaleId srcLoc) {
        this.sourceLocale = srcLoc;
    }

    public LocaleId getTargetLocale() {
        return this.targetLocale;
    }

    public void setTargetLocale(LocaleId trgLoc) {
        this.targetLocale = trgLoc;
    }

    public String getProjectId() {
        return this.projectId;
    }

    public void setProjectId(String projectId) {
        this.projectId = projectId;
        this.cli = null;
    }

    public String getUser() {
        return this.user;
    }

    public void setUser(String user) {
        this.user = user;
        this.cli = null;
    }

    public String getPassword() {
        return this.password;
    }

    public void setPassword(String password) {
        this.password = Base64.decodePassword(password);
        this.cli = null;
    }

    public boolean getProtectApproved() {
        return this.protectApproved;
    }

    public void setProtectApproved(boolean protectApproved) {
        this.protectApproved = protectApproved;
    }

    public List<ResourceInfo> getResources() {
        return this.resources;
    }

    public void setPath(String path) {
        this.path = path;
    }

    public void save() {
        try (PrintWriter pw = new PrintWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(this.path), StandardCharsets.UTF_8));){
            pw.println("host=" + this.host);
            pw.println("user=" + this.user);
            pw.println("password=" + Base64.encodePassword(this.password));
            pw.println("projectId=" + this.projectId);
            pw.println("sourceLocale=" + this.sourceLocale.toString());
            pw.println("targetLocale=" + this.targetLocale.toString());
            pw.println("protectApproved=" + (this.protectApproved ? "yes" : "no"));
            for (ResourceInfo info : this.resources) {
                pw.println(info.getId() + "\t" + (info.getSelected() ? "yes" : "no"));
            }
        }
        catch (FileNotFoundException e) {
            throw new OkapiIOException("Error saving project file.\n" + e.getMessage(), e);
        }
    }

    public void read(BufferedReader br, LocaleId srcLoc, LocaleId trgLoc) throws IOException {
        this.reset(srcLoc, trgLoc);
        String line = br.readLine();
        while (line != null) {
            if (!(line = line.trim()).isEmpty() && !line.startsWith("#")) {
                int n = line.indexOf(61);
                if (n > 0) {
                    String value = line.substring(n + 1).trim();
                    if (line.startsWith(HOST)) {
                        this.setHost(value);
                    } else if (line.startsWith(USER)) {
                        this.setUser(value);
                    } else if (line.startsWith(PASSWORD)) {
                        this.setPassword(value);
                    } else if (line.startsWith(PROJECTID)) {
                        this.setProjectId(value);
                    } else if (line.startsWith(SOURCELOCALE)) {
                        if (this.sourceLocale == null) {
                            this.setSourceLocale(LocaleId.fromString(value));
                        }
                    } else if (line.startsWith(TARGETLOCALE)) {
                        if (this.targetLocale == null) {
                            this.setTargetLocale(LocaleId.fromString(value));
                        }
                    } else if (line.startsWith(PROTECTAPPROVED)) {
                        this.setProtectApproved(value.equals("yes"));
                    }
                } else {
                    n = line.indexOf(9);
                    boolean selected = true;
                    if (n > 0) {
                        String tmp = line.substring(n + 1).trim();
                        selected = tmp.equals("yes");
                        line = line.substring(0, n);
                    }
                    ResourceInfo info = new ResourceInfo(line, "", PO_TYPE, selected);
                    this.resources.add(info);
                }
            }
            line = br.readLine();
        }
    }

    public void refreshResources(boolean onlyExistingResources) {
        Object[] res;
        if (this.cli == null) {
            this.cli = new TransifexClient(this.getHost());
            this.cli.setCredentials(this.getUser(), this.getPassword());
            this.cli.setProject(this.getProjectId());
        }
        if ((res = this.cli.getResourceList(this.sourceLocale))[0] == null) {
            throw new OkapiIOException((String)res[1]);
        }
        Map map = (Map)res[2];
        if (map.isEmpty()) {
            this.resources.clear();
            return;
        }
        ArrayList<ResourceInfo> oldList = new ArrayList<ResourceInfo>(this.resources);
        this.resources.clear();
        for (String resId : map.keySet()) {
            ResourceInfo info = (ResourceInfo)map.get(resId);
            if (!PO_TYPE.equals(info.getI18nType())) continue;
            boolean found = false;
            for (int i = 0; i < oldList.size(); ++i) {
                if (!((ResourceInfo)oldList.get(i)).getId().equals(resId)) continue;
                info.setSelected(((ResourceInfo)oldList.get(i)).getSelected());
                found = true;
                break;
            }
            if (!found && onlyExistingResources) continue;
            this.resources.add(info);
        }
    }
}

