/*
 * Decompiled with CFR 0.152.
 */
package net.sf.okapi.filters.xini.rainbowkit;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import net.sf.okapi.common.Event;
import net.sf.okapi.common.IParameters;
import net.sf.okapi.common.LocaleId;
import net.sf.okapi.common.encoder.EncoderManager;
import net.sf.okapi.common.exceptions.OkapiException;
import net.sf.okapi.common.exceptions.OkapiIOException;
import net.sf.okapi.common.filterwriter.IFilterWriter;
import net.sf.okapi.common.skeleton.ISkeletonWriter;
import net.sf.okapi.filters.xini.rainbowkit.FilterEventToXiniTransformer;

public class XINIRainbowkitWriter
extends FilterEventToXiniTransformer
implements IFilterWriter {
    private EncoderManager encodingManager;
    private IParameters params;
    private String xiniPath;
    private String nextPageName;

    @Override
    public void cancel() {
    }

    @Override
    public void close() {
    }

    @Override
    public String getName() {
        return "XINIRainbowKitWriter";
    }

    @Override
    public void setOptions(LocaleId locale, String defaultEncoding) {
    }

    @Override
    public void setOutput(String path) {
    }

    @Override
    public void setOutput(OutputStream output) {
    }

    @Override
    public Event handleEvent(Event event) {
        switch (event.getEventType()) {
            case START_DOCUMENT: {
                this.startPage(this.nextPageName);
                break;
            }
            case TEXT_UNIT: {
                this.transformTextUnit(event.getTextUnit());
                break;
            }
            case START_GROUP: {
                this.pushGroupToStack(event.getStartGroup());
                break;
            }
            case END_GROUP: {
                this.popGroupFromStack();
                break;
            }
        }
        return event;
    }

    public void writeXINI() {
        try {
            File outputPath = new File(this.xiniPath);
            if (!outputPath.getParentFile().exists()) {
                outputPath.getParentFile().mkdirs();
            }
            if (!outputPath.exists()) {
                outputPath.createNewFile();
            }
            FileOutputStream fos = new FileOutputStream(outputPath);
            this.marshall(fos);
            fos.close();
        }
        catch (FileNotFoundException e) {
            throw new OkapiException(e);
        }
        catch (IOException e) {
            throw new OkapiIOException(e);
        }
    }

    @Override
    public IParameters getParameters() {
        return this.params;
    }

    @Override
    public void setParameters(IParameters params) {
        this.params = params;
    }

    @Override
    public EncoderManager getEncoderManager() {
        return this.encodingManager;
    }

    public void setOutputPath(String path) {
        this.xiniPath = path;
    }

    @Override
    public ISkeletonWriter getSkeletonWriter() {
        return null;
    }

    public void setNextPageName(String nextPageName) {
        this.nextPageName = nextPageName;
    }
}

