/*
 * Decompiled with CFR 0.152.
 */
package net.sf.okapi.filters.yaml;

import net.sf.okapi.common.resource.ITextUnit;
import net.sf.okapi.common.resource.Property;
import net.sf.okapi.common.resource.TextUnitUtil;
import net.sf.okapi.common.skeleton.GenericSkeletonWriter;
import net.sf.okapi.filters.yaml.YamlEncoder;
import net.sf.okapi.filters.yaml.parser.YamlScalarTypes;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.yaml.snakeyaml.DumperOptions;

public class YamlSkeletonWriter
extends GenericSkeletonWriter {
    private final Logger logger = LoggerFactory.getLogger(this.getClass());
    private Property scalarType;
    private Property scalarFlow;
    private Property scalarParentIndent;
    private boolean flow;
    private int fullIndent;
    private DumperOptions.FlowStyle flowStyle;
    private boolean wrap;

    public YamlSkeletonWriter(boolean wrap) {
        this.wrap = wrap;
        this.flowStyle = DumperOptions.FlowStyle.AUTO;
        this.flow = false;
    }

    @Override
    public String processTextUnit(ITextUnit resource) {
        TextUnitUtil.unsegmentTU(resource);
        if (resource.hasProperty("Scalar Type")) {
            this.scalarType = resource.getProperty("Scalar Type");
            this.scalarFlow = resource.getProperty("Scalar Flow");
            this.scalarParentIndent = resource.getProperty("Parent Scalar Indent");
            this.flow = this.scalarFlow.getBoolean();
            this.fullIndent = Integer.parseInt(this.scalarParentIndent.getValue());
            this.flowStyle = this.flow ? DumperOptions.FlowStyle.FLOW : DumperOptions.FlowStyle.BLOCK;
        }
        this.getEncoderManager().updateEncoder("text/x-yaml");
        YamlEncoder encoder = (YamlEncoder)this.getEncoderManager().getEncoder();
        encoder.setScalarType(YamlScalarTypes.valueOf(this.scalarType.getValue()));
        String encoded = super.processTextUnit(resource);
        encoded = encoded.replaceAll("\r\n", "\n").replaceAll("\r", "\n").replaceAll("\n", this.getEncoderManager().getLineBreak());
        this.flowStyle = DumperOptions.FlowStyle.AUTO;
        this.flow = false;
        this.fullIndent = 0;
        return encoded;
    }
}

