/*
 * Decompiled with CFR 0.152.
 */
package net.sf.okapi.lib.search.lucene.scorer;

import java.io.IOException;
import java.util.List;
import org.apache.lucene.index.IndexReader;
import org.apache.lucene.index.MultipleTermPositions;
import org.apache.lucene.index.Term;
import org.apache.lucene.index.TermPositions;
import org.apache.lucene.search.Scorer;
import org.apache.lucene.search.Similarity;

public class ConcordanceFuzzyScorer
extends Scorer {
    private static float ROUGH_THRSHOLD = 0.5f;
    private MultipleTermPositions multiTermPositions;
    private TermPositions[] termPositions;
    private IndexReader reader;
    private float score;
    private int[] query;
    private int matches = 0;
    private float threshold;
    private int currentDoc;
    private List<Term> terms;

    private static int max(int x1, int x2) {
        return x1 > x2 ? x1 : x2;
    }

    private static int max(int x1, int x2, int x3, int x4) {
        return ConcordanceFuzzyScorer.max(ConcordanceFuzzyScorer.max(x1, x2), ConcordanceFuzzyScorer.max(x3, x4));
    }

    public ConcordanceFuzzyScorer(float threshold, Similarity similarity, List<Term> terms, TermPositions[] termPositions, MultipleTermPositions multiTermPositions, IndexReader reader) throws IOException {
        super(similarity);
        this.threshold = threshold;
        this.multiTermPositions = multiTermPositions;
        this.termPositions = termPositions;
        this.reader = reader;
        this.currentDoc = -1;
        this.terms = terms;
        this.query = new int[terms.size()];
        for (int i = 1; i < terms.size(); ++i) {
            this.query[i] = i;
        }
    }

    private int findNext() throws IOException {
        while (!(this.calculateSimpleFilter() >= ROUGH_THRSHOLD) || !(this.calculateScore(this.multiTermPositions.doc()) >= this.threshold)) {
            if (this.multiTermPositions.next()) continue;
            return Integer.MAX_VALUE;
        }
        return this.multiTermPositions.doc();
    }

    public float score() throws IOException {
        return this.score;
    }

    private float calculateSimpleFilter() {
        return (float)this.multiTermPositions.freq() / (float)this.terms.size();
    }

    private float calculateScore(int d) throws IOException {
        int[] hit = null;
        int[] query = new int[this.terms.size()];
        int maxpos = 0;
        int minpos = 0;
        minpos = this.multiTermPositions.nextPosition();
        for (int i = 1; i < this.multiTermPositions.freq(); ++i) {
            maxpos = this.multiTermPositions.nextPosition();
        }
        int size = maxpos - minpos + 1;
        if (maxpos <= 0) {
            size = 1;
        }
        hit = new int[size];
        for (int i = 0; i < this.terms.size(); ++i) {
            query[i] = i + 1;
            TermPositions tp = this.termPositions[i];
            if (tp == null) continue;
            if (!tp.skipTo(d)) {
                this.termPositions[i].close();
                this.termPositions[i] = null;
                continue;
            }
            if (tp.doc() != d) {
                this.termPositions[i] = this.reader.termPositions(this.terms.get(i));
                continue;
            }
            for (int j = 0; j < tp.freq(); ++j) {
                int p = tp.nextPosition();
                hit[p - minpos] = i + 1;
            }
        }
        this.score = this.editDistance(hit, query);
        return this.score;
    }

    private float editDistance(int[] seq1, int[] seq2) {
        int d = 1;
        int n = seq1.length;
        int m = seq2.length;
        int[][] F = new int[n + 1][m + 1];
        TraceBack[][] T = new TraceBack[n + 1][m + 1];
        int s = 0;
        int maxi = n;
        int maxj = m;
        int maxval = Integer.MIN_VALUE;
        for (int i = 1; i <= n; ++i) {
            for (int j = 1; j <= m; ++j) {
                int val;
                s = 0;
                if (seq1[i - 1] == seq2[j - 1]) {
                    s = 2;
                }
                F[i][j] = val = ConcordanceFuzzyScorer.max(0, F[i - 1][j - 1] + s, F[i - 1][j] - d, F[i][j - 1] - d);
                if (val == 0) {
                    T[i][j] = null;
                } else if (val == F[i - 1][j - 1] + s) {
                    T[i][j] = new TraceBack(i - 1, j - 1);
                } else if (val == F[i - 1][j] - d) {
                    T[i][j] = new TraceBack(i - 1, j);
                } else if (val == F[i][j - 1] - d) {
                    T[i][j] = new TraceBack(i, j - 1);
                }
                if (val <= maxval) continue;
                maxval = val;
                maxi = i;
                maxj = j;
            }
        }
        TraceBack start = new TraceBack(maxi, maxj);
        this.matches = 0;
        TraceBack tb = start;
        int i = tb.i;
        int j = tb.j;
        while ((tb = this.next(tb, T)) != null) {
            i = tb.i;
            j = tb.j;
            if (seq1[i] != seq2[j]) continue;
            ++this.matches;
        }
        return (float)this.matches / (float)this.terms.size();
    }

    private TraceBack next(TraceBack tb, TraceBack[][] tba) {
        TraceBack tb2 = tb;
        return tba[tb2.i][tb2.j];
    }

    public int advance(int target) throws IOException {
        if (target == Integer.MAX_VALUE) {
            this.currentDoc = Integer.MAX_VALUE;
            return Integer.MAX_VALUE;
        }
        while ((this.currentDoc = this.nextDoc()) < target) {
        }
        return this.currentDoc;
    }

    public int docID() {
        return this.currentDoc;
    }

    public int nextDoc() throws IOException {
        if (!this.multiTermPositions.next()) {
            this.multiTermPositions.close();
            return Integer.MAX_VALUE;
        }
        this.currentDoc = this.findNext();
        return this.currentDoc;
    }

    private static class TraceBack {
        public int i;
        public int j;

        public TraceBack(int i, int j) {
            this.i = i;
            this.j = j;
        }
    }
}

