/*
 * Decompiled with CFR 0.152.
 */
package net.sf.okapi.lib.terminology.tbx;

import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import javax.xml.stream.XMLInputFactory;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import net.sf.okapi.common.LocaleId;
import net.sf.okapi.common.Util;
import net.sf.okapi.common.exceptions.OkapiIOException;
import net.sf.okapi.lib.terminology.ConceptEntry;
import net.sf.okapi.lib.terminology.IGlossaryReader;
import net.sf.okapi.lib.terminology.LangEntry;
import net.sf.okapi.lib.terminology.TermEntry;

public class TBXReader
implements IGlossaryReader {
    private ConceptEntry nextEntry;
    private ConceptEntry cent;
    private LangEntry lent;
    private XMLStreamReader reader;

    @Override
    public void open(File file) {
        try {
            this.open(new FileInputStream(file));
        }
        catch (Throwable e) {
            throw new OkapiIOException("Error opening the URI.\n" + e.getLocalizedMessage());
        }
    }

    @Override
    public void open(InputStream input) {
        try {
            this.close();
            XMLInputFactory fact = XMLInputFactory.newInstance();
            fact.setProperty("javax.xml.stream.isCoalescing", true);
            fact.setProperty("javax.xml.stream.supportDTD", false);
            this.reader = fact.createXMLStreamReader(input);
            this.readNext();
        }
        catch (Throwable e) {
            throw new OkapiIOException("Error opening the URI.\n" + e.getLocalizedMessage());
        }
    }

    @Override
    public void close() {
        this.nextEntry = null;
        try {
            if (this.reader != null) {
                this.reader.close();
                this.reader = null;
            }
        }
        catch (XMLStreamException e) {
            throw new OkapiIOException(e);
        }
    }

    @Override
    public boolean hasNext() {
        return this.nextEntry != null;
    }

    @Override
    public ConceptEntry next() {
        ConceptEntry currentEntry = this.nextEntry;
        this.readNext();
        return currentEntry;
    }

    private void readNext() {
        try {
            this.cent = null;
            this.nextEntry = null;
            while (this.reader.hasNext()) {
                int eventType = this.reader.next();
                switch (eventType) {
                    case 1: {
                        String name = this.reader.getLocalName();
                        if (!"termEntry".equals(name)) break;
                        this.processTermEntry();
                        return;
                    }
                }
            }
        }
        catch (Throwable e) {
            throw new OkapiIOException("Error when reading." + e.getLocalizedMessage(), e);
        }
    }

    private void processTermEntry() throws XMLStreamException {
        this.cent = new ConceptEntry();
        this.cent.setId(this.reader.getAttributeValue(null, "id"));
        while (this.reader.hasNext()) {
            int eventType = this.reader.next();
            switch (eventType) {
                case 1: {
                    String name = this.reader.getLocalName();
                    if (!"langSet".equals(name)) break;
                    this.processLangSet();
                    break;
                }
                case 2: {
                    String name = this.reader.getLocalName();
                    if (!"termEntry".equals(name)) break;
                    this.nextEntry = this.cent;
                    return;
                }
            }
        }
    }

    private void processLangSet() throws XMLStreamException {
        String lang = this.reader.getAttributeValue("http://www.w3.org/XML/1998/namespace", "lang");
        if (Util.isEmpty(lang)) {
            throw new OkapiIOException("Missing or empty xml:lang attribute.");
        }
        this.lent = new LangEntry(LocaleId.fromString(lang));
        while (this.reader.hasNext()) {
            int eventType = this.reader.next();
            switch (eventType) {
                case 1: {
                    String name = this.reader.getLocalName();
                    if ("tig".equals(name)) {
                        this.processTig();
                        break;
                    }
                    if (!"ntig".equals(name)) break;
                    this.processNtig();
                    break;
                }
                case 2: {
                    String name = this.reader.getLocalName();
                    if (!"langSet".equals(name)) break;
                    this.cent.addLangEntry(this.lent);
                    return;
                }
            }
        }
    }

    private void processTig() throws XMLStreamException {
        while (this.reader.hasNext()) {
            int eventType = this.reader.next();
            switch (eventType) {
                case 1: {
                    String name = this.reader.getLocalName();
                    if (!"term".equals(name)) break;
                    this.processTerm();
                    break;
                }
                case 2: {
                    String name = this.reader.getLocalName();
                    if (!"tig".equals(name)) break;
                    return;
                }
            }
        }
    }

    private void processNtig() throws XMLStreamException {
        while (this.reader.hasNext()) {
            int eventType = this.reader.next();
            switch (eventType) {
                case 1: {
                    String name = this.reader.getLocalName();
                    if (!"termGrp".equals(name)) break;
                    this.processTermGrp();
                    break;
                }
                case 2: {
                    String name = this.reader.getLocalName();
                    if (!"ntig".equals(name)) break;
                    return;
                }
            }
        }
    }

    private void processTermGrp() throws XMLStreamException {
        while (this.reader.hasNext()) {
            int eventType = this.reader.next();
            switch (eventType) {
                case 1: {
                    String name = this.reader.getLocalName();
                    if (!"term".equals(name)) break;
                    this.processTerm();
                    break;
                }
                case 2: {
                    String name = this.reader.getLocalName();
                    if (!"termGrp".equals(name)) break;
                    return;
                }
            }
        }
    }

    private void processTerm() throws XMLStreamException {
        String id = this.reader.getAttributeValue(null, "id");
        StringBuilder tmp = new StringBuilder();
        while (this.reader.hasNext()) {
            int eventType = this.reader.next();
            switch (eventType) {
                case 2: {
                    if (!"term".equals(this.reader.getLocalName())) break;
                    TermEntry term = new TermEntry(tmp.toString());
                    term.setId(id);
                    this.lent.addTerm(term);
                    return;
                }
                case 4: {
                    tmp.append(this.reader.getText());
                }
            }
        }
    }
}

