/*
 * Decompiled with CFR 0.152.
 */
package net.sf.okapi.lib.translation;

import java.text.BreakIterator;
import java.util.ArrayList;
import java.util.List;
import net.sf.okapi.common.LocaleId;
import net.sf.okapi.common.resource.TextFragment;

public class TextMatcher {
    public static final int IGNORE_CASE = 1;
    public static final int IGNORE_WHITESPACES = 2;
    public static final int IGNORE_PUNCTUATION = 4;
    private static final int MAXTOKEN = 1024;
    private static short[] matP = null;
    private static short[] matD = null;
    private BreakIterator breaker1;
    private BreakIterator breaker2;

    public TextMatcher(LocaleId locale1, LocaleId locale2) {
        this.breaker1 = BreakIterator.getWordInstance(locale1.toJavaLocale());
        this.breaker2 = locale1.equals(locale2) ? this.breaker1 : BreakIterator.getWordInstance(locale2.toJavaLocale());
    }

    protected static short minimum(int value1, int value2, int value3) {
        return (short)Math.min(value1, Math.min(value2, value3));
    }

    private static int waikoloa(List<String> tokens1, List<String> tokens2) {
        int wordsInQuery = tokens1.size();
        int wordsInCandidate = tokens2.size();
        int wordsFound = 0;
        for (String token : tokens1) {
            int n = tokens2.indexOf(token);
            if (n <= -1) continue;
            ++wordsFound;
            tokens2.set(n, null);
        }
        Float f = Float.valueOf(100.0f * ((float)(2 * wordsFound) / (float)(wordsInQuery + wordsInCandidate)));
        return f.intValue();
    }

    private static int levenshtein(List<String> tokens1, List<String> tokens2) {
        int i;
        int n = tokens1.size();
        int m = tokens2.size();
        if (n == 0) {
            return m;
        }
        if (m == 0) {
            return n;
        }
        if (matP == null) {
            matP = new short[1025];
        }
        if (matD == null) {
            matD = new short[1025];
        }
        if (n > 1024) {
            n = 1024;
        }
        if (m > 1024) {
            m = 1024;
        }
        String obj2j = null;
        for (i = 0; i <= n; ++i) {
            TextMatcher.matP[i] = (short)i;
        }
        for (int j = 1; j <= m; ++j) {
            obj2j = tokens2.get(j - 1);
            TextMatcher.matD[0] = (short)j;
            String obj1i = null;
            for (i = 1; i <= n; ++i) {
                obj1i = tokens1.get(i - 1);
                short cost = obj1i.equals(obj2j) ? (short)0 : 1;
                TextMatcher.matD[i] = TextMatcher.minimum(matD[i - 1] + 1, matP[i] + 1, matP[i - 1] + cost);
            }
            short[] swap = matP;
            matP = matD;
            matD = swap;
        }
        int longest = Math.max(n, m);
        return 100 * (longest - matP[n]) / longest;
    }

    public int compare(TextFragment frag1, TextFragment frag2, int options) {
        List<String> tokens2;
        List<String> tokens1;
        String text2;
        String text1 = frag1.getCodedText();
        if (text1.equals(text2 = frag2.getCodedText())) {
            return 100;
        }
        if (text1.equalsIgnoreCase(text2)) {
            return (options & 1) == 1 ? 100 : 99;
        }
        if ((options & 4) == 4) {
            text1 = text1.replaceAll("\\p{Punct}", " ");
            text2 = text2.replaceAll("\\p{Punct}", " ");
        }
        if ((options & 1) == 1) {
            tokens1 = this.tokenize(text1.toLowerCase(), this.breaker1);
            tokens2 = this.tokenize(text2.toLowerCase(), this.breaker2);
        } else {
            tokens1 = this.tokenize(text1, this.breaker1);
            tokens2 = this.tokenize(text2, this.breaker2);
        }
        int n = TextMatcher.levenshtein(tokens1, tokens2);
        if (n == 100) {
            return 99;
        }
        return n;
    }

    public List<String> prepareBaseTokens(String plainText) {
        String text = plainText.replaceAll("\\p{Punct}", " ");
        return this.tokenize(text.toLowerCase(), this.breaker1);
    }

    public int compareToBaseTokens(String text1, List<String> tokens1, TextFragment frag2) {
        String text2 = frag2.getCodedText();
        if (text1.equals(text2)) {
            return 100;
        }
        if (text1.equalsIgnoreCase(text2)) {
            return 99;
        }
        List<String> tokens2 = this.tokenize((text2 = text2.replaceAll("\\p{Punct}", " ")).toLowerCase(), this.breaker2);
        int n = TextMatcher.waikoloa(tokens1, tokens2);
        if (n == 100) {
            return 99;
        }
        return n;
    }

    private List<String> tokenize(String text, BreakIterator breakerToUse) {
        breakerToUse.setText(text);
        ArrayList<String> list = new ArrayList<String>();
        int start = breakerToUse.first();
        int end = breakerToUse.next();
        while (end != -1) {
            list.add(text.substring(start, end));
            start = end;
            end = breakerToUse.next();
        }
        return list;
    }
}

