/*
 * Decompiled with CFR 0.152.
 */
package net.sf.okapi.lib.xliff2.its;

import java.util.Iterator;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import net.sf.okapi.lib.xliff2.InvalidParameterException;
import net.sf.okapi.lib.xliff2.its.DataCategory;
import net.sf.okapi.lib.xliff2.its.DataCategoryGroup;
import net.sf.okapi.lib.xliff2.its.Domain;
import net.sf.okapi.lib.xliff2.its.IITSItem;
import net.sf.okapi.lib.xliff2.its.LocQualityIssue;
import net.sf.okapi.lib.xliff2.its.LocQualityIssues;
import net.sf.okapi.lib.xliff2.its.MTConfidence;
import net.sf.okapi.lib.xliff2.its.Provenance;
import net.sf.okapi.lib.xliff2.its.Provenances;

public class ITSItems
implements Iterable<IITSItem> {
    private final ConcurrentHashMap<String, IITSItem> map = new ConcurrentHashMap();

    public ITSItems() {
    }

    public ITSItems(ITSItems original) {
        for (IITSItem item : original) {
            this.add(item.createCopy());
        }
    }

    @Override
    public Iterator<IITSItem> iterator() {
        return this.map.values().iterator();
    }

    public void add(IITSItem item) {
        if (item instanceof LocQualityIssues) {
            this.addSpecial((LocQualityIssues)item);
            return;
        }
        if (item instanceof LocQualityIssue) {
            this.addSpecial((LocQualityIssue)item);
            return;
        }
        if (item instanceof Provenances) {
            this.addSpecial((Provenances)item);
            return;
        }
        if (item instanceof Provenance) {
            this.addSpecial((Provenance)item);
            return;
        }
        this.map.put(item.getClass().getName(), item);
    }

    public boolean isEmpty() {
        return this.map.isEmpty();
    }

    public void clear() {
        this.map.clear();
    }

    public void remove(IITSItem item) {
        IITSItem old = this.map.remove(item.getClass().getName());
        if (old != null) {
            return;
        }
        DataCategoryGroup group = null;
        if (item instanceof LocQualityIssue) {
            group = (DataCategoryGroup)this.map.get(LocQualityIssues.class.getName());
        }
        if (item instanceof Provenance) {
            group = (DataCategoryGroup)this.map.get(Provenances.class.getName());
        }
        if (group != null) {
            group.getList().remove(item);
        }
    }

    public int size() {
        return this.map.size();
    }

    public IITSItem get(String dcName) {
        switch (dcName) {
            case "localization-quality-issue": {
                return this.get(LocQualityIssue.class);
            }
            case "provenance": {
                return this.get(Provenance.class);
            }
            case "domain": {
                return this.get(Domain.class);
            }
            case "text-analysis": {
                return this.get(LocQualityIssue.class);
            }
            case "mt-confidence": {
                return this.get(MTConfidence.class);
            }
        }
        throw new InvalidParameterException("Unexpected data category name " + dcName);
    }

    public <A extends DataCategory> IITSItem get(Class<A> dcType) {
        IITSItem item = this.map.get(dcType.getName());
        if (item == null) {
            if (dcType == LocQualityIssue.class) {
                return this.map.get(LocQualityIssues.class.getName());
            }
            if (dcType == Provenance.class) {
                return this.map.get(Provenances.class.getName());
            }
        }
        return item;
    }

    private IITSItem addSpecial(LocQualityIssues newGroup) {
        LocQualityIssue old = (LocQualityIssue)this.map.get(LocQualityIssue.class.getName());
        if (old != null) {
            newGroup.getList().add(0, old);
            this.map.remove(LocQualityIssue.class.getName());
            this.map.put(LocQualityIssues.class.getName(), newGroup);
            return newGroup;
        }
        LocQualityIssues oldGroup = (LocQualityIssues)this.map.get(LocQualityIssues.class.getName());
        if (oldGroup != null) {
            oldGroup.getList().addAll(newGroup.getList());
            return oldGroup;
        }
        this.map.put(LocQualityIssues.class.getName(), newGroup);
        return newGroup;
    }

    private IITSItem addSpecial(Provenances newGroup) {
        Provenance old = (Provenance)this.map.get(Provenance.class.getName());
        if (old != null) {
            newGroup.getList().add(0, old);
            this.map.remove(Provenance.class.getName());
            this.map.put(Provenances.class.getName(), newGroup);
            return newGroup;
        }
        Provenances oldGroup = (Provenances)this.map.get(Provenances.class.getName());
        if (oldGroup != null) {
            oldGroup.getList().addAll(newGroup.getList());
            return oldGroup;
        }
        this.map.put(Provenances.class.getName(), newGroup);
        return newGroup;
    }

    private IITSItem addSpecial(LocQualityIssue dc) {
        LocQualityIssues group = null;
        IITSItem old = this.map.get(dc.getClass().getName());
        if (old != null) {
            group = new LocQualityIssues(UUID.randomUUID().toString());
            group.getList().add((LocQualityIssue)old);
            this.map.remove(LocQualityIssue.class.getName());
            this.map.put(LocQualityIssues.class.getName(), group);
        } else {
            IITSItem grpItem = this.map.get(LocQualityIssues.class.getName());
            if (grpItem != null) {
                group = (LocQualityIssues)grpItem;
            }
        }
        if (group != null) {
            group.getList().add(dc);
        } else {
            this.map.put(dc.getClass().getName(), dc);
        }
        return dc;
    }

    private IITSItem addSpecial(Provenance dc) {
        Provenances group = null;
        IITSItem old = this.map.get(dc.getClass().getName());
        if (old != null) {
            group = new Provenances(UUID.randomUUID().toString());
            group.getList().add((Provenance)old);
            this.map.remove(Provenance.class.getName());
            this.map.put(Provenance.class.getName(), group);
        } else {
            IITSItem grpItem = this.map.get(Provenances.class.getName());
            if (grpItem != null) {
                group = (Provenances)grpItem;
            }
        }
        if (group != null) {
            group.getList().add(dc);
        } else {
            this.map.put(dc.getClass().getName(), dc);
        }
        return dc;
    }
}

