/*
 * Decompiled with CFR 0.152.
 */
package net.sf.okapi.lib.xliff2.reader;

import java.io.IOException;
import javax.xml.transform.Source;
import javax.xml.transform.stream.StreamSource;
import javax.xml.validation.Schema;
import javax.xml.validation.SchemaFactory;
import javax.xml.validation.Validator;
import net.sf.okapi.lib.xliff2.XLIFFException;
import net.sf.okapi.lib.xliff2.reader.XLIFFReaderException;
import org.xml.sax.SAXException;

class SchemaValidator {
    private Validator validator;

    SchemaValidator() {
    }

    public void validate(StreamSource inputSource) {
        try {
            if (this.validator == null) {
                try {
                    SchemaFactory schemaFactory = SchemaFactory.newInstance("http://www.w3.org/2001/XMLSchema");
                    Schema schema = schemaFactory.newSchema(new Source[]{new StreamSource(this.getClass().getResourceAsStream("/net/sf/okapi/lib/xliff2/informativeCopiesOf3rdPartySchemas/w3c/xml.xsd")), new StreamSource(this.getClass().getResourceAsStream("/net/sf/okapi/lib/xliff2/xliff_core_2.0.xsd")), new StreamSource(this.getClass().getResourceAsStream("/net/sf/okapi/lib/xliff2/modules/metadata.xsd")), new StreamSource(this.getClass().getResourceAsStream("/net/sf/okapi/lib/xliff2/modules/change_tracking.xsd")), new StreamSource(this.getClass().getResourceAsStream("/net/sf/okapi/lib/xliff2/modules/fs.xsd")), new StreamSource(this.getClass().getResourceAsStream("/net/sf/okapi/lib/xliff2/modules/glossary.xsd")), new StreamSource(this.getClass().getResourceAsStream("/net/sf/okapi/lib/xliff2/modules/matches.xsd")), new StreamSource(this.getClass().getResourceAsStream("/net/sf/okapi/lib/xliff2/modules/resource_data.xsd")), new StreamSource(this.getClass().getResourceAsStream("/net/sf/okapi/lib/xliff2/modules/size_restriction.xsd")), new StreamSource(this.getClass().getResourceAsStream("/net/sf/okapi/lib/xliff2/modules/validation.xsd"))});
                    this.validator = schema.newValidator();
                    this.validator.setProperty("http://javax.xml.XMLConstants/property/accessExternalDTD", "");
                    this.validator.setProperty("http://javax.xml.XMLConstants/property/accessExternalSchema", "");
                }
                catch (SAXException e) {
                    throw new XLIFFException("Cannot load one of the XLIFF-related schemas.\nReason: " + e.getLocalizedMessage());
                }
            }
            this.validator.validate(inputSource);
        }
        catch (SAXException e) {
            String text = e.toString();
            if (text.startsWith("org.xml.sax.SAXParseException; ")) {
                text = "Error " + text.substring(31);
            }
            throw new XLIFFReaderException(this.wrap(text), e);
        }
        catch (IOException e) {
            throw new XLIFFException("IO error.\nReason: " + e.getLocalizedMessage(), e);
        }
    }

    private String wrap(String text) {
        return text;
    }
}

