/*
 * Decompiled with CFR 0.152.
 */
package net.sf.okapi.lib.xliff2.renderer;

import java.util.Map;
import java.util.Stack;
import net.sf.okapi.lib.xliff2.NSContext;
import net.sf.okapi.lib.xliff2.Util;
import net.sf.okapi.lib.xliff2.core.CTag;
import net.sf.okapi.lib.xliff2.core.Fragment;
import net.sf.okapi.lib.xliff2.core.MTag;
import net.sf.okapi.lib.xliff2.core.Tag;
import net.sf.okapi.lib.xliff2.core.TagType;
import net.sf.okapi.lib.xliff2.renderer.IFragmentObject;

public class XLIFFFragmentObject
implements IFragmentObject {
    private final Object obj;
    private final Integer status;
    private final Stack<NSContext> nsStack;

    XLIFFFragmentObject(Object object, Map<Tag, Integer> tagsStatus, Stack<NSContext> nsStack) {
        this.obj = object;
        this.status = this.obj instanceof String ? null : tagsStatus.get(this.obj);
        this.nsStack = nsStack;
    }

    @Override
    public String render() {
        if (this.obj instanceof String) {
            return this.render((String)this.obj);
        }
        if (this.obj instanceof CTag) {
            return this.render((CTag)this.obj);
        }
        return this.render((MTag)this.obj);
    }

    @Override
    public String getText() {
        return (String)this.obj;
    }

    @Override
    public CTag getCTag() {
        return (CTag)this.obj;
    }

    @Override
    public MTag getMTag() {
        return (MTag)this.obj;
    }

    @Override
    public Object getObject() {
        return this.obj;
    }

    private String render(String ctext) {
        StringBuilder tmp = new StringBuilder();
        block6: for (int i = 0; i < ctext.length(); ++i) {
            char ch = ctext.charAt(i);
            if (ch == '\ue106') {
                tmp.append("<INVALID:HIDDEN-PROTECTED-CONTENT/>");
                ++i;
                continue;
            }
            switch (ch) {
                case '\r': {
                    tmp.append("&#13;");
                    continue block6;
                }
                case '<': {
                    tmp.append("&lt;");
                    continue block6;
                }
                case '&': {
                    tmp.append("&amp;");
                    continue block6;
                }
                case '\t': 
                case '\n': {
                    tmp.append(ch);
                    continue block6;
                }
                default: {
                    if (ch > '\u001f' && ch < '\ud800') {
                        tmp.append(ch);
                        continue block6;
                    }
                    if (Character.isHighSurrogate(ch)) {
                        tmp.append(Character.toChars(ctext.codePointAt(i)));
                        ++i;
                        continue block6;
                    }
                    if (ch >= ' ' && (ch <= '\ud7ff' || ch >= '\ue000') && ch != '\ufffe' && ch != '\uffff') continue block6;
                    tmp.append(String.format("<cp hex=\"%04X\"/>", ch));
                }
            }
        }
        return tmp.toString();
    }

    private String render(CTag ctag) {
        StringBuilder tmp = new StringBuilder();
        switch (ctag.getTagType()) {
            case OPENING: {
                if (this.status == 2) {
                    tmp.append("<pc id=\"" + ctag.getId() + "\"");
                    if (ctag.getCanOverlap()) {
                        tmp.append(" canOverlap=\"yes\"");
                    }
                } else {
                    tmp.append("<sc id=\"" + ctag.getId() + "\"");
                    if (!ctag.getCanOverlap()) {
                        tmp.append(" canOverlap=\"no\"");
                    }
                    if (this.status == 0) {
                        tmp.append(" isolated=\"yes\"");
                    }
                }
                Fragment.printCommonAttributes(ctag, null, tmp, null, false);
                Fragment.printExtAttributes(ctag, tmp, this.nsStack);
                if (this.status == 2) {
                    tmp.append(">");
                    break;
                }
                tmp.append("/>");
                break;
            }
            case CLOSING: {
                if (this.status == 2) {
                    tmp.append("</pc>");
                    break;
                }
                tmp.append("<ec " + (this.status == 0 ? "id" : "startRef") + "=\"" + ctag.getId() + "\"");
                if (!ctag.getCanOverlap()) {
                    tmp.append(" canOverlap=\"no\"");
                }
                if (this.status == 0) {
                    tmp.append(" isolated=\"yes\"");
                }
                Fragment.printCommonAttributes(ctag, null, tmp, null, false);
                Fragment.printExtAttributes(ctag, tmp, this.nsStack);
                tmp.append("/>");
                break;
            }
            case STANDALONE: {
                tmp.append(String.format("<ph id=\"%s\"", ctag.getId()));
                Fragment.printCommonAttributes(ctag, null, tmp, null, false);
                Fragment.printExtAttributes(ctag, tmp, this.nsStack);
                tmp.append("/>");
            }
        }
        return tmp.toString();
    }

    private String render(MTag mtag) {
        StringBuilder tmp = new StringBuilder();
        if (mtag.getTagType() == TagType.OPENING) {
            if (this.status == 2) {
                tmp.append("<mrk id=\"" + mtag.getId() + "\"");
            } else {
                tmp.append("<sm id=\"" + mtag.getId() + "\"");
            }
            if (!mtag.getType().equals("generic")) {
                tmp.append(" type=\"" + mtag.getType() + "\"");
            }
            if (mtag.getTranslate() != null) {
                tmp.append(" translate=\"" + (mtag.getTranslate() != false ? "yes" : "no") + "\"");
            }
            if (!Util.isNoE(mtag.getValue())) {
                tmp.append(" value=\"" + Util.toXML(mtag.getValue(), true) + "\"");
            }
            if (!Util.isNoE(mtag.getRef())) {
                tmp.append(" ref=\"" + Util.toXML(mtag.getRef(), true) + "\"");
            }
            Fragment.printExtAttributes(mtag, tmp, this.nsStack);
            if (this.status == 2) {
                tmp.append(">");
            } else {
                tmp.append("/>");
            }
        } else if (this.status == 2) {
            tmp.append("</mrk>");
        } else {
            tmp.append("<em startRef=\"" + mtag.getId() + "\"/>");
        }
        return tmp.toString();
    }
}

