/*
 * Decompiled with CFR 0.152.
 */
package net.sf.okapi.steps.gcaligner;

public class DpMatrixCell {
    private DpMatrixCell m_backLink;
    private int m_xPos;
    private int m_yPos;
    private int m_score;
    private int m_state;
    public static final int DELETED = 1;
    public static final int INSERTED = 2;
    public static final int MATCH = 3;
    public static final int MULTI_MATCH = 4;
    public static final int NO_STATE = -1;

    public DpMatrixCell(int p_xPos, int p_yPos) {
        this.m_xPos = p_xPos;
        this.m_yPos = p_yPos;
        this.m_score = 0;
        this.m_state = -1;
        this.m_backLink = null;
    }

    public boolean hasNext() {
        return this.m_backLink != null;
    }

    public DpMatrixCell nextCell() {
        return this.m_backLink;
    }

    public int getXindex() {
        return this.m_xPos;
    }

    public int getYindex() {
        return this.m_yPos;
    }

    public int getScore() {
        return this.m_score;
    }

    public int getState() {
        return this.m_state;
    }

    public int getMultiMatchXIndexBegin() {
        return this.m_backLink.m_xPos + 1;
    }

    public int getMultiMatchYIndexBegin() {
        return this.m_backLink.m_yPos + 1;
    }

    public int getMultiMatchXIndexEnd() {
        return this.m_xPos + 1;
    }

    public int getMultiMatchYIndexEnd() {
        return this.m_yPos + 1;
    }

    public void setScoreAndLink(int p_score, DpMatrixCell p_backLink) {
        this.m_backLink = p_backLink;
        this.m_score = p_score;
        this.m_state = this.getState(p_backLink);
    }

    private int getState(DpMatrixCell p_backLink) {
        int state = -1;
        int linkX = p_backLink.m_xPos;
        int linkY = p_backLink.m_yPos;
        if (linkX == this.m_xPos && linkY == this.m_yPos || linkX > this.m_xPos || linkY > this.m_yPos) {
            String[] params = new String[]{Integer.toString(this.m_xPos), Integer.toString(this.m_yPos), Integer.toString(linkX), Integer.toString(linkY)};
        }
        state = linkX == this.m_xPos ? 2 : (linkY == this.m_yPos ? 1 : (linkX == this.m_xPos - 1 && linkY == this.m_yPos - 1 ? 3 : 4));
        return state;
    }

    public String toString() {
        StringBuffer sb = new StringBuffer();
        sb.append("[ xPos = ").append(this.m_xPos).append(" yPos = ").append(this.m_yPos).append(" score = ").append(this.m_score).append(" state = ");
        String state = null;
        switch (this.m_state) {
            case 1: {
                state = "DELETED";
                break;
            }
            case 2: {
                state = "INSERTED";
                break;
            }
            case 3: {
                state = "MATCH";
                break;
            }
            case 4: {
                state = "MULTI_MATCH";
                break;
            }
            case -1: {
                state = "NO_STATE";
            }
        }
        sb.append(state).append("]\r\n");
        return sb.toString();
    }
}

