/*
 * Decompiled with CFR 0.152.
 */
package net.sf.okapi.steps.terminologyleveraging;

import net.sf.okapi.common.Event;
import net.sf.okapi.common.IParameters;
import net.sf.okapi.common.LocaleId;
import net.sf.okapi.common.UsingParameters;
import net.sf.okapi.common.exceptions.OkapiException;
import net.sf.okapi.common.pipeline.BasePipelineStep;
import net.sf.okapi.common.pipeline.annotations.StepParameterMapping;
import net.sf.okapi.common.pipeline.annotations.StepParameterType;
import net.sf.okapi.common.resource.ITextUnit;
import net.sf.okapi.steps.terminologyleveraging.ITerminologyQuery;
import net.sf.okapi.steps.terminologyleveraging.TerminologyParameters;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@UsingParameters(value=TerminologyParameters.class)
public class TerminologyLeveragingStep
extends BasePipelineStep {
    private final Logger logger = LoggerFactory.getLogger(this.getClass());
    private TerminologyParameters params = new TerminologyParameters();
    private LocaleId sourceLocale;
    private LocaleId targetLocale;
    private boolean initDone;
    private ITerminologyQuery connector;

    @StepParameterMapping(parameterType=StepParameterType.SOURCE_LOCALE)
    public void setSourceLocale(LocaleId sourceLocale) {
        this.sourceLocale = sourceLocale;
    }

    public LocaleId getSourceLocale() {
        return this.sourceLocale;
    }

    @StepParameterMapping(parameterType=StepParameterType.TARGET_LOCALE)
    public void setTargetLocale(LocaleId targetLocale) {
        this.targetLocale = targetLocale;
    }

    public LocaleId getTargetLocale() {
        return this.targetLocale;
    }

    @Override
    public IParameters getParameters() {
        return this.params;
    }

    @Override
    public void setParameters(IParameters params) {
        this.params = (TerminologyParameters)params;
    }

    @Override
    public String getName() {
        return "Terminology Leveraging";
    }

    @Override
    public String getDescription() {
        return "Leverage terminology into the text units content of a document. Expects: filter events. Sends back: filter events.";
    }

    @Override
    public void cancel() {
        this.closeConnector();
    }

    @Override
    public void destroy() {
        this.closeConnector();
    }

    @Override
    protected Event handleStartBatch(Event event) {
        this.initDone = false;
        return event;
    }

    @Override
    protected Event handleEndBatch(Event event) {
        if (!this.params.getLeverage()) {
            return event;
        }
        return event;
    }

    @Override
    protected Event handleStartDocument(Event event) {
        if (!this.params.getLeverage()) {
            return event;
        }
        this.logger.info("Starting processing document");
        if (!this.initDone) {
            this.init();
        }
        return event;
    }

    @Override
    protected Event handleEndDocument(Event event) {
        if (!this.params.getLeverage()) {
            return event;
        }
        this.logger.info("Ended processing document");
        return event;
    }

    @Override
    protected Event handleTextUnit(Event event) {
        if (!this.params.getLeverage()) {
            return event;
        }
        ITextUnit tu = event.getTextUnit();
        if (!tu.isTranslatable()) {
            return event;
        }
        this.connector.leverage(tu);
        return event;
    }

    private void init() {
        if (!this.params.getLeverage()) {
            this.initDone = true;
            return;
        }
        try {
            this.connector = (ITerminologyQuery)Class.forName(this.params.getConnectorClassName()).newInstance();
        }
        catch (ClassNotFoundException | IllegalAccessException | InstantiationException e) {
            throw new OkapiException("Error creating connector.", e);
        }
        IParameters connectorParams = this.connector.getParameters();
        if (connectorParams != null) {
            connectorParams.fromString(this.params.getConnectorParameters());
            this.connector.setParameters(connectorParams);
        }
        if (this.sourceLocale != null && this.targetLocale != null) {
            this.connector.setLanguages(this.sourceLocale, this.targetLocale);
        }
        this.connector.setAnnotateSource(this.params.getAnnotateSource());
        this.connector.setAnnotateTarget(this.params.getAnnotateTarget());
        this.connector.open();
        this.logger.info("Terminology leveraging settings: {} {}", (Object)this.connector.getName(), (Object)this.connector.getSettingsDisplay());
        this.initDone = true;
    }

    private void closeConnector() {
        if (this.connector != null) {
            try {
                this.connector.close();
                this.connector = null;
            }
            catch (Exception e) {
                this.logger.error("Error closing connector", (Throwable)e);
            }
        }
    }
}

