/*
 * Decompiled with CFR 0.152.
 */
package net.sf.okapi.steps.wordcount.common;

import net.sf.okapi.common.Event;
import net.sf.okapi.common.IResource;
import net.sf.okapi.common.IdGenerator;
import net.sf.okapi.common.LocaleId;
import net.sf.okapi.common.resource.Ending;
import net.sf.okapi.common.resource.ITextUnit;
import net.sf.okapi.common.resource.IWithAnnotations;
import net.sf.okapi.common.resource.Segment;
import net.sf.okapi.common.resource.TextContainer;
import net.sf.okapi.common.resource.TextUnit;
import net.sf.okapi.lib.extra.steps.AbstractPipelineStep;
import net.sf.okapi.steps.wordcount.common.Metrics;
import net.sf.okapi.steps.wordcount.common.MetricsAnnotation;
import net.sf.okapi.steps.wordcount.common.Parameters;

public abstract class BaseCountStep
extends AbstractPipelineStep {
    private Parameters params;
    private IdGenerator gen = new IdGenerator("ending");
    private TextContainer source;
    private StringBuilder sb;
    private long batchCount;
    private long batchItemCount;
    private long documentCount;
    private long subDocumentCount;
    private long groupCount;

    public BaseCountStep() {
        this.params = new Parameters();
        this.setParameters(this.params);
        this.setName(this.getName());
        this.setDescription(this.getName());
    }

    @Override
    protected void component_init() {
        this.params = this.getParameters(Parameters.class);
        this.batchCount = 0L;
        this.batchItemCount = 0L;
        this.documentCount = 0L;
        this.subDocumentCount = 0L;
        this.groupCount = 0L;
    }

    @Override
    public abstract String getName();

    @Override
    public abstract String getDescription();

    public abstract String getMetric();

    protected abstract long count(TextContainer var1, LocaleId var2);

    protected abstract long count(Segment var1, LocaleId var2);

    protected abstract long countInTextUnit(ITextUnit var1);

    protected abstract boolean countOnlyTranslatable();

    protected void saveCount(Metrics metrics, long count) {
        if (metrics == null) {
            return;
        }
        metrics.setMetric(this.getMetric(), count);
    }

    public long getBatchCount() {
        return this.batchCount;
    }

    public long getBatchItemCount() {
        return this.batchItemCount;
    }

    public long getDocumentCount() {
        return this.documentCount;
    }

    public long getSubDocumentCount() {
        return this.subDocumentCount;
    }

    public long getGroupCount() {
        return this.groupCount;
    }

    protected void saveToMetrics(Event event, long count) {
        Metrics m;
        if (event == null) {
            return;
        }
        if (count == 0L) {
            return;
        }
        IWithAnnotations res = (IWithAnnotations)((Object)event.getResource());
        if (res == null) {
            res = (IWithAnnotations)((Object)this.createResource(event));
        }
        if (res == null) {
            return;
        }
        MetricsAnnotation ma = res.getAnnotation(MetricsAnnotation.class);
        if (ma == null) {
            ma = new MetricsAnnotation();
            res.setAnnotation(ma);
        }
        if ((m = ma.getMetrics()) == null) {
            return;
        }
        this.saveCount(m, count);
    }

    protected void removeFromMetrics(IWithAnnotations res, String metricName) {
        Metrics m;
        MetricsAnnotation ma = res.getAnnotation(MetricsAnnotation.class);
        if (ma == null) {
            ma = new MetricsAnnotation();
            res.setAnnotation(ma);
        }
        if ((m = ma.getMetrics()) == null) {
            return;
        }
        m.unregisterMetric(metricName);
    }

    protected void removeFromMetrics(TextContainer textContainer, String metricName) {
        Metrics m;
        if (textContainer == null) {
            return;
        }
        MetricsAnnotation ma = textContainer.getAnnotation(MetricsAnnotation.class);
        if (ma == null) {
            ma = new MetricsAnnotation();
            textContainer.setAnnotation(ma);
        }
        if ((m = ma.getMetrics()) == null) {
            return;
        }
        m.unregisterMetric(metricName);
    }

    protected void removeFromMetrics(Segment seg, String metricName) {
        Metrics m;
        if (seg == null) {
            return;
        }
        MetricsAnnotation ma = seg.getAnnotation(MetricsAnnotation.class);
        if (ma == null) {
            ma = new MetricsAnnotation();
            seg.setAnnotation(ma);
        }
        if ((m = ma.getMetrics()) == null) {
            return;
        }
        m.unregisterMetric(metricName);
    }

    private IResource createResource(Event event) {
        if (event == null) {
            return null;
        }
        IResource res = event.getResource();
        if (res != null) {
            return res;
        }
        switch (event.getEventType()) {
            case END_BATCH: 
            case END_BATCH_ITEM: 
            case END_DOCUMENT: 
            case END_SUBDOCUMENT: 
            case END_GROUP: {
                res = new Ending(this.gen.createId());
                event.setResource(res);
                break;
            }
        }
        return res;
    }

    protected void saveToMetrics(TextContainer textContainer, long count) {
        Metrics m;
        if (textContainer == null) {
            return;
        }
        MetricsAnnotation ma = textContainer.getAnnotation(MetricsAnnotation.class);
        if (ma == null) {
            ma = new MetricsAnnotation();
            textContainer.setAnnotation(ma);
        }
        if ((m = ma.getMetrics()) == null) {
            return;
        }
        this.saveCount(m, count);
    }

    protected void saveToMetrics(Segment seg, long count) {
        Metrics m;
        if (seg == null) {
            return;
        }
        if (count == 0L) {
            return;
        }
        MetricsAnnotation ma = seg.getAnnotation(MetricsAnnotation.class);
        if (ma == null) {
            ma = new MetricsAnnotation();
            seg.setAnnotation(ma);
        }
        if ((m = ma.getMetrics()) == null) {
            return;
        }
        this.saveCount(m, count);
    }

    @Override
    protected Event handleStartBatch(Event event) {
        this.batchCount = 0L;
        return event;
    }

    @Override
    protected Event handleEndBatch(Event event) {
        this.flushBuffer();
        if (!this.params.getCountInBatch()) {
            return event;
        }
        if (this.batchCount == 0L) {
            return event;
        }
        this.saveToMetrics(event, this.batchCount);
        return event;
    }

    @Override
    protected Event handleStartBatchItem(Event event) {
        this.batchItemCount = 0L;
        return event;
    }

    @Override
    protected Event handleEndBatchItem(Event event) {
        this.flushBuffer();
        if (!this.params.getCountInBatchItems()) {
            return event;
        }
        if (this.batchItemCount == 0L) {
            return event;
        }
        this.saveToMetrics(event, this.batchItemCount);
        return event;
    }

    @Override
    protected Event handleStartDocument(Event event) {
        this.documentCount = 0L;
        return super.handleStartDocument(event);
    }

    @Override
    protected Event handleEndDocument(Event event) {
        if (!this.params.getCountInDocuments()) {
            return event;
        }
        if (this.documentCount == 0L) {
            return event;
        }
        this.saveToMetrics(event, this.documentCount);
        return event;
    }

    @Override
    protected Event handleStartSubDocument(Event event) {
        this.subDocumentCount = 0L;
        return event;
    }

    @Override
    protected Event handleEndSubDocument(Event event) {
        if (!this.params.getCountInSubDocuments()) {
            return event;
        }
        if (this.subDocumentCount == 0L) {
            return event;
        }
        this.saveToMetrics(event, this.subDocumentCount);
        return event;
    }

    @Override
    protected Event handleStartGroup(Event event) {
        this.groupCount = 0L;
        return event;
    }

    @Override
    protected Event handleEndGroup(Event event) {
        if (!this.params.getCountInGroups()) {
            return event;
        }
        if (this.groupCount == 0L) {
            return event;
        }
        this.saveToMetrics(event, this.groupCount);
        return event;
    }

    protected TextContainer getSource() {
        return this.source;
    }

    private void flushBuffer() {
        if (this.params.getBufferSize() == 0) {
            return;
        }
        if (this.sb == null) {
            return;
        }
        TextUnit tu = new TextUnit("temp", this.sb.toString());
        this.sb = null;
        this.updateCounts(tu, null);
    }

    private void updateCounts(ITextUnit tu, Event event) {
        long textUnitCount = this.countInTextUnit(tu);
        if (textUnitCount != 0L) {
            this.saveToMetrics(event, textUnitCount);
            if (this.params.getCountInBatch()) {
                this.batchCount += textUnitCount;
            }
            if (this.params.getCountInBatchItems()) {
                this.batchItemCount += textUnitCount;
            }
            if (this.params.getCountInDocuments()) {
                this.documentCount += textUnitCount;
            }
            if (this.params.getCountInSubDocuments()) {
                this.subDocumentCount += textUnitCount;
            }
            if (this.params.getCountInGroups()) {
                this.groupCount += textUnitCount;
            }
        }
    }

    @Override
    protected Event handleTextUnit(Event event) {
        ITextUnit tu = event.getTextUnit();
        if (tu.isEmpty()) {
            return event;
        }
        if (!tu.isTranslatable() && this.countOnlyTranslatable()) {
            return event;
        }
        this.source = tu.getSource();
        if (this.params.getBufferSize() > 0) {
            if (this.sb == null) {
                this.sb = new StringBuilder(this.params.getBufferSize());
            }
            String srcText = tu.getSource().getUnSegmentedContentCopy().getText();
            this.sb.append(srcText);
            if (this.sb.length() >= this.params.getBufferSize()) {
                this.flushBuffer();
            }
            return event;
        }
        this.updateCounts(tu, event);
        return event;
    }
}

