/*
 * Decompiled with CFR 0.152.
 */
package net.sf.okapi.steps.searchandreplace;

import java.io.File;
import java.util.List;
import net.sf.okapi.common.Event;
import net.sf.okapi.common.EventType;
import net.sf.okapi.common.FileLocation;
import net.sf.okapi.common.IResource;
import net.sf.okapi.common.LocaleId;
import net.sf.okapi.common.observer.IObserver;
import net.sf.okapi.common.pipeline.IPipelineStep;
import net.sf.okapi.common.pipeline.Pipeline;
import net.sf.okapi.common.resource.TextUnit;
import net.sf.okapi.steps.searchandreplace.EventObserver;
import net.sf.okapi.steps.searchandreplace.Parameters;
import net.sf.okapi.steps.searchandreplace.SearchAndReplaceStep;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.JUnit4;

@RunWith(value=JUnit4.class)
public class SearchAndReplaceTest {
    private SearchAndReplaceStep searchAndReplace;
    private EventObserver eventObserver;
    private Pipeline pipeline;
    private FileLocation root;

    @Before
    public void setUp() throws Exception {
        this.root = FileLocation.fromClass(this.getClass());
        this.searchAndReplace = new SearchAndReplaceStep();
        this.pipeline = new Pipeline();
        this.eventObserver = new EventObserver();
        this.pipeline.addObserver((IObserver)this.eventObserver);
        this.pipeline.addStep((IPipelineStep)this.searchAndReplace);
    }

    @After
    public void tearDown() throws Exception {
    }

    @Test
    public void constructor() {
        Assert.assertNotNull((String)"Step constructor creates a default Parameters", (Object)this.searchAndReplace.getParameters());
    }

    @Test
    public void getDescription() {
        Assert.assertNotNull((String)"Step message is not null", (Object)this.searchAndReplace.getDescription());
        Assert.assertTrue((String)"Step message is a string", (boolean)(this.searchAndReplace.getDescription() instanceof String));
        Assert.assertTrue((String)"Step message is not zero length", (this.searchAndReplace.getDescription().length() >= 1 ? 1 : 0) != 0);
    }

    @Test
    public void replaceSourceCharacter() {
        Parameters p = (Parameters)this.searchAndReplace.getParameters();
        p.reset();
        p.setRegEx(true);
        String[] pattern = new String[]{Boolean.toString(true), "\\{nb\\}|\\{tab\\}|\\{em\\}|\\{en\\}|\\{emsp\\}|\\{ensp\\}", ""};
        p.addRule(pattern);
        p.setTarget(false);
        p.setSource(true);
        this.pipeline.startBatch();
        TextUnit tu = new TextUnit("1", "{nb}{tab}{em}{en}{emsp}{ensp}");
        tu.createTarget(LocaleId.SPANISH, true, 7);
        Event e = new Event(EventType.TEXT_UNIT, (IResource)tu);
        this.pipeline.process(e);
        this.pipeline.endBatch();
        List<Event> el = this.eventObserver.getResult();
        Assert.assertEquals((Object)EventType.START_BATCH, (Object)el.remove(0).getEventType());
        Assert.assertEquals((Object)EventType.START_BATCH_ITEM, (Object)el.remove(0).getEventType());
        tu = el.get(0).getTextUnit();
        Assert.assertTrue((boolean)tu.getSource().getFirstContent().isEmpty());
        Assert.assertEquals((Object)"{nb}{tab}{em}{en}{emsp}{ensp}", (Object)tu.getTarget(LocaleId.SPANISH).getFirstContent().toString());
        Assert.assertEquals((Object)EventType.TEXT_UNIT, (Object)el.remove(0).getEventType());
        Assert.assertEquals((Object)EventType.END_BATCH_ITEM, (Object)el.remove(0).getEventType());
        Assert.assertEquals((Object)EventType.END_BATCH, (Object)el.remove(0).getEventType());
        this.searchAndReplace.setTargetLocale(LocaleId.SPANISH);
    }

    @Test
    public void replaceSourceCharacterMultiplePatterns() {
        Parameters p = (Parameters)this.searchAndReplace.getParameters();
        p.reset();
        p.setRegEx(true);
        String[] pattern = new String[]{Boolean.toString(true), "\\{nb\\}|\\{tab\\}|\\{em\\}", ""};
        p.addRule(pattern);
        String[] pattern2 = new String[]{Boolean.toString(true), "\\{en\\}|\\{emsp\\}|\\{ensp\\}", ""};
        p.addRule(pattern2);
        p.setTarget(false);
        p.setSource(true);
        this.pipeline.startBatch();
        TextUnit tu = new TextUnit("1", "{nb}{tab}{em}{en}{emsp}{ensp}");
        tu.createTarget(LocaleId.SPANISH, true, 7);
        Event e = new Event(EventType.TEXT_UNIT, (IResource)tu);
        this.pipeline.process(e);
        this.pipeline.endBatch();
        List<Event> el = this.eventObserver.getResult();
        Assert.assertEquals((Object)EventType.START_BATCH, (Object)el.remove(0).getEventType());
        Assert.assertEquals((Object)EventType.START_BATCH_ITEM, (Object)el.remove(0).getEventType());
        tu = el.get(0).getTextUnit();
        Assert.assertTrue((boolean)tu.getSource().getFirstContent().isEmpty());
        Assert.assertEquals((Object)"{nb}{tab}{em}{en}{emsp}{ensp}", (Object)tu.getTarget(LocaleId.SPANISH).getFirstContent().toString());
        Assert.assertEquals((Object)EventType.TEXT_UNIT, (Object)el.remove(0).getEventType());
        Assert.assertEquals((Object)EventType.END_BATCH_ITEM, (Object)el.remove(0).getEventType());
        Assert.assertEquals((Object)EventType.END_BATCH, (Object)el.remove(0).getEventType());
        this.searchAndReplace.setTargetLocale(LocaleId.SPANISH);
    }

    @Test
    public void replaceSourceCharacterWithUnicodeChar() {
        Parameters p = (Parameters)this.searchAndReplace.getParameters();
        p.reset();
        p.setRegEx(true);
        String[] pattern = new String[]{Boolean.toString(true), "\\{nb\\}|\\{tab\\}|\\{em\\}|\\{en\\}|\\{emsp\\}|\\{ensp\\}", "E"};
        p.addRule(pattern);
        p.setTarget(false);
        p.setSource(true);
        this.pipeline.startBatch();
        TextUnit tu = new TextUnit("1", "{nb}{tab}{em}{en}{emsp}{ensp}");
        Event e = new Event(EventType.TEXT_UNIT, (IResource)tu);
        this.pipeline.process(e);
        this.pipeline.endBatch();
        List<Event> el = this.eventObserver.getResult();
        Assert.assertEquals((Object)EventType.START_BATCH, (Object)el.remove(0).getEventType());
        Assert.assertEquals((Object)EventType.START_BATCH_ITEM, (Object)el.remove(0).getEventType());
        tu = el.get(0).getTextUnit();
        Assert.assertEquals((Object)"EEEEEE", (Object)tu.getSource().getFirstContent().toString());
        Assert.assertEquals((Object)EventType.TEXT_UNIT, (Object)el.remove(0).getEventType());
        Assert.assertEquals((Object)EventType.END_BATCH_ITEM, (Object)el.remove(0).getEventType());
        Assert.assertEquals((Object)EventType.END_BATCH, (Object)el.remove(0).getEventType());
        this.searchAndReplace.setTargetLocale(LocaleId.SPANISH);
    }

    @Test
    public void replaceTargetCharacter() {
        this.searchAndReplace.setTargetLocale(LocaleId.SPANISH);
        Parameters p = (Parameters)this.searchAndReplace.getParameters();
        p.reset();
        p.setRegEx(true);
        String[] pattern = new String[]{Boolean.toString(true), "\\{nb\\}|\\{tab\\}|\\{em\\}|\\{en\\}|\\{emsp\\}|\\{ensp\\}", ""};
        p.addRule(pattern);
        this.pipeline.startBatch();
        TextUnit tu = new TextUnit("1", "{nb}{tab}{em}{en}{emsp}{ensp}");
        tu.createTarget(LocaleId.SPANISH, true, 7);
        Event e = new Event(EventType.TEXT_UNIT, (IResource)tu);
        this.pipeline.process(e);
        this.pipeline.endBatch();
        List<Event> el = this.eventObserver.getResult();
        Assert.assertEquals((Object)EventType.START_BATCH, (Object)el.remove(0).getEventType());
        Assert.assertEquals((Object)EventType.START_BATCH_ITEM, (Object)el.remove(0).getEventType());
        tu = el.get(0).getTextUnit();
        Assert.assertEquals((Object)"{nb}{tab}{em}{en}{emsp}{ensp}", (Object)tu.getSource().getFirstContent().toString());
        Assert.assertTrue((boolean)tu.getTarget(LocaleId.SPANISH).getFirstContent().isEmpty());
        Assert.assertEquals((Object)EventType.TEXT_UNIT, (Object)el.remove(0).getEventType());
        Assert.assertEquals((Object)EventType.END_BATCH_ITEM, (Object)el.remove(0).getEventType());
        Assert.assertEquals((Object)EventType.END_BATCH, (Object)el.remove(0).getEventType());
    }

    @Test
    public void readTabDelimited() {
        SearchAndReplaceStep srStep = new SearchAndReplaceStep();
        File f = new File(this.root.in("replace.txt").asUri());
        srStep.replacementWords = srStep.loadList(f.getPath());
        Assert.assertEquals((Object)"from1", (Object)((String[])srStep.replacementWords.get(0))[0]);
        Assert.assertEquals((Object)"to1", (Object)((String[])srStep.replacementWords.get(0))[1]);
        Assert.assertEquals((Object)"from2", (Object)((String[])srStep.replacementWords.get(1))[0]);
        Assert.assertEquals((Object)"to2", (Object)((String[])srStep.replacementWords.get(1))[1]);
        Assert.assertEquals((Object)"from3", (Object)((String[])srStep.replacementWords.get(2))[0]);
        Assert.assertEquals((Object)" ", (Object)((String[])srStep.replacementWords.get(2))[1]);
        Assert.assertEquals((Object)"from4", (Object)((String[])srStep.replacementWords.get(3))[0]);
        Assert.assertEquals((Object)"", (Object)((String[])srStep.replacementWords.get(3))[1]);
    }
}

