/*
 * Decompiled with CFR 0.152.
 */
package net.sf.okapi.steps.tokenization.common;

import net.sf.okapi.common.LocaleFilter;
import net.sf.okapi.common.LocaleId;
import net.sf.okapi.common.ParametersString;
import net.sf.okapi.lib.extra.AbstractParameters;

public class LanguageParameters
extends AbstractParameters {
    private LocaleFilter localeFilter;

    protected void parameters_init() {
    }

    protected void parameters_load(ParametersString buffer) {
        if (this.localeFilter == null) {
            return;
        }
        this.localeFilter.fromString(buffer.getString("languages"));
    }

    protected void parameters_reset() {
        this.localeFilter = new LocaleFilter();
    }

    protected void parameters_save(ParametersString buffer) {
        if (this.localeFilter == null) {
            return;
        }
        buffer.setString("languages", this.localeFilter.toString());
    }

    public boolean supportsLanguage(LocaleId language) {
        if (this.localeFilter == null) {
            return false;
        }
        return this.localeFilter.matches(language);
    }

    public LocaleFilter getLocaleFilter() {
        return this.localeFilter;
    }

    public String getLanguages() {
        if (this.localeFilter == null) {
            return "";
        }
        return this.localeFilter.toString();
    }

    public void setLocaleFilter(LocaleFilter localeFilter) {
        this.localeFilter = localeFilter;
    }

    public void setLocaleFilter(String string) {
        if (this.localeFilter == null) {
            return;
        }
        this.localeFilter.fromString(string);
    }
}

