/*
 * Decompiled with CFR 0.152.
 */
package net.sf.okapi.steps.tokenization.common;

import java.util.ArrayList;
import java.util.List;
import net.sf.okapi.common.ListUtil;
import net.sf.okapi.common.ParametersString;
import net.sf.okapi.steps.tokenization.common.LanguageParameters;
import net.sf.okapi.steps.tokenization.tokens.Tokens;

public class LanguageAndTokenParameters
extends LanguageParameters {
    private List<String> tokenNames;
    private List<Integer> tokenIds;

    @Override
    protected void parameters_init() {
        super.parameters_init();
    }

    @Override
    protected void parameters_load(ParametersString buffer) {
        super.parameters_load(buffer);
        this.setTokenNames(buffer.getString("tokens"));
    }

    @Override
    protected void parameters_reset() {
        super.parameters_reset();
        this.tokenNames = new ArrayList<String>();
        this.tokenIds = new ArrayList<Integer>();
    }

    @Override
    protected void parameters_save(ParametersString buffer) {
        super.parameters_save(buffer);
        buffer.setString("tokens", ListUtil.listAsString(this.tokenNames));
    }

    public boolean supportsToken(String tokenName) {
        return this.tokenNames != null && (this.tokenNames.contains(tokenName) || this.tokenNames.size() == 0);
    }

    public boolean supportsToken(int tokenId) {
        return this.tokenIds != null && (this.tokenIds.contains(tokenId) || this.tokenIds.size() == 0);
    }

    public void setTokenNames(String ... tokenNames) {
        if (tokenNames != null) {
            this.tokenNames = ListUtil.arrayAsList((Object[])tokenNames);
        }
        this.tokenIds = Tokens.getTokenIDs(this.tokenNames);
    }

    public List<String> getTokenNames() {
        return this.tokenNames;
    }
}

