/*
 * Decompiled with CFR 0.152.
 */
package net.sf.okapi.steps.xliffsplitter;

import java.io.File;
import net.sf.okapi.common.LocaleId;
import net.sf.okapi.common.Util;
import net.sf.okapi.common.pipeline.IPipelineStep;
import net.sf.okapi.common.pipeline.Pipeline;
import net.sf.okapi.common.resource.RawDocument;
import net.sf.okapi.steps.xliffsplitter.XliffJoinerStep;
import org.junit.After;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.JUnit4;

@RunWith(value=JUnit4.class)
public class XliffJoinerTest {
    private Pipeline pipeline;
    private String xlfRoot;
    private String joinPath;
    private String[] xlfFileList;
    private XliffJoinerStep joiner;

    @Before
    public void setUp() throws Exception {
        this.xlfRoot = Util.getDirectoryName((String)this.getClass().getResource("to_join/tasks_Test_SDL_XLIFF_18961_es_ES_xliff_singleFile_PART0001.xlf").toURI().getPath()) + File.separator;
        this.xlfFileList = Util.getFilteredFiles((String)this.xlfRoot, (String)".xlf");
        this.joinPath = this.xlfRoot + "out" + File.separator;
        Util.createDirectories((String)this.joinPath);
        this.pipeline = new Pipeline();
        this.joiner = new XliffJoinerStep();
        this.pipeline.addStep((IPipelineStep)this.joiner);
    }

    @After
    public void tearDown() throws Exception {
        this.pipeline.destroy();
    }

    @Test
    public void joinXliffWithMultipleInputFiles() {
        this.pipeline.startBatch();
        for (String file : this.xlfFileList) {
            this.joiner.setOutputURI(Util.toURI((String)(this.joinPath + file)));
            this.pipeline.process(new RawDocument(Util.toURI((String)(this.xlfRoot + file)), "UTF-8", LocaleId.ENGLISH));
        }
        this.pipeline.endBatch();
    }
}

