/*
 * Decompiled with CFR 0.152.
 */
package net.sf.okapi.steps.xliffsplitter;

import java.io.File;
import net.sf.okapi.common.IParameters;
import net.sf.okapi.common.LocaleId;
import net.sf.okapi.common.Util;
import net.sf.okapi.common.pipeline.IPipelineStep;
import net.sf.okapi.common.pipeline.Pipeline;
import net.sf.okapi.common.resource.RawDocument;
import net.sf.okapi.steps.xliffsplitter.XliffSplitterParameters;
import net.sf.okapi.steps.xliffsplitter.XliffSplitterStep;
import org.junit.After;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.JUnit4;

@RunWith(value=JUnit4.class)
public class XliffSplitterTest {
    private Pipeline pipeline;
    private String xlfRoot;
    private String splitPath;
    private String[] xlfFileList;
    private XliffSplitterStep splitter;

    @Before
    public void setUp() throws Exception {
        this.xlfRoot = Util.getDirectoryName((String)this.getClass().getResource("tasks_Test_SDL_XLIFF_18961_es_ES_xliff.xlf").toURI().getPath()) + File.separator;
        this.xlfFileList = Util.getFilteredFiles((String)this.xlfRoot, (String)".xlf");
        this.splitPath = this.xlfRoot + "/split";
        Util.createDirectories((String)(this.splitPath + "/"));
        this.pipeline = new Pipeline();
        this.splitter = new XliffSplitterStep();
        this.pipeline.addStep((IPipelineStep)this.splitter);
    }

    @After
    public void tearDown() throws Exception {
        this.pipeline.destroy();
    }

    @Test
    public void splitXliffWithOneFile() {
        this.pipeline.startBatch();
        String file = "tasks_Test_SDL_XLIFF_18961_es_ES_xliff_singleFile.xlf";
        this.splitter.setOutputURI(Util.toURI((String)(this.splitPath + "/" + file)));
        this.pipeline.process(new RawDocument(Util.toURI((String)(this.xlfRoot + file)), "UTF-8", LocaleId.ENGLISH));
        this.pipeline.endBatch();
    }

    @Test
    public void splitXliffWithMultipleFiles() {
        this.pipeline.startBatch();
        String file = "tasks_Test_SDL_XLIFF_18961_es_ES_xliff.xlf";
        this.splitter.setOutputURI(Util.toURI((String)(this.splitPath + "/" + file)));
        this.pipeline.process(new RawDocument(Util.toURI((String)(this.xlfRoot + file)), "UTF-8", LocaleId.ENGLISH));
        this.pipeline.endBatch();
    }

    @Test
    public void splitXliffWithMultipleInputFiles() {
        this.pipeline.startBatch();
        for (String file : this.xlfFileList) {
            this.splitter.setOutputURI(Util.toURI((String)(this.splitPath + "/" + file)));
            this.pipeline.process(new RawDocument(Util.toURI((String)(this.xlfRoot + file)), "UTF-8", LocaleId.ENGLISH));
        }
        this.pipeline.endBatch();
    }

    @Test
    public void splitBigXliffWithOneFile() {
        XliffSplitterParameters params = new XliffSplitterParameters();
        params.setBigFile(true);
        this.splitter.setParameters((IParameters)params);
        this.pipeline.startBatch();
        String file = "tasks_Test_SDL_XLIFF_18961_es_ES_xliff_singleFile.xlf";
        this.splitter.setOutputURI(Util.toURI((String)(this.splitPath + "/" + file)));
        this.pipeline.process(new RawDocument(Util.toURI((String)(this.xlfRoot + file)), "UTF-8", LocaleId.ENGLISH));
        this.pipeline.endBatch();
    }

    @Test
    public void splitBigXliffWithMultipleFiles() {
        XliffSplitterParameters params = new XliffSplitterParameters();
        params.setBigFile(true);
        this.splitter.setParameters((IParameters)params);
        this.pipeline.startBatch();
        String file = "tasks_Test_SDL_XLIFF_18961_es_ES_xliff.xlf";
        this.splitter.setOutputURI(Util.toURI((String)(this.splitPath + "/" + file)));
        this.pipeline.process(new RawDocument(Util.toURI((String)(this.xlfRoot + file)), "UTF-8", LocaleId.ENGLISH));
        this.pipeline.endBatch();
    }

    @Test
    public void splitBigXliffWithMultipleInputFiles() {
        XliffSplitterParameters params = new XliffSplitterParameters();
        params.setBigFile(true);
        this.splitter.setParameters((IParameters)params);
        this.pipeline.startBatch();
        for (String file : this.xlfFileList) {
            this.splitter.setOutputURI(Util.toURI((String)(this.splitPath + "/" + file)));
            this.pipeline.process(new RawDocument(Util.toURI((String)(this.xlfRoot + file)), "UTF-8", LocaleId.ENGLISH));
        }
        this.pipeline.endBatch();
    }
}

