/*
 * Decompiled with CFR 0.152.
 */
package net.sf.okapi.steps.xliffsplitter;

import java.io.IOException;
import java.io.InputStream;
import java.util.Map;
import net.sf.okapi.common.Util;
import net.sf.okapi.steps.xliffsplitter.XliffWCSplitter;
import net.sf.okapi.steps.xliffsplitter.XliffWCSplitterParameters;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.JUnit4;

@RunWith(value=JUnit4.class)
public class XliffWCSplitterTest {
    private String root;
    private String splitDir;

    @Before
    public void setUp() throws Exception {
        this.root = Util.getDirectoryName((String)this.getClass().getResource("input1.xlf").toURI().getPath()) + "/";
        this.splitDir = this.root + "split-wc/";
        Util.createDirectories((String)this.splitDir);
    }

    @Test
    public void test5Words() throws IOException {
        XliffWCSplitterParameters p = new XliffWCSplitterParameters();
        p.setThreshold(5);
        XliffWCSplitter spltr = new XliffWCSplitter(p);
        try (InputStream is = this.getClass().getResourceAsStream("input1.xlf");){
            Util.deleteDirectory((String)this.splitDir, (boolean)true);
            Map res = spltr.process(this.getClass().getResourceAsStream("input1.xlf"), this.splitDir + "output5w", "en-US");
            Assert.assertEquals((long)3L, (long)res.size());
            Assert.assertEquals((long)7L, (long)((Integer)res.get("output5w_PART001.xlf")).intValue());
            Assert.assertEquals((long)8L, (long)((Integer)res.get("output5w_PART002.xlf")).intValue());
            Assert.assertEquals((long)0L, (long)((Integer)res.get("output5w_PART003.xlf")).intValue());
        }
    }

    @Test
    public void test3Words() throws IOException {
        XliffWCSplitterParameters p = new XliffWCSplitterParameters();
        p.setThreshold(3);
        XliffWCSplitter spltr = new XliffWCSplitter(p);
        try (InputStream is = this.getClass().getResourceAsStream("input1.xlf");){
            Util.deleteDirectory((String)this.splitDir, (boolean)true);
            Map res = spltr.process(this.getClass().getResourceAsStream("input1.xlf"), this.splitDir + "output3w", "en-US");
            Assert.assertEquals((long)5L, (long)res.size());
            Assert.assertEquals((long)4L, (long)((Integer)res.get("output3w_PART001.xlf")).intValue());
            Assert.assertEquals((long)3L, (long)((Integer)res.get("output3w_PART002.xlf")).intValue());
            Assert.assertEquals((long)4L, (long)((Integer)res.get("output3w_PART003.xlf")).intValue());
            Assert.assertEquals((long)4L, (long)((Integer)res.get("output3w_PART004.xlf")).intValue());
            Assert.assertEquals((long)0L, (long)((Integer)res.get("output3w_PART005.xlf")).intValue());
        }
    }

    @Test
    public void test9999Words() throws IOException {
        XliffWCSplitterParameters p = new XliffWCSplitterParameters();
        p.setThreshold(9999);
        XliffWCSplitter spltr = new XliffWCSplitter(p);
        try (InputStream is = this.getClass().getResourceAsStream("input1.xlf");){
            Util.deleteDirectory((String)this.splitDir, (boolean)true);
            Map res = spltr.process(this.getClass().getResourceAsStream("input1.xlf"), this.splitDir + "output9999w", "en-US");
            Assert.assertEquals((long)1L, (long)res.size());
            Assert.assertEquals((long)15L, (long)((Integer)res.get("output9999w_PART001.xlf")).intValue());
        }
    }
}

