/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jiga.xtended;

import java.util.Stack;
import net.sf.jiga.xtended.kernel.JXAenvUtils;
import net.sf.jiga.xtended.kernel.ThreadWorks;

public class JXAException
extends RuntimeException {
    public static final Stack<JXAException> _history = new Stack();
    private long hash = System.nanoTime();

    public JXAException() {
        _history.push(this);
    }

    public JXAException(Throwable tCause) {
        this("A JXAException was invoked by : " + tCause, tCause);
    }

    public JXAException(String msg) {
        this(msg, null);
    }

    public JXAException(LEVEL l, String msg) {
        this(JXAenvUtils.log(msg, l.lvl), null);
    }

    public JXAException(String msg, Throwable tCause) {
        super(msg);
        if (tCause != null) {
            this.initCause(tCause);
        }
        _history.push(this);
        this.printStackTrace(ThreadWorks.cLogFilePrintStream);
    }

    public int hashCode() {
        return (int)this.hash;
    }

    public boolean equals(Object o) {
        return o == null ? false : o.hashCode() == this.hashCode();
    }

    public static enum LEVEL {
        APP(JXAenvUtils.LVL.APP_ERR),
        USER(JXAenvUtils.LVL.USR_ERR),
        SYSTEM(JXAenvUtils.LVL.SYS_ERR);

        int jxaLevel;
        JXAenvUtils.LVL lvl;

        private LEVEL(JXAenvUtils.LVL l) {
            this.jxaLevel = l.level;
            this.lvl = l;
        }
    }
}

