/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jiga.xtended.kernel;

import java.io.Serializable;
import java.math.BigInteger;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Vector;
import net.sf.jiga.xtended.kernel.JXAenvUtils;

public class BigBitStack {
    protected final Map<BigInteger, BigInteger> _ALLBITS = Collections.synchronizedMap(new HashMap());
    private int _ALLBITSstack = 0;
    private static BigInteger _TWO = BigInteger.valueOf(2L);
    private BigInteger _ALLBITSRANGES = BigInteger.ZERO;
    private BigInteger _ALLBITSNORANGE = BigInteger.ZERO;

    public BigBitStack() {
        this(BigInteger.ONE);
    }

    public BigBitStack(BigInteger offset) {
        while (offset.compareTo(_TWO.pow(this._ALLBITSstack + 1)) > 0) {
            ++this._ALLBITSstack;
        }
    }

    public int getBitsStackCurrentLevel() {
        return this._ALLBITSstack - 1;
    }

    public final BigInteger _newBitRange() {
        BigInteger newBit = _TWO.pow(this._ALLBITSstack++);
        this._ALLBITSRANGES = this._ALLBITSRANGES.or(newBit);
        return newBit;
    }

    public final BigInteger _newBit(BigInteger range) {
        if (!this._ALLBITSRANGES.and(range).equals(range)) {
            throw new IllegalArgumentException("invalid supplied range");
        }
        BigInteger newBit = _TWO.pow(this._ALLBITSstack++);
        if (!this._ALLBITS.containsKey(range)) {
            this._ALLBITS.put(range, BigInteger.ZERO);
        }
        BigInteger rangeMask = this._ALLBITS.get(range).or(newBit);
        this._ALLBITS.put(range, rangeMask);
        this._ALLBITSNORANGE = this._ALLBITSNORANGE.or(newBit);
        return range.or(newBit);
    }

    public final BigInteger _getAllBitRanges() {
        return this._ALLBITSRANGES;
    }

    public final BigInteger _getAllBits() {
        return this._ALLBITSNORANGE;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final BigInteger _getMask(BigInteger forRange) {
        BigInteger mask = BigInteger.ZERO;
        Map<BigInteger, BigInteger> map = this._ALLBITS;
        synchronized (map) {
            for (BigInteger range : this._ALLBITS.keySet()) {
                if (forRange.and(range).equals(BigInteger.ZERO)) continue;
                mask = mask.or(this._ALLBITS.get(range));
            }
        }
        return mask;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final BigInteger _getNotMask(BigInteger forRange) {
        BigInteger mask = BigInteger.ZERO;
        Map<BigInteger, BigInteger> map = this._ALLBITS;
        synchronized (map) {
            for (BigInteger range : this._ALLBITS.keySet()) {
                if (forRange.and(range).equals(BigInteger.ZERO)) continue;
                mask = mask.or(this._ALLBITS.get(range));
            }
        }
        return mask;
    }

    public static String _toBitsString(BigInteger integer) {
        BigInteger s = integer;
        Vector<Character> sBits = new Vector<Character>();
        while (s.compareTo(BigInteger.ONE) == 1) {
            int n = 0;
            while (_TWO.pow(n).compareTo(s) <= 0) {
                ++n;
            }
            if (sBits.size() < --n + 1) {
                sBits.setSize(n + 1);
            }
            sBits.set(n, Character.valueOf('1'));
            s = s.subtract(_TWO.pow(n));
        }
        if (s.equals(BigInteger.ONE)) {
            if (sBits.isEmpty()) {
                sBits.add(Character.valueOf('1'));
            } else {
                sBits.set(0, Character.valueOf('1'));
            }
        }
        String bitsString = "";
        for (int i = 0; i < sBits.size(); ++i) {
            bitsString = (sBits.get(i) == null ? "0" : (Serializable)sBits.get(i)) + bitsString;
        }
        return bitsString;
    }

    public static String _toBitsString(BigInteger integer, int fields) {
        String bitsString = BigBitStack._toBitsString(integer);
        for (int i = bitsString.length(); i < fields; ++i) {
            bitsString = "0" + bitsString;
        }
        return bitsString;
    }

    static {
        if (JXAenvUtils._debugSys) {
            System.err.println("BigBitStack test 7 bitsString: " + BigBitStack._toBitsString(BigInteger.valueOf(7L), 4));
        }
    }
}

