/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jiga.xtended.kernel;

import java.io.Serializable;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Vector;

public class BitStack {
    protected final Map<Integer, Integer> _ALLBITS = Collections.synchronizedMap(new HashMap());
    private int _ALLBITSstack = 0;
    private int _ALLBITSRANGES = 0;
    private int _ALLBITSNORANGE = 0;

    public BitStack() {
        this(1);
    }

    public BitStack(int offset) {
        while (Math.pow(2.0, this._ALLBITSstack + 1) < (double)offset) {
            ++this._ALLBITSstack;
        }
    }

    public int getBitsStackCurrentLevel() {
        return this._ALLBITSstack - 1;
    }

    public final int _newBitRange() {
        assert (!this.isFull()) : "overflowing the Integer limit";
        int newBit = (int)Math.pow(2.0, this._ALLBITSstack++);
        this._ALLBITSRANGES |= newBit;
        return newBit;
    }

    public boolean isFull() {
        return 2.147483647E9 / Math.pow(2.0, this._ALLBITSstack - 1) < 2.0;
    }

    public final int _newBit(int range) {
        assert (!this.isFull()) : "overflowing the Integer limit";
        if ((this._ALLBITSRANGES & range) != range) {
            throw new IllegalArgumentException("invalid supplied range");
        }
        int newBit = (int)Math.pow(2.0, this._ALLBITSstack++);
        if (!this._ALLBITS.containsKey(range)) {
            this._ALLBITS.put(range, 0);
        }
        int rangeMask = this._ALLBITS.get(range) | newBit;
        this._ALLBITS.put(range, rangeMask);
        this._ALLBITSNORANGE |= newBit;
        return range | newBit;
    }

    public final int _getAllBitRanges() {
        return this._ALLBITSRANGES;
    }

    public final int _getAllBits() {
        return this._ALLBITSNORANGE;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final int _getMask(int forRange) {
        int mask = 0;
        Map<Integer, Integer> map = this._ALLBITS;
        synchronized (map) {
            for (int range : this._ALLBITS.keySet()) {
                if ((forRange & range) == 0) continue;
                mask |= this._ALLBITS.get(range).intValue();
            }
        }
        return mask;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final int _getNotMask(int forRange) {
        int mask = 0;
        Map<Integer, Integer> map = this._ALLBITS;
        synchronized (map) {
            for (int range : this._ALLBITS.keySet()) {
                if ((forRange & range) != 0) continue;
                mask |= this._ALLBITS.get(range).intValue();
            }
        }
        return mask;
    }

    public static String _toBitsString(int integer) {
        double s;
        int n;
        Vector<Character> sBits = new Vector<Character>();
        for (s = (double)integer; s > 1.0; s -= Math.pow(2.0, n)) {
            n = 0;
            while (Math.pow(2.0, n) <= s) {
                ++n;
            }
            if (sBits.size() < --n + 1) {
                sBits.setSize(n + 1);
            }
            sBits.set(n, Character.valueOf('1'));
        }
        if (s == 1.0) {
            if (sBits.isEmpty()) {
                sBits.add(Character.valueOf('1'));
            } else {
                sBits.set(0, Character.valueOf('1'));
            }
        }
        String bitsString = "";
        for (int i = 0; i < sBits.size(); ++i) {
            bitsString = (sBits.get(i) == null ? "0" : (Serializable)sBits.get(i)) + bitsString;
        }
        return bitsString;
    }

    public static String _toBitsString(int integer, int fields) {
        String bitsString = BitStack._toBitsString(integer);
        for (int i = bitsString.length(); i < fields; ++i) {
            bitsString = "0" + bitsString;
        }
        return bitsString;
    }

    public static void test() {
        System.err.println("bitstack test offset 7.\n bitsString: " + BitStack._toBitsString(7, 4));
        new BitStack(7)._newBitRange();
    }
}

