/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jiga.xtended.kernel;

import java.io.BufferedInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.PipedInputStream;
import java.io.PipedOutputStream;
import java.io.PrintStream;
import java.io.PrintWriter;
import java.security.AccessControlContext;
import java.security.AccessController;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Formatter;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.SortedMap;
import java.util.TreeMap;
import net.sf.jiga.xtended.kernel.DebugMap;
import net.sf.jiga.xtended.kernel.Debugger;
import net.sf.jiga.xtended.kernel.ErrorListener;
import net.sf.jiga.xtended.kernel.FileHelper;
import net.sf.jiga.xtended.kernel.InputLogListener;
import net.sf.jiga.xtended.kernel.JXAenvUtils;
import net.sf.jiga.xtended.kernel.Level;
import net.sf.jiga.xtended.kernel.Resource;
import net.sf.jiga.xtended.kernel.SpritesCacheManager;
import net.sf.jiga.xtended.kernel.ThreadWorks;

public class Console
implements Debugger,
Appendable,
Resource {
    public static final String newLine = JXAenvUtils._getSysValue("line.separator");
    public static final Level dbLevel = DebugMap._getInstance().newDebugLevel();
    public static final PrintStream _stdout;
    public static final PrintStream _stderr;
    public static final int STDOUT = 1;
    public static final int STDERR = 2;
    public static final int PRINT_ERROR = 0;
    protected static final int PRINT_WAIT = 1;
    protected static final int PRINT_STOP = 2;
    protected static final int PRINT_RESUME = 3;
    public static int INIT_BUFFER;
    private SpritesCacheManager<Long, StringBuilder> buffer_spm = new SpritesCacheManager(INIT_BUFFER);
    private SortedMap<Long, StringBuilder> buffer = Collections.synchronizedSortedMap(this.buffer_spm);
    public static long MAXSWAPUSAGE;
    private int toStdout = 1;
    private int fromStdout = 0;
    private List<ErrorListener> output = new ArrayList<ErrorListener>();
    private List<InputLogListener> input = new ArrayList<InputLogListener>();
    private final ErrorListener stdOutCallback = new ErrorListener(){

        @Override
        public void printStreamError(IOException e) {
            block3: {
                if (Console.this.isDebugEnabled()) {
                    e.printStackTrace();
                }
                try {
                    Console.this.setLogStdoutEnabled(false);
                }
                catch (IOException ex) {
                    if (!Console.this.isDebugEnabled()) break block3;
                    ex.printStackTrace();
                }
            }
        }
    };
    private final ErrorListener stdErrCallback = new ErrorListener(){

        @Override
        public void printStreamError(IOException e) {
            block3: {
                if (Console.this.isDebugEnabled()) {
                    e.printStackTrace();
                }
                try {
                    Console.this.setLogStderrEnabled(false);
                }
                catch (IOException ex) {
                    if (!Console.this.isDebugEnabled()) break block3;
                    ex.printStackTrace();
                }
            }
        }
    };
    private PrintWriter out = null;
    private SortedMap<Long, PrintStream> in;
    private TreeMap<Long, PrintStream> _in = new TreeMap();
    public String _format = "%s";
    private Map<Integer, List<Long>> stdoutPS = Collections.synchronizedMap(new HashMap());
    protected AccessControlContext acc = AccessController.getContext();
    private ThreadGroup inputMonitor = new ThreadGroup("Console input threadgroup");
    private ThreadGroup outputMonitor = new ThreadGroup("Console output threadgroup");
    private ThreadWorks inputNotifiers = new ThreadWorks("Console input");
    SortedMap<Integer, Map<Long, Integer>> events = Collections.synchronizedSortedMap(new TreeMap());

    public boolean isDebugEnabled() {
        return DebugMap._getInstance().isDebuggerEnabled(Console.class);
    }

    public void setDebugEnabled(boolean b) {
        DebugMap._getInstance().setDebuggerEnabled(b, Console.class, dbLevel);
    }

    @Override
    public Object loadResource() {
        return null;
    }

    public Console() {
        this.buffer_spm.setSwapDiskEnabled(true);
        this.in = Collections.synchronizedSortedMap(this._in);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public StringBuilder getBuffer() {
        StringBuilder strBuf = new StringBuilder();
        SortedMap<Long, StringBuilder> sortedMap = this.buffer;
        synchronized (sortedMap) {
            Iterator<Long> i = this.buffer.keySet().iterator();
            while (i.hasNext()) {
                StringBuilder line = (StringBuilder)this.buffer.get(i.next());
                strBuf.append((CharSequence)(line instanceof StringBuilder ? line : null));
            }
            return strBuf;
        }
    }

    public SortedMap<Long, StringBuilder> getCachedBuffer() {
        return this.buffer;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void notifyInput(String message) {
        if (this.isDebugEnabled()) {
            System.err.println(this.getClass().getName() + "-notifyInput lstSize = " + this.input.size());
        }
        List<InputLogListener> list = this.input;
        synchronized (list) {
            for (InputLogListener ill : this.input) {
                if (ill == null) continue;
                ill.newLogPacket(message);
            }
        }
    }

    public void addInputLogListener(InputLogListener l) {
        if (!this.input.contains(l)) {
            this.sendConsoleEvent(1);
            this.input.add(l);
            this.sendConsoleEvent(3);
        }
    }

    public void removeInputLogListener(InputLogListener l) {
        this.sendConsoleEvent(1);
        this.input.remove(l);
        this.sendConsoleEvent(3);
    }

    public StringBuilder getCurrentLine() {
        StringBuilder line = this.buffer.isEmpty() ? null : (StringBuilder)this.buffer.get(this.buffer.lastKey());
        return line instanceof StringBuilder ? line : new StringBuilder();
    }

    public void setStdoutEnabled(boolean b) {
        this.setStdoutEnabled(b, 1);
    }

    public void setStderrEnabled(boolean b) {
        this.setStdoutEnabled(b, 2);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void setStdoutEnabled(boolean b, int systemStreams) {
        try {
            if (b) {
                this.setLogStdoutEnabled(false, systemStreams);
            }
            this.toStdout = b ? systemStreams : this.toStdout - (this.toStdout & systemStreams);
        }
        catch (IOException ex) {
            try {
                if (this.isDebugEnabled()) {
                    ex.printStackTrace();
                }
                this.toStdout = b ? systemStreams : this.toStdout - (this.toStdout & systemStreams);
            }
            catch (Throwable throwable) {
                this.toStdout = b ? systemStreams : this.toStdout - (this.toStdout & systemStreams);
                throw throwable;
            }
        }
    }

    public boolean isStdoutEnabled() {
        return (this.toStdout & 1) != 0;
    }

    public boolean isLogStdoutEnabled() {
        return (this.fromStdout & 1) != 0;
    }

    public boolean isLogStderrEnabled() {
        return (this.fromStdout & 2) != 0;
    }

    public boolean isStderrEnabled() {
        return (this.toStdout & 2) != 0;
    }

    public void setLogStdoutEnabled(boolean b) throws IOException {
        if (this.isLogStdoutEnabled() && b) {
            return;
        }
        this.setLogStdoutEnabled(b, 1);
    }

    private void setLogStdoutEnabled(final boolean b, final int systemStreams) throws IOException {
        try {
            AccessController.doPrivileged(new PrivilegedExceptionAction(){

                public Object run() throws IOException {
                    Console.this._setLogStdoutEnabled(b, systemStreams);
                    return null;
                }
            }, this.acc);
        }
        catch (PrivilegedActionException ex) {
            throw (IOException)ex.getException();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void _setLogStdoutEnabled(boolean b, int systemStreams) throws IOException {
        int pty = Thread.currentThread().getPriority();
        Thread.currentThread().setPriority(10);
        this.fromStdout = b ? this.fromStdout | systemStreams : this.fromStdout - (this.fromStdout & systemStreams);
        int _toStdout = this.toStdout;
        this.toStdout = 0;
        if (b) {
            HashMap<Integer, Map<String, Object>> pss = new HashMap<Integer, Map<String, Object>>();
            if ((systemStreams & 1) != 0) {
                pss.put(1, this.newPrintStream(this.stdOutCallback));
            }
            if ((systemStreams & 2) != 0) {
                pss.put(2, this.newPrintStream(this.stdErrCallback));
            }
            for (Integer out : pss.keySet()) {
                if (!this.stdoutPS.containsKey(out)) {
                    this.stdoutPS.put(out, new ArrayList());
                }
                Map ps = (Map)pss.get(out);
                long id = (Long)ps.get("id");
                PrintStream printstream = (PrintStream)ps.get("ps");
                if (this.isDebugEnabled()) {
                    System.out.println("loading the printStream " + id + " as system stream...");
                }
                this.sendConsoleEvent(3, id);
                if (!printstream.checkError()) {
                    this.stdoutPS.get(out).add(id);
                    if ((out & 1) != 0) {
                        System.setOut(printstream);
                    }
                    if ((out & 2) == 0) continue;
                    System.setErr(printstream);
                    continue;
                }
                if (!this.isDebugEnabled()) continue;
                System.err.println("PrintStream " + id + " is in error.");
            }
        } else {
            Map<Integer, List<Long>> map;
            boolean error = false;
            if ((systemStreams & 1) != 0) {
                if (this.stdoutPS.containsKey(1)) {
                    map = this.stdoutPS;
                    synchronized (map) {
                        for (Long id : this.stdoutPS.get(1)) {
                            this.sendConsoleEvent(2, id);
                        }
                    }
                }
                if (!(error = _stdout.checkError() || error)) {
                    System.setOut(_stdout);
                }
            }
            if ((systemStreams & 2) != 0) {
                if (this.stdoutPS.containsKey(2)) {
                    map = this.stdoutPS;
                    synchronized (map) {
                        for (Long id : this.stdoutPS.get(2)) {
                            this.sendConsoleEvent(2, id);
                        }
                    }
                }
                if (!(error = _stderr.checkError() || error)) {
                    System.setErr(_stderr);
                }
            }
            if (this.isDebugEnabled() && error) {
                System.err.println("System err PrintStream is in error. see (PrintStream).checkError() !");
            }
        }
        this.toStdout = _toStdout - (systemStreams & _toStdout);
        Thread.currentThread().setPriority(pty);
    }

    public void setLogStderrEnabled(boolean b) throws IOException {
        if (this.isLogStderrEnabled() && b) {
            return;
        }
        this.setLogStdoutEnabled(b, 2);
    }

    public PrintWriter setOutput(PrintWriter newOut) {
        PrintWriter old = this.out;
        this.flushOuput();
        this.out = newOut;
        return old;
    }

    public void flushOuput() {
        if (this.out != null) {
            this.out.flush();
        }
    }

    public Thread getNewInput(InputStream in) throws IOException {
        return this.getNewInput(in, this._format);
    }

    public Thread getNewInput(InputStream in, String format) throws IOException {
        final String _f = format;
        final BufferedInputStream _in = new BufferedInputStream(in);
        final Map<String, Object> map = this.newPrintStream(new ErrorListener(){

            @Override
            public void printStreamError(IOException e) {
                if (Console.this.isDebugEnabled()) {
                    e.printStackTrace();
                }
            }
        });
        Thread t = new Thread(this.inputMonitor, new Runnable(){

            @Override
            public void run() {
                block9: {
                    try {
                        Console.this.sendConsoleEvent(3, (Long)map.get("id"));
                        PrintStream ps = (PrintStream)map.get("ps");
                        ps.println(JXAenvUtils.log("New Console input has been created.", JXAenvUtils.LVL.APP_NOT));
                        Formatter f = new Formatter(ps);
                        byte[] s = new byte[128];
                        while (true) {
                            if (_in.available() <= 0) {
                                Thread.sleep(250L);
                                continue;
                            }
                            int r = _in.read(s);
                            if (r != -1) {
                                byte[] rB = new byte[r];
                                for (int i = 0; i < r; ++i) {
                                    rB[i] = s[i];
                                }
                                f.format(_f, new String(rB));
                            }
                            if (r == -1) break;
                        }
                        if (Console.this.isDebugEnabled()) {
                            System.out.println("InputStream " + (Long)map.get("id") + " is terminating.");
                        }
                        Console.this.sendConsoleEvent(2, (Long)map.get("id"));
                    }
                    catch (IOException e) {
                        if (Console.this.isDebugEnabled()) {
                            e.printStackTrace();
                        }
                    }
                    catch (InterruptedException e) {
                        if (!Console.this.isDebugEnabled()) break block9;
                        e.printStackTrace();
                    }
                }
            }
        }, "T-Console inputStream");
        t.setDaemon(true);
        t.setPriority(10);
        return t;
    }

    public void addErrorListener(ErrorListener l) {
        if (!this.output.contains(l)) {
            this.output.add(l);
        }
    }

    public void removeErrorListener(ErrorListener l) {
        this.output.remove(l);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void notifyError(int event, IOException e) {
        List<ErrorListener> list = this.output;
        synchronized (list) {
            switch (event) {
                case 0: {
                    for (ErrorListener l : this.output) {
                        if (!(l instanceof ErrorListener)) continue;
                        l.printStreamError(e);
                    }
                    break;
                }
            }
        }
    }

    protected Map<String, Object> newPrintStream(ErrorListener l) throws IOException {
        if (l != null) {
            this.addErrorListener(l);
        }
        PipedOutputStream pipedOutputStream = new PipedOutputStream();
        final long id = System.nanoTime();
        PrintStream ps = new PrintStream(pipedOutputStream, true);
        this.in.put(id, ps);
        final BufferedInputStream pis = new BufferedInputStream(new PipedInputStream(pipedOutputStream), FileHelper._SMALLBUFFFER_SIZE);
        Map<String, Object> map = Collections.synchronizedMap(new HashMap());
        map.put("id", id);
        map.put("ps", ps);
        Thread t = new Thread(this.outputMonitor, new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                try {
                    if (Console.this.isDebugEnabled()) {
                        System.out.println("a new PrintStream " + id + " is startin'...");
                    }
                    byte[] b = new byte[128];
                    boolean wait = true;
                    boolean stop = false;
                    block12: while (true) {
                        if (wait) {
                            switch (Console.this.readConsoleEvent(id)) {
                                case 1: {
                                    wait = true;
                                    continue block12;
                                }
                                case 2: {
                                    stop = true;
                                    wait = false;
                                }
                                case 3: {
                                    wait = false;
                                    continue block12;
                                }
                            }
                            Thread.yield();
                            continue;
                        }
                        if (stop) break;
                        while (pis.available() <= 0) {
                            Thread.sleep(250L);
                        }
                        int r = pis.read(b);
                        if (r != -1) {
                            byte[] rB = new byte[r];
                            for (int i = 0; i < r; ++i) {
                                rB[i] = b[i];
                            }
                            final String s = new String(rB);
                            Console.this.inputNotifiers.doLater(new Runnable(){

                                @Override
                                public void run() {
                                    Console.this.notifyInput(s);
                                    try {
                                        Console.this.append(s);
                                    }
                                    catch (IOException ex) {
                                        Console.this.notifyError(0, ex);
                                    }
                                    finally {
                                        Console.this.sendConsoleEvent(2, id);
                                    }
                                }
                            });
                        }
                        if (r == -1) break;
                    }
                    if (Console.this.isDebugEnabled()) {
                        System.out.println("PrintStream " + id + " is terminating...");
                    }
                    pis.close();
                }
                catch (InterruptedException ex) {
                    if (Console.this.isDebugEnabled()) {
                        ex.printStackTrace();
                    }
                }
                catch (IOException ex) {
                    Console.this.notifyError(0, ex);
                }
                finally {
                    Console.this.removePrintStream(id);
                }
            }
        }, "T-PrintStream-" + id);
        t.setPriority(10);
        t.setDaemon(true);
        t.start();
        if (this.isDebugEnabled()) {
            System.out.println("The new PrintStream " + id + " is waiting for a startup delivery...");
        }
        return map;
    }

    protected PrintStream removePrintStream(long id) {
        return (PrintStream)this.in.remove(id);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int readConsoleEvent(long id) {
        Set<Integer> set = this.events.keySet();
        SortedMap<Integer, Map<Long, Integer>> sortedMap = this.events;
        synchronized (sortedMap) {
            Iterator<Integer> i = set.iterator();
            while (i.hasNext()) {
                int key = i.next();
                Map event = (Map)this.events.get(key);
                if (event == null || event.get(id) == null) continue;
                i.remove();
                return (Integer)event.get(id);
            }
            return -1;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void sendConsoleEvent(int event) {
        Set<Long> set = this.in.keySet();
        SortedMap<Long, PrintStream> sortedMap = this.in;
        synchronized (sortedMap) {
            Iterator<Long> i = set.iterator();
            while (i.hasNext()) {
                this.sendConsoleEvent(event, i.next());
            }
        }
    }

    private void sendConsoleEvent(int event, long id) {
        HashMap<Long, Integer> map = new HashMap<Long, Integer>();
        map.put(id, event);
        this.events.put(this.events.size(), map);
    }

    @Override
    public Appendable append(final CharSequence charSequence) throws IOException {
        try {
            return AccessController.doPrivileged(new PrivilegedExceptionAction<Appendable>(){

                @Override
                public Appendable run() throws IOException {
                    return Console.this._append(charSequence);
                }
            }, this.acc);
        }
        catch (PrivilegedActionException ex) {
            throw (IOException)ex.getException();
        }
    }

    private Appendable _append(CharSequence charSequence) throws IOException {
        charSequence = new Formatter().format(this._format, charSequence).toString().subSequence(0, charSequence.length());
        if ((this.toStdout & 1) != 0) {
            _stdout.append(charSequence);
        }
        if ((this.toStdout & 2) != 0) {
            _stderr.append(charSequence);
        }
        if (this.out != null) {
            this.out.append(charSequence);
        }
        String[] s = charSequence.toString().split(newLine);
        boolean b = this.buffer_spm.isDebugEnabled();
        this.buffer_spm.setDebugEnabled(false);
        for (int i = 0; i < s.length; ++i) {
            String line = s[i];
            if (i < s.length - 1) {
                line = line + newLine;
            }
            if (!this.buffer.isEmpty() && this.getCurrentLine().lastIndexOf(newLine) == -1) {
                this.buffer.put(this.buffer.lastKey(), this.getCurrentLine().append(line));
                continue;
            }
            this.buffer.put(System.nanoTime(), new StringBuilder(line));
        }
        if (this.buffer_spm.getSwapUsage() > MAXSWAPUSAGE) {
            if (this.isDebugEnabled()) {
                System.out.println(this.getClass().getName() + " SWAP MEMORY LIMIT is " + MAXSWAPUSAGE + " clearing swap map...");
            }
            this.buffer_spm.clearMemorySwap();
        }
        this.buffer_spm.setDebugEnabled(b);
        return this;
    }

    @Override
    public Appendable append(final CharSequence charSequence, final int i, final int i0) throws IOException {
        try {
            return AccessController.doPrivileged(new PrivilegedExceptionAction<Appendable>(){

                @Override
                public Appendable run() throws IOException {
                    return Console.this._append(charSequence, i, i0);
                }
            }, this.acc);
        }
        catch (PrivilegedActionException ex) {
            throw (IOException)ex.getException();
        }
    }

    private Appendable _append(CharSequence charSequence, int i, int i0) throws IOException {
        charSequence = new Formatter().format(this._format, charSequence).toString().subSequence(i, i0);
        if ((this.toStdout & 1) != 0) {
            _stdout.append(charSequence, i, i0);
        }
        if ((this.toStdout & 2) != 0) {
            _stderr.append(charSequence, i, i0);
        }
        if (this.out != null) {
            this.out.append(charSequence, i, i0);
        }
        String[] s = charSequence.toString().split(newLine);
        boolean b = this.buffer_spm.isDebugEnabled();
        this.buffer_spm.setDebugEnabled(false);
        for (int j = 0; j < s.length; ++j) {
            String line = s[j];
            if (j < s.length - 1) {
                line = line + newLine;
            }
            if (!this.buffer.isEmpty() && this.getCurrentLine().lastIndexOf(newLine) == -1) {
                this.buffer.put(this.buffer.lastKey(), this.getCurrentLine().append(line, i, i0));
                continue;
            }
            this.buffer.put(System.nanoTime(), new StringBuilder().append(line, i, i0));
        }
        if (this.buffer_spm.getSwapUsage() > MAXSWAPUSAGE) {
            if (this.isDebugEnabled()) {
                System.out.println(this.getClass().getName() + " SWAP MEMORY LIMIT is " + MAXSWAPUSAGE + " clearing swap map...");
            }
            this.buffer_spm.clearMemorySwap();
        }
        this.buffer_spm.setDebugEnabled(b);
        return this;
    }

    @Override
    public Appendable append(final char c) throws IOException {
        try {
            return AccessController.doPrivileged(new PrivilegedExceptionAction<Appendable>(){

                @Override
                public Appendable run() throws IOException {
                    return Console.this._append(c);
                }
            }, this.acc);
        }
        catch (PrivilegedActionException ex) {
            throw (IOException)ex.getException();
        }
    }

    private Appendable _append(char c) throws IOException {
        c = new Formatter().format(this._format, Character.valueOf(c)).toString().charAt(0);
        if ((this.toStdout & 1) != 0) {
            _stdout.append(c);
        }
        if ((this.toStdout & 2) != 0) {
            _stderr.append(c);
        }
        if (this.out != null) {
            this.out.append(c);
        }
        boolean b = this.buffer_spm.isDebugEnabled();
        this.buffer_spm.setDebugEnabled(false);
        if (!this.buffer.isEmpty() && this.getCurrentLine().lastIndexOf(newLine) == -1) {
            this.buffer.put(this.buffer.lastKey(), this.getCurrentLine().append(c));
        } else {
            this.buffer.put(System.nanoTime(), new StringBuilder(c));
        }
        if (this.buffer_spm.getSwapUsage() > MAXSWAPUSAGE) {
            if (this.isDebugEnabled()) {
                System.out.println(this.getClass().getName() + " SWAP MEMORY LIMIT is " + MAXSWAPUSAGE + " clearing swap map...");
            }
            this.buffer_spm.clearMemorySwap();
        }
        this.buffer_spm.setDebugEnabled(b);
        return this;
    }

    public void clearContents() {
        this.buffer.clear();
        this.buffer_spm.clearMemorySwap();
    }

    public void finalize() {
        this.clearResource();
    }

    public PrintStream getNewPrintStream(ErrorListener l) {
        try {
            Map<String, Object> map = this.newPrintStream(l);
            PrintStream ps = (PrintStream)map.get("ps");
            long id = (Long)map.get("id");
            this.sendConsoleEvent(3, id);
            return ps;
        }
        catch (IOException ex) {
            if (this.isDebugEnabled()) {
                ex.printStackTrace();
            }
            return null;
        }
    }

    @Override
    public Object clearResource() {
        try {
            if (this.isLogStderrEnabled()) {
                this.setLogStderrEnabled(false);
            }
            if (this.isLogStdoutEnabled()) {
                this.setLogStdoutEnabled(false);
            }
            this.sendConsoleEvent(2);
            this.clearContents();
        }
        catch (IOException ex) {
            if (this.isDebugEnabled()) {
                ex.printStackTrace();
            }
        }
        finally {
            return null;
        }
    }

    @Override
    public boolean isResourceLoaded() {
        return true;
    }

    public boolean isInnerResourceModeEnabled() {
        return false;
    }

    public void setInnerResourceModeEnabled(boolean b) {
    }

    static {
        DebugMap._getInstance().setDebuggerEnabled("jxa.debugCSL", Console.class, dbLevel);
        _stdout = System.out;
        _stderr = System.err;
        INIT_BUFFER = 200;
        MAXSWAPUSAGE = 4000000L;
    }
}

