/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jiga.xtended.kernel;

import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectStreamClass;
import java.io.Serializable;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.security.AccessControlContext;
import java.security.AccessController;
import net.sf.jiga.xtended.JXAException;
import net.sf.jiga.xtended.kernel.DebugMap;
import net.sf.jiga.xtended.kernel.ExtensionsClassLoaderImpl;
import net.sf.jiga.xtended.kernel.JXAenvUtils;
import net.sf.jiga.xtended.kernel.env;

public class ExtensionsClassLoader {
    static AccessControlContext _acc = AccessController.getContext();
    private static ExtensionsClassLoader _INSTANCE;
    private ClassLoader ECL;

    private ExtensionsClassLoader(JXAenvUtils env2) {
        env2.classLoader = this.ECL = new ExtensionsClassLoaderImpl(env2);
    }

    @Deprecated
    private ExtensionsClassLoader(JXAenvUtils env2, boolean keepRemote) {
        env2.keepReadingOnRemoteJarResources = keepRemote;
        env2.classLoader = this.ECL = new ExtensionsClassLoaderImpl(env2);
    }

    public static ExtensionsClassLoader getInstance() {
        if (!ExtensionsClassLoader.isResourceLoaded()) {
            throw new JXAException(JXAException.LEVEL.SYSTEM, "classloader instance not loaded yet !! ECL INSTANCE is not ready. !!");
        }
        return _INSTANCE;
    }

    public ClassLoader getClassLoader() {
        return this.ECL;
    }

    public static void _load(JXAenvUtils env2) {
        if (ExtensionsClassLoader.isResourceLoaded()) {
            throw new JXAException(JXAException.LEVEL.SYSTEM, "trying to change environment classloader, but it was already loaded");
        }
        _INSTANCE = new ExtensionsClassLoader(env2);
        JXAenvUtils._switchToClassLoader(ExtensionsClassLoader._INSTANCE.ECL);
    }

    @Deprecated
    public static void _load(JXAenvUtils env2, boolean keepRemote) {
        env2.keepReadingOnRemoteJarResources = keepRemote;
        ExtensionsClassLoader._load(env2);
    }

    public static Class<?> forName(String name) throws ClassNotFoundException {
        return Class.forName(name, true, ExtensionsClassLoader._INSTANCE.ECL);
    }

    public static InvocationHandler _proxyClassHandler(Object target) {
        return new ProxyClassHandler(target);
    }

    public static <T> T _proxyClass(Object target, Class<T> clazz) {
        if (!clazz.isInterface()) {
            throw new IllegalArgumentException("Class " + clazz + " is not an interface");
        }
        return (T)(target == null ? null : Proxy.newProxyInstance(clazz.getClassLoader(), new Class[]{clazz}, ExtensionsClassLoader._proxyClassHandler(target)));
    }

    public static boolean isResourceLoaded() {
        return _INSTANCE != null;
    }

    class ObjectInputStream
    extends java.io.ObjectInputStream {
        public ObjectInputStream(InputStream in) throws IOException {
            super(in);
        }

        @Override
        protected Class<?> resolveClass(ObjectStreamClass desc) throws IOException, ClassNotFoundException {
            if (!env.APP_REMOTE.isEnv()) {
                if (DebugMap._getInstance().isDebugLevelEnabled(DebugMap._getInstance()._VOID)) {
                    System.out.println("resolveClass classloader " + Thread.currentThread().getContextClassLoader());
                }
                return super.resolveClass(desc);
            }
            if (DebugMap._getInstance().isDebugLevelEnabled(DebugMap._getInstance()._VOID)) {
                System.out.println("resolveClass classloader " + ExtensionsClassLoader.this.ECL);
            }
            String name = desc.getName();
            try {
                return Class.forName(name, false, ExtensionsClassLoader.this.ECL);
            }
            catch (ClassNotFoundException ex) {
                if (DebugMap._getInstance().isDebugLevelEnabled(DebugMap._getInstance()._VOID)) {
                    ex.printStackTrace();
                }
                return super.resolveClass(desc);
            }
        }

        @Override
        protected Class<?> resolveProxyClass(String[] interfaces) throws IOException, ClassNotFoundException {
            if (!env.APP_REMOTE.isEnv()) {
                if (DebugMap._getInstance().isDebugLevelEnabled(DebugMap._getInstance()._VOID)) {
                    System.out.println("resolveProxyClass classloader " + Thread.currentThread().getContextClassLoader());
                }
                return super.resolveProxyClass(interfaces);
            }
            if (DebugMap._getInstance().isDebugLevelEnabled(DebugMap._getInstance()._VOID)) {
                System.out.println("resolveProxyClass classloader " + ExtensionsClassLoader.this.ECL);
            }
            Class[] classes = new Class[interfaces.length];
            for (int i = 0; i < interfaces.length; ++i) {
                classes[i] = Class.forName(interfaces[i], false, ExtensionsClassLoader.this.ECL);
            }
            try {
                return Proxy.getProxyClass(ExtensionsClassLoader.this.ECL, classes);
            }
            catch (IllegalArgumentException ex) {
                if (DebugMap._getInstance().isDebugLevelEnabled(DebugMap._getInstance()._VOID)) {
                    ex.printStackTrace();
                }
                return super.resolveProxyClass(interfaces);
            }
        }
    }

    static class ProxyClassHandler
    implements InvocationHandler,
    Serializable {
        private static final long serialVersionUID = 2323L;
        Object target;

        public ProxyClassHandler(Object target) {
            this.target = target;
        }

        @Override
        public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
            Object o = this.target.getClass().getMethod(method.getName(), method.getParameterTypes()).invoke(this.target, args);
            return o;
        }
    }
}

