/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jiga.xtended.kernel;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.JarURLConnection;
import java.net.MalformedURLException;
import java.net.URISyntaxException;
import java.net.URL;
import java.net.URLConnection;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.security.AccessControlContext;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import java.security.SecureClassLoader;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.jar.Attributes;
import java.util.jar.Manifest;
import net.sf.jiga.xtended.kernel.DebugMap;
import net.sf.jiga.xtended.kernel.Debugger;
import net.sf.jiga.xtended.kernel.ExtensionsInstaller;
import net.sf.jiga.xtended.kernel.JXAenvUtils;
import net.sf.jiga.xtended.kernel.Level;
import net.sf.jiga.xtended.kernel.SystemPropertyChange;
import net.sf.jiga.xtended.kernel.ThreadBlockData;

public class ExtensionsClassLoaderImpl
extends SecureClassLoader
implements Debugger {
    public static final Level _DEBUG = DebugMap._getInstance().newDebugLevel();
    protected AccessControlContext acc;
    protected URL[] extClassPathUrl;
    private Map<String, Class<?>> cache = Collections.synchronizedMap(new HashMap());
    public static final String JXA_ECLFIRST = "jxa.ecl.first";
    public static ThreadBlockData<Boolean> isFirst;
    private ThreadLocal<List<URL>> currentSeek = new ThreadLocal<List<URL>>(){

        @Override
        protected List<URL> initialValue() {
            return new ArrayList<URL>();
        }
    };

    public ExtensionsClassLoaderImpl(JXAenvUtils env2) {
        super(env2.getEnvClassLoader());
        this.extClassPathUrl = ExtensionsInstaller._getURLClassLoaderURLS(env2);
        this.acc = AccessController.getContext();
        if (this.isDebugEnabled()) {
            String s = "new instance (EXTDIR=" + env2.getJXAenvPath() + ") with parent ClassLoader " + env2.getEnvClassLoader();
            for (URL url : this.extClassPathUrl) {
                s = s + "\nresource url : " + url;
            }
            System.out.println(JXAenvUtils.log(s, JXAenvUtils.LVL.SYS_NOT));
        }
    }

    public byte[] getData(final URL jarUrl) {
        return AccessController.doPrivileged(new PrivilegedAction<byte[]>(){

            @Override
            public byte[] run() {
                return ExtensionsClassLoaderImpl.this._getData(jarUrl);
            }
        }, this.acc);
    }

    protected byte[] _getData(URL jarUrl) {
        block4: {
            if (jarUrl != null) {
                try {
                    JarURLConnection jar = (JarURLConnection)jarUrl.openConnection();
                    BufferedInputStream bis = new BufferedInputStream(jar.getInputStream());
                    ByteBuffer b = ByteBuffer.allocate(jar.getContentLength()).order(ByteOrder.nativeOrder());
                    byte[] r = new byte[512];
                    int rB = 0;
                    while ((rB = bis.read(r)) != -1) {
                        b.put(r, 0, rB);
                    }
                    bis.close();
                    return b.array();
                }
                catch (IOException ex) {
                    if (!this.isDebugEnabled()) break block4;
                    ex.printStackTrace();
                }
            }
        }
        return null;
    }

    private String getAttribute(Attributes main, Attributes spec, Attributes.Name name) {
        String v = null;
        if (spec != null) {
            v = spec.getValue(name);
        }
        if (v == null && main != null) {
            v = main.getValue(name);
        }
        return v;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    protected Class<?> findClass(String name) throws ClassNotFoundException {
        Class<?> c;
        if (this.isDebugEnabled()) {
            System.out.println(JXAenvUtils.log("ECL findClass " + name, JXAenvUtils.LVL.SYS_NOT));
        }
        if ((c = this.cache.get(name)) == null) {
            byte[] classData;
            if (!(name instanceof String)) throw new ClassNotFoundException(JXAenvUtils.log("ECL class null name was given", JXAenvUtils.LVL.SYS_NOT));
            String jarEntry = name.replaceAll("\\.", "/") + ".class";
            if (name.startsWith("java.")) throw new ClassNotFoundException(JXAenvUtils.log("ECL java.* class " + name + " was given", JXAenvUtils.LVL.SYS_NOT));
            URL res = this.findResource(jarEntry);
            if (res != null && (classData = this.getData(res)) != null) {
                String pname = name.substring(0, name.lastIndexOf("."));
                boolean attributes = false;
                if (this.getPackage(pname) == null) {
                    block11: {
                        JarURLConnection juc = this._findJarConnection(jarEntry);
                        if (juc != null) {
                            try {
                                Manifest m = juc.getJarFile().getManifest();
                                if (m != null) {
                                    Attributes aMain = m.getMainAttributes();
                                    String path = pname.replace('.', '/').concat("/");
                                    Attributes a = m.getAttributes(path);
                                    this.definePackage(pname, this.getAttribute(aMain, a, Attributes.Name.SPECIFICATION_TITLE), this.getAttribute(aMain, a, Attributes.Name.SPECIFICATION_VERSION), this.getAttribute(aMain, a, Attributes.Name.SPECIFICATION_VENDOR), this.getAttribute(aMain, a, Attributes.Name.IMPLEMENTATION_TITLE), this.getAttribute(aMain, a, Attributes.Name.IMPLEMENTATION_VERSION), this.getAttribute(aMain, a, Attributes.Name.IMPLEMENTATION_VENDOR), "true".equalsIgnoreCase(this.getAttribute(aMain, a, Attributes.Name.SEALED)) ? juc.getJarFileURL() : null);
                                    if (this.isDebugEnabled()) {
                                        System.out.println("ECL defined package " + pname + "(" + path + ")" + this.getPackage(pname).toString());
                                    }
                                    attributes = true;
                                }
                            }
                            catch (IOException ex) {
                                if (!this.isDebugEnabled()) break block11;
                                ex.printStackTrace();
                            }
                        }
                    }
                    if (!attributes) {
                        this.definePackage(pname, null, null, null, null, null, null, null);
                    }
                }
                c = this.defineClass(name, classData, 0, classData.length, this.getClass().getProtectionDomain());
                if (this.isDebugEnabled()) {
                    System.out.println(JXAenvUtils.log("ECL successfully defined class " + name, JXAenvUtils.LVL.SYS_NOT));
                }
            }
        }
        if (c == null) throw new ClassNotFoundException(JXAenvUtils.log("ECL class " + name + " was not found", JXAenvUtils.LVL.SYS_NOT));
        this.cache.put(name, c);
        return c;
    }

    protected JarURLConnection _findJarEntryConnection(final URL jarUrl, final String resourceName) {
        return AccessController.doPrivileged(new PrivilegedAction<JarURLConnection>(){

            @Override
            public JarURLConnection run() {
                JarURLConnection jarUrlConn = ExtensionsClassLoaderImpl.this.__findJarEntryConnection(jarUrl, resourceName);
                ExtensionsClassLoaderImpl.this.currentSeek.remove();
                return jarUrlConn;
            }
        }, this.acc);
    }

    public static boolean isFirst() {
        return isFirst.get();
    }

    @Override
    protected synchronized Class<?> loadClass(String name, boolean resolve) throws ClassNotFoundException {
        Class<?> c;
        if (this.isDebugEnabled()) {
            System.out.println("ECL loadClass " + name + " resolve " + resolve);
        }
        ClassNotFoundException cnf = null;
        Class<?> clazz = c = this.cache.containsKey(name) ? this.cache.get(name) : this.findLoadedClass(name);
        if (!ExtensionsClassLoaderImpl.isFirst() && c == null) {
            try {
                c = this.getParent() != null ? this.getParent().loadClass(name) : ExtensionsClassLoaderImpl.getSystemClassLoader().loadClass(name);
            }
            catch (ClassNotFoundException ex) {
                cnf = ex;
            }
        }
        if (c == null) {
            try {
                c = this.findClass(name);
            }
            catch (ClassNotFoundException ex) {
                cnf = ex;
            }
        }
        if (ExtensionsClassLoaderImpl.isFirst() && c == null) {
            try {
                c = this.getParent() != null ? this.getParent().loadClass(name) : ExtensionsClassLoaderImpl.getSystemClassLoader().loadClass(name);
            }
            catch (ClassNotFoundException ex) {
                cnf = ex;
            }
        }
        if (c == null) {
            throw new ClassNotFoundException(name, cnf);
        }
        if (this.isDebugEnabled()) {
            System.out.println("System successfully loaded class " + name);
        }
        if (resolve) {
            this.resolveClass(c);
        }
        return c;
    }

    protected JarURLConnection __findJarEntryConnection(URL jarUrl, String resourceName) {
        try {
            if (jarUrl == null || !jarUrl.toString().endsWith(".jar")) {
                return null;
            }
            this.currentSeek.get().add(jarUrl);
            URL u = new URL(new URL("jar:" + jarUrl + "!/"), resourceName);
            URLConnection jar = u.openConnection();
            if (jar instanceof JarURLConnection && ((JarURLConnection)jar).getJarEntry() != null) {
                return (JarURLConnection)jar;
            }
            return null;
        }
        catch (IOException ex) {
            if (this.isDebugEnabled() && DebugMap._getInstance().isDebugLevelEnabled(DebugMap._getInstance()._VOID)) {
                System.err.println(ex.getMessage());
            }
            try {
                if (jarUrl != null) {
                    Map<String, URL> jarUrls = ExtensionsInstaller._getJarClasspathJars(jarUrl);
                    for (URL classpathinjarUrl : jarUrls.values()) {
                        JarURLConnection entryUrl;
                        if (this.currentSeek.get().contains(classpathinjarUrl) || (entryUrl = this.__findJarEntryConnection(classpathinjarUrl, resourceName)) == null) continue;
                        return entryUrl;
                    }
                }
                return null;
            }
            catch (IOException ex2) {
                if (this.isDebugEnabled() && DebugMap._getInstance().isDebugLevelEnabled(DebugMap._getInstance()._VOID)) {
                    ex2.printStackTrace();
                }
                return null;
            }
        }
    }

    @Override
    public InputStream getResourceAsStream(String name) {
        try {
            URL u = this.getResource(name);
            if (u != null) {
                return u.openStream();
            }
            return null;
        }
        catch (IOException ex) {
            if (this.isDebugEnabled()) {
                ex.printStackTrace();
            }
            return null;
        }
    }

    @Override
    public URL getResource(String name) {
        if (this.isDebugEnabled()) {
            System.out.println("ECL look for resource : " + name);
        }
        URL r = null;
        if (!ExtensionsClassLoaderImpl.isFirst()) {
            r = this.getParent() != null ? this.getParent().getResource(name) : ExtensionsClassLoaderImpl.getSystemResource(name);
        }
        if (r == null) {
            r = this.findResource(name);
        }
        if (ExtensionsClassLoaderImpl.isFirst() && r == null) {
            r = this.getParent() != null ? this.getParent().getResource(name) : ExtensionsClassLoaderImpl.getSystemResource(name);
        }
        if (r != null && this.isDebugEnabled()) {
            System.err.println("System found resource " + name);
        }
        return r;
    }

    protected JarURLConnection _findJarConnection(String resourceName) {
        URL url;
        JarURLConnection jarUrl = null;
        while (resourceName.startsWith("/") && resourceName.length() > 1) {
            resourceName = resourceName.substring(1);
        }
        URL[] uRLArray = this.extClassPathUrl;
        int n = uRLArray.length;
        for (int i = 0; i < n && (jarUrl = this._findJarEntryConnection(url = uRLArray[i], resourceName)) == null; ++i) {
        }
        return jarUrl;
    }

    @Override
    protected URL findResource(String name) {
        JarURLConnection juc = this._findJarConnection(name);
        if (juc != null) {
            URL jarUrl = juc.getURL();
            if (this.isDebugEnabled()) {
                System.out.println(JXAenvUtils.log("found resource : " + jarUrl, JXAenvUtils.LVL.SYS_NOT));
            }
            return jarUrl;
        }
        if (this.isDebugEnabled()) {
            System.out.println(JXAenvUtils.log("resource not found : " + name, JXAenvUtils.LVL.SYS_NOT));
        }
        return null;
    }

    @Override
    public Enumeration<URL> getResources(String name) throws IOException {
        URL u;
        LinkedList<URL> r = new LinkedList<URL>();
        Enumeration<URL> e = null;
        if (!ExtensionsClassLoaderImpl.isFirst()) {
            e = this.getParent() != null ? this.getParent().getResources(name) : ExtensionsClassLoaderImpl.getSystemResources(name);
            while (e.hasMoreElements()) {
                u = e.nextElement();
                if (r.contains(u)) continue;
                r.add(u);
            }
        }
        e = this.findResources(name);
        while (e.hasMoreElements()) {
            r.add(e.nextElement());
        }
        if (ExtensionsClassLoaderImpl.isFirst()) {
            e = this.getParent() != null ? this.getParent().getResources(name) : ExtensionsClassLoaderImpl.getSystemResources(name);
            while (e.hasMoreElements()) {
                u = e.nextElement();
                if (r.contains(u)) continue;
                r.add(u);
            }
        }
        return Collections.enumeration(r);
    }

    @Override
    protected Enumeration<URL> findResources(String resourceName) throws IOException {
        LinkedList<URL> l = new LinkedList<URL>();
        while (resourceName.startsWith("/") && resourceName.length() > 1) {
            resourceName = resourceName.substring(1);
        }
        for (URL url : this.extClassPathUrl) {
            JarURLConnection u = this._findJarEntryConnection(url, resourceName);
            if (u == null) continue;
            l.add(u.getURL());
        }
        return Collections.enumeration(l);
    }

    @Override
    protected String findLibrary(final String libname) {
        try {
            File ret = AccessController.doPrivileged(new PrivilegedExceptionAction<File>(){

                @Override
                public File run() throws MalformedURLException, URISyntaxException {
                    Map<URL, Boolean> map = ExtensionsInstaller._getJXANatenvFiles(null, new File(ExtensionsInstaller._findExtPath(true)).toURI().toURL()).get(JXAenvUtils._getSysValue("os.name")).get(libname);
                    if (map instanceof Map) {
                        return new File(map.keySet().iterator().next().toURI());
                    }
                    return null;
                }
            }, this.acc);
            return ret != null ? (ret.exists() ? ret.getAbsolutePath() : null) : null;
        }
        catch (PrivilegedActionException ex) {
            if (this.isDebugEnabled()) {
                ex.getException().printStackTrace();
            }
            return null;
        }
    }

    public boolean isDebugEnabled() {
        return DebugMap._getInstance().isDebuggerEnabled(ExtensionsClassLoaderImpl.class);
    }

    public void setDebugEnabled(boolean b) {
        DebugMap._getInstance().setDebuggerEnabled(b, ExtensionsClassLoaderImpl.class, _DEBUG);
    }

    static {
        DebugMap._getInstance().associateDebugLevel(ExtensionsClassLoaderImpl.class, _DEBUG);
        DebugMap._getInstance().setDebuggerEnabled("jxa.debugECL", ExtensionsClassLoaderImpl.class, _DEBUG);
        isFirst = new ThreadBlockData<Boolean>(Boolean.valueOf(Boolean.getBoolean(JXA_ECLFIRST)));
        SystemPropertyChange.INSTANCE.add(new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent evt) {
                if (evt.getPropertyName().equals(ExtensionsClassLoaderImpl.JXA_ECLFIRST)) {
                    isFirst = new ThreadBlockData<Boolean>(Boolean.valueOf(Boolean.parseBoolean(evt.getNewValue().toString())));
                }
            }
        });
    }
}

