/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jiga.xtended.kernel;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.FontMetrics;
import java.awt.GraphicsConfiguration;
import java.awt.GraphicsEnvironment;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.event.ActionEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.RandomAccessFile;
import java.lang.management.ManagementFactory;
import java.lang.management.MemoryMXBean;
import java.lang.management.OperatingSystemMXBean;
import java.lang.management.RuntimeMXBean;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.math.BigInteger;
import java.net.MalformedURLException;
import java.net.URISyntaxException;
import java.net.URL;
import java.net.URLConnection;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.charset.Charset;
import java.security.AccessControlContext;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.text.DateFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.PropertyPermission;
import java.util.ResourceBundle;
import java.util.Set;
import java.util.concurrent.ExecutionException;
import java.util.logging.Level;
import java.util.logging.LogRecord;
import java.util.logging.Logger;
import java.util.zip.Checksum;
import javax.imageio.ImageIO;
import javax.swing.AbstractAction;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JProgressBar;
import javax.swing.JTextField;
import net.sf.jiga.xtended.JXAException;
import net.sf.jiga.xtended.kernel.BitStack;
import net.sf.jiga.xtended.kernel.Console;
import net.sf.jiga.xtended.kernel.DebugMap;
import net.sf.jiga.xtended.kernel.Debugger;
import net.sf.jiga.xtended.kernel.ExtensionsClassLoader;
import net.sf.jiga.xtended.kernel.ExtensionsInstaller;
import net.sf.jiga.xtended.kernel.FileHelper;
import net.sf.jiga.xtended.kernel.MD5Checksum;
import net.sf.jiga.xtended.kernel.Monitor;
import net.sf.jiga.xtended.kernel.Resource;
import net.sf.jiga.xtended.kernel.SpritesCacheManager;
import net.sf.jiga.xtended.kernel.SystemPropertyChange;
import net.sf.jiga.xtended.kernel.ThreadWorks;
import net.sf.jiga.xtended.kernel.env;
import net.sf.jiga.xtended.ui.Ant;
import net.sf.jiga.xtended.ui.AntApplet;
import net.sf.jiga.xtended.ui.AntHandler;
import net.sf.jiga.xtended.ui.DisplayInterface;
import net.sf.jiga.xtended.ui.JFCApplet;
import net.sf.jiga.xtended.ui.JXAWebView;
import net.sf.jiga.xtended.ui.TransparentBackground;
import net.sf.jiga.xtended.ui.UIMessage;
import org.apache.commons.httpclient.HttpException;
import org.apache.commons.io.FileUtils;

public class JXAenvUtils
extends Logger
implements Cloneable,
Resource,
Debugger {
    public static AccessControlContext acc = AccessController.getContext();
    public static ResourceBundle rb = ResourceBundle.getBundle("net.sf.jiga.xtended.kernel.jxaenvutils");
    public static boolean _debug = Boolean.parseBoolean(rb.getString("debugEnabled")) || JXAenvUtils._getSysBoolean("jxa.debug");
    public static boolean _debugSys = JXAenvUtils._getSysBoolean("jxa.debugSys");
    private Map<String, Map<String, Map<URL, Boolean>>> envNatives = Collections.synchronizedMap(new LinkedHashMap());
    protected Map<String, Map<String, URL>> envJars = Collections.synchronizedMap(new LinkedHashMap());
    public boolean keepReadingOnRemoteJarResources = false;
    public boolean silent = false;
    public static GraphicsConfiguration _defaultGC = GraphicsEnvironment.getLocalGraphicsEnvironment().getDefaultScreenDevice().getDefaultConfiguration();
    private DisplayInterface splash;
    private Container splashContents;
    private JFrame splashFrame;
    private static final BitStack lvlBits = new BitStack();
    private static final int LVL_USER = lvlBits._newBitRange();
    private static final int LVL_APP = lvlBits._newBitRange();
    private static final int LVL_SYS = lvlBits._newBitRange();
    private static final int TYPE_ERROR = lvlBits._newBitRange();
    private static final int TYPE_NOTICE = lvlBits._newBitRange();
    private static final int TYPE_WARNING = lvlBits._newBitRange();
    public static final int APP_ERROR = lvlBits._newBit(LVL_APP | TYPE_ERROR);
    public static final int APP_NOTICE = lvlBits._newBit(LVL_APP | TYPE_NOTICE);
    public static final int APP_WARNING = lvlBits._newBit(LVL_APP | TYPE_WARNING);
    public static final int USER_ERROR = lvlBits._newBit(LVL_USER | TYPE_ERROR);
    public static final int USER_NOTICE = lvlBits._newBit(LVL_USER | TYPE_NOTICE);
    public static final int USER_WARNING = lvlBits._newBit(LVL_USER | TYPE_WARNING);
    public static final int SYS_ERROR = lvlBits._newBit(LVL_SYS | TYPE_ERROR);
    public static final int SYS_NOTICE = lvlBits._newBit(LVL_SYS | TYPE_NOTICE);
    public static final int SYS_WARNING = lvlBits._newBit(LVL_SYS | TYPE_WARNING);
    ClassLoader classLoader;
    private Map<String, URL> map = Collections.synchronizedMap(new LinkedHashMap());
    private String envPath;
    String[] libraryPath = JXAenvUtils.getLibraryPath().split(File.pathSeparator);
    Runnable envImageIOLayer = new Runnable(){

        @Override
        public void run() {
            ClassLoader c = JXAenvUtils._switchToClassLoader(ExtensionsClassLoader.getInstance().getClassLoader());
            ImageIO.scanForPlugins();
            JXAenvUtils._switchToClassLoader(c);
        }
    };
    Runnable envLWJGLLayer = new Runnable(){

        @Override
        public void run() {
            JXAenvUtils._setSysValue("net.java.games.input.librarypath", ExtensionsInstaller._findExtPath(true));
            JXAenvUtils._setSysValue("org.lwjgl.librarypath", JXAenvUtils._updatePath(JXAenvUtils._getSysValue("org.lwjgl.librarypath"), ExtensionsInstaller._findExtPath(true)));
        }
    };
    Runnable envJMFLayer = new Runnable(){

        @Override
        public void run() {
            JXAenvUtils._setSysValue("java.class.path", JXAenvUtils._updatePath(JXAenvUtils.getClasspath(), FileHelper._USERHOMEDIRECTORY.getAbsolutePath()));
        }
    };
    private static boolean exitedJXA = false;
    private static boolean exiting = false;
    private Runnable quitJXAEnv = new Runnable(){

        @Override
        public void run() {
            JXAenvUtils.this.unloadEnvironment(true);
        }
    };
    private Runnable logUncaughtExceptionsClose = new Runnable(){

        @Override
        public void run() {
            ThreadWorks.cLogFile_close();
        }
    };
    private Runnable logUncaughtExceptionsOpen = new Runnable(){

        @Override
        public void run() {
            ThreadWorks.cLogFile_open(JXAenvUtils.this.antClassName);
            Thread.setDefaultUncaughtExceptionHandler(new Thread.UncaughtExceptionHandler(){

                @Override
                public void uncaughtException(Thread t, Throwable e) {
                    ThreadWorks._uncaughtException(true, t, e);
                }
            });
        }
    };
    ArrayList<Runnable> preEnvLayers = new ArrayList();
    ArrayList<Runnable> postEnvLayers = new ArrayList();
    ArrayList<Runnable> preUEnvLayers = new ArrayList();
    ArrayList<Runnable> postUEnvLayers = new ArrayList();
    public static File fileLock = new File(FileHelper._USERHOMESTOREDIRECTORY, "lock");
    private static boolean startedJXA = false;
    private static Monitor envload = new Monitor();
    String[] classpath = JXAenvUtils.getClasspath().split(File.pathSeparator);
    public static boolean _multiThreading = Runtime.getRuntime().availableProcessors() > 1 && !JXAenvUtils._getSysBoolean("jxa.nomt");
    public static final String LOGGER_NAME = "jxa.logger";
    private boolean forceInstall = false;
    public boolean keepFolderHierarchy = false;
    public boolean bigBuffer = true;
    private Set<String> erroredFiles = Collections.synchronizedSet(new HashSet());
    AntApplet antapplet = null;
    Container antContents = null;
    public String antClassName = Ant.class.getName();
    public long jpb = 0L;
    private static final BitStack bits = new BitStack();
    private static final int LOAD_ERROR = bits._newBitRange();
    private static final int LOAD_LOADING = bits._newBitRange();
    private static final int LOAD_CLEARED = bits._newBitRange();
    private static final int LOAD_LOADED = bits._newBitRange();
    int loaded = LOAD_CLEARED;
    public static BigInteger hours = BigInteger.valueOf(3600L * (long)Math.pow(10.0, 3.0));
    public static BigInteger minutes = BigInteger.valueOf(60L * (long)Math.pow(10.0, 3.0));
    public static BigInteger seconds = BigInteger.valueOf(1L * (long)Math.pow(10.0, 3.0));

    public static String _getSysValue(final String name) {
        return AccessController.doPrivileged(new PrivilegedAction<String>(){

            @Override
            public String run() {
                return System.getProperty(name);
            }
        }, acc);
    }

    public static boolean _getSysBoolean(final String name) {
        return AccessController.doPrivileged(new PrivilegedAction<Boolean>(){

            @Override
            public Boolean run() {
                return Boolean.getBoolean(name);
            }
        }, acc);
    }

    public static int _getSysInteger(final String name) {
        return AccessController.doPrivileged(new PrivilegedAction<Integer>(){

            @Override
            public Integer run() {
                return Integer.getInteger(name);
            }
        }, acc);
    }

    public static void _setSysValue(final String name, final String value) {
        AccessController.doPrivileged(new PrivilegedAction(){

            public String run() {
                try {
                    PropertyPermission pp = new PropertyPermission(name, "write");
                    pp.checkGuard(null);
                    String o = System.getProperty(name);
                    System.setProperty(name, value);
                    SystemPropertyChange.INSTANCE.dispatchEvent(new PropertyChangeEvent(Thread.currentThread().getName(), name, o, value));
                    if (_debugSys) {
                        System.out.println(JXAenvUtils.log("system property updated : " + name + " new value : " + value, LVL.SYS_NOT, null));
                    }
                    return null;
                }
                catch (SecurityException ex) {
                    if (_debugSys) {
                        ex.printStackTrace();
                    }
                    return null;
                }
            }
        }, acc);
    }

    @Deprecated
    public static String _getURLFilename(URL url) {
        return FileHelper._getURLFilename(url);
    }

    public void addEnvJars(URL[] urls) {
        LinkedHashMap<String, URL> jars = new LinkedHashMap<String, URL>();
        for (URL u : urls) {
            if (u == null) {
                System.out.println(JXAenvUtils.log("jar was not found !! please check input", LVL.SYS_ERR, null));
                continue;
            }
            jars.put(JXAenvUtils._getURLFilename(u), u);
        }
        this.addEnvJars(jars);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addEnvJars(Map<String, URL> jars) {
        Map<String, URL> jarsMap = this.envJars.get(JXAenvUtils._getSysValue("os.name"));
        if (jarsMap == null) {
            jarsMap = new LinkedHashMap<String, URL>();
            this.envJars.put(JXAenvUtils._getSysValue("os.name"), jarsMap);
        }
        jarsMap.putAll(jars);
        Map<String, URL> map = jars;
        synchronized (map) {
            for (URL jar : jars.values()) {
                try {
                    jarsMap.putAll(ExtensionsInstaller._getJarClasspathJars(jar));
                }
                catch (IOException ex) {
                    if (!_debugSys) continue;
                    ex.printStackTrace();
                }
            }
        }
    }

    public void addEnvNatives(Map<String, Map<URL, Boolean>> natives) {
        Map<String, Map<URL, Boolean>> nativesMap = this.envNatives.get(JXAenvUtils._getSysValue("os.name"));
        if (nativesMap == null) {
            nativesMap = new LinkedHashMap<String, Map<URL, Boolean>>();
            this.envNatives.put(JXAenvUtils._getSysValue("os.name"), nativesMap);
        }
        nativesMap.putAll(natives);
    }

    @Deprecated
    public static boolean _accessFilePermitted(File file, int fileMode) {
        return FileHelper._accessFilePermitted(file, fileMode);
    }

    @Deprecated
    private static boolean __accessFilePermitted(File file, int fileMode) {
        return FileHelper.__accessFilePermitted(file, fileMode);
    }

    private static String _logTrace_r(StackTraceElement[] trace, int i, int nelements, String tab) {
        if (i >= trace.length) {
            return "[No trace log]" + JXAenvUtils._getSysValue("line.separator");
        }
        if (i >= nelements) {
            return "";
        }
        if (trace[i].getClassName().contains("JXAenvUtils") && trace[i].getMethodName().startsWith("log")) {
            return JXAenvUtils._logTrace_r(trace, i + 1, nelements, tab);
        }
        return tab + "at " + trace[i].getClassName() + "." + trace[i].getMethodName() + JXAenvUtils._getSysValue("line.separator") + JXAenvUtils._logTrace_r(trace, i + 1, nelements, tab);
    }

    private static String _stradd_r(String chars, int n, int i) {
        if (i < n) {
            return chars + JXAenvUtils._stradd_r(chars, n, i + 1);
        }
        return chars;
    }

    private static String log(String s, int level, Throwable e) {
        int traceIndex;
        StackTraceElement[] trace;
        String traceStr;
        String levelStr = "";
        String output = "";
        output = output + DateFormat.getDateTimeInstance(2, 1).format(new Date()) + " " + Thread.currentThread().getName() + " : ";
        String tab = JXAenvUtils._stradd_r(" ", output.length(), 0);
        String string = traceStr = e != null ? e.getClass().getCanonicalName() + ": " + JXAenvUtils._getSysValue("line.separator") : "";
        if (e == null) {
            trace = Thread.currentThread().getStackTrace();
            traceIndex = 1;
        } else {
            trace = e.getStackTrace();
            traceIndex = 0;
        }
        if ((level & LVL_SYS) != 0) {
            levelStr = "SYST";
        }
        if ((level & LVL_APP) != 0) {
            levelStr = "APPL";
        }
        if ((level & LVL_USER) != 0) {
            levelStr = "";
        }
        if ((level & TYPE_ERROR) != 0) {
            levelStr = levelStr + " ERRO";
            traceStr = traceStr + JXAenvUtils._logTrace_r(trace, traceIndex, 3, tab);
        }
        if ((level & TYPE_NOTICE) != 0) {
            levelStr = levelStr + " INFO";
        }
        if ((level & TYPE_WARNING) != 0) {
            levelStr = levelStr + " WARN";
            traceStr = traceStr + JXAenvUtils._logTrace_r(trace, traceIndex, 1, tab);
        }
        output = output + trace[0].getClassName().substring(trace[0].getClassName().lastIndexOf(".") + 1) + " - " + levelStr + ": " + s;
        if (!"".equals(traceStr)) {
            output = output + JXAenvUtils._getSysValue("line.separator") + tab + traceStr;
        }
        return output;
    }

    public static String log(String s, LVL level) {
        return JXAenvUtils.log(s, level, null);
    }

    public static String log(String s, LVL level, Throwable e) {
        return JXAenvUtils.log(s, level.level, e);
    }

    @Override
    public void log(LogRecord record) {
        if (record.getThrown() != null) {
            System.out.println(JXAenvUtils.log(record.getMessage(), LVL._findJXALevel(LVL_SYS, record.getLevel()), record.getThrown()));
        } else if (record.getMessage() != null) {
            System.out.println(JXAenvUtils.log(record.getMessage(), LVL._findJXALevel(LVL_APP, record.getLevel()), record.getThrown()));
        } else {
            System.out.println(JXAenvUtils.log(record.getMessage(), LVL._findJXALevel(LVL_USER, record.getLevel()), record.getThrown()));
        }
    }

    public static String _JXAEnvOutput(String s, int level) {
        return JXAenvUtils.log(s, level, null);
    }

    @Deprecated
    public static File _findFreeDirectory(List<File> freeList) {
        return FileHelper._findFreeDirectory(freeList);
    }

    @Deprecated
    static File _findTempDirectory() {
        return FileHelper._findTempDirectory();
    }

    @Deprecated
    static File _findHomeDirectory() {
        return FileHelper._findHomeDirectory();
    }

    public ClassLoader getEnvClassLoader() {
        return this.classLoader;
    }

    public static ClassLoader _switchToClassLoader(final ClassLoader classLoader) {
        ClassLoader currentCL = Thread.currentThread().getContextClassLoader();
        AccessController.doPrivileged(new PrivilegedAction(){

            public Object run() {
                Thread.currentThread().setContextClassLoader(classLoader);
                return null;
            }
        }, AccessController.getContext());
        return currentCL;
    }

    public void loadEnvironment() {
        AccessController.doPrivileged(new PrivilegedAction(){

            public Object run() {
                JXAenvUtils.this._loadEnvironment();
                return null;
            }
        }, acc);
    }

    public void unloadEnvironment(final boolean cleanTemp) {
        AccessController.doPrivileged(new PrivilegedAction(){

            public Object run() {
                JXAenvUtils.this._unloadEnvironment(cleanTemp);
                return null;
            }
        }, acc);
    }

    public static String _getDateAndTime(long t) {
        return new Date(t).toString();
    }

    public static void cLogFilePrintStackStrace(Throwable throwable) {
        ThreadWorks.cLogFilePrintStackStrace(throwable);
    }

    public boolean isLocal() {
        return !env.APP_REMOTE.isEnv() || JFCApplet._localApplet;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    private void _loadEnvironment() {
        if (!ExtensionsClassLoader.isResourceLoaded()) {
            ExtensionsClassLoader._load(this);
        }
        AntHandler._applyLAF("native");
        boolean swingEdt = ThreadWorks.Swing.isEventDispatchThread();
        if (swingEdt && this.splashContents == null) {
            this._initSplashContents();
        }
        this.preEnvLayers.add(this.logUncaughtExceptionsOpen);
        this.preEnvLayers.add(new Runnable(){

            @Override
            public void run() {
                if (!exitedJXA) {
                    Runtime.getRuntime().addShutdownHook(new Thread(JXAenvUtils.this.quitJXAEnv));
                }
            }
        });
        this.preEnvLayers.add(new Runnable(){

            @Override
            public void run() {
                JXAenvUtils.this.createLock();
            }
        });
        this.preEnvLayers.add(this.envLWJGLLayer);
        this.preEnvLayers.add(this.envJMFLayer);
        this.preEnvLayers.add(new Runnable(){

            @Override
            public void run() {
                JXAenvUtils._setImageIOCacheEnabled(true, FileHelper._ImageIOCache);
            }
        });
        this.postEnvLayers.add(this.envImageIOLayer);
        if (_debugSys) {
            System.out.println(JXAenvUtils._JXAEnvOutput("loading JXA ENVIRONMENT...", SYS_NOTICE));
        }
        if (swingEdt) {
            UIMessage.getProgressBar(this.jpb).setStringPainted(true);
        }
        boolean res = true;
        int i = 0;
        if (swingEdt) {
            UIMessage.getProgressBar(this.jpb).setString("Loading JXA pre-Environment...");
        }
        ArrayList<Runnable> arrayList = this.preEnvLayers;
        synchronized (arrayList) {
            for (Runnable a : this.preEnvLayers) {
                a.run();
                if (!swingEdt) continue;
                UIMessage.updateProgress(this.jpb, ++i, this.preEnvLayers.size());
            }
        }
        if (swingEdt) {
            UIMessage.getProgressBar(this.jpb).setString("Loading JXA Environment...");
        }
        i = 0;
        try {
            if (!swingEdt) {
                ExtensionsInstaller.showSplash = false;
            }
            if (!this.keepReadingOnRemoteJarResources) {
                ExtensionsInstaller._installExtensions(this, this.envJars, false, new File(FileHelper._USERHOMESTOREDIRECTORY, "" + this.antClassName));
            }
            res = this.isResourceLoaded() && res;
            boolean bl = res = ExtensionsInstaller._installExtensions(ExtensionsInstaller._getJXANatenvFiles(this.envNatives, false), true, null).isResourceLoaded() && res;
            if (swingEdt) {
                UIMessage.getProgressBar(this.jpb).setString("Loading JXA post-Environment...");
            }
            i = 0;
            arrayList = this.postEnvLayers;
        }
        catch (MalformedURLException ex222222) {
            if (_debugSys) {
                ex222222.printStackTrace();
            }
            if (swingEdt) {
                UIMessage.getProgressBar(this.jpb).setString("Loading JXA post-Environment...");
            }
            i = 0;
            ArrayList<Runnable> ex222222 = this.postEnvLayers;
            synchronized (ex222222) {
                for (Runnable a : this.postEnvLayers) {
                    a.run();
                    if (!swingEdt) continue;
                    UIMessage.updateProgress(this.jpb, ++i, this.postEnvLayers.size());
                }
            }
            if (_debugSys) {
                System.out.println(JXAenvUtils._JXAEnvOutput("JXA ENVIRONMENT " + (res ? "is loaded." : " had errors on loading."), SYS_NOTICE));
            }
            if (swingEdt) {
                UIMessage.getProgressBar(this.jpb).setString("JXA Environment " + (res ? "is loaded." : " had errors on loading."));
            }
        }
        catch (URISyntaxException ex) {
            ex.printStackTrace();
            if (swingEdt) {
                UIMessage.getProgressBar(this.jpb).setString("Loading JXA post-Environment...");
            }
            i = 0;
            ArrayList<Runnable> arrayList2 = this.postEnvLayers;
            synchronized (arrayList2) {
                for (Runnable a : this.postEnvLayers) {
                    a.run();
                    if (!swingEdt) continue;
                    UIMessage.updateProgress(this.jpb, ++i, this.postEnvLayers.size());
                }
            }
            if (_debugSys) {
                System.out.println(JXAenvUtils._JXAEnvOutput("JXA ENVIRONMENT " + (res ? "is loaded." : " had errors on loading."), SYS_NOTICE));
            }
            if (swingEdt) {
                UIMessage.getProgressBar(this.jpb).setString("JXA Environment " + (res ? "is loaded." : " had errors on loading."));
            }
            {
                catch (Throwable throwable) {
                    if (swingEdt) {
                        UIMessage.getProgressBar(this.jpb).setString("Loading JXA post-Environment...");
                    }
                    i = 0;
                    ArrayList<Runnable> arrayList3 = this.postEnvLayers;
                    synchronized (arrayList3) {
                        for (Runnable a : this.postEnvLayers) {
                            a.run();
                            if (!swingEdt) continue;
                            UIMessage.updateProgress(this.jpb, ++i, this.postEnvLayers.size());
                        }
                    }
                    if (_debugSys) {
                        System.out.println(JXAenvUtils._JXAEnvOutput("JXA ENVIRONMENT " + (res ? "is loaded." : " had errors on loading."), SYS_NOTICE));
                    }
                    if (swingEdt) {
                        UIMessage.getProgressBar(this.jpb).setString("JXA Environment " + (res ? "is loaded." : " had errors on loading."));
                    }
                    throw throwable;
                }
            }
        }
        synchronized (arrayList) {
            for (Runnable a : this.postEnvLayers) {
                a.run();
                if (!swingEdt) continue;
                UIMessage.updateProgress(this.jpb, ++i, this.postEnvLayers.size());
            }
        }
        if (_debugSys) {
            System.out.println(JXAenvUtils._JXAEnvOutput("JXA ENVIRONMENT " + (res ? "is loaded." : " had errors on loading."), SYS_NOTICE));
        }
        if (swingEdt) {
            UIMessage.getProgressBar(this.jpb).setString("JXA Environment " + (res ? "is loaded." : " had errors on loading."));
        }
    }

    public void addPreEnvLayer(Runnable a) {
        this.preEnvLayers.add(a);
    }

    public void removePreEnvLayer(Runnable a) {
        this.preEnvLayers.remove(a);
    }

    public void addPostEnvLayer(Runnable a) {
        this.postEnvLayers.add(a);
    }

    public void removePostEnvLayer(Runnable a) {
        this.postEnvLayers.remove(a);
    }

    public void addPreUEnvLayer(Runnable a) {
        this.preUEnvLayers.add(a);
    }

    public void removePreUEnvLayer(Runnable a) {
        this.preUEnvLayers.remove(a);
    }

    public void addPostUEnvLayer(Runnable a) {
        this.postUEnvLayers.add(a);
    }

    public void removePostUEnvLayer(Runnable a) {
        this.postUEnvLayers.remove(a);
    }

    public String[] getLibraryPathArray() {
        return this.libraryPath;
    }

    private void createLock() {
        block6: {
            if (startedJXA) {
                return;
            }
            startedJXA = true;
            if (this.antClassName == null) {
                return;
            }
            System.out.println(JXAenvUtils._JXAEnvOutput("JXAKernel v. " + JXAenvUtils._kernelVersion(), SYS_NOTICE));
            try {
                if (!fileLock.exists()) {
                    fileLock.createNewFile();
                }
                RandomAccessFile raf = new RandomAccessFile(fileLock, "rw");
                raf.writeLong(System.currentTimeMillis());
                raf.writeInt(this.antClassName.hashCode());
                raf.close();
                if (!this.verifyLock(true)) {
                    UIMessage.showLightPopupMessage(new JLabel("<html>You seem to already run an instance of this program.<br>If you are sure to continue, then close this popup;<br> if unsure, then quit.</html>"), new AbstractAction("quit", UIMessage._getIcon(51, true)){

                        @Override
                        public void actionPerformed(ActionEvent e) {
                            System.exit(0);
                        }
                    }, null, UIMessage._BOTTOM_RIGHT);
                }
            }
            catch (IOException ex) {
                if (!DebugMap._getInstance().isDebugLevelEnabled(DebugMap._getInstance()._VOID)) break block6;
                ex.printStackTrace();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Map<Long, Integer> getLocks() {
        LinkedHashMap<Long, Integer> locks = new LinkedHashMap<Long, Integer>();
        RandomAccessFile locksF = null;
        try {
            try {
                locksF = new RandomAccessFile(fileLock, "r");
                while (true) {
                    long lock = locksF.readLong();
                    int lockName = locksF.readInt();
                    if (System.currentTimeMillis() - lock >= 86400000L) continue;
                    locks.put(lock, lockName);
                }
            }
            catch (IOException ex) {
                if (DebugMap._getInstance().isDebugLevelEnabled(DebugMap._getInstance()._VOID)) {
                    System.err.println("EOF detected, OK, locks have been read.");
                    ex.printStackTrace();
                }
            }
        }
        finally {
            return locks;
        }
    }

    private boolean verifyLock(boolean sameClass) {
        if (this.getLocks().size() <= 1) {
            return true;
        }
        if (sameClass) {
            Map<Long, Integer> locks = this.getLocks();
            int found = 0;
            Iterator<Long> it = locks.keySet().iterator();
            while (it.hasNext()) {
                if (!locks.get(it.next()).equals(this.antClassName.hashCode())) continue;
                ++found;
            }
            return found <= 1;
        }
        return false;
    }

    private void releaseLock() {
        block4: {
            if (this.antClassName == null) {
                return;
            }
            Map<Long, Integer> locks = this.getLocks();
            RandomAccessFile locksF = null;
            try {
                File tmp = JXAenvUtils._createTempFile("lock_", FileHelper._USERHOMESTOREDIRECTORY);
                locksF = new RandomAccessFile(tmp, "rw");
                for (Long lck : locks.keySet()) {
                    if (locks.get(lck).equals(this.antClassName.hashCode())) continue;
                    locksF.writeLong(lck);
                    locksF.writeInt(locks.get(lck));
                }
                locksF.close();
                JXAenvUtils._fileCopy(tmp, fileLock, false, false);
                tmp.delete();
            }
            catch (IOException ex) {
                if (!DebugMap._getInstance().isDebugLevelEnabled(DebugMap._getInstance()._VOID)) break block4;
                ex.printStackTrace();
            }
        }
    }

    @Deprecated
    public static void _erase(File path) {
        FileHelper._erase(path);
    }

    @Deprecated
    public static void _erase(File path, boolean reportException) throws IOException {
        FileHelper._erase(path, reportException);
    }

    @Deprecated
    public static void _eraseTmpFiles(String suffix, File dir) throws IllegalArgumentException {
        FileHelper._eraseTmpFiles(suffix, dir);
    }

    @Deprecated
    public static File _createTempFile(String prefix, File dir) throws IOException {
        return FileHelper._createTempFile(prefix, dir, !exiting);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void _unloadEnvironment(boolean cleanTemp) {
        boolean swingEdt = ThreadWorks.Swing.isEventDispatchThread();
        this.addPostUEnvLayer(this.logUncaughtExceptionsClose);
        if (swingEdt) {
            UIMessage.getProgressBar(this.jpb).setStringPainted(true);
        }
        int i = 0;
        if (swingEdt) {
            UIMessage.getProgressBar(this.jpb).setString("Unloading JXA pre-Environment...");
        }
        ArrayList<Runnable> arrayList = this.preUEnvLayers;
        synchronized (arrayList) {
            for (Runnable runnable : this.preUEnvLayers) {
                runnable.run();
                if (!swingEdt) continue;
                UIMessage.updateProgress(this.jpb, ++i, this.preUEnvLayers.size());
            }
        }
        try {
            arrayList = envload;
            synchronized (arrayList) {
                while (exiting) {
                    envload.wait();
                }
                if (!exitedJXA) {
                    exiting = true;
                    ExtensionsInstaller.showSplash = false;
                    ExtensionsInstaller._uninstallExtensions(this, this.envJars, false, new File(FileHelper._USERHOMESTOREDIRECTORY, "" + this.antClassName));
                    boolean mustExit = this.verifyLock(false);
                    if (mustExit) {
                        if (swingEdt) {
                            UIMessage.getProgressBar(this.jpb).setString("Exiting JXA environment (1-2 mn.)");
                        }
                        ExtensionsInstaller._uninstallExtensions(this.envNatives, true, null);
                        if (cleanTemp) {
                            SpritesCacheManager._cleanFileSwap();
                            for (File t : FileHelper._tmpDir) {
                                JXAenvUtils._eraseTmpFiles(".jxa.tmp", t);
                            }
                        }
                    }
                }
            }
        }
        catch (Exception ex) {
            if (_debugSys) {
                ex.printStackTrace();
            }
        }
        finally {
            if (swingEdt) {
                UIMessage.getProgressBar(this.jpb).setString("Done.");
            }
            Object object = envload;
            synchronized (object) {
                this.releaseLock();
                exitedJXA = true;
                exiting = false;
                envload.notifyAll();
            }
            if (swingEdt) {
                UIMessage.getProgressBar(this.jpb).setString("Unloading JXA post-Environment...");
            }
            i = 0;
            object = this.postUEnvLayers;
            synchronized (object) {
                for (Runnable runnable : this.postUEnvLayers) {
                    runnable.run();
                    if (!swingEdt) continue;
                    UIMessage.updateProgress(this.jpb, ++i, this.postUEnvLayers.size());
                }
            }
            if (swingEdt) {
                UIMessage.getProgressBar(this.jpb).setString("Done.");
            }
        }
    }

    public static String getLibraryPath() {
        return AccessController.doPrivileged(new PrivilegedAction<String>(){

            @Override
            public String run() {
                return ManagementFactory.getRuntimeMXBean().getLibraryPath();
            }
        }, acc);
    }

    public String[] getClasspathArray() {
        return this.classpath;
    }

    public static String getClasspath() {
        return AccessController.doPrivileged(new PrivilegedAction<String>(){

            @Override
            public String run() {
                return ManagementFactory.getRuntimeMXBean().getClassPath();
            }
        }, acc);
    }

    public String getJXAenvPath() {
        return this.envPath;
    }

    public void setJXAenvPath(String path) {
        this.envPath = path;
    }

    public static String _updatePath(String currentPath, String path) {
        return JXAenvUtils._updatePath(currentPath, path, false);
    }

    public static String _updatePath(String currentPath, String path, boolean prepend) {
        String separator;
        if (path instanceof String && path.endsWith(".")) {
            path = path.substring(0, path.lastIndexOf("."));
        }
        boolean found = false;
        if (currentPath == null) {
            currentPath = "";
            separator = "";
        } else {
            separator = File.pathSeparator;
        }
        for (String regPath : currentPath.split(File.pathSeparator)) {
            if (!(regPath instanceof String) || !regPath.equalsIgnoreCase(path)) continue;
            found = true;
            break;
        }
        if (!found) {
            currentPath = prepend ? path + separator + currentPath : currentPath + separator + path;
        }
        return currentPath;
    }

    protected Object clone() throws CloneNotSupportedException {
        int i;
        JXAenvUtils env2 = (JXAenvUtils)super.clone();
        env2.classLoader = this.classLoader;
        env2.classpath = new String[this.classpath.length];
        for (i = 0; i < this.classpath.length; ++i) {
            env2.classpath[i] = this.classpath[i];
        }
        env2.libraryPath = new String[this.libraryPath.length];
        for (i = 0; i < this.libraryPath.length; ++i) {
            env2.libraryPath[i] = this.libraryPath[i];
        }
        env2.map = Collections.synchronizedMap(new HashMap<String, URL>(this.map));
        env2.postEnvLayers = new ArrayList<Runnable>(this.postEnvLayers);
        env2.preEnvLayers = new ArrayList<Runnable>(this.preEnvLayers);
        env2.envJars = Collections.synchronizedMap(new LinkedHashMap<String, Map<String, URL>>(this.envJars));
        env2.envNatives = Collections.synchronizedMap(new LinkedHashMap<String, Map<String, Map<URL, Boolean>>>(this.envNatives));
        env2.erroredFiles = Collections.synchronizedSet(new HashSet<String>(this.erroredFiles));
        return env2;
    }

    public JXAenvUtils(Class classLoader, Map<String, URL> filesMap) {
        this(classLoader.getClassLoader(), filesMap);
    }

    public JXAenvUtils(ClassLoader classLoader, Map<String, URL> filesMap) {
        super(LOGGER_NAME, null);
        this.classLoader = classLoader;
        this.map.putAll(filesMap);
        this.envPath = FileHelper._findTempDirectory().getPath();
        SystemPropertyChange.INSTANCE.add(new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent evt) {
                if (evt.getPropertyName().equals("jxa.jwrapper")) {
                    JXAenvUtils.this.keepReadingOnRemoteJarResources = Boolean.parseBoolean(evt.getNewValue().toString());
                }
            }
        });
    }

    public long getUIMessageProgressBar() {
        return this.jpb;
    }

    public JXAenvUtils(Class classLoader) {
        this(classLoader.getClassLoader());
    }

    public JXAenvUtils(ClassLoader classLoader) {
        this(classLoader, new HashMap<String, URL>());
    }

    public JXAenvUtils() {
        this(ClassLoader.getSystemClassLoader());
    }

    @Deprecated
    public static String _convertToResourceString(File filePath) {
        return FileHelper._convertToResourceString(filePath);
    }

    @Deprecated
    public static String _quotedFileSeparator() {
        return FileHelper._quotedFileSeparator();
    }

    public boolean isForceInstall() {
        return this.forceInstall;
    }

    public void setForceInstall(boolean forceInstall) {
        this.forceInstall = forceInstall;
    }

    private boolean loadEnvFile(final URL filePath) {
        return AccessController.doPrivileged(new PrivilegedAction<Boolean>(){

            @Override
            public Boolean run() {
                return JXAenvUtils.this._loadEnvFile(filePath);
            }
        }, acc);
    }

    public void setKeepFolderHierarchy(boolean keepFolderHierarchy) {
        this.keepFolderHierarchy = keepFolderHierarchy;
    }

    public boolean isKeepFolderHierarchy() {
        return this.keepFolderHierarchy;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean _loadEnvFile(URL filePath) {
        if (this.jpb != 0L) {
            UIMessage.getProgressBar(this.jpb).setIndeterminate(true);
        }
        File fileLink = this.findEnvInstalledFile(filePath);
        String dir = fileLink.getParentFile().getAbsolutePath();
        String file = fileLink.getAbsolutePath();
        int pty = Thread.currentThread().getPriority();
        Thread.currentThread().setPriority(10);
        try {
            boolean install;
            URLConnection connection;
            InputStream src;
            if (_debugSys) {
                System.out.print("looking for installing file " + filePath + "...");
            }
            if ((src = (connection = filePath.openConnection()).getInputStream()) instanceof InputStream && src.available() > 0) {
                if (_debugSys) {
                    System.out.println(" found " + FileUtils.byteCountToDisplaySize((long)connection.getContentLength()));
                }
            } else {
                if (_debugSys) {
                    System.out.println(" not found.");
                }
                throw new FileNotFoundException("File " + filePath + " was not found.");
            }
            src.close();
            File d = new File(dir);
            if (!d.exists()) {
                d.mkdirs();
                JXAenvUtils._makeWritable(d);
            }
            File f = new File(file);
            if (_debugSys) {
                System.out.print("Comparing with existing " + f + "...");
            }
            boolean bl = install = this.forceInstall || !f.exists();
            if (!install) {
                try {
                    URLConnection ucheck = null;
                    long sum = 0L;
                    try {
                        ucheck = new URL(filePath + ".MD5").openConnection();
                        int l = ucheck.getContentLength();
                        InputStream bi = ucheck.getInputStream();
                        if (l == 0) {
                            l = bi.available();
                        }
                        ByteBuffer sb = ByteBuffer.allocate(l).order(ByteOrder.nativeOrder());
                        byte[] b = new byte[FileHelper._BIGBUFFER_SIZE];
                        int r = 0;
                        while ((r = bi.read(b)) != -1) {
                            sb.put(b, 0, r);
                        }
                        bi.close();
                        sum = MD5Checksum.decodeLong(sb.array());
                        install = sum != FileUtils.checksum((File)f, (Checksum)new MD5Checksum()).getValue();
                    }
                    catch (IOException ex) {
                        try {
                            if (DebugMap._getInstance().isDebugLevelEnabled(DebugMap._getInstance()._VOID)) {
                                ex.printStackTrace();
                            }
                            connection = filePath.openConnection();
                            src = connection.getInputStream();
                            MD5Checksum checksum = new MD5Checksum();
                            byte[] br = new byte[FileHelper._BIGBUFFER_SIZE];
                            int r = 0;
                            while ((r = src.read(br)) != -1) {
                                checksum.update(br, 0, r);
                            }
                            src.close();
                            sum = checksum.getValue();
                            install = sum != FileUtils.checksum((File)f, (Checksum)new MD5Checksum()).getValue();
                        }
                        catch (Throwable throwable) {
                            install = sum != FileUtils.checksum((File)f, (Checksum)new MD5Checksum()).getValue();
                            throw throwable;
                        }
                    }
                }
                catch (IOException ex) {
                    if (DebugMap._getInstance().isDebugLevelEnabled(DebugMap._getInstance()._VOID)) {
                        ex.printStackTrace();
                    }
                    connection = filePath.openConnection();
                    src = connection.getInputStream();
                    boolean bl2 = install = f.length() != (long)(connection.getContentLength() == -1 ? src.available() : connection.getContentLength());
                }
            }
            if (_debugSys) {
                System.out.println(install ? " REQUIRES UPDATE" : " REQUIRES NO UPDATE");
            }
            if (install) {
                JXAenvUtils._fileCopy(filePath, f, this.jpb != 0L, this.jpb, this.bigBuffer);
                if (_debugSys) {
                    System.out.println("installed : " + file + " in " + dir);
                }
            }
            boolean bl3 = true;
            return bl3;
        }
        catch (IOException e) {
            String message = "File : " + file;
            Logger.getLogger(LOGGER_NAME).log(Level.CONFIG, message, e);
            boolean bl = false;
            return bl;
        }
        finally {
            Thread.currentThread().setPriority(pty);
        }
    }

    public void setBigBuffer(boolean bigBuffer) {
        this.bigBuffer = bigBuffer;
    }

    public boolean isBigBuffer() {
        return this.bigBuffer;
    }

    private void unloadEnvFile(final URL filePath) {
        AccessController.doPrivileged(new PrivilegedAction(){

            public Object run() {
                try {
                    File f = JXAenvUtils.this.findEnvInstalledFile(filePath);
                    if (JXAenvUtils.__accessFilePermitted(f, 4)) {
                        f.delete();
                    }
                    if (!exiting) {
                        f.deleteOnExit();
                    }
                }
                catch (Exception e) {
                    if (DebugMap._getInstance().isDebugLevelEnabled(DebugMap._getInstance()._VOID)) {
                        e.printStackTrace();
                    }
                }
                finally {
                    return null;
                }
            }
        }, acc);
    }

    public File getEnvInstalledFile(String id) {
        URL u = this.map.get(id);
        if (u != null) {
            return this.findEnvInstalledFile(u);
        }
        throw new JXAException(JXAException.LEVEL.SYSTEM, "File " + id + " wasn't loaded yet");
    }

    protected File findEnvInstalledFile(URL fileUrl) {
        String p = fileUrl.getFile();
        if (p.startsWith("/")) {
            p = p.substring(1);
        }
        String fp = p.replaceAll("%20", " ");
        return new File(this.envPath + File.separator + (this.keepFolderHierarchy ? fp : new File(fp).getName()));
    }

    public URL getEnvSourceFile(String id) {
        return this.map.get(id);
    }

    public Map<String, URL> getEnvSourceFiles() {
        return this.map;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map<String, File> getEnvInstalledFiles() {
        HashMap<String, File> fileMap = new HashMap<String, File>();
        Set<String> set = this.map.keySet();
        Map<String, URL> map = this.map;
        synchronized (map) {
            for (String id : set) {
                fileMap.put(id, this.getEnvInstalledFile(id));
            }
        }
        return Collections.synchronizedMap(fileMap);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void unloadAll() {
        Set<String> set = this.map.keySet();
        Map<String, URL> map = this.map;
        synchronized (map) {
            Iterator<String> i = set.iterator();
            while (i.hasNext()) {
                this.unloadEnvFile(this.map.get(i.next()));
            }
            this.loaded = LOAD_CLEARED;
            this.erroredFiles.clear();
        }
    }

    public Set<String> getErroredFiles() {
        return this.erroredFiles;
    }

    public void addEnvFile(String id, URL filePath) {
        if (_debugSys) {
            System.out.println("added env File : " + id + " = " + filePath);
            if (filePath == null) {
                System.err.println(JXAenvUtils.log(id + " was not found !! please check input.", LVL.SYS_ERR, null));
            }
        }
        this.map.put(id, filePath);
    }

    public void removeEnvFile(String id) {
        if (_debugSys) {
            System.out.println("removed env File : " + id);
        }
        this.map.remove(id);
    }

    public boolean load(String id) {
        if (_debugSys) {
            System.out.println("loading " + id + " ...");
        }
        boolean b = false;
        this.loaded |= LOAD_LOADING;
        boolean bl = b = this.map.get(id) != null ? this.loadEnvFile(this.map.get(id)) : false;
        if (!b && _debugSys) {
            System.err.println(JXAenvUtils._JXAEnvOutput(id + " " + this.map.get(id) + " has not been found or has failed to load", SYS_WARNING));
        }
        this.loaded &= ~LOAD_LOADING;
        if (!b) {
            this.loaded |= LOAD_ERROR;
            this.erroredFiles.add(id);
        }
        return b;
    }

    public void unload(String id) {
        if (_debugSys) {
            System.out.println("unloading " + id + " ...");
        }
        this.loaded |= LOAD_LOADING;
        this.unloadEnvFile(this.map.get(id));
        this.loaded &= ~LOAD_LOADING;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean loadAll() {
        Set<String> set = this.map.keySet();
        try {
            ArrayList<Thread> t = new ArrayList<Thread>();
            Map<String, URL> map = this.map;
            synchronized (map) {
                for (final String lib : set) {
                    Runnable r = new Runnable(){

                        @Override
                        public void run() {
                            JXAenvUtils.this.load(lib);
                        }
                    };
                    if (_multiThreading) {
                        t.add(new Thread(r, "load-" + lib));
                        continue;
                    }
                    r.run();
                }
            }
            if (_multiThreading) {
                for (Thread thr : t) {
                    thr.start();
                    thr.join();
                }
            }
            if (_debugSys) {
                System.out.println("load all libs done.");
            }
            this.loaded &= ~LOAD_CLEARED;
            this.loaded |= LOAD_LOADED;
            return (this.loaded & LOAD_LOADED) != 0;
        }
        catch (InterruptedException ex) {
            try {
                if (_debugSys) {
                    ex.printStackTrace();
                }
                this.loaded &= ~LOAD_CLEARED;
                this.loaded |= LOAD_LOADED;
                return (this.loaded & LOAD_LOADED) != 0;
            }
            catch (Throwable throwable) {
                this.loaded &= ~LOAD_CLEARED;
                this.loaded |= LOAD_LOADED;
                return (this.loaded & LOAD_LOADED) != 0;
            }
        }
    }

    public boolean hasLoadErrors() {
        return (this.loaded & LOAD_ERROR) != 0;
    }

    private void _initSplashContents() {
        if (_debugSys) {
            System.out.println(JXAenvUtils.log("Splash screen initializing...", LVL.SYS_NOT, null));
        }
        this.splashContents = new TransparentBackground(new GridBagLayout(), true);
        GridBagConstraints c = new GridBagConstraints();
        c.gridwidth = 0;
        c.fill = 2;
        this.jpb = UIMessage.newProgress(0, 0, this.splashContents);
        UIMessage.getProgressBar(this.jpb).setIndeterminate(true);
        UIMessage.getProgressBar(this.jpb).setString(null);
        UIMessage.getProgressBar(this.jpb).setStringPainted(false);
        this.splashContents.add((Component)UIMessage.getProgressBar(this.jpb), c);
    }

    private void _initSplashFrame(GraphicsConfiguration gc) {
        this.splashFrame = new JFrame(gc);
        this.splashFrame.setUndecorated(true);
        this.splashFrame.setContentPane(this.splashContents);
        UIMessage._makeUncloseable(this.splashFrame);
        this.splashFrame.validate();
    }

    public void showSplash() {
        block2: {
            try {
                ThreadWorks.Swing.invokeSwingAndReturn(new ThreadWorks.SwingStaticReturn(){

                    public Object run() {
                        JXAenvUtils.this._showSplash();
                        return null;
                    }
                });
            }
            catch (Exception ex) {
                if (!_debugSys) break block2;
                ex.printStackTrace();
            }
        }
    }

    private void _addSplashDisplay() {
        if (this.splashContents == null) {
            this._initSplashContents();
        }
        if (this.splash != null) {
            if (_debugSys) {
                System.out.println(JXAenvUtils.log("A JComponent Display is added.", LVL.SYS_NOT, null));
            }
            GridBagConstraints c = new GridBagConstraints();
            c.gridwidth = 0;
            this.splashContents.add((Component)this.splash.getJComponentDisplay(), c);
            this.splashContents.validate();
        }
    }

    private void _showSplash() {
        this._addSplashDisplay();
        if (this.antapplet instanceof AntApplet && this.antapplet.getApplet() != null) {
            ((TransparentBackground)this.splashContents).setDisableTransparency(true);
            this.antContents = this.antapplet.getApplet().getContentPane();
            this.antapplet.getApplet().setContentPane(this.splashContents);
            this.antapplet.getApplet().validate();
            this.antapplet.getApplet().setVisible(true);
            this.antapplet.getApplet().update(this.antapplet.getApplet().getGraphics());
        } else {
            if (this.splashFrame == null) {
                this._initSplashFrame(_defaultGC);
            }
            ((TransparentBackground)this.splashContents).setDisableTransparency(false);
            if (env.OS_LINUX.isEnv()) {
                this.splashFrame.pack();
                this.splashFrame.setLocationRelativeTo(null);
                this.splashFrame.setExtendedState(0);
            } else {
                Dimension dim = new Dimension(_defaultGC.getDevice().getDisplayMode().getWidth(), _defaultGC.getDevice().getDisplayMode().getHeight());
                this.splashContents.setPreferredSize(dim);
                this.splashFrame.pack();
                this.splashFrame.setExtendedState(6);
            }
            ((TransparentBackground)this.splashContents).updateBackground();
            this.splashFrame.setAlwaysOnTop(true);
            this.splashFrame.setVisible(true);
            this.splashFrame.setAlwaysOnTop(false);
            this.splashFrame.update(this.splashFrame.getGraphics());
        }
    }

    public void hideSplash() {
        block2: {
            try {
                ThreadWorks.Swing.invokeSwingAndReturnException(new ThreadWorks.SwingStaticReturnException(){

                    public Object run() {
                        JXAenvUtils.this._hideSplash();
                        return null;
                    }
                });
            }
            catch (Exception ex) {
                if (!_debugSys) break block2;
                ex.printStackTrace();
            }
        }
    }

    private void _hideSplash() {
        if (this.antapplet instanceof AntApplet && this.antapplet.getApplet() != null) {
            this.antapplet.getApplet().setContentPane(this.antContents);
            this.antapplet.getApplet().validate();
        } else {
            this.splashFrame.setVisible(false);
        }
    }

    public void setAntApplet(AntApplet ant) {
        this.antapplet = ant;
    }

    public void finalize() throws Throwable {
        if (ThreadWorks.Swing.isEventDispatchThread()) {
            this.splashFrame.setVisible(false);
            this.splashFrame.dispose();
        }
    }

    public void setSplashPicture(DisplayInterface splash) {
        this.splash = splash;
    }

    public boolean isMultiThreadingEnabled() {
        return _multiThreading;
    }

    public void setMultiThreadingEnabled(boolean b) {
        _multiThreading = b;
    }

    @Override
    public Object loadResource() {
        try {
            this.showSplash();
            this.loadAll();
            Thread.sleep(3000L);
        }
        catch (InterruptedException ex) {
            if (_debugSys) {
                ex.printStackTrace();
            }
        }
        finally {
            this.hideSplash();
            return null;
        }
    }

    public static void _setDebugEnabled(boolean b) {
        _debugSys = b;
    }

    public static boolean _isDebugEnabled() {
        return _debugSys;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Object clearResource() {
        long unloading = UIMessage.displayWaiting("please wait...", null);
        this.unloadAll();
        try {
            Thread.sleep(3000L);
        }
        catch (InterruptedException ex) {
            if (_debugSys) {
                ex.printStackTrace();
            }
        }
        finally {
            UIMessage.kill(unloading);
            return null;
        }
    }

    @Override
    public boolean isResourceLoaded() {
        return (this.loaded & LOAD_LOADED) != 0 && (this.loaded & LOAD_ERROR) == 0;
    }

    public static long _getSwapUsage() {
        return SpritesCacheManager._getSwap_global_memory_usage();
    }

    public static MemoryMXBean _memoryBean() {
        return ManagementFactory.getMemoryMXBean();
    }

    public static OperatingSystemMXBean _systemBean() {
        return ManagementFactory.getOperatingSystemMXBean();
    }

    public static RuntimeMXBean _runtimeBean() {
        return ManagementFactory.getRuntimeMXBean();
    }

    public static <T> T _callback(String method, Object target, Object[] args, Class[] clargs) throws NoSuchMethodException, IllegalAccessException, InvocationTargetException {
        Method m = null;
        m = target instanceof Class ? ((Class)target).getMethod(method, clargs) : target.getClass().getMethod(method, clargs);
        m.setAccessible(true);
        if (target instanceof Class) {
            return (T)m.invoke(null, args);
        }
        return (T)m.invoke(target, args);
    }

    @Deprecated
    public static void _fileCopy(File src, File dst, boolean progressBar, boolean bigBuffer) throws FileNotFoundException, IOException {
        FileHelper._fileCopy(src, dst, progressBar, bigBuffer);
    }

    @Deprecated
    public static void _fileCopy(InputStream src, File dst, boolean progressBar, boolean bigBuffer) throws FileNotFoundException, IOException {
        FileHelper._fileCopy(src, dst, progressBar, bigBuffer);
    }

    @Deprecated
    public static void _fileCopy(URL src, File dst, boolean progressBar, boolean bigBuffer) throws FileNotFoundException, IOException, HttpException {
        FileHelper._fileCopy(src, dst, progressBar, bigBuffer);
    }

    public static Object _doPriority(String method, Object target, Object[] args, Class[] clargs, int level) throws IllegalAccessException, InvocationTargetException, NoSuchMethodException {
        int currentPty = Thread.currentThread().getPriority();
        Thread.currentThread().setPriority(level);
        Object result = JXAenvUtils._callback(method, target, args, clargs);
        Thread.currentThread().setPriority(currentPty);
        return result;
    }

    @Deprecated
    public static void _fileCopy(File src, File dst, boolean progressBar, long progressBarID, boolean bigBuffer) throws IOException {
        FileHelper._fileCopy(src, dst, progressBar, progressBarID, bigBuffer);
    }

    @Deprecated
    public static void _fileCopy(InputStream src, File dst, boolean progressBar, long progressBarID, boolean bigBuffer) throws IOException {
        FileHelper._fileCopy(src, dst, progressBar, progressBarID, bigBuffer);
    }

    @Deprecated
    public static void _fileCopy(URL src, File dst, boolean progressBar, long progressBarID, boolean bigBuffer) throws IOException {
        FileHelper._fileCopy(src, dst, progressBar, progressBarID, bigBuffer);
    }

    public static void _popExceptionToUser(boolean modal, Thread t, Throwable ex) {
        ThreadWorks._uncaughtException(modal, t, ex);
    }

    public static Console _runShell(String[] cmd, boolean confirm, boolean waitForFinish, boolean log) {
        return JXAenvUtils._runShell(cmd, null, confirm, waitForFinish, log);
    }

    public static Console _runShell(final String[] cmd, final File cwd, final boolean confirm, final boolean waitForFinish, final boolean log) {
        return AccessController.doPrivileged(new PrivilegedAction<Console>(){

            @Override
            public Console run() {
                return JXAenvUtils.__runShell(cmd, cwd, confirm, waitForFinish, log);
            }
        }, acc);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static Console __runShell(String[] cmd, File cwd, boolean confirm, boolean waitForFinish, boolean log) {
        long frame = UIMessage.displayWaiting("Loading...", null);
        Console console = new Console();
        String[] shell = new String[]{};
        File shellFile = FileHelper._TMPDIRECTORY.getAbsoluteFile();
        String commandline = "";
        Process p = null;
        try {
            if (env.OS_WINDOWS.isEnv()) {
                shellFile = new File(shellFile, "run-tmp.bat");
                shell = new String[]{"cmd.exe", "/C", "call", shellFile.getAbsolutePath()};
                commandline = commandline + "@echo off" + Console.newLine;
            } else if (env._hasEnv(env.OS_LINUX.bitMask() | env.OS_MAC.bitMask())) {
                shellFile = new File(shellFile, ".run");
                shell = new String[]{"/bin/sh", shellFile.getAbsolutePath()};
            } else {
                new UIMessage(true, (Object)(JXAenvUtils._getSysValue("os.name") + " operating systems are currently not supported. Program is going to exit..."), null);
                Console console2 = console;
                return console2;
            }
            for (String s : cmd) {
                commandline = commandline + s + " ";
            }
            String shellString = "";
            for (String sh : shell) {
                shellString = shellString + " " + sh;
            }
            String msg = "LAUNCH :" + shellString + " >> " + commandline;
            if (_debugSys) {
                System.out.println(msg);
            }
            if (!shellFile.exists()) {
                shellFile.createNewFile();
            }
            RandomAccessFile raf = new RandomAccessFile(shellFile, "rw");
            raf.setLength(commandline.length());
            Charset cs = env.OS_WINDOWS.isEnv() ? Charset.forName("US-ASCII") : Charset.forName("UTF-16");
            raf.write(commandline.getBytes(cs));
            raf.close();
            final String MSG = msg;
            JPanel panel = new JPanel(true);
            panel.setLayout(new BorderLayout());
            panel.add((Component)new JLabel("Do run the command ?"), "Center");
            panel.add((Component)new JButton(new AbstractAction("show command...", UIMessage._getIcon(47, true)){

                @Override
                public void actionPerformed(ActionEvent e) {
                    new UIMessage(true, (Object)MSG, null);
                }
            }), "South");
            UIMessage.hideProgress(frame);
            if (confirm && UIMessage.showConfirmDialog(UIMessage._getDisplayFrame(frame), panel, "continue ?", 2) == 2) {
                Console console3 = console;
                return console3;
            }
            ArrayList<String> pbCmd = new ArrayList<String>();
            for (String c : shell) {
                pbCmd.add(c);
            }
            ProcessBuilder pb = new ProcessBuilder(pbCmd);
            pb.directory(cwd);
            p = pb.start();
            UIMessage.showProgress(frame);
            if (log) {
                Thread t_err = console.getNewInput(p.getErrorStream(), "%S");
                Thread t_in = console.getNewInput(p.getInputStream());
                t_err.setDaemon(true);
                t_in.setDaemon(true);
                t_err.start();
                t_in.start();
            }
            try {
                if (waitForFinish) {
                    final Process ps = p;
                    Runtime.getRuntime().addShutdownHook(new Thread(new Runnable(){

                        @Override
                        public void run() {
                            ps.destroy();
                        }
                    }));
                    p.waitFor();
                    if (log || p.exitValue() != 0) {
                        new UIMessage(true, (Object)(commandline + " has exited with status " + p.exitValue() + " (0 for normal termination)"), null, p.exitValue() == 0 ? 0 : 1);
                    }
                }
                break block27;
            }
            catch (InterruptedException ex) {
                if (_debugSys) {
                    ex.printStackTrace();
                }
            }
            {
                block27: {
                }
            }
        }
        catch (Exception ex) {
            if (_debugSys) {
                ex.printStackTrace();
            }
        }
        finally {
            UIMessage.kill(frame);
            if (shellFile.exists()) {
                if (_debugSys) {
                    shellFile.deleteOnExit();
                } else {
                    shellFile.delete();
                }
            }
            return console;
        }
    }

    public static String _getJavaExecutablePath() {
        return AccessController.doPrivileged(new PrivilegedAction<String>(){

            @Override
            public String run() {
                return JXAenvUtils.__getJavaExecutablePath();
            }
        }, acc);
    }

    private static String __getJavaExecutablePath() {
        String javaHome = JXAenvUtils._getSysValue("java.home");
        if (env._hasEnv(env.OS_LINUX.bitMask() | env.OS_MAC.bitMask())) {
            javaHome = javaHome + File.separator + "bin" + File.separator + "java";
        } else if (env.OS_WINDOWS.isEnv()) {
            javaHome = javaHome + File.separator + "bin" + File.separator + "java.exe";
        }
        return javaHome;
    }

    public static void _goWeb(URL url, Object JSInterface) {
        JXAenvUtils._goWeb(url, JSInterface, new Dimension(600, 400));
    }

    public static JXAWebView.Browser _goWeb(URL url, Object JSInterface, Dimension dim) {
        Monitor init = JXAWebView.initVars(url, JSInterface, dim);
        try {
            return JXAWebView.newBrowser(url);
        }
        catch (ExecutionException ex) {
            Logger.getLogger(JXAenvUtils.class.getName()).log(Level.SEVERE, null, ex);
            return null;
        }
    }

    public static JPanel _goWeb(final URL url) {
        return AccessController.doPrivileged(new PrivilegedAction<JPanel>(){

            @Override
            public JPanel run() {
                return JXAenvUtils.__goWeb(url);
            }
        }, acc);
    }

    private static JPanel __goWeb(URL url) {
        String[] run = new String[]{};
        run = env.OS_WINDOWS.isEnv() ? new String[]{"start", "\"STARTING THE BROWSER\"", "\"" + url.toString() + "\""} : (env.OS_LINUX.isEnv() ? new String[]{"firefox", "\"" + url.toString() + "\""} : new String[]{"open", "\"" + url.toString() + "\""});
        JXAenvUtils._runShell(run, false, false, true);
        JPanel panel = new JPanel(new BorderLayout(), true);
        final JTextField urlField = new JTextField(url.toString(), 50);
        urlField.setDragEnabled(true);
        panel.add((Component)new JLabel("<html>Go web :<br>(COPY & PASTE into your browser)"), "West");
        panel.add((Component)urlField, "Center");
        panel.add((Component)new JButton(new AbstractAction("", UIMessage._getIcon(46, true)){

            @Override
            public void actionPerformed(ActionEvent e) {
                try {
                    JXAenvUtils._goWeb(new URL(urlField.getText()), null);
                    urlField.setToolTipText("If the browser doesn't open, copy-paste the URL into your browser !");
                }
                catch (MalformedURLException ex) {
                    if (_debugSys) {
                        ex.printStackTrace();
                    }
                    urlField.setToolTipText("Not a valid URL");
                }
            }
        }), "East");
        return panel;
    }

    public boolean isDebugEnabled() {
        return _debug;
    }

    public void setDebugEnabled(boolean b) {
        _debug = b;
    }

    public static JProgressBar _JTimeProgressBar(String textString) {
        JTimeProgressBar jpb = new JTimeProgressBar();
        jpb.setString(textString);
        FontMetrics fm = jpb.getFontMetrics(jpb.getFont());
        Dimension getPref = new Dimension(Math.round((float)fm.stringWidth(jpb.getString()) * jpb.paddingFactor), Math.round((float)fm.getHeight() * jpb.paddingFactor));
        jpb.setPreferredSize(getPref);
        return jpb;
    }

    public static JProgressBar _JTimeProgressBar() {
        JTimeProgressBar jpb = new JTimeProgressBar();
        return jpb;
    }

    public static JXAenvUtils _loadNativeLibrary(env os, String libname, boolean link) throws MalformedURLException {
        return JXAenvUtils._loadNativeLibraries(os, new LinkedHashMap<String, Boolean>(Collections.singletonMap(libname, link)));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static JXAenvUtils _loadNativeLibraries(env os, LinkedHashMap<String, Boolean> mapLibrary) throws MalformedURLException {
        HashMap<String, Map<URL, Boolean>> exts = new HashMap<String, Map<URL, Boolean>>();
        Map<String, Boolean> libs = Collections.synchronizedMap(mapLibrary);
        ClassLoader ecl = ExtensionsClassLoader.isResourceLoaded() ? ExtensionsClassLoader.getInstance().getClassLoader() : Thread.currentThread().getContextClassLoader();
        LinkedHashMap<String, Boolean> linkedHashMap = mapLibrary;
        synchronized (linkedHashMap) {
            for (String libname : libs.keySet()) {
                if ((os.compareMask() & (env.OS_WINDOWS.bitMask() | env.OS_WINDOWS_7.bitMask() | env.OS_WINDOWS_VISTA.bitMask() | env.OS_WINDOWS_XP.bitMask())) != 0) {
                    exts.put(libname, Collections.singletonMap(ecl.getResource("/" + libname + ".dll"), libs.get(libname)));
                }
                if ((os.compareMask() & env.OS_LINUX.bitMask()) != 0) {
                    exts.put(libname, Collections.singletonMap(ecl.getResource("/lib" + libname + ".so"), libs.get(libname)));
                }
                if ((os.compareMask() & env.OS_MAC.bitMask()) == 0) continue;
                String path = "/lib" + libname + ".jnilib";
                if (!(ecl.getResource(path) instanceof URL)) {
                    path = "/lib" + libname + ".dylib";
                }
                exts.put(libname, Collections.singletonMap(ecl.getResource(path), libs.get(libname)));
            }
        }
        return ExtensionsInstaller._installExtensions(Collections.singletonMap(os.osname(), exts), true, null);
    }

    public static String _kernelVersion() {
        return JXAenvUtils.class.getPackage().getImplementationVersion();
    }

    @Deprecated
    public static void _makeWritableOwnerOnly(File fd) {
        FileHelper._makeWritableOwnerOnly(fd);
    }

    @Deprecated
    public static void _makeWritable(File fd) {
        FileHelper._makeWritable(fd);
    }

    @Deprecated
    public static void ___rawfileCopy(File s, File d) throws IOException {
        FileHelper.___rawfileCopy(s, d, true);
    }

    @Deprecated
    public static void _makeReadableOwnerOnly(File fd) {
        FileHelper._makeReadableOwnerOnly(fd);
    }

    @Deprecated
    public static void _makeReadable(File fd) {
        FileHelper._makeReadable(fd);
    }

    @Deprecated
    public static boolean _isImageIOCacheEnabled() {
        return FileHelper._isImageIOCacheEnabled();
    }

    @Deprecated
    public static void _setImageIOCacheEnabled(boolean b, File cacheDirectory) {
        FileHelper._setImageIOCacheEnabled(b, cacheDirectory);
    }

    static /* synthetic */ int access$000() {
        return LVL_SYS;
    }

    static /* synthetic */ int access$100() {
        return TYPE_ERROR;
    }

    static /* synthetic */ int access$200() {
        return TYPE_WARNING;
    }

    static /* synthetic */ int access$300() {
        return TYPE_NOTICE;
    }

    static /* synthetic */ int access$400() {
        return LVL_APP;
    }

    static /* synthetic */ int access$500() {
        return LVL_USER;
    }

    static class JTimeProgressBar
    extends JProgressBar {
        private long wSpeedTimer = 0L;
        private int wValTimer = 0;
        private String wTime;
        long time = 0L;
        final String format_default = "%1$s time left";
        String format = "%1$s time left";
        float paddingFactor = 1.2f;
        List<Double> wSpeedTimerValues = Collections.synchronizedList(new ArrayList());

        public JTimeProgressBar() {
        }

        public JTimeProgressBar(int orient) {
            super(orient);
        }

        public JTimeProgressBar(int min, int max) {
            super(min, max);
        }

        public JTimeProgressBar(int orient, int min, int max) {
            super(orient, min, max);
        }

        public String getTimeStr(long time) {
            BigInteger t = BigInteger.valueOf(time);
            if (time != 0L) {
                String fStr = "";
                BigInteger[] H = t.divideAndRemainder(hours);
                BigInteger[] M = H[1].divideAndRemainder(minutes);
                BigInteger[] S = M[1].divideAndRemainder(seconds);
                if (H[0].intValue() > 0) {
                    fStr = fStr + String.format("%1$2d:", H[0].intValue());
                }
                if (M[0].intValue() > 0) {
                    fStr = fStr + String.format("%1$2d'", M[0].intValue());
                }
                fStr = fStr + String.format("%1$2ds", S[0].intValue());
                return fStr;
            }
            return "N/A";
        }

        @Override
        public void setString(String s) {
            if (s != null) {
                String sQ = s.replace("%20", " ");
                this.wTime = String.format(sQ, this.getTimeStr(this.time));
                this.format = sQ;
                super.setStringPainted(true);
            } else {
                this.wTime = null;
                this.format = "%1$s time left";
                super.setStringPainted(false);
            }
            super.setString(this.wTime);
            if (ThreadWorks.Swing.isEventDispatchThread()) {
                this.paintImmediately(this.getVisibleRect());
            }
        }

        @Override
        public void setValue(int n) {
            long now = System.currentTimeMillis();
            double avgSpeed = 0.0;
            for (double s : this.wSpeedTimerValues) {
                avgSpeed += s;
            }
            this.time = n == this.getValue() || this.wSpeedTimerValues.isEmpty() ? this.time : Math.round((double)(this.getMaximum() - n) / (avgSpeed / (double)this.wSpeedTimerValues.size()));
            this.setString(n >= this.getMaximum() ? null : this.format);
            if (n != this.wValTimer && now - this.wSpeedTimer > 100L) {
                if (this.wSpeedTimer != 0L) {
                    this.wSpeedTimerValues.add(((double)n - (double)this.wValTimer) / (double)(now - this.wSpeedTimer));
                }
                this.wValTimer = n;
                this.wSpeedTimer = now;
            }
            super.setValue(n);
            if (n >= this.getMaximum()) {
                this.wValTimer = 0;
                this.wSpeedTimer = this.time = (long)0;
                this.wSpeedTimerValues.clear();
            }
            if (ThreadWorks.Swing.isEventDispatchThread()) {
                this.paintImmediately(this.getVisibleRect());
            }
        }
    }

    public static enum LVL {
        SYS_ERR(JXAenvUtils.access$000() | JXAenvUtils.access$100(), Level.SEVERE),
        SYS_WRN(JXAenvUtils.access$000() | JXAenvUtils.access$200(), Level.WARNING),
        SYS_NOT(JXAenvUtils.access$000() | JXAenvUtils.access$300(), Level.INFO),
        APP_ERR(JXAenvUtils.access$400() | JXAenvUtils.access$100(), Level.SEVERE),
        APP_WRN(JXAenvUtils.access$400() | JXAenvUtils.access$200(), Level.WARNING),
        APP_NOT(JXAenvUtils.access$400() | JXAenvUtils.access$300(), Level.INFO),
        USR_ERR(JXAenvUtils.access$500() | JXAenvUtils.access$100(), Level.SEVERE),
        USR_WRN(JXAenvUtils.access$500() | JXAenvUtils.access$200(), Level.WARNING),
        USR_NOT(JXAenvUtils.access$500() | JXAenvUtils.access$300(), Level.INFO);

        public int level;
        public Level loggingLevel;

        private LVL(int level, Level loggingLevel) {
            this.level = level;
            this.loggingLevel = loggingLevel;
        }

        static LVL _findJXALevel(int level, Level loggingLevel) {
            for (LVL l : LVL.values()) {
                if (!l.loggingLevel.equals(loggingLevel) || 0 == (l.level & level)) continue;
                return l;
            }
            return USR_NOT;
        }
    }
}

