/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jiga.xtended.kernel;

import java.awt.Image;
import java.awt.event.ActionEvent;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.Closeable;
import java.io.EOFException;
import java.io.Externalizable;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.FilenameFilter;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInput;
import java.io.ObjectInputStream;
import java.io.ObjectOutput;
import java.io.ObjectOutputStream;
import java.io.OptionalDataException;
import java.io.OutputStream;
import java.io.RandomAccessFile;
import java.io.Serializable;
import java.lang.ref.Reference;
import java.lang.ref.ReferenceQueue;
import java.lang.ref.WeakReference;
import java.lang.reflect.InvocationTargetException;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.SortedMap;
import java.util.Stack;
import java.util.Timer;
import java.util.TimerTask;
import java.util.TreeMap;
import java.util.TreeSet;
import java.util.WeakHashMap;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import java.util.zip.ZipOutputStream;
import javax.swing.AbstractAction;
import javax.swing.JLabel;
import net.sf.jiga.xtended.kernel.DebugMap;
import net.sf.jiga.xtended.kernel.Debugger;
import net.sf.jiga.xtended.kernel.ExtensionsClassLoader;
import net.sf.jiga.xtended.kernel.FileHelper;
import net.sf.jiga.xtended.kernel.JXAenvUtils;
import net.sf.jiga.xtended.kernel.Level;
import net.sf.jiga.xtended.kernel.Monitor;
import net.sf.jiga.xtended.kernel.SpritesCacheListener;
import net.sf.jiga.xtended.kernel.Threaded;
import net.sf.jiga.xtended.ui.UIMessage;

public class SpritesCacheManager<K, V>
implements SortedMap<K, V>,
Externalizable,
Threaded,
Debugger {
    public static final Level dbLevel = DebugMap._getInstance().newDebugLevel();
    private static final long serialVersionUID = 2323L;
    private transient Set<SpritesCacheListener> listeners = Collections.synchronizedSet(new HashSet());
    private Exception lastError;
    private int listCapacity;
    private int initialListCapacity;
    private transient Map<KeyRegistry<K>, V> lru;
    private transient List<KeyRegistry<K>> lruK;
    private transient Map<KeyRegistry<K>, V> mru;
    private transient List<KeyRegistry<K>> mruK;
    private transient Map<KeyRegistry<K>, SoftValue<KeyRegistry<K>, V>> cache;
    private static final ReferenceQueue _cacheBack;
    private SortedMap<KeyRegistry<K>, File> cacheDisk;
    private boolean compress = false;
    private boolean swap = false;
    private transient Timer timer = null;
    protected String cacheDisk_ext = ".sp3";
    protected String cacheDisk_dir = "cache";
    protected static String _cacheDisk_dir;
    protected String cacheDisk_prefix = "_cache";
    protected static String _cacheDisk_prefix;
    protected transient boolean writing = false;
    protected transient Monitor writeMonitor;
    protected transient boolean reading = false;
    protected transient Monitor readMonitor;
    protected transient List<WeakReference<Map<K, V>>> subMaps;
    protected transient List<WeakReference<Set<K>>> keysSubLists;
    protected transient List<WeakReference<Set<V>>> valuesSubLists;
    private transient Map<Integer, SoftValue> buffer;
    private long swap_memory_usage = 0L;
    private static long swap_global_memory_usage;
    public static final String JXA_ECLIO = "jxa.ecl.io";
    private long hash = System.nanoTime();
    private static List fileCache;
    public transient Comparator<? super K> comparator = null;

    public void setDebugEnabled(boolean b) {
        DebugMap._getInstance().setDebuggerEnabled(b, SpritesCacheManager.class, dbLevel);
    }

    public boolean isDebugEnabled() {
        return DebugMap._getInstance().isDebuggerEnabled(SpritesCacheManager.class);
    }

    public boolean isCompressedCacheEnabled() {
        return this.compress;
    }

    public String getCacheDisk_dir() {
        return this.cacheDisk_dir;
    }

    public void setCacheDisk_dir(String cacheDisk_dir) {
        this.cacheDisk_dir = cacheDisk_dir;
    }

    public String getCacheDisk_ext() {
        return this.cacheDisk_ext;
    }

    public void setCacheDisk_prefix(String cacheDisk_prefix) {
        this.cacheDisk_prefix = cacheDisk_prefix;
    }

    public void setCacheDisk_ext(String cacheDisk_ext) {
        this.cacheDisk_ext = cacheDisk_ext;
    }

    public String getCacheDisk_prefix() {
        return this.cacheDisk_prefix;
    }

    private static void debug(Object message) {
        SpritesCacheManager.debug(message, true);
    }

    private static void debug(Object message, boolean newLine) {
        if (DebugMap._getInstance().isDebuggerEnabled(SpritesCacheManager.class)) {
            if (newLine) {
                System.err.println(message);
            } else {
                System.err.print(message);
            }
        }
    }

    public SpritesCacheManager(Comparator<? super K> c, int capacity) {
        this(capacity);
        this.comparator = c;
    }

    public SpritesCacheManager(Comparator<? super K> c) {
        this(c, 1);
    }

    public SpritesCacheManager() {
        this(1);
    }

    public SpritesCacheManager(int capacity) {
        assert (capacity != 0) : "capacity cannot be zero";
        File d = new File(FileHelper._TMPDIRECTORY.getPath() + File.separator + _cacheDisk_dir);
        if (!d.isDirectory()) {
            d.mkdirs();
            FileHelper._makeWritable(d);
        }
        this.listCapacity = this.initialListCapacity = capacity;
        this.setGroupMonitor(new Monitor(), new Monitor());
        this.buffer = Collections.synchronizedMap(new HashMap());
        this.subMaps = Collections.synchronizedList(new ArrayList());
        this.keysSubLists = Collections.synchronizedList(new ArrayList());
        this.valuesSubLists = Collections.synchronizedList(new ArrayList());
        this.lru = Collections.synchronizedMap(new HashMap(this.listCapacity));
        this.lruK = Collections.synchronizedList(new Stack());
        this.mru = Collections.synchronizedMap(new HashMap(this.listCapacity));
        this.mruK = Collections.synchronizedList(new Stack());
        this.cache = Collections.synchronizedMap(new WeakHashMap(capacity));
        this.buffer(this.cache);
        this.cacheDisk = Collections.synchronizedSortedMap(new TreeMap());
        this.buffer(this.cacheDisk);
    }

    @Override
    public void setGroupMonitor(Monitor ... tg) {
        this.writeMonitor = tg[0];
        this.readMonitor = tg[1];
    }

    @Override
    public Monitor[] getGroupMonitor() {
        return new Monitor[]{this.writeMonitor, this.readMonitor};
    }

    public int getInitialListCapacity() {
        return this.initialListCapacity;
    }

    private void trunk(Map<KeyRegistry<K>, V> ru, List<KeyRegistry<K>> ruK, int n) {
        while (ru.size() > n) {
            ru.remove(ruK.remove(ruK.size() - 1));
        }
        this.cleanup();
    }

    private void memorySensitiveUpdate(KeyRegistry<K> key, V sp) throws Throwable {
        this.memorySensitiveCallback("memoryUpdate", this, new Object[]{key, sp}, new Class[]{KeyRegistry.class, Object.class});
    }

    public void memoryUpdate(KeyRegistry<K> key, V sp) {
        int currentPty = Thread.currentThread().getPriority();
        Thread.currentThread().setPriority(10);
        if (this.lru.containsKey(key)) {
            this.mru.put(key, sp);
            this.mruK.add(0, key);
            this.trunk(this.mru, this.mruK, this.listCapacity);
        }
        this.lru.put(key, sp);
        this.lruK.add(0, key);
        this.trunk(this.lru, this.lruK, this.listCapacity);
        Thread.currentThread().setPriority(currentPty);
    }

    private V memorySensitiveClear(V sp) throws Throwable {
        return (V)this.memorySensitiveCallback("memoryClear", this, new Object[]{sp}, new Class[]{Object.class});
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public V memoryClear(V sp) {
        Iterator<KeyRegistry<K>> i1;
        List<KeyRegistry<K>> list;
        Object value;
        Map.Entry<KeyRegistry<K>, V> entry;
        Iterator<Map.Entry<KeyRegistry<K>, V>> i0;
        Map<KeyRegistry<K>, V> map;
        Set<Map.Entry<KeyRegistry<K>, V>> set;
        int currentPty = Thread.currentThread().getPriority();
        Thread.currentThread().setPriority(10);
        if (this.lru.containsValue(sp)) {
            set = this.lru.entrySet();
            map = this.lru;
            synchronized (map) {
                i0 = set.iterator();
                this.buffer(i0);
                while (i0.hasNext()) {
                    entry = i0.next();
                    this.buffer(entry);
                    value = entry != null ? (Object)entry.getValue() : null;
                    this.buffer(value);
                    if (value == null || !value.equals(sp)) continue;
                    list = this.lruK;
                    synchronized (list) {
                        i1 = this.lruK.iterator();
                        this.buffer(i1);
                        while (i1.hasNext()) {
                            if (!i1.next().equals(entry.getKey())) continue;
                            i1.remove();
                        }
                        i0.remove();
                    }
                }
            }
        }
        if (this.mru.containsValue(sp)) {
            set = this.mru.entrySet();
            map = this.mru;
            synchronized (map) {
                i0 = set.iterator();
                this.buffer(i0);
                while (i0.hasNext()) {
                    entry = i0.next();
                    this.buffer(entry);
                    value = entry != null ? (Object)entry.getValue() : null;
                    this.buffer(value);
                    if (value == null || !value.equals(sp)) continue;
                    list = this.mruK;
                    synchronized (list) {
                        i1 = this.mruK.iterator();
                        this.buffer(i1);
                        while (i1.hasNext()) {
                            if (!i1.next().equals(entry.getKey())) continue;
                            i1.remove();
                        }
                        i0.remove();
                    }
                }
            }
        }
        Thread.currentThread().setPriority(currentPty);
        return sp;
    }

    protected void clearMemory() {
        this.mru.clear();
        this.mruK.clear();
        this.lru.clear();
        this.lruK.clear();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void compress(Serializable sp, OutputStream out) {
        int pty = Thread.currentThread().getPriority();
        Thread.currentThread().setPriority(10);
        this.cleanup();
        this.buffer(sp);
        this.buffer(out);
        try {
            ZipEntry ze = new ZipEntry("sp_" + sp.hashCode());
            ZipOutputStream zip = new ZipOutputStream(out);
            zip.setLevel(8);
            zip.putNextEntry(ze);
            this.buffer(ze);
            this.buffer(zip);
            ObjectOutputStream oos = new ObjectOutputStream(zip);
            oos.writeObject(sp);
            oos.flush();
            zip.closeEntry();
            zip.finish();
            SpritesCacheManager.debug("Compressed caching " + ze.getCompressedSize() + " !");
        }
        catch (IOException ex) {
            if (this.isDebugEnabled()) {
                ex.printStackTrace();
            }
        }
        finally {
            Thread.currentThread().setPriority(pty);
        }
    }

    public Map<KeyRegistry<K>, File> getSwapMap() {
        return this.cacheDisk;
    }

    public static long _getSwap_global_memory_usage() {
        return swap_global_memory_usage;
    }

    public long getSwapUsage() {
        return this.swap_memory_usage;
    }

    private static boolean isExtClassLoadIO() {
        return Boolean.getBoolean(JXA_ECLIO);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Serializable uncompress(InputStream in) throws NullPointerException {
        int pty = Thread.currentThread().getPriority();
        Thread.currentThread().setPriority(10);
        this.cleanup();
        Serializable o = null;
        ZipInputStream zis = new ZipInputStream(in);
        this.buffer(zis);
        try {
            ObjectInputStream objectInputStream;
            zis.getNextEntry();
            if (!SpritesCacheManager.isExtClassLoadIO()) {
                objectInputStream = new ObjectInputStream(zis);
            } else {
                ExtensionsClassLoader extensionsClassLoader = ExtensionsClassLoader.getInstance();
                extensionsClassLoader.getClass();
                objectInputStream = extensionsClassLoader.new ExtensionsClassLoader.ObjectInputStream(zis);
            }
            ObjectInputStream ois = objectInputStream;
            this.buffer(ois);
            o = (Serializable)ois.readObject();
            this.buffer(o);
            zis.closeEntry();
            zis.close();
        }
        catch (EOFException e) {
            SpritesCacheManager.debug("CacheEntry: uncompress: done.");
        }
        catch (IOException e) {
            if (this.isDebugEnabled()) {
                e.printStackTrace();
            }
        }
        catch (ClassNotFoundException e) {
            if (this.isDebugEnabled()) {
                e.printStackTrace();
            }
        }
        finally {
            if (o == null) {
                throw new NullPointerException("Null CacheEntry: cannot uncompress!");
            }
            Thread.currentThread().setPriority(pty);
            return o;
        }
    }

    @Override
    public int hashCode() {
        return (int)this.hash;
    }

    @Override
    public boolean equals(Object o) {
        return o != null ? this.hash == (long)o.hashCode() : false;
    }

    public boolean writeSwap(final KeyRegistry<K> key, final Serializable value) {
        return AccessController.doPrivileged(new PrivilegedAction<Boolean>(){

            @Override
            public Boolean run() {
                return SpritesCacheManager.this._writeSwap(key, value);
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean _writeSwap(KeyRegistry<K> key, Serializable value) {
        int pty = Thread.currentThread().getPriority();
        Thread.currentThread().setPriority(10);
        this.cleanup();
        this.notifyWrite(4);
        this.buffer(key);
        this.buffer(value);
        File f = null;
        boolean compress0 = this.compress;
        try {
            Monitor monitor1;
            Monitor monitor0;
            Monitor monitor = monitor0 = this.readMonitor;
            synchronized (monitor) {
                while (this.reading) {
                    monitor0.wait();
                }
                this.writing = true;
                File dir = new File(FileHelper._TMPDIRECTORY.getPath() + File.separator + _cacheDisk_dir);
                dir.mkdirs();
                FileHelper._makeWritable(dir);
                f = FileHelper._createTempFile(this.cacheDisk_prefix + this.hashCode(), dir, true);
                RandomAccessFile raf = new RandomAccessFile(f, "rws");
                FileOutputStream fos = new FileOutputStream(raf.getFD());
                BufferedOutputStream bos = new BufferedOutputStream(fos, FileHelper._SMALLBUFFFER_SIZE);
                ObjectOutputStream oos = new ObjectOutputStream(bos);
                this.buffer(oos);
                this.buffer(bos);
                oos.writeBoolean(compress0);
                if (compress0) {
                    this.compress(value, oos);
                } else {
                    oos.writeObject(value);
                }
                oos.flush();
                oos.close();
                bos.close();
                raf.close();
                File old = this.cacheDisk.put(key, f);
                if (old instanceof File && !old.equals(f) && FileHelper._accessFilePermitted(old, 4)) {
                    old.delete();
                    this.swap_memory_usage -= old.length();
                    swap_global_memory_usage -= old.length();
                }
                this.swap_memory_usage += f.length();
                swap_global_memory_usage += f.length();
                this.notifyWrite(6);
                value = null;
                Thread.currentThread().setPriority(pty);
                monitor0.notify();
            }
            Monitor monitor2 = monitor1 = this.writeMonitor;
            synchronized (monitor2) {
                this.writing = false;
                monitor1.notifyAll();
            }
            return true;
        }
        catch (Exception e) {
            Monitor monitor;
            if (e instanceof InterruptedException) {
                if (this.isDebugEnabled()) {
                    e.printStackTrace();
                }
            } else if (this.isDebugEnabled()) {
                e.printStackTrace();
            }
            this.lastError = e;
            this.notifyWrite(7);
            if (f != null) {
                f.delete();
                this.swap_memory_usage -= f.length();
                swap_global_memory_usage -= f.length();
                this.notifyWrite(5);
            }
            Monitor monitor3 = monitor = this.writeMonitor;
            synchronized (monitor3) {
                this.writing = false;
                monitor.notifyAll();
            }
            return false;
        }
    }

    public V readSwap(final KeyRegistry<K> key) {
        return (V)AccessController.doPrivileged(new PrivilegedAction<V>(){

            @Override
            public V run() {
                return SpritesCacheManager.this._readSwap(key);
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private V _readSwap(KeyRegistry<K> key) {
        int pty = Thread.currentThread().getPriority();
        Thread.currentThread().setPriority(10);
        this.cleanup();
        this.notifyRead(0);
        Object value = null;
        File f = null;
        try {
            Monitor monitor0;
            Monitor monitor = monitor0 = this.writeMonitor;
            synchronized (monitor) {
                while (this.writing) {
                    monitor0.wait();
                }
                this.reading = true;
                if (this.cacheDisk.containsKey(key)) {
                    ObjectInputStream objectInputStream;
                    SpritesCacheManager.debug("Swap: Found Key " + key + " ");
                    f = (File)this.cacheDisk.get(key);
                    SpritesCacheManager.debug(f.getCanonicalPath());
                    RandomAccessFile raf = new RandomAccessFile(f, "r");
                    FileInputStream fis = new FileInputStream(raf.getFD());
                    BufferedInputStream bis = new BufferedInputStream(fis, FileHelper._SMALLBUFFFER_SIZE);
                    SpritesCacheManager.debug("opening...");
                    if (!SpritesCacheManager.isExtClassLoadIO()) {
                        objectInputStream = new ObjectInputStream(bis);
                    } else {
                        ExtensionsClassLoader extensionsClassLoader = ExtensionsClassLoader.getInstance();
                        extensionsClassLoader.getClass();
                        objectInputStream = extensionsClassLoader.new ExtensionsClassLoader.ObjectInputStream(bis);
                    }
                    ObjectInputStream ois = objectInputStream;
                    this.buffer(ois);
                    this.buffer(bis);
                    value = ois.readBoolean() ? this.uncompress(ois) : ois.readObject();
                    this.buffer(value);
                    ois.close();
                    bis.close();
                    raf.close();
                }
                monitor0.notify();
                // MONITOREXIT @DISABLED, blocks:[0, 1, 6] lbl39 : MonitorExitStatement: MONITOREXIT : var6_8
            }
        }
        catch (Exception e) {
            if (e instanceof OptionalDataException) {
                OptionalDataException opt = (OptionalDataException)e;
                SpritesCacheManager.debug("OPTIONAL DATA EXCEPTION : eof=" + opt.eof + " bytes=" + opt.length);
            } else if (e instanceof InterruptedException) {
                if (this.isDebugEnabled()) {
                    e.printStackTrace();
                }
                value = null;
            } else if (this.isDebugEnabled()) {
                e.printStackTrace();
            }
            this.lastError = e;
            this.notifyRead(3);
        }
        finally {
            Monitor monitor1;
            if (value == null) {
                this.notifyRead(1);
            } else {
                SpritesCacheManager.debug("Swap: reading done.");
                this.notifyRead(2);
            }
            Thread.currentThread().setPriority(pty);
            Monitor monitor = monitor1 = this.readMonitor;
            synchronized (monitor) {
                this.reading = false;
                monitor1.notifyAll();
            }
            return (V)value;
        }
    }

    private boolean unswap(final KeyRegistry<K> key) {
        return AccessController.doPrivileged(new PrivilegedAction<Boolean>(){

            @Override
            public Boolean run() {
                return SpritesCacheManager.this._unswap(key);
            }
        });
    }

    private boolean _unswap(KeyRegistry<K> key) {
        File f = (File)this.cacheDisk.remove(key);
        try {
            if (f instanceof File) {
                if (FileHelper._accessFilePermitted(f, 4)) {
                    f.delete();
                    this.swap_memory_usage -= f.length();
                    swap_global_memory_usage -= f.length();
                } else {
                    f.deleteOnExit();
                }
                return true;
            }
            return false;
        }
        catch (Exception e) {
            if (this.isDebugEnabled()) {
                e.printStackTrace();
            }
            return false;
        }
    }

    public void setCompressionEnabled(boolean b) {
        this.compress = b;
    }

    private Thread getShutdownHooker() {
        return new Thread(new Runnable(){

            @Override
            public void run() {
                SpritesCacheManager.this.clearMemorySwap();
            }
        });
    }

    public void setSwapDiskEnabled(final boolean b) {
        AccessController.doPrivileged(new PrivilegedAction(){

            public Object run() {
                if (b) {
                    if (!SpritesCacheManager.this.swap) {
                        Runtime.getRuntime().addShutdownHook(SpritesCacheManager.this.getShutdownHooker());
                    }
                } else {
                    Runtime.getRuntime().removeShutdownHook(SpritesCacheManager.this.getShutdownHooker());
                }
                SpritesCacheManager.this.swap = b;
                return null;
            }
        });
    }

    public boolean isSwapDiskEnabled() {
        return this.swap;
    }

    @Override
    public int size() {
        try {
            this.cleanup();
        }
        catch (Exception e) {
            if (this.isDebugEnabled()) {
                e.printStackTrace();
            }
        }
        finally {
            return this.cache.size();
        }
    }

    public double allocSize() {
        double d = 100 * this.cache.size() / this.listCapacity;
        SpritesCacheManager.debug("alloc=" + d);
        return d;
    }

    public V add(K key, V obj) {
        return this.add(key, obj, this.swap);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void updateSubMaps(boolean removal, K key, V value) {
        List<WeakReference<Map<K, V>>> list = this.subMaps;
        synchronized (list) {
            for (WeakReference<Map<K, V>> ref : this.subMaps) {
                Map subMap = (Map)ref.get();
                if (!(subMap instanceof Map) || key == null || value == null) continue;
                if (removal) {
                    subMap.remove(key);
                    continue;
                }
                subMap.put(key, value);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void updateSubListsK(boolean removal, K key) {
        List<WeakReference<Set<K>>> list = this.keysSubLists;
        synchronized (list) {
            for (WeakReference<Set<K>> listRef : this.keysSubLists) {
                Set subList = (Set)listRef.get();
                if (!(subList instanceof Set) || key == null) continue;
                if (removal) {
                    subList.remove(key);
                    continue;
                }
                subList.add(key);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void updateSubListsV(boolean removal, V value) {
        List<WeakReference<Set<V>>> list = this.valuesSubLists;
        synchronized (list) {
            for (WeakReference<Set<V>> listRef : this.valuesSubLists) {
                Set subList = (Set)listRef.get();
                if (!(subList instanceof Set) || value == null) continue;
                if (removal) {
                    subList.remove(value);
                    continue;
                }
                subList.add(value);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected V add(K key, V obj, boolean swap) {
        SoftValue<KeyRegistry<K>, V> ancient;
        block5: {
            this.cleanup();
            ancient = null;
            KeyRegistry<K> keyReg = new KeyRegistry<K>(key);
            try {
                Object v;
                if (obj == null) break block5;
                if (swap && this.memorySensitiveCallback("writeSwap", this, new Object[]{keyReg, (Serializable)obj}, new Class[]{KeyRegistry.class, Serializable.class}).equals(Boolean.FALSE)) {
                    throw new Exception("Unable to swap! " + key);
                }
                ancient = this.cache.put(keyReg, new SoftValue<KeyRegistry<K>, V>(obj, keyReg));
                this.buffer(ancient);
                this.updateSubMaps(false, key, obj);
                this.updateSubListsK(false, key);
                this.updateSubListsV(false, obj);
                if (ancient == null || (v = ancient.get()) == null || v.equals(obj)) break block5;
                this.memorySensitiveClear(ancient.get());
            }
            catch (Exception e) {
                block6: {
                    try {
                        SpritesCacheManager.debug("CacheEntry: error while caching " + key + e.getMessage() + "\r\n");
                        if (!this.isDebugEnabled()) break block6;
                        e.printStackTrace();
                    }
                    catch (Throwable throwable) {
                        return ancient instanceof WeakReference ? (V)ancient.get() : null;
                    }
                }
                return ancient instanceof WeakReference ? (V)ancient.get() : null;
            }
        }
        return ancient instanceof WeakReference ? (V)ancient.get() : null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public V remove(Object sp) {
        try {
            Iterator<KeyRegistry<K>> i;
            KeyRegistry<Object> key = new KeyRegistry<Object>(sp);
            SoftValue<KeyRegistry<K>, V> ref = this.cache.remove(key);
            this.updateSubMaps(true, key.getKey(), null);
            this.updateSubListsK(true, key.getKey());
            V value = ref instanceof SoftValue ? (ref.get() == null ? null : (V)ref.get()) : null;
            this.updateSubListsV(true, value);
            List<KeyRegistry<K>> list = this.lruK;
            synchronized (list) {
                i = this.lruK.iterator();
                this.buffer(i);
                while (i.hasNext()) {
                    if (!i.next().equals(key)) continue;
                    i.remove();
                }
            }
            list = this.mruK;
            synchronized (list) {
                i = this.mruK.iterator();
                this.buffer(i);
                while (i.hasNext()) {
                    if (!i.next().equals(key)) continue;
                    i.remove();
                }
            }
            this.lru.remove(key);
            this.mru.remove(key);
            if (this.swap) {
                this.unswap(key);
            }
            return value;
        }
        catch (ClassCastException e) {
            try {
                return (V)this.memorySensitiveClear(sp);
            }
            catch (Throwable t) {
                if (this.isDebugEnabled()) {
                    t.printStackTrace();
                }
                return null;
            }
        }
    }

    @Override
    public V get(Object k) {
        V value;
        block8: {
            KeyRegistry<Object> key;
            block7: {
                this.cleanup();
                key = new KeyRegistry<Object>(k);
                value = null;
                if (this.cache.containsKey(key)) {
                    value = (V)this.cache.get(key).get();
                }
                if (value == null && this.swap && this.cacheDisk.containsKey(key)) {
                    SpritesCacheManager.debug("Get key " + key + " from swap...");
                    try {
                        value = (V)this.memorySensitiveCallback("readSwap", this, new Object[]{key}, new Class[]{KeyRegistry.class});
                        this.add(key.getKey(), value, false);
                    }
                    catch (Throwable ex) {
                        if (!this.isDebugEnabled()) break block7;
                        ex.printStackTrace();
                    }
                }
            }
            if (value != null) {
                try {
                    this.memorySensitiveUpdate(key, value);
                }
                catch (Throwable t) {
                    if (!this.isDebugEnabled()) break block8;
                    t.printStackTrace();
                }
            }
        }
        return value;
    }

    private boolean has(KeyRegistry<K> key) {
        this.cleanup();
        return this.cache.containsKey(key) ? true : (this.swap ? this.cacheDisk.containsKey(key) : false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void clearMemorySwap() {
        if (this.swap) {
            Set<Map.Entry<KeyRegistry<K>, File>> set = this.cacheDisk.entrySet();
            SortedMap<KeyRegistry<K>, File> sortedMap = this.cacheDisk;
            synchronized (sortedMap) {
                Iterator<Map.Entry<KeyRegistry<K>, File>> i = set.iterator();
                while (i.hasNext()) {
                    Map.Entry<KeyRegistry<K>, File> entry = i.next();
                    File f = entry.getValue();
                    if (fileCache.contains(f.getPath())) continue;
                    if (FileHelper._accessFilePermitted(f, 4)) {
                        f.delete();
                        this.swap_memory_usage -= f.length();
                        swap_global_memory_usage -= f.length();
                    }
                    i.remove();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void clearSubMaps() {
        List<WeakReference<Map<K, V>>> list = this.subMaps;
        synchronized (list) {
            for (WeakReference<Map<K, V>> mapRef : this.subMaps) {
                Map subMap = (Map)mapRef.get();
                if (!(subMap instanceof Map)) continue;
                subMap.clear();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void clearSubListsK() {
        List<WeakReference<Set<K>>> list = this.keysSubLists;
        synchronized (list) {
            for (WeakReference<Set<K>> listRef : this.keysSubLists) {
                Set subList = (Set)listRef.get();
                if (!(subList instanceof Set)) continue;
                subList.clear();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void clearSubListsV() {
        List<WeakReference<Set<V>>> list = this.valuesSubLists;
        synchronized (list) {
            for (WeakReference<Set<V>> listRef : this.valuesSubLists) {
                Set subList = (Set)listRef.get();
                if (!(subList instanceof Set)) continue;
                subList.clear();
            }
        }
    }

    @Override
    public void clear() {
        this.clearMemory();
        this.cleanup();
        this.cache.clear();
    }

    public static void _cleanup() {
        Reference ref;
        while ((ref = _cacheBack.poll()) != null) {
            Object o = ref.get();
            if (o instanceof Image) {
                ((Image)o).flush();
            }
            if (!(o instanceof Closeable)) continue;
            try {
                ((Closeable)o).close();
            }
            catch (IOException ex) {
                if (!DebugMap._getInstance().isDebuggerEnabled(SpritesCacheManager.class)) continue;
                ex.printStackTrace();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void cleanup() {
        Iterator<Object> it;
        int currentPty = Thread.currentThread().getPriority();
        Thread.currentThread().setPriority(10);
        SpritesCacheManager._cleanup();
        List<WeakReference<Object>> list = this.buffer;
        synchronized (list) {
            it = this.buffer.keySet().iterator();
            while (it.hasNext()) {
                int k = it.next();
                if (this.buffer.get(k).get() != null) continue;
                it.remove();
            }
        }
        list = this.keysSubLists;
        synchronized (list) {
            it = this.keysSubLists.iterator();
            while (it.hasNext()) {
                WeakReference s = (WeakReference)it.next();
                if (s.get() != null) continue;
                it.remove();
            }
        }
        list = this.valuesSubLists;
        synchronized (list) {
            it = this.valuesSubLists.iterator();
            while (it.hasNext()) {
                WeakReference s = (WeakReference)it.next();
                if (s.get() != null) continue;
                it.remove();
            }
        }
        list = this.subMaps;
        synchronized (list) {
            it = this.subMaps.iterator();
            while (it.hasNext()) {
                WeakReference s = (WeakReference)it.next();
                if (s.get() != null) continue;
                it.remove();
            }
        }
        SpritesCacheManager._cleanup();
        Thread.currentThread().setPriority(currentPty);
    }

    public void setAutoCleanupEnabled(boolean b) {
        if (this.timer != null) {
            this.timer.cancel();
            this.timer.purge();
        }
        if (b) {
            this.timer = new Timer("Timer-SpritesCacheManager-Cleanup");
            this.timer.scheduleAtFixedRate(new TimerTask(){

                @Override
                public void run() {
                    Thread.currentThread().setPriority(6);
                    SpritesCacheManager.this.cleanup();
                }
            }, 0L, 250L);
            this.buffer(this.timer);
        } else {
            this.timer = null;
        }
    }

    public void ensureListCapacity(int n) {
        this.listCapacity = Math.max(this.listCapacity, n);
        this.notifyEvent(8);
    }

    public void trimCacheLive(int n) {
        int pty = Thread.currentThread().getPriority();
        Thread.currentThread().setPriority(10);
        this.trunk(this.mru, this.mruK, n);
        this.trunk(this.lru, this.lruK, n);
        this.listCapacity = n;
        this.notifyEvent(8);
        Thread.currentThread().setPriority(pty);
    }

    public static <T> T callback(String method, Object target, Object[] args, Class[] clargs) throws NoSuchMethodException, IllegalAccessException, InvocationTargetException {
        return JXAenvUtils._callback(method, target, args, clargs);
    }

    public static Object doPriority(String method, Object target, Object[] args, Class[] clargs, int level) throws IllegalAccessException, InvocationTargetException, NoSuchMethodException {
        return JXAenvUtils._doPriority(method, target, args, clargs, level);
    }

    public <T> T memorySensitiveCallback(String method, Object target, Object[] args, Class[] clargs) throws Throwable {
        T ret = this.__memorySensitiveCallback(method, target, args, clargs);
        this.ensureListCapacity(this.initialListCapacity);
        return ret;
    }

    private <T> T __memorySensitiveCallback(String method, Object target, Object[] args, Class[] clargs) throws Throwable {
        try {
            T o = SpritesCacheManager.callback(method, target, args, clargs);
            this.cleanup();
            return o;
        }
        catch (NoSuchMethodException ex) {
            ex.printStackTrace();
            return null;
        }
        catch (IllegalArgumentException ex) {
            ex.printStackTrace();
            return null;
        }
        catch (IllegalAccessException ex) {
            ex.printStackTrace();
            return null;
        }
        catch (InvocationTargetException ex) {
            Throwable t = ex.getTargetException();
            this.buffer(t);
            if (t instanceof OutOfMemoryError) {
                if (this.isDebugEnabled()) {
                    System.err.println("!!!!!!! " + this.getClass().getName() + " caught OutOfMemory error, trying to collect garbage (System.gc())...");
                }
                if (this.isDebugEnabled()) {
                    t.printStackTrace();
                }
                if (this.listCapacity <= 1) {
                    this.clearMemory();
                    if (this.isDebugEnabled()) {
                        System.err.println("!!!!!!! " + this.toString() + " cache capacity is dangerously low...");
                    }
                    UIMessage.showLightPopupMessage(new JLabel("<html><b>FATAL ERROR :</b> <br>Memory seems to be overlflown, task is interrupted now.</html>"), new AbstractAction("Exit"){

                        @Override
                        public void actionPerformed(ActionEvent e) {
                            Runtime.getRuntime().halt(666);
                        }
                    }, null, 0);
                    Thread.currentThread().interrupt();
                    System.gc();
                    System.runFinalization();
                    System.gc();
                    throw t;
                }
                this.trimCacheLive((int)Math.ceil((float)this.listCapacity / 2.0f));
                System.gc();
                if (this.isDebugEnabled()) {
                    System.err.println("!!!!!!! Garbage has been collected by the System. cleanup.");
                }
                this.cleanup();
                System.runFinalization();
                System.gc();
                return this.__memorySensitiveCallback(method, target, args, clargs);
            }
            throw t;
        }
    }

    protected void finalize() throws Throwable {
        if (this.timer != null) {
            this.timer.cancel();
            this.timer = null;
        }
        this.clear();
        this.clearSubMaps();
        this.clearSubListsK();
        this.clearSubListsV();
        this.clearMemorySwap();
        super.finalize();
    }

    public static void _cleanFileSwap() {
        File dir = null;
        swap_global_memory_usage = 0L;
        dir = new File(FileHelper._TMPDIRECTORY + File.separator + _cacheDisk_dir);
        File[] swapFiles = null;
        if (dir.isDirectory()) {
            swapFiles = dir.listFiles(new FilenameFilter(){

                @Override
                public boolean accept(File dir, String name) {
                    return name.startsWith(_cacheDisk_prefix);
                }
            });
        }
        for (File f : swapFiles) {
            try {
                if (!FileHelper._accessFilePermitted(f, 4)) continue;
                f.delete();
                swap_global_memory_usage -= f.length();
            }
            catch (Exception e) {
                if (!DebugMap._getInstance().isDebuggerEnabled(SpritesCacheManager.class)) continue;
                e.printStackTrace();
            }
        }
    }

    public void buffer(Object obj) {
        int pty = Thread.currentThread().getPriority();
        Thread.currentThread().setPriority(10);
        this.cleanup();
        if (obj != null) {
            this.buffer.put(obj.hashCode(), new SoftValue<Integer, Object>(obj, obj.hashCode()));
        }
        Thread.currentThread().setPriority(pty);
    }

    @Override
    public boolean isEmpty() {
        return this.swap ? this.cacheDisk.isEmpty() : this.cache.isEmpty();
    }

    @Override
    public boolean containsKey(Object key) {
        if (key == null) {
            return false;
        }
        return this.has(new KeyRegistry<Object>(key));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean containsValue(Object object) {
        Set<K> coll;
        Set<K> set = coll = this.keySet();
        synchronized (set) {
            Iterator<K> i = coll.iterator();
            while (i.hasNext()) {
                V ref = this.get(i.next());
                if (ref == null || !ref.equals(object)) continue;
                return true;
            }
        }
        return false;
    }

    @Override
    public V put(K key, V value) {
        return this.add(key, value);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void putAll(Map<? extends K, ? extends V> map) {
        Map<K, V> smap = Collections.synchronizedMap(map);
        Set<K> set = smap.keySet();
        Map<K, V> map2 = smap;
        synchronized (map2) {
            for (K k : set) {
                this.put(k, smap.get(k));
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Set<K> keySet() {
        TreeSet<K> sortedKeys = new TreeSet<K>(this.comparator);
        Set<KeyRegistry<K>> set = this.swap ? this.cacheDisk.keySet() : this.cache.keySet();
        Map<KeyRegistry<K>, Object> map = this.swap ? this.cacheDisk : this.cache;
        synchronized (map) {
            for (KeyRegistry<K> k : set) {
                if (k == null) continue;
                sortedKeys.add(k.getKey());
            }
        }
        this.keysSubLists.add(new WeakReference<TreeSet<? super K>>(sortedKeys, _cacheBack));
        return sortedKeys;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Collection<V> values() {
        Set<K> set;
        HashSet<V> cached = new HashSet<V>();
        Set<K> set2 = set = this.keySet();
        synchronized (set2) {
            for (K k : set) {
                if (k == null) continue;
                cached.add(this.get(k));
            }
        }
        this.valuesSubLists.add(new WeakReference(cached, _cacheBack));
        return cached;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Set<Map.Entry<K, V>> entrySet() {
        Set<K> set;
        TreeMap<K, V> m = new TreeMap<K, V>(this.comparator);
        Set<K> set2 = set = this.keySet();
        synchronized (set2) {
            for (K k : set) {
                if (k == null) continue;
                m.put(k, this.get(k));
            }
        }
        this.subMaps.add(new WeakReference(m, _cacheBack));
        return m.entrySet();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void endWrite(ObjectOutput out) throws IOException {
        Set<Map.Entry<KeyRegistry<K>, File>> set = this.cacheDisk.entrySet();
        SortedMap<KeyRegistry<K>, File> sortedMap = this.cacheDisk;
        synchronized (sortedMap) {
            for (Map.Entry<KeyRegistry<K>, File> entry : set) {
                this.buffer(entry);
                File f = entry.getValue();
                RandomAccessFile raf = new RandomAccessFile(f, "r");
                FileInputStream fis = new FileInputStream(raf.getFD());
                BufferedInputStream bis = new BufferedInputStream(fis, FileHelper._SMALLBUFFFER_SIZE);
                this.buffer(bis);
                this.buffer(raf);
                out.writeObject(entry.getKey());
                out.writeLong(f.length());
                SpritesCacheManager.debug(f.length());
                try {
                    byte[] b = new byte[FileHelper._SMALLBUFFFER_SIZE];
                    int readBytes = 0;
                    int writtenBytes = 0;
                    while ((readBytes = bis.read(b)) != -1) {
                        out.write(b, 0, readBytes);
                        writtenBytes += readBytes;
                    }
                    SpritesCacheManager.debug(writtenBytes);
                    bis.close();
                    raf.close();
                }
                catch (Exception e) {
                    if (!this.isDebugEnabled()) continue;
                    e.printStackTrace();
                }
                finally {
                    this.cleanup();
                }
            }
        }
    }

    private void endRead(ObjectInput in) throws IOException, ClassNotFoundException {
        this.cache = Collections.synchronizedMap(new WeakHashMap(this.listCapacity));
        this.buffer(this.cache);
        File file = null;
        File tmpDir = new File(FileHelper._TMPDIRECTORY.getPath() + File.separator + this.cacheDisk_dir);
        tmpDir.mkdirs();
        int size = this.cacheDisk.size();
        for (int i = 0; i < size; ++i) {
            boolean skipped = false;
            RandomAccessFile raf = null;
            Object oos = null;
            FileOutputStream fos = null;
            KeyRegistry key = (KeyRegistry)in.readObject();
            file = (File)this.cacheDisk.get(key);
            fileCache.add(file.getPath());
            long len = in.readLong();
            if (!file.exists() && (file = new File(tmpDir.getPath() + File.separator + file.getName())).isFile()) {
                skipped = true;
            }
            skipped = file.length() == len;
            file.deleteOnExit();
            SpritesCacheManager.debug("read " + file);
            if (skipped) {
                in.skipBytes((int)len);
            } else {
                raf = new RandomAccessFile(file, "rw");
                raf.setLength(len);
                fos = new FileOutputStream(raf.getFD());
                BufferedOutputStream bos = new BufferedOutputStream(fos, FileHelper._SMALLBUFFFER_SIZE);
                this.buffer(bos);
                this.buffer(raf);
                byte[] b = new byte[FileHelper._SMALLBUFFFER_SIZE];
                int readBytes = 0;
                boolean fread = true;
                do {
                    int rBytes;
                    if ((long)(readBytes + b.length) > len) {
                        rBytes = (int)len - readBytes;
                        in.readFully(b, 0, rBytes);
                    } else {
                        rBytes = in.read(b);
                    }
                    SpritesCacheManager.debug(".", false);
                    if (rBytes != -1) {
                        bos.write(b, 0, rBytes);
                        readBytes += rBytes;
                    } else {
                        fread = false;
                    }
                    if ((long)readBytes < len) continue;
                    fread = false;
                } while (fread);
                SpritesCacheManager.debug("bytes read: " + readBytes + " file length was: " + len);
                bos.close();
                raf.close();
                this.cleanup();
            }
            this.cacheDisk.put(key, file);
        }
        SpritesCacheManager.debug("SpritesCacheManager read from DataStream!");
    }

    public void addSpritesCacheListener(SpritesCacheListener l) {
        this.listeners.add(l);
    }

    public void removeSpritesCacheListener(SpritesCacheListener l) {
        this.listeners.remove(l);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void notifyWrite(int event) {
        switch (event) {
            case 4: {
                Set<SpritesCacheListener> set = this.listeners;
                synchronized (set) {
                    for (SpritesCacheListener l : this.listeners) {
                        if (l == null) continue;
                        l.writeStarted();
                    }
                    break;
                }
            }
            case 5: {
                Set<SpritesCacheListener> set = this.listeners;
                synchronized (set) {
                    for (SpritesCacheListener l : this.listeners) {
                        if (l == null) continue;
                        l.writeAborted();
                    }
                    break;
                }
            }
            case 6: {
                Set<SpritesCacheListener> set = this.listeners;
                synchronized (set) {
                    for (SpritesCacheListener l : this.listeners) {
                        if (l == null) continue;
                        l.writeCompleted();
                    }
                    break;
                }
            }
            case 7: {
                Set<SpritesCacheListener> set = this.listeners;
                synchronized (set) {
                    for (SpritesCacheListener l : this.listeners) {
                        if (l == null) continue;
                        l.writeError(this.lastError);
                    }
                    break;
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void notifyRead(int event) {
        switch (event) {
            case 0: {
                Set<SpritesCacheListener> set = this.listeners;
                synchronized (set) {
                    for (SpritesCacheListener l : this.listeners) {
                        if (l == null) continue;
                        l.readStarted();
                    }
                    break;
                }
            }
            case 1: {
                Set<SpritesCacheListener> set = this.listeners;
                synchronized (set) {
                    for (SpritesCacheListener l : this.listeners) {
                        if (l == null) continue;
                        l.readAborted();
                    }
                    break;
                }
            }
            case 2: {
                Set<SpritesCacheListener> set = this.listeners;
                synchronized (set) {
                    for (SpritesCacheListener l : this.listeners) {
                        if (l == null) continue;
                        l.readCompleted();
                    }
                    break;
                }
            }
            case 3: {
                Set<SpritesCacheListener> set = this.listeners;
                synchronized (set) {
                    for (SpritesCacheListener l : this.listeners) {
                        if (l == null) continue;
                        l.readError(this.lastError);
                    }
                    break;
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void notifyEvent(int event) {
        switch (event) {
            case 0: 
            case 1: 
            case 2: 
            case 3: {
                this.notifyRead(event);
                break;
            }
            case 4: 
            case 5: 
            case 6: 
            case 7: {
                this.notifyWrite(event);
                break;
            }
            case 8: {
                Set<SpritesCacheListener> set = this.listeners;
                synchronized (set) {
                    for (SpritesCacheListener l : this.listeners) {
                        if (!(l instanceof SpritesCacheListener)) continue;
                        l.capacityExtended(this.listCapacity);
                    }
                    break;
                }
            }
        }
    }

    public static File makeKeyFile(Serializable key, File f, String fileDir, String keyFilename, boolean compress) {
        try {
            int readBytes;
            RandomAccessFile raf = new RandomAccessFile(f, "r");
            FileInputStream fis = new FileInputStream(raf.getFD());
            BufferedInputStream bis = new BufferedInputStream(fis, FileHelper._SMALLBUFFFER_SIZE);
            byte[] b = new byte[FileHelper._SMALLBUFFFER_SIZE];
            SpritesCacheManager<Integer, byte[]> fileContents = new SpritesCacheManager<Integer, byte[]>((int)f.length());
            fileContents.setSwapDiskEnabled(true);
            int i = 0;
            while ((readBytes = bis.read(b)) != -1) {
                byte[] rb = new byte[readBytes];
                for (int j = 0; j < rb.length; ++j) {
                    rb[j] = b[j];
                }
                fileContents.put(i++, rb);
            }
            bis.close();
            raf.close();
            return SpritesCacheManager.makeKeyFile(new Serializable[]{key}, new SpritesCacheManager[]{fileContents}, fileDir, keyFilename, compress);
        }
        catch (FileNotFoundException ex) {
            if (DebugMap._getInstance().isDebuggerEnabled(SpritesCacheManager.class)) {
                ex.printStackTrace();
            }
            return null;
        }
        catch (IOException ex) {
            if (DebugMap._getInstance().isDebuggerEnabled(SpritesCacheManager.class)) {
                ex.printStackTrace();
            }
            return null;
        }
    }

    public static File makeKeyFile(Serializable[] key, Serializable[] serialData, String fileDir, String keyFilename, boolean compress) throws IndexOutOfBoundsException {
        if (key.length != serialData.length) {
            throw new IndexOutOfBoundsException("Keys and serial datas must be of the same length. there are " + key.length + " keys and " + serialData.length + " serial datas");
        }
        SpritesCacheManager<Serializable, Serializable> spm = new SpritesCacheManager<Serializable, Serializable>();
        spm.setSwapDiskEnabled(true);
        spm.setCompressionEnabled(compress);
        for (int i = 0; i < key.length; ++i) {
            spm.put(key[i], serialData[i]);
        }
        new File(fileDir).mkdirs();
        spm.cacheDisk_dir = fileDir;
        try {
            File keyFile = new File(fileDir + File.separator + keyFilename);
            File temp = FileHelper._createTempFile("spKey_", FileHelper._TMPDIRECTORY, true);
            RandomAccessFile raf = new RandomAccessFile(temp, "rw");
            FileOutputStream fos = new FileOutputStream(raf.getFD());
            BufferedOutputStream bos = new BufferedOutputStream(fos, FileHelper._SMALLBUFFFER_SIZE);
            ObjectOutputStream out = new ObjectOutputStream(bos);
            out.writeObject(spm);
            out.flush();
            out.close();
            bos.close();
            raf.close();
            raf = new RandomAccessFile(temp, "r");
            RandomAccessFile rafCopy = new RandomAccessFile(keyFile, "rw");
            rafCopy.setLength(temp.length());
            byte[] b = new byte[FileHelper._SMALLBUFFFER_SIZE];
            int readBytes = 0;
            while ((readBytes = raf.read(b)) != -1) {
                rafCopy.write(b, 0, readBytes);
            }
            rafCopy.close();
            raf.close();
            temp.delete();
            return keyFile;
        }
        catch (FileNotFoundException ex) {
            if (DebugMap._getInstance().isDebuggerEnabled(SpritesCacheManager.class)) {
                ex.printStackTrace();
            }
            return null;
        }
        catch (IOException ex) {
            if (DebugMap._getInstance().isDebuggerEnabled(SpritesCacheManager.class)) {
                ex.printStackTrace();
            }
            return null;
        }
    }

    public static File extractKeyFile(File f, Serializable key, String extractFilename) {
        try {
            SpritesCacheManager serial = (SpritesCacheManager)SpritesCacheManager.extractKeyData(f, key);
            if (serial == null) {
                return null;
            }
            File xF = new File(extractFilename);
            File temp = FileHelper._createTempFile("keyFile_", FileHelper._TMPDIRECTORY, true);
            RandomAccessFile raf = new RandomAccessFile(temp, "rw");
            FileOutputStream fos = new FileOutputStream(raf.getFD());
            BufferedOutputStream bos = new BufferedOutputStream(fos, FileHelper._SMALLBUFFFER_SIZE);
            for (int i = 0; i < serial.getSwapMap().size(); ++i) {
                bos.write((byte[])serial.readSwap(new KeyRegistry<Integer>(i)));
            }
            bos.close();
            raf.close();
            raf = new RandomAccessFile(temp, "r");
            RandomAccessFile rafCopy = new RandomAccessFile(xF, "rw");
            rafCopy.setLength(temp.length());
            byte[] b = new byte[FileHelper._SMALLBUFFFER_SIZE];
            int readBytes = 0;
            while ((readBytes = raf.read(b)) != -1) {
                rafCopy.write(b, 0, readBytes);
            }
            rafCopy.close();
            raf.close();
            temp.delete();
            return xF;
        }
        catch (FileNotFoundException ex) {
            if (DebugMap._getInstance().isDebuggerEnabled(SpritesCacheManager.class)) {
                ex.printStackTrace();
            }
            return null;
        }
        catch (IOException ex) {
            if (DebugMap._getInstance().isDebuggerEnabled(SpritesCacheManager.class)) {
                ex.printStackTrace();
            }
            return null;
        }
    }

    public static Serializable extractKeyData(File f, Serializable key) {
        try {
            ObjectInputStream in;
            BufferedInputStream bin;
            RandomAccessFile raf = new RandomAccessFile(f, "r");
            if (!SpritesCacheManager.isExtClassLoadIO()) {
                FileInputStream fin = new FileInputStream(raf.getFD());
                bin = new BufferedInputStream(fin, FileHelper._SMALLBUFFFER_SIZE);
                in = new ObjectInputStream(bin);
            } else {
                ExtensionsClassLoader extensionsClassLoader = ExtensionsClassLoader.getInstance();
                extensionsClassLoader.getClass();
                FileInputStream fin = new FileInputStream(raf.getFD());
                bin = new BufferedInputStream(fin, FileHelper._SMALLBUFFFER_SIZE);
                in = extensionsClassLoader.new ExtensionsClassLoader.ObjectInputStream(bin);
            }
            SpritesCacheManager spm = (SpritesCacheManager)in.readObject();
            in.close();
            bin.close();
            raf.close();
            Serializable serialData = null;
            serialData = (Serializable)spm.readSwap(new KeyRegistry<Serializable>(key));
            return serialData;
        }
        catch (FileNotFoundException ex) {
            if (DebugMap._getInstance().isDebuggerEnabled(SpritesCacheManager.class)) {
                ex.printStackTrace();
            }
            return null;
        }
        catch (IOException ex) {
            if (DebugMap._getInstance().isDebuggerEnabled(SpritesCacheManager.class)) {
                ex.printStackTrace();
            }
            return null;
        }
        catch (ClassNotFoundException ex) {
            if (DebugMap._getInstance().isDebuggerEnabled(SpritesCacheManager.class)) {
                ex.printStackTrace();
            }
            return null;
        }
    }

    public void setComparator(Comparator<? super K> c) {
        this.comparator = c;
    }

    public Comparator<? super K> getComparator() {
        return this.comparator();
    }

    @Override
    public Comparator<? super K> comparator() {
        return this.comparator;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public SortedMap<K, V> subMap(K fromKey, K toKey) {
        Set<Map.Entry<K, V>> entries = this.entrySet();
        TreeMap<K, V> sortedMap = new TreeMap<K, V>(this.comparator);
        Set<Map.Entry<K, V>> set = entries;
        synchronized (set) {
            for (Map.Entry<K, V> entry : entries) {
                sortedMap.put(entry.getKey(), entry.getValue());
            }
        }
        this.subMaps.add(new WeakReference(sortedMap, _cacheBack));
        return sortedMap.subMap(fromKey, toKey);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public SortedMap<K, V> headMap(K headKey) {
        Set<Map.Entry<K, V>> entries = this.entrySet();
        TreeMap<K, V> sortedMap = new TreeMap<K, V>(this.comparator);
        Set<Map.Entry<K, V>> set = entries;
        synchronized (set) {
            for (Map.Entry<K, V> entry : entries) {
                sortedMap.put(entry.getKey(), entry.getValue());
            }
        }
        this.subMaps.add(new WeakReference(sortedMap, _cacheBack));
        return sortedMap.headMap(headKey);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public SortedMap<K, V> tailMap(K tailKey) {
        Set<Map.Entry<K, V>> entries = this.entrySet();
        TreeMap<K, V> sortedMap = new TreeMap<K, V>(this.comparator);
        Set<Map.Entry<K, V>> set = entries;
        synchronized (set) {
            for (Map.Entry<K, V> entry : entries) {
                sortedMap.put(entry.getKey(), entry.getValue());
            }
        }
        this.subMaps.add(new WeakReference(sortedMap, _cacheBack));
        return sortedMap.tailMap(tailKey);
    }

    @Override
    public K firstKey() {
        TreeSet keys = (TreeSet)this.keySet();
        return keys.isEmpty() ? null : (K)keys.first();
    }

    public void setListCapacity(int listCapacity) {
        this.listCapacity = listCapacity;
        this.notifyEvent(8);
    }

    public int getListCapacity() {
        return this.listCapacity;
    }

    @Override
    public K lastKey() {
        TreeSet keys = (TreeSet)this.keySet();
        return keys.isEmpty() ? null : (K)keys.last();
    }

    @Override
    public void writeExternal(ObjectOutput out) throws IOException {
        int pty = Thread.currentThread().getPriority();
        Thread.currentThread().setPriority(10);
        out.writeObject(this.cacheDisk);
        out.writeUTF(this.cacheDisk_dir);
        out.writeUTF(this.cacheDisk_ext);
        out.writeUTF(this.cacheDisk_prefix);
        out.writeBoolean(this.compress);
        out.writeLong(this.hash);
        out.writeInt(this.initialListCapacity);
        if (this.lastError != null) {
            out.writeBoolean(true);
            out.writeObject(this.lastError);
        } else {
            out.writeBoolean(false);
        }
        out.writeInt(this.listCapacity);
        out.writeBoolean(this.swap);
        out.writeLong(this.swap_memory_usage);
        this.endWrite(out);
        out.flush();
        Thread.currentThread().setPriority(pty);
    }

    @Override
    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        int pty = Thread.currentThread().getPriority();
        Thread.currentThread().setPriority(10);
        this.cacheDisk = (SortedMap)in.readObject();
        this.cacheDisk_dir = in.readUTF();
        this.cacheDisk_ext = in.readUTF();
        this.cacheDisk_prefix = in.readUTF();
        this.compress = in.readBoolean();
        this.hash = in.readLong();
        this.initialListCapacity = in.readInt();
        if (in.readBoolean()) {
            this.lastError = (Exception)in.readObject();
        }
        this.listCapacity = in.readInt();
        this.swap = in.readBoolean();
        this.swap_memory_usage = in.readLong();
        this.endRead(in);
        Thread.currentThread().setPriority(pty);
    }

    @Override
    public boolean isMultiThreadingEnabled() {
        return JXAenvUtils._multiThreading;
    }

    @Override
    public void setMultiThreadingEnabled(boolean b) {
        JXAenvUtils._multiThreading = b;
    }

    static {
        DebugMap._getInstance().setDebuggerEnabled("jxa.debugSPM", SpritesCacheManager.class, dbLevel);
        _cacheBack = new ReferenceQueue();
        _cacheDisk_dir = "cache";
        _cacheDisk_prefix = "_cache";
        swap_global_memory_usage = 0L;
        fileCache = Collections.synchronizedList(new ArrayList());
    }

    static class KeyRegistry<K>
    implements Comparable,
    Externalizable {
        private K key;

        public KeyRegistry() {
            this.key = null;
        }

        public KeyRegistry(K key) throws NullPointerException {
            this.key = key;
            if (key == null) {
                throw new NullPointerException(this.getClass().getName() + " only non-null keys are accepted");
            }
        }

        public K getKey() {
            return this.key;
        }

        public int hashCode() {
            return this.key.hashCode();
        }

        public boolean equals(Object o) {
            return o == null ? false : this.hashCode() == o.hashCode();
        }

        public int compareTo(Object o) {
            return this.equals(o) ? 0 : (o instanceof KeyRegistry && this.key instanceof Comparable ? ((Comparable)this.key).compareTo(((KeyRegistry)o).getKey()) : (o == null ? 1 : Integer.valueOf(this.hashCode()).compareTo(o.hashCode())));
        }

        public String toString() {
            return this.key.toString();
        }

        @Override
        public void writeExternal(ObjectOutput out) throws IOException {
            out.writeObject(this.key);
        }

        @Override
        public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
            this.key = in.readObject();
        }
    }

    class SoftValue<L, V>
    extends WeakReference<V> {
        final L key;
        final boolean enqueueClear;

        SoftValue(V k, L key, boolean enqueueClear) {
            super(k, _cacheBack);
            this.key = key;
            this.enqueueClear = enqueueClear;
        }

        public SoftValue(V k, L key) {
            this(k, key, true);
        }

        @Override
        public void clear() {
            Object o;
            if (this.enqueueClear && (o = this.get()) != null) {
                SoftValue sClear = new SoftValue(o, this.key, false);
                sClear.enqueue();
            }
            super.clear();
        }
    }
}

