/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jiga.xtended.kernel;

import net.sf.jiga.xtended.kernel.ThreadBlock;

public class ThreadBlockData<D>
extends ThreadBlock {
    private ThreadLocal<D> current;
    private ThreadLocal<D> temp;

    public ThreadBlockData(final D data) {
        this.current = new ThreadLocal<D>(){

            @Override
            protected D initialValue() {
                return data == null ? super.initialValue() : data;
            }
        };
        this.temp = new ThreadLocal();
    }

    public ThreadBlockData() {
        this(null);
    }

    public D get() {
        return this.current.get();
    }

    public void set(D tdata) {
        this.current.set(tdata);
    }

    public void remove() {
        this.current.remove();
    }

    public void begin(D data) {
        super.begin();
        this.temp.set(this.get());
        this.set(data);
    }

    @Override
    public void end() {
        super.end();
        if (this.temp.get() != null) {
            this.set(this.temp.get());
            this.temp.remove();
        } else {
            this.remove();
        }
    }
}

