/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jiga.xtended.kernel;

import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.ArrayList;
import net.sf.jiga.xtended.kernel.BitStack;
import net.sf.jiga.xtended.kernel.JXAenvUtils;

public enum env {
    _OS{

        @Override
        public String propertyName() {
            return "os.name";
        }
    }
    ,
    OS_WINDOWS(_OS, 1){

        @Override
        public String propertyValue() {
            return "Windows";
        }
    }
    ,
    OS_WINDOWS_XP(_OS, 1){

        @Override
        public String propertyValue() {
            return "Windows XP";
        }
    }
    ,
    OS_WINDOWS_VISTA(_OS, 1){

        @Override
        public String propertyValue() {
            return "Windows Vista";
        }
    }
    ,
    OS_WINDOWS_7(_OS, 1){

        @Override
        public String propertyValue() {
            return "Windows 7";
        }
    }
    ,
    OS_WINDOWS_8(_OS, 1){

        @Override
        public String propertyValue() {
            return "Windows 8";
        }
    }
    ,
    OS_WINDOWS_10(_OS, 1){

        @Override
        public String propertyValue() {
            return "Windows 10";
        }
    }
    ,
    OS_MAC(_OS, 1){

        @Override
        public String propertyValue() {
            return "Mac OS";
        }
    }
    ,
    OS_LINUX(_OS, 1){

        @Override
        public String propertyValue() {
            return "Linux";
        }
    }
    ,
    OS_OTHER(_OS, new isOS(_OS){

        @Override
        public boolean checkProperty() {
            return !OS_LINUX.isEnv() && !OS_MAC.isEnv() && !OS_WINDOWS.isEnv();
        }
    }){

        @Override
        public String propertyValue() {
            return "unknown";
        }
    }
    ,
    _JAVA,
    _JAVA_VERSION{

        @Override
        public String propertyName() {
            return "java.version";
        }
    }
    ,
    JAVA_VERSION_5(_JAVA_VERSION, 1){

        @Override
        public String propertyValue() {
            return "1.5";
        }
    }
    ,
    JAVA_VERSION_6(_JAVA_VERSION, 1){

        @Override
        public String propertyValue() {
            return "1.6";
        }
    }
    ,
    JAVA_VERSION_7(_JAVA_VERSION, 1){

        @Override
        public String propertyValue() {
            return "1.7";
        }
    }
    ,
    JAVA_VERSION_8(_JAVA_VERSION, 1){

        @Override
        public String propertyValue() {
            return "1.8";
        }
    }
    ,
    JAVA_2D_OPENGL(_JAVA, 0){

        @Override
        public String propertyName() {
            return "sun.java2d.opengl";
        }

        @Override
        public String propertyValue() {
            return "true";
        }
    }
    ,
    JAVA_2D_D3D(_JAVA, 0){

        @Override
        public String propertyName() {
            return "sun.java2d.d3d";
        }

        @Override
        public String propertyValue() {
            return "true";
        }
    }
    ,
    _THREADING,
    THREADING_MULTI(_THREADING, new isEnv(_THREADING){

        @Override
        public boolean checkProperty() {
            return Runtime.getRuntime().availableProcessors() > 1 && !JXAenvUtils._getSysBoolean("jxa.nomt");
        }
    }),
    _ARCH{

        @Override
        public String propertyName() {
            return "os.arch";
        }
    }
    ,
    ARCH_X86(_ARCH, 0){

        @Override
        public String propertyValue() {
            return "x86";
        }
    }
    ,
    ARCH_AMD64(_ARCH, 0){

        @Override
        public String propertyValue() {
            return "amd64";
        }
    }
    ,
    ARCH_PPC(_ARCH, 0){

        @Override
        public String propertyValue() {
            return "ppc";
        }
    }
    ,
    ARCH_I386(_ARCH, 0){

        @Override
        public String propertyValue() {
            return "i386";
        }
    }
    ,
    ARCH_PPC64(_ARCH, 0){

        @Override
        public String propertyValue() {
            return "ppc64";
        }
    }
    ,
    _APP{

        @Override
        public String propertyName() {
            return "jxa.app.type";
        }
    }
    ,
    APP_APPLET(_APP, 0){

        @Override
        public String propertyValue() {
            return "antapplet";
        }
    }
    ,
    APP_FRAME(_APP, 0){

        @Override
        public String propertyValue() {
            return "antframe";
        }
    }
    ,
    APP_REMOTE(_APP, 0){

        @Override
        public String propertyName() {
            return "jxa.app.remote";
        }

        @Override
        public String propertyValue() {
            return "true";
        }
    };

    int mask;
    isEnv check;
    env parentEnv = null;

    private env(env parentEnv, int check) {
        this.parentEnv = parentEnv;
        this.mask = isEnv._ENV_BITS._newBit(parentEnv.mask);
        switch (check) {
            case 1: {
                this.check = new isOS(this);
                break;
            }
            default: {
                this.check = new isEnv(this){

                    @Override
                    protected boolean checkProperty() {
                        String s = JXAenvUtils._getSysValue(this.e.propertyName());
                        return s == null ? false : s.equalsIgnoreCase(this.e.propertyValue());
                    }
                };
            }
        }
    }

    private env(env parentRangeOption, isEnv check) {
        this.check = check;
        this.parentEnv = parentRangeOption;
        this.mask = isEnv._ENV_BITS._newBit(parentRangeOption.mask);
    }

    private env() {
        this.parentEnv = null;
        this.check = new isEnv(this){

            @Override
            public boolean checkProperty() {
                return true;
            }
        };
        this.mask = isEnv._ENV_BITS._newBitRange();
    }

    public boolean isEnv() {
        return this.check.check();
    }

    public int bitMask() {
        return this.mask;
    }

    public int compareMask() {
        return isEnv._ENV_BITS._getAllBits() & this.mask;
    }

    public String osname() {
        return this.check instanceof isOS ? this.propertyValue() : JXAenvUtils._getSysValue("os.name");
    }

    public String propertyName() {
        return this.parentEnv != null ? this.parentEnv.propertyName() : this.toString();
    }

    public String propertyValue() {
        return JXAenvUtils._getSysValue(this.propertyName());
    }

    public static boolean _isEnv(env[] envMask) {
        for (env e : envMask) {
            if (e.isEnv()) continue;
            return false;
        }
        return true;
    }

    public static boolean _isEnv(int envBitsMask) {
        return env._isEnv(envBitsMask, envBitsMask);
    }

    public static boolean _hasEnv(int envBitsMask) {
        return !env._isEnv(envBitsMask, 0);
    }

    public static boolean _isEnv(int envBitsMask, int ref) {
        return (envBitsMask & env._getEnvBits() & isEnv._ENV_BITS._getAllBits()) == (ref & isEnv._ENV_BITS._getAllBits());
    }

    public static int _getEnvBits() {
        int bits = 0;
        for (env e : env.values()) {
            if (!e.isEnv()) continue;
            bits |= e.bitMask();
        }
        return bits;
    }

    public static env[] _getEnv() {
        ArrayList<env> bits = new ArrayList<env>();
        for (env e : env.values()) {
            if (!e.isEnv()) continue;
            bits.add(e);
        }
        return bits.toArray(new env[0]);
    }

    public static env[] _getEnv(env property) {
        ArrayList<env> bits = new ArrayList<env>();
        for (env e : env.values()) {
            if (!e.isEnv() || 0 == (isEnv._ENV_BITS._getMask(property.bitMask()) & e.bitMask())) continue;
            bits.add(e);
        }
        return bits.toArray(new env[0]);
    }

    private static class isOS
    extends isEnv {
        public isOS(env e) {
            super(e);
        }

        @Override
        public boolean checkProperty() {
            String s = JXAenvUtils._getSysValue(this.e.propertyName());
            return s == null ? false : s.startsWith(this.e.propertyValue());
        }
    }

    private static abstract class isEnv {
        private static BitStack _ENV_BITS = new BitStack();
        env e;

        public isEnv(env e) {
            this.e = e;
        }

        public final boolean check() {
            return AccessController.doPrivileged(new PrivilegedAction<Boolean>(){

                @Override
                public Boolean run() {
                    return isEnv.this.checkProperty();
                }
            }, JXAenvUtils.acc);
        }

        protected abstract boolean checkProperty();
    }
}

