/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jiga.xtended.ui;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.security.AccessController;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import java.util.Collections;
import java.util.HashMap;
import net.sf.jiga.xtended.kernel.FileHelper;
import net.sf.jiga.xtended.kernel.JXAenvUtils;
import net.sf.jiga.xtended.kernel.Monitor;
import net.sf.jiga.xtended.ui.UIMessage;
import org.apache.commons.httpclient.HttpException;

public class FileHelperUI {
    public static void _fileCopy(File src, File dst, boolean progressBar, boolean bigBuffer) throws FileNotFoundException, IOException {
        long id = progressBar ? UIMessage.displayProgress(0, 100, null) : 0L;
        FileHelperUI.__fileCopy(src, dst, progressBar, id, bigBuffer);
        if (progressBar) {
            UIMessage.kill(id);
        }
    }

    public static void _fileCopy(InputStream src, File dst, boolean progressBar, boolean bigBuffer) throws FileNotFoundException, IOException {
        long id = progressBar ? UIMessage.displayProgress(0, 100, null) : 0L;
        FileHelperUI.__fileCopy(src, dst, progressBar, id, bigBuffer);
        if (progressBar) {
            UIMessage.kill(id);
        }
    }

    public static void _fileCopy(URL src, File dst, boolean progressBar, boolean bigBuffer) throws FileNotFoundException, IOException, HttpException {
        long id = progressBar ? UIMessage.displayProgress(0, 100, null) : 0L;
        FileHelperUI.__fileCopy(src, dst, progressBar, id, bigBuffer);
        if (progressBar) {
            UIMessage.kill(id);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void __startfileCopy(Runnable copyRunnable, Object src, File dst, boolean progressBar, long id, boolean bigBuffer) {
        boolean progressBarIndState = false;
        try {
            Thread tCopy = new Thread(copyRunnable, "file copy " + src + " -> " + dst);
            tCopy.setPriority(10);
            boolean retryRequested = false;
            Monitor monitor = FileHelper.fileThreads;
            synchronized (monitor) {
                FileHelper.Copy.readSync.put(tCopy.getId(), Collections.synchronizedMap(new HashMap<String, Boolean>(Collections.singletonMap("reading", false))));
                FileHelper.Copy.readProgress.put(tCopy.getId(), Collections.synchronizedMap(new HashMap()));
                FileHelper.Copy.readProgress.get(tCopy.getId()).put("string", "");
                FileHelper.Copy.readProgress.get(tCopy.getId()).put("value", "0");
                FileHelper.Copy.readProgress.get(tCopy.getId()).put("max", "100");
                if (progressBar) {
                    progressBarIndState = UIMessage.getProgressBar(id).isIndeterminate();
                    UIMessage.getProgressBar(id).setIndeterminate(false);
                    FileHelper.Copy.readProgress.get(tCopy.getId()).put("string", "loading " + dst.getName());
                }
                FileHelper.Copy.readSync.get(tCopy.getId()).put("reading", true);
                tCopy.start();
                while (FileHelper.Copy.readSync.get(tCopy.getId()).get("reading").booleanValue()) {
                    long time = System.currentTimeMillis();
                    FileHelper.fileThreads.wait(FileHelper._streamsTimeout);
                    if (progressBar) {
                        UIMessage.getProgressBar(id).setString(FileHelper.Copy.readProgress.get(tCopy.getId()).get("string"));
                        UIMessage.getProgressBar(id).setMaximum(Integer.parseInt(FileHelper.Copy.readProgress.get(tCopy.getId()).get("max")));
                        UIMessage.getProgressBar(id).setValue(Integer.parseInt(FileHelper.Copy.readProgress.get(tCopy.getId()).get("value")));
                        UIMessage.getProgressBar(id).paintImmediately(UIMessage.getProgressBar(id).getVisibleRect());
                    }
                    if (System.currentTimeMillis() - time < FileHelper._streamsTimeout) continue;
                    FileHelper.abortedThreads.add(tCopy.getId());
                    tCopy.interrupt();
                    if (JXAenvUtils._debugSys) {
                        System.out.println("attempting a retry...");
                    }
                    if (progressBar) {
                        UIMessage.getProgressBar(id).setString("lost connection, retry attempt...");
                    }
                    retryRequested = true;
                }
            }
            if (retryRequested) {
                FileHelperUI.__fileCopy(src, dst, progressBar, id, bigBuffer);
            }
        }
        catch (Exception ex) {
            if (JXAenvUtils._debugSys) {
                ex.printStackTrace();
            }
        }
        finally {
            if (progressBar) {
                UIMessage.getProgressBar(id).setIndeterminate(progressBarIndState);
            }
        }
    }

    public static void __fileCopy(final Object src, final File dst, final boolean progress, final long id, final boolean bigBuffer) throws FileNotFoundException, IOException {
        if (JXAenvUtils._debugSys) {
            System.out.println("Local file copy");
        }
        try {
            AccessController.doPrivileged(new PrivilegedExceptionAction(){

                public Object run() throws IOException {
                    Runnable copyRunnable = FileHelper.Copy.__preparefileCopy(src, dst, progress, id, bigBuffer);
                    FileHelperUI.__startfileCopy(copyRunnable, src, dst, progress, id, bigBuffer);
                    return null;
                }
            }, JXAenvUtils.acc);
        }
        catch (PrivilegedActionException ex) {
            throw (IOException)ex.getException();
        }
    }
}

