/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jiga.xtended.ui;

import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.LayoutManager;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Robot;
import java.awt.image.BufferedImage;
import java.awt.image.ConvolveOp;
import java.awt.image.Kernel;
import java.security.AccessControlContext;
import java.security.AccessController;
import java.security.PrivilegedAction;
import javax.swing.JPanel;
import net.sf.jiga.xtended.kernel.JXAenvUtils;
import net.sf.jiga.xtended.kernel.env;

public class TransparentBackground
extends JPanel {
    private BufferedImage background;
    private boolean disableTransparency = false;
    AccessControlContext acc = AccessController.getContext();
    float[] my_kernel = new float[]{0.0f, 0.0f, 0.05f, 0.0f, 0.0f, 0.0f, 0.05f, 0.05f, 0.05f, 0.0f, 0.05f, 0.05f, 0.1f, 0.05f, 0.05f, 0.0f, 0.05f, 0.05f, 0.05f, 0.0f, 0.0f, 0.0f, 0.05f, 0.0f, 0.0f};
    ConvolveOp _blurOp = new ConvolveOp(new Kernel(5, 5, this.my_kernel));

    public TransparentBackground(LayoutManager layout, boolean doubleBufferedPanel) {
        super(layout, doubleBufferedPanel);
    }

    public void setDisableTransparency(boolean disableTransparency) {
        this.disableTransparency = disableTransparency;
    }

    public void updateBackground() {
        AccessController.doPrivileged(new PrivilegedAction(){

            public Object run() {
                TransparentBackground.this._updateBackground();
                return null;
            }
        }, this.acc);
    }

    private void _updateBackground() {
        block5: {
            Dimension dim = new Dimension(JXAenvUtils._defaultGC.getDevice().getDisplayMode().getWidth(), JXAenvUtils._defaultGC.getDevice().getDisplayMode().getHeight());
            if (this.background instanceof BufferedImage) {
                this.background.flush();
            }
            if (env.OS_LINUX.isEnv()) {
                this.background = new BufferedImage(dim.width, dim.height, 7);
                Graphics g = this.background.getGraphics();
                g.setColor(this.getBackground());
                g.fillRect(0, 0, dim.width, dim.height);
                g.dispose();
            } else {
                try {
                    Robot rbt = new Robot();
                    BufferedImage b = rbt.createScreenCapture(new Rectangle(0, 0, (int)dim.getWidth(), (int)dim.getHeight()));
                    this.background = this._blurOp.filter(b, null);
                    b.flush();
                }
                catch (Exception ex) {
                    if (!JXAenvUtils._debugSys) break block5;
                    ex.printStackTrace();
                }
            }
        }
    }

    @Override
    public void paintComponent(Graphics g) {
        if (this.disableTransparency) {
            super.paintComponent(g);
        } else if (this.isShowing()) {
            Point pos = this.getLocationOnScreen();
            Point offset = new Point(-pos.x, -pos.y);
            g.drawImage(this.background, offset.x, offset.y, null);
        }
    }
}

