/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jiga.xtended.kernel;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.PrintStream;
import java.lang.ref.ReferenceQueue;
import java.lang.ref.SoftReference;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import net.sf.jiga.xtended.JXAException;
import net.sf.jiga.xtended.kernel.BigBitStack;
import net.sf.jiga.xtended.kernel.Debugger;
import net.sf.jiga.xtended.kernel.JXAenvUtils;
import net.sf.jiga.xtended.kernel.Level;
import net.sf.jiga.xtended.kernel.SystemPropertyChange;

public class DebugMap {
    private BigBitStack bits = new BigBitStack();
    private Level jxaDebug = this.newDebugLevel();
    private Level jxaDebugSys = this.newDebugLevel();
    public Level _VOID = this.newDebugLevel();
    public Level _SYS = this.jxaDebugSys;
    public Level _JXA = this.jxaDebug;
    private Level bitMap = Level.NoDebug;
    private Map<String, SoftDebugger> instances = Collections.synchronizedMap(new HashMap());
    private Map<String, Level> instancesClass = Collections.synchronizedMap(new HashMap());
    private ReferenceQueue refQueue = new ReferenceQueue();
    private static DebugMap _instance = DebugMap._getInstance();
    private Set<Level> availableBits = Collections.synchronizedSet(new HashSet());
    private long ticker = 0L;
    private long ticktime = 1000L;

    private DebugMap() {
    }

    private Level getJXADebugState() {
        return (JXAenvUtils._debug ? this.jxaDebug : Level.NoDebug).or(JXAenvUtils._debugSys ? this.jxaDebugSys : Level.NoDebug).or(JXAenvUtils._getSysBoolean("jxa.void") ? this._VOID : Level.NoDebug);
    }

    private void cleanup() {
        SoftDebugger sd = null;
        while ((sd = (SoftDebugger)this.refQueue.poll()) != null) {
            this.instances.remove(sd.className);
            this.instancesClass.remove(sd.className);
        }
    }

    private Level bitMap(Class<? extends Debugger> d) {
        Level lvl = this.instancesClass.get(d.getName());
        if (lvl != null) {
            return lvl;
        }
        return Level.NoDebug;
    }

    private Level levelBits(Class<? extends Debugger> d, Level level) {
        Level lvl = this.bitMap(d);
        return lvl.and(new Level(this.bits._getMask(level.n)).or(level));
    }

    private boolean isDebuggerEnabled(Class<? extends Debugger> d, Level level) {
        Level b = this.levelBits(d, level);
        Level r = this.bitMap.or(this.getJXADebugState()).and(b);
        return !r.equals(Level.NoDebug);
    }

    public boolean isDebugLevelEnabled(Level level) {
        return this.bitMap.or(this.getJXADebugState()).and(level).equals(level);
    }

    public void setDebuggerEnabled(boolean enable, Class<? extends Debugger> d) {
        Level level = this.bitMap(d);
        this.setDebuggerEnabled(enable, d, level.equals(Level.NoDebug) ? this.newDebugLevel() : level);
    }

    public void setDebuggerEnabled(final String systemProperty, final Class<? extends Debugger> d, final Level level) {
        this.setDebuggerEnabled(JXAenvUtils._getSysBoolean(systemProperty), d, level);
        SystemPropertyChange.INSTANCE.add(new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent evt) {
                if (evt.getPropertyName().equals(systemProperty)) {
                    DebugMap._getInstance().setDebuggerEnabled(Boolean.parseBoolean(evt.getNewValue().toString()), (Class<? extends Debugger>)d, level);
                }
            }
        });
    }

    public void setDebuggerEnabled(boolean enable, Class<? extends Debugger> d, Level level) {
        Level lvl = Level.NoDebug;
        this.cleanup();
        assert (!new Level(this.bits._getAllBitRanges()).and(level).equals(Level.NoDebug)) : "no valid level (use newDebugLevel() as level)";
        if (enable) {
            this.associateDebugLevel(d, level);
            lvl = this.levelBits(d, level);
            this.bitMap = this.bitMap.or(new Level(this.bits._getAllBits()).and(lvl));
            if (this.isDebugLevelEnabled(this._VOID)) {
                System.out.println("enabled debugger " + d.getSimpleName());
            }
        } else {
            this.deassociateDebugLevel(d, level);
            lvl = this.levelBits(d, level);
            this.bitMap = this.bitMap.andNot(new Level(this.bits._getAllBits()).and(lvl));
            if (this.isDebugLevelEnabled(this._VOID)) {
                System.out.println("disabled debugger " + d.getSimpleName());
            }
        }
    }

    public void setDebugLevelEnabled(boolean enable, Level level) {
        if (enable) {
            this.bitMap = this.bitMap.or(level.and(new Level(this.bits._getAllBitRanges())));
            if (this.isDebugLevelEnabled(this._VOID)) {
                System.out.println("enabled debuglevel " + level.toString());
            }
        } else {
            this.bitMap = this.bitMap.andNot(new Level(this.bits._getMask(level.n)).or(level));
        }
        if (this.isDebugLevelEnabled(this._VOID)) {
            System.out.println("disabled debuglevel " + level.toString());
        }
    }

    public static final DebugMap _getInstance() {
        return _instance != null ? _instance : (_instance = new DebugMap());
    }

    public Level newDebugLevel() {
        return this.newDebugLevel(null);
    }

    public Level newDebugLevel(Class<? extends Debugger> clazz) {
        Level l = new Level(this.bits._newBitRange());
        if (clazz != null) {
            this.associateDebugLevel(clazz, l);
        }
        return l;
    }

    public boolean isJXADebugEnabled(Debugger d) {
        return this.isDebuggerEnabled(d.getClass(), this.jxaDebug);
    }

    public boolean isJXADebugSysEnabled(Debugger d) {
        return this.isDebuggerEnabled(d.getClass(), this.jxaDebugSys);
    }

    public void setJXADebugEnabled(boolean b, Class<? extends Debugger> d) {
        this.setDebuggerEnabled(b, d, this.jxaDebug);
    }

    public void setJXADebugSysEnabled(boolean b, Class<? extends Debugger> d) {
        this.setDebuggerEnabled(b, d, this.jxaDebugSys);
    }

    public void setJXADebugEnabled(boolean b) {
        this.setDebugLevelEnabled(b, this.jxaDebug);
    }

    public void setJXADebugSysEnabled(boolean b) {
        this.setDebugLevelEnabled(b, this.jxaDebugSys);
    }

    public boolean isJXADebugEnabled() {
        return this.isDebugLevelEnabled(this.jxaDebug);
    }

    public boolean isJXADebugSysEnabled() {
        return this.isDebugLevelEnabled(this.jxaDebugSys);
    }

    public boolean isJXADebugEnabled(Class<? extends Debugger> d) {
        return this.isDebuggerEnabled(d, this.jxaDebug);
    }

    public boolean isJXADebugSysEnabled(Class<? extends Debugger> d) {
        return this.isDebuggerEnabled(d, this.jxaDebugSys);
    }

    public boolean isDebuggerEnabled(Class<? extends Debugger> d) {
        return this.isDebuggerEnabled(d, new Level(this.bits._getAllBitRanges()));
    }

    public void setJXADebugEnabled(boolean enable, Debugger d) {
        this.setDebuggerEnabled(enable, d.getClass(), this.jxaDebug);
    }

    public void setJXADebugSysEnabled(boolean b, Debugger d) {
        this.setDebuggerEnabled(b, d.getClass(), this.jxaDebugSys);
    }

    public void associateJXADebugSys(Class<? extends Debugger> d) {
        this.associateDebugLevel(d, this.jxaDebugSys);
    }

    public void associateJXADebug(Class<? extends Debugger> d) {
        this.associateDebugLevel(d, this.jxaDebug);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Level findVacantLevelBits(Level level) {
        Set<Level> set = this.availableBits;
        synchronized (set) {
            for (Level l : this.availableBits) {
                if (!level.and(l).equals(level)) continue;
                return l;
            }
            return null;
        }
    }

    public void associateDebugLevel(Class<? extends Debugger> d, Level level) {
        Level lvl = Level.NoDebug;
        if (!this.instancesClass.containsKey(d.getName())) {
            lvl = new Level(this.bits._newBit(level.n));
        } else {
            lvl = this.bitMap(d);
            if (lvl.and(level).equals(Level.NoDebug)) {
                Level newLevel = this.findVacantLevelBits(level);
                lvl = lvl.or(newLevel != null ? newLevel : new Level(this.bits._newBit(level.n)));
            }
        }
        if (this.isDebugLevelEnabled(this._VOID)) {
            System.out.println("associated " + d.getSimpleName() + " with debuglevel " + lvl.toString());
        }
        this.instancesClass.put(d.getName(), lvl);
        this.instances.put(d.getName(), new SoftDebugger(d));
    }

    public void deassociateJXADebugSys(Class<? extends Debugger> d) {
        this.deassociateDebugLevel(d, this.jxaDebugSys);
    }

    public void deassociateJXADebug(Class<? extends Debugger> d) {
        this.deassociateDebugLevel(d, this.jxaDebug);
    }

    public void deassociateDebugLevel(Class<? extends Debugger> d, Level level) {
        Level lvl = this.bitMap(d);
        Level lvlFree = this.levelBits(d, level);
        this.availableBits.add(lvlFree);
        this.instancesClass.put(d.getName(), lvl.andNot(lvlFree));
        this.instances.put(d.getName(), new SoftDebugger(d));
        if (this.isDebugLevelEnabled(this._VOID)) {
            System.out.println("unassociated " + d.getSimpleName() + " with debuglevel " + lvl.toString());
        }
    }

    public long getTickTime() {
        return this.ticktime;
    }

    public void setTickTime(long delay) {
        if (delay < 0L) {
            throw new JXAException("no negative value please");
        }
        this.ticktime = delay;
    }

    private boolean print(PrintStream out, boolean newLine, String message, boolean tick) {
        boolean printed;
        long c = System.currentTimeMillis();
        boolean bl = printed = c - this.ticker > this.ticktime;
        if (printed) {
            if (tick) {
                this.ticker = c;
            }
            if (newLine) {
                out.println(message);
            } else {
                out.print(message);
            }
        }
        return printed;
    }

    public boolean tickPrintln(PrintStream out, String message, boolean tick) {
        return this.print(out, true, message, tick);
    }

    public boolean tickPrint(PrintStream out, String message, boolean tick) {
        return this.print(out, false, message, tick);
    }

    private class SoftDebugger
    extends SoftReference {
        final String className;

        public SoftDebugger(Class<? extends Debugger> d) {
            super(d, DebugMap.this.refQueue);
            this.className = d.getName();
        }
    }
}

