/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jiga.xtended.kernel;

import java.io.File;
import java.io.IOException;
import java.net.JarURLConnection;
import java.net.MalformedURLException;
import java.net.URISyntaxException;
import java.net.URL;
import java.net.URLConnection;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.Locale;
import java.util.Map;
import java.util.ResourceBundle;
import java.util.jar.Attributes;
import java.util.jar.Manifest;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.JLabel;
import net.sf.jiga.xtended.JXAException;
import net.sf.jiga.xtended.kernel.Console;
import net.sf.jiga.xtended.kernel.DebugMap;
import net.sf.jiga.xtended.kernel.ExtensionsClassLoader;
import net.sf.jiga.xtended.kernel.ExtensionsClassLoaderImpl;
import net.sf.jiga.xtended.kernel.FileHelper;
import net.sf.jiga.xtended.kernel.JXAenvUtils;
import net.sf.jiga.xtended.kernel.ThreadWorks;
import net.sf.jiga.xtended.kernel.env;
import net.sf.jiga.xtended.ui.Display;
import net.sf.jiga.xtended.ui.UIMessage;

public class ExtensionsInstaller {
    public static boolean showSplash = false;
    public static URL splashPic = ExtensionsInstaller.class.getResource("/net/sf/jiga/xtended/ui/images/Sf3Splash.png");
    public static ResourceBundle rb = ResourceBundle.getBundle("net.sf.jiga.xtended.kernel.extension", Locale.getDefault(), ExtensionsInstaller.class.getClassLoader());

    public static <U> JXAenvUtils _installExtensions(Map<String, Map<String, U>> map, boolean libpath, File backupDirectory) throws MalformedURLException {
        JXAenvUtils env2 = new JXAenvUtils();
        env2.setJXAenvPath(ExtensionsInstaller._findExtPath(libpath));
        env2.setBigBuffer(true);
        return ExtensionsInstaller._installExtensions(env2, map, libpath, backupDirectory);
    }

    public static <U> JXAenvUtils _uninstallExtensions(Map<String, Map<String, U>> map, boolean libpath, File backupDirectory) {
        JXAenvUtils env2 = new JXAenvUtils();
        env2.setJXAenvPath(ExtensionsInstaller._findExtPath(libpath));
        return ExtensionsInstaller._uninstallExtensions(env2, map, libpath, backupDirectory);
    }

    public static String _findExtPath(final boolean libpath) {
        return AccessController.doPrivileged(new PrivilegedAction<String>(){

            @Override
            public String run() {
                return ExtensionsInstaller.__findExtPath(libpath);
            }
        });
    }

    private static String __findExtPath(boolean libpath) {
        boolean useSystemExtPaths;
        boolean writeableExts = false;
        String extPath = "---";
        String exts = libpath ? JXAenvUtils.getLibraryPath() : JXAenvUtils._getSysValue("java.ext.dirs");
        boolean bl = useSystemExtPaths = Boolean.parseBoolean(rb.getString("useSystemExtensionsPaths")) || JXAenvUtils._getSysBoolean("jxa.ext.dirs");
        if (JXAenvUtils._debugSys) {
            System.out.println(JXAenvUtils.log("Detecting your home (writeable) folder : " + FileHelper._USERHOMEDIRECTORY.getAbsolutePath(), JXAenvUtils.LVL.SYS_NOT));
            System.out.println(JXAenvUtils.log("Detecting your temp (writeable) folder : " + FileHelper._TMPDIRECTORY.getAbsolutePath(), JXAenvUtils.LVL.SYS_NOT));
            System.out.println(JXAenvUtils.log("Detecting your class-path : " + JXAenvUtils.getClasspath(), JXAenvUtils.LVL.SYS_NOT));
            System.out.println(JXAenvUtils.log("Detecting your extensions path : " + exts, JXAenvUtils.LVL.SYS_NOT));
        }
        if (libpath && JXAenvUtils._debugSys) {
            System.out.println(JXAenvUtils.log("Detecting your Library path : " + JXAenvUtils.getLibraryPath(), JXAenvUtils.LVL.SYS_NOT));
        }
        if (useSystemExtPaths) {
            if (env.OS_WINDOWS.isEnv() && !env._hasEnv(env.OS_WINDOWS_XP.bitMask())) {
                String dir = env.JAVA_VERSION_7.isEnv() ? "jre7" : (env.JAVA_VERSION_6.isEnv() ? "jre6" : "jre5");
                exts = JXAenvUtils._updatePath(exts, FileHelper._USERHOMEDIRECTORY.getPath() + File.separator + "AppData\\Local\\VirtualStore\\Program Files\\Java\\" + dir + "\\lib\\ext");
            }
            for (String path : exts.split(File.pathSeparator)) {
                writeableExts = FileHelper._accessFilePermitted(new File(path), 3);
                if (!writeableExts) continue;
                extPath = path;
                break;
            }
        }
        if (!writeableExts && !FileHelper._USERHOMEDIRECTORY.equals(new File(".")) && (writeableExts = FileHelper._accessFilePermitted(FileHelper._USERHOMEDIRECTORY, 3))) {
            extPath = FileHelper._USERHOMEDIRECTORY.getAbsolutePath();
        }
        if (!writeableExts && !FileHelper._TMPDIRECTORY.equals(new File(".")) && (writeableExts = FileHelper._accessFilePermitted(FileHelper._TMPDIRECTORY, 3))) {
            extPath = FileHelper._TMPDIRECTORY.getAbsolutePath();
        }
        if (!writeableExts) {
            extPath = ".";
        }
        if (libpath) {
            if (JXAenvUtils._debugSys) {
                System.out.println(JXAenvUtils.log("Altering java.library.path may not be successful", JXAenvUtils.LVL.SYS_WRN));
            }
            JXAenvUtils._setSysValue("java.library.path", JXAenvUtils._updatePath(JXAenvUtils.getLibraryPath(), extPath));
        }
        if (JXAenvUtils._debugSys) {
            System.out.println(JXAenvUtils.log("Using " + (libpath ? "lib." : "ext.") + " path : " + extPath, JXAenvUtils.LVL.SYS_NOT));
        }
        return extPath;
    }

    public static <U> JXAenvUtils _installExtensions(final JXAenvUtils env2, final Map<String, Map<String, U>> map, final boolean libpath, final File backupDirectory) throws MalformedURLException {
        try {
            return AccessController.doPrivileged(new PrivilegedExceptionAction<JXAenvUtils>(){

                @Override
                public JXAenvUtils run() throws MalformedURLException, CloneNotSupportedException {
                    if (backupDirectory instanceof File) {
                        JXAenvUtils backenv = (JXAenvUtils)env2.clone();
                        backenv.silent = true;
                        System.out.println(JXAenvUtils.log("Loading backup " + (libpath ? "natives" : "extensions") + " (if available)...", JXAenvUtils.LVL.SYS_NOT));
                        if (libpath) {
                            ExtensionsInstaller.__installExtensions(backenv, ExtensionsInstaller.__baseFileMapNat(map, backupDirectory.toURI().toURL(), false), libpath);
                        } else {
                            ExtensionsInstaller.__installExtensions(backenv, ExtensionsInstaller.__baseFileMapExt(map, backupDirectory.toURI().toURL(), false), libpath);
                        }
                    }
                    System.out.println(JXAenvUtils.log("Loading updated " + (libpath ? "natives" : "extensions") + " (if available)...", JXAenvUtils.LVL.SYS_NOT));
                    return ExtensionsInstaller.__installExtensions(env2, map, libpath);
                }
            });
        }
        catch (PrivilegedActionException ex) {
            if (ex.getException() instanceof CloneNotSupportedException) {
                if (JXAenvUtils._debugSys) {
                    ex.getException().printStackTrace();
                }
                return env2;
            }
            throw (MalformedURLException)ex.getException();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static <U> JXAenvUtils __installExtensions(JXAenvUtils env, Map<String, Map<String, U>> map, boolean libpath) {
        if (map == null) {
            System.out.println(JXAenvUtils.log("Nothing loaded for extensions here.", JXAenvUtils.LVL.SYS_WRN));
            return env;
        }
        if (map.isEmpty()) {
            System.out.println(JXAenvUtils.log("Nothing loaded for extensions here.", JXAenvUtils.LVL.SYS_WRN));
            return env;
        }
        if (!JXAenvUtils._getSysValue("os.name").startsWith(ExtensionsInstaller.rb.getString("os"))) {
            JXAenvUtils._popExceptionToUser(true, Thread.currentThread(), new UnsupportedOperationException("The running OS " + JXAenvUtils._getSysValue("os.name") + " does not match with " + ExtensionsInstaller.rb.getString("os")));
            System.exit(1);
        }
        extsMap = null;
        var4_4 /* !! */  = map;
        synchronized (var4_4 /* !! */ ) {
            for (String os : map.keySet()) {
                if (!JXAenvUtils._getSysValue("os.name").startsWith(os)) continue;
                extsMap = map.get(os);
                break;
            }
        }
        if (extsMap instanceof Map) {
            var4_4 /* !! */  = extsMap;
            synchronized (var4_4 /* !! */ ) {
                for (String id : extsMap.keySet()) {
                    if (libpath) {
                        env.addEnvFile(id, (URL)((Map)extsMap.get(id)).keySet().iterator().next());
                        continue;
                    }
                    env.addEnvFile(id, (URL)extsMap.get(id));
                }
            }
            if (!env.silent && ExtensionsInstaller.showSplash && ThreadWorks.Swing.isEventDispatchThread()) {
                try {
                    env.setSplashPicture(Display._Display(ExtensionsInstaller.splashPic, null));
                }
                catch (Exception ex) {
                    if (!JXAenvUtils._debugSys) ** GOTO lbl48
                    ex.printStackTrace();
                }
                finally {
                    env.loadResource();
                }
            } else {
                env.loadAll();
            }
lbl48:
            // 4 sources

            if (env.hasLoadErrors()) {
                if (!env.silent) {
                    errors = "";
                    for (String id : env.getErroredFiles()) {
                        errors = errors + id + " expected path : " + env.getEnvSourceFile(id) + File.pathSeparator + " not ";
                    }
                    message = (libpath != false ? "Native libraries" : "Jar resources") + " were not found on classpath." + Console.newLine + (libpath != false ? "" : "Maybe <param name='keepremote' value='true'> was missing.") + " Set jxa.debugSys=true jxa.debugECL=true to show more info. " + Console.newLine + errors;
                    if (!Boolean.getBoolean("jxa.jwrapper")) throw new JXAException(JXAException.LEVEL.SYSTEM, message);
                    Logger.getLogger("jxa.logger").log(Level.SEVERE, message);
                }
            } else if (libpath) {
                var4_4 /* !! */  = extsMap;
                synchronized (var4_4 /* !! */ ) {
                    cL = JXAenvUtils._switchToClassLoader(env.getEnvClassLoader());
                    ExtensionsClassLoaderImpl.isFirst.begin(true);
                    for (String id : extsMap.keySet()) {
                        if (!((Boolean)((Map)extsMap.get(id)).values().iterator().next()).booleanValue()) continue;
                        try {
                            if (JXAenvUtils._debugSys) {
                                System.out.print("System.loadLibrary " + id);
                            }
                            System.loadLibrary(id);
                            if (!JXAenvUtils._debugSys) continue;
                            System.out.println(" OK");
                        }
                        catch (Throwable e) {
                            if (JXAenvUtils._debugSys) {
                                System.out.println(" FAILED " + e.getMessage());
                            }
                            fullPath = env.getEnvInstalledFile(id).getAbsolutePath();
                            if (JXAenvUtils._debugSys) {
                                System.out.print("System.load library " + id + " from " + fullPath);
                            }
                            try {
                                System.load(fullPath);
                                if (!JXAenvUtils._debugSys) continue;
                                System.out.println(" OK");
                            }
                            catch (Throwable ex) {
                                if (JXAenvUtils._debugSys) {
                                    System.out.println(" FAILED " + ex.getMessage());
                                }
                                if (env.silent) continue;
                                throw new JXAException(e.getLocalizedMessage(), ex);
                            }
                        }
                    }
                    ExtensionsClassLoaderImpl.isFirst.end();
                    JXAenvUtils._switchToClassLoader(cL);
                }
            }
        }
        if (env.isResourceLoaded()) {
            if (!JXAenvUtils._debugSys) return env;
            System.out.println(JXAenvUtils.log("Loaded all environment resources !", JXAenvUtils.LVL.SYS_NOT));
            return env;
        } else {
            if (env.silent) return env;
            System.err.println(JXAenvUtils.log("Some of the environment resources failed to load. Use jxa.debugSys=true system property to see details !", JXAenvUtils.LVL.SYS_ERR));
        }
        return env;
    }

    public static <U> JXAenvUtils _uninstallExtensions(final JXAenvUtils env2, final Map<String, Map<String, U>> map, final boolean libpath, final File backupDirectory) {
        return AccessController.doPrivileged(new PrivilegedAction<JXAenvUtils>(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public JXAenvUtils run() {
                if (backupDirectory instanceof File) {
                    Map osfileMap;
                    Map map2 = osfileMap = (Map)map.get(JXAenvUtils._getSysValue("os.name"));
                    synchronized (map2) {
                        boolean i = false;
                        for (String id : osfileMap.keySet()) {
                            try {
                                File dst;
                                if (libpath) {
                                    dst = new File(backupDirectory + File.separator + new File(((URL)((Map)osfileMap.get(id)).keySet().iterator().next()).toString()).getName());
                                    URL file = (URL)((Map)osfileMap.get(id)).keySet().iterator().next();
                                    FileHelper._fileCopy(file, dst, false, true);
                                    continue;
                                }
                                URL u = (URL)osfileMap.get(id);
                                if (JXAenvUtils._debugSys) {
                                    System.out.println("extensions .jar file : " + u);
                                }
                                dst = new File(backupDirectory + File.separator + new File(u.toString()).getName());
                                FileHelper._fileCopy((URL)osfileMap.get(id), dst, false, true);
                            }
                            catch (Exception ex) {
                                if (!JXAenvUtils._debugSys) continue;
                                ex.printStackTrace();
                            }
                        }
                    }
                }
                return ExtensionsInstaller.__uninstallExtensions(env2, map, libpath);
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static <U> JXAenvUtils __uninstallExtensions(JXAenvUtils env2, Map<String, Map<String, U>> map, boolean libpath) {
        if (map == null) {
            System.out.println(JXAenvUtils.log("Nothing loaded for extensions here.", JXAenvUtils.LVL.SYS_WRN));
            return env2;
        }
        if (map.isEmpty()) {
            System.out.println(JXAenvUtils.log("Nothing loaded for extensions here.", JXAenvUtils.LVL.SYS_WRN));
            return env2;
        }
        Map<String, Map<String, U>> map2 = map;
        synchronized (map2) {
            for (String os : map.keySet()) {
                Map<String, U> extsMap = map.get(os);
                if (!JXAenvUtils._getSysValue("os.name").startsWith(os)) continue;
                Map<String, U> map3 = extsMap;
                synchronized (map3) {
                    for (String id : extsMap.keySet()) {
                        if (libpath) {
                            env2.addEnvFile(id, (URL)((Map)extsMap.get(id)).keySet().iterator().next());
                            continue;
                        }
                        env2.addEnvFile(id, (URL)extsMap.get(id));
                    }
                }
                if (showSplash && ThreadWorks.Swing.isEventDispatchThread()) {
                    env2.clearResource();
                } else {
                    env2.unloadAll();
                }
                if (!env2.hasLoadErrors()) break;
                System.err.println(JXAenvUtils.log("environment unloading process had error(s) on unloading", JXAenvUtils.LVL.SYS_ERR));
                break;
            }
        }
        if (!env2.isResourceLoaded()) {
            if (JXAenvUtils._debugSys) {
                System.out.println(JXAenvUtils.log("Successfully unloaded all environment resources !", JXAenvUtils.LVL.SYS_NOT));
            }
        } else {
            System.err.println(JXAenvUtils.log("Some of the environment resources failed to unload.", JXAenvUtils.LVL.SYS_ERR));
        }
        return env2;
    }

    public static Map<String, Map<String, Map<URL, Boolean>>> _getJXANatenvFiles(Map<String, Map<String, Map<URL, Boolean>>> map, URL base) throws MalformedURLException, URISyntaxException {
        return ExtensionsInstaller.__baseFileMapNat(ExtensionsInstaller._getJXANatenvFiles(map, true), base, false);
    }

    public static Map<String, Map<String, Map<URL, Boolean>>> _getJXANatenvFiles(Map<String, Map<String, Map<URL, Boolean>>> map, boolean local) throws MalformedURLException, URISyntaxException {
        Map<String, Map<URL, Boolean>> exts = (map = map instanceof Map ? map : Collections.synchronizedMap(new LinkedHashMap())).get(JXAenvUtils._getSysValue("os.name"));
        if (exts == null) {
            exts = new LinkedHashMap<String, Map<URL, Boolean>>();
            map.put(JXAenvUtils._getSysValue("os.name"), exts);
        }
        String natives = rb.getString("extNatives");
        ClassLoader extLoader = ExtensionsClassLoader.getInstance().getClassLoader();
        for (String nat : natives.split("\\s")) {
            boolean loadLib;
            String libname = nat.split(":")[0];
            String libfile = nat.split(":")[1];
            boolean bl = loadLib = nat.split(":").length == 3 ? Boolean.parseBoolean(nat.split(":")[2]) : false;
            while (libfile.startsWith("/") && libfile.length() > 1) {
                libfile = libfile.substring(1);
            }
            URL url = local ? new File("." + File.separator + libfile).toURI().toURL() : extLoader.getResource(libfile);
            exts.put(libname, Collections.singletonMap(url, loadLib));
        }
        if (JXAenvUtils._debugSys) {
            System.out.println("ExtensionsInstaller (natives) :: current running directory is : " + new File("."));
        }
        return map;
    }

    private static Map<String, URL> _getJXAExtFile(String jar, URL base) throws MalformedURLException {
        while (jar.startsWith("/") && jar.length() > 1) {
            jar = jar.substring(1);
        }
        URL url = new URL(base, jar);
        return Collections.singletonMap(FileHelper._getURLFilename(url), url);
    }

    public static Map<String, Map<String, URL>> _getJXAExtenvFiles(Map<String, Map<String, URL>> map, boolean local, boolean withInstaller) throws MalformedURLException, URISyntaxException {
        URL jarsPath;
        String jars = rb.getString("extJars");
        String jarsPathStr = rb.getString("extPathURL");
        if (jarsPathStr.endsWith("/")) {
            jarsPathStr = jarsPathStr + "/";
        }
        File appRoot = new File(System.getProperty("jxa.appRoot", "."));
        URL uRL = jarsPath = local ? new File(appRoot, "api" + File.separator).toURI().toURL() : new URL(jarsPathStr);
        if (Boolean.getBoolean("jxa.appBundle")) {
            jarsPath = appRoot.toURI().toURL();
            if (DebugMap._getInstance().isJXADebugSysEnabled()) {
                UIMessage.showLightPopupMessage(new JLabel("appbundle " + jarsPath), null, null, UIMessage.UI_BOTTOM_LEFT);
            }
        }
        String jarInstaller = rb.getString("extInstallerJar");
        Map<String, URL> exts = (map = map instanceof Map ? map : Collections.synchronizedMap(new LinkedHashMap())).get(JXAenvUtils._getSysValue("os.name"));
        if (exts == null) {
            exts = new LinkedHashMap<String, URL>();
            map.put(JXAenvUtils._getSysValue("os.name"), exts);
        }
        for (String jar : jars.split("\\s")) {
            exts.putAll(ExtensionsInstaller._getJXAExtFile(local ? jar.replaceAll("%20", " ") : jar, jarsPath));
        }
        if (withInstaller) {
            exts.putAll(ExtensionsInstaller._getJXAExtFile(local ? jarInstaller.replaceAll("%20", " ") : jarInstaller, jarsPath));
        }
        if (JXAenvUtils._debugSys) {
            if (local) {
                System.out.println("ExtensionsInstaller (api) :: current running directory is : " + new File(".").getAbsolutePath());
            } else {
                System.out.println("ExtensionsInstaller (api) :: current codebase is : " + ExtensionsInstaller.class.getProtectionDomain().getCodeSource().getLocation());
            }
        }
        return map;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static <U> Map<String, Map<String, U>> __baseFileMapNat(Map<String, Map<String, U>> map, URL base, boolean fullPath) throws MalformedURLException {
        Map<String, Map<String, U>> baseFileMap = Collections.synchronizedMap(new LinkedHashMap());
        Map<String, Map<String, U>> map2 = map;
        synchronized (map2) {
            for (String os : map.keySet()) {
                LinkedHashMap osMap = new LinkedHashMap();
                for (Map.Entry<String, U> file : map.get(os).entrySet()) {
                    osMap.put(file.getKey(), ((Map)file.getValue()).keySet().iterator().next());
                }
                baseFileMap.put(os, osMap);
            }
        }
        baseFileMap = ExtensionsInstaller.__baseFileMapExt(baseFileMap, base, fullPath);
        LinkedHashMap baseFileMapNat = new LinkedHashMap();
        Map<String, Map<String, U>> map3 = baseFileMap;
        synchronized (map3) {
            for (String os : baseFileMap.keySet()) {
                LinkedHashMap osMap = new LinkedHashMap();
                for (Map.Entry<String, U> file : baseFileMap.get(os).entrySet()) {
                    osMap.put(file.getKey(), Collections.singletonMap(file.getValue(), ((Map)map.get(os).get(file.getKey())).values().iterator().next()));
                }
                baseFileMapNat.put(os, osMap);
            }
        }
        return Collections.synchronizedMap(baseFileMapNat);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static <U> Map<String, Map<String, U>> __baseFileMapExt(Map<String, Map<String, U>> map, URL base, boolean fullPath) throws MalformedURLException {
        Map<String, Map<String, U>> baseFileMap = Collections.synchronizedMap(new LinkedHashMap());
        Map<String, Map<String, U>> map2 = map;
        synchronized (map2) {
            for (Map.Entry<String, Map<String, U>> osMap : map.entrySet()) {
                Map<String, U> osfileMap = osMap.getValue();
                LinkedHashMap<String, URL> osbasefileMap = new LinkedHashMap<String, URL>();
                for (String id : osfileMap.keySet()) {
                    String sPath;
                    URL path = (URL)osfileMap.get(id);
                    if (path == null) {
                        osbasefileMap.put(id, null);
                        continue;
                    }
                    if (base == null) {
                        osbasefileMap.put(id, path);
                        continue;
                    }
                    String string = sPath = fullPath ? path.getPath() : new File(path.getPath()).getName();
                    while (sPath.startsWith("/") && sPath.length() > 1) {
                        sPath = sPath.substring(1);
                    }
                    osbasefileMap.put(id, new URL(base, sPath));
                }
                baseFileMap.put(osMap.getKey(), osbasefileMap);
            }
        }
        return baseFileMap;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static Map<String, Map<String, URL>> __urlFileMap(Map<String, Map<String, File>> map) throws MalformedURLException {
        LinkedHashMap urlMap = new LinkedHashMap();
        Map<String, Map<String, File>> map2 = map;
        synchronized (map2) {
            for (String os : map.keySet()) {
                LinkedHashMap<String, URL> osfileMap = new LinkedHashMap<String, URL>();
                for (String id : map.get(os).keySet()) {
                    if (map.get(os).get(id) == null) {
                        osfileMap.put(id, null);
                        continue;
                    }
                    osfileMap.put(id, map.get(os).get(id).toURI().toURL());
                }
                urlMap.put(os, osfileMap);
            }
        }
        return Collections.synchronizedMap(urlMap);
    }

    public static Map<String, Map<String, URL>> _getJXAExtenvFilesFromBase(Map<String, Map<String, URL>> map, URL base, boolean withInstaller, boolean fullPath) throws MalformedURLException, URISyntaxException {
        return ExtensionsInstaller.__baseFileMapExt(ExtensionsInstaller._getJXAExtenvFiles(map, true, withInstaller), base, fullPath);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static URL[] _getURLClassLoaderURLS(JXAenvUtils env2) {
        try {
            Map<String, URL> jarMap = ExtensionsInstaller._getJXAExtenvFiles(env2.envJars, env2.isLocal(), false).get(JXAenvUtils._getSysValue("os.name"));
            ArrayList<URL> classloaderJars = new ArrayList<URL>();
            Map<String, URL> map = jarMap;
            synchronized (map) {
                for (URL jarUrl : jarMap.values()) {
                    try {
                        if (env2.keepReadingOnRemoteJarResources) {
                            classloaderJars.add(jarUrl);
                            continue;
                        }
                        classloaderJars.add(env2.findEnvInstalledFile(jarUrl).toURI().toURL());
                    }
                    catch (MalformedURLException ex) {
                        ex.printStackTrace();
                    }
                }
            }
            return classloaderJars.toArray(new URL[0]);
        }
        catch (Exception ex) {
            if (JXAenvUtils._debugSys) {
                ex.printStackTrace();
            }
            return null;
        }
    }

    public static Map<String, URL> _getJarClasspathJars(URL jarUrl) throws IOException {
        String classpath;
        Attributes a;
        Manifest m;
        URL u = new URL("jar:" + jarUrl + "!/");
        LinkedHashMap<String, URL> jarUrls = new LinkedHashMap<String, URL>();
        URLConnection jar = u.openConnection();
        if (jar instanceof JarURLConnection && (m = ((JarURLConnection)jar).getManifest()) != null && (a = m.getMainAttributes()) != null && (classpath = a.getValue(Attributes.Name.CLASS_PATH)) != null) {
            for (String path : classpath.split("\\s")) {
                if (path == null || !path.endsWith(".jar")) continue;
                URL nJarUrl = new URL(jarUrl.toString().substring(0, jarUrl.toString().lastIndexOf("/")) + "/" + path);
                String name = FileHelper._getURLFilename(u);
                jarUrls.put(name, nJarUrl);
            }
        }
        return jarUrls;
    }
}

