/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jiga.xtended.kernel;

import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.FilePermission;
import java.io.FilenameFilter;
import java.io.IOException;
import java.io.InputStream;
import java.io.RandomAccessFile;
import java.lang.reflect.InvocationTargetException;
import java.net.URL;
import java.net.URLConnection;
import java.nio.channels.FileChannel;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.regex.Matcher;
import javax.imageio.ImageIO;
import net.sf.jiga.xtended.kernel.DebugMap;
import net.sf.jiga.xtended.kernel.ExtensionsInstaller;
import net.sf.jiga.xtended.kernel.JXAenvUtils;
import net.sf.jiga.xtended.kernel.Monitor;
import net.sf.jiga.xtended.kernel.SpritesCacheManager;
import net.sf.jiga.xtended.kernel.env;
import org.apache.commons.httpclient.DefaultHttpMethodRetryHandler;
import org.apache.commons.httpclient.HttpClient;
import org.apache.commons.httpclient.HttpException;
import org.apache.commons.httpclient.HttpMethod;
import org.apache.commons.httpclient.methods.GetMethod;
import org.apache.commons.io.FileUtils;

public class FileHelper {
    public static File _USERHOMEDIRECTORY = FileHelper._findHomeDirectory();
    public static File _USERHOMESTOREDIRECTORY = FileHelper._makeStoreDirectory(_USERHOMEDIRECTORY);
    public static final int FILE_READ = 1;
    public static Monitor fileThreads = new Monitor();
    public static final String _tmpFilesSuffix = ".jxa.tmp";
    private static boolean _ImageIOUseCache = false;
    public static final int FILE_EXECUTE = 8;
    public static final int FILE_DELETE = 4;
    public static int _SMALLBUFFFER_SIZE = 65536;
    public static File _TMPDIRECTORY = FileHelper._findTempDirectory();
    public static File _LIBDIRECTORY = new File(ExtensionsInstaller._findExtPath(true));
    public static List<Long> abortedThreads = new ArrayList<Long>();
    public static long _streamsTimeout = 5000L;
    public static File _ImageIOCache = new File(_TMPDIRECTORY, "JavaImageIO");
    protected static final Set<File> _tmpDir = Collections.synchronizedSet(new HashSet<File>(Collections.singleton(_TMPDIRECTORY)));
    public static int _BIGBUFFER_SIZE = 0x100000;
    public static final int FILE_WRITE = 2;
    public static File _EXTDIRECTORY = new File(ExtensionsInstaller._findExtPath(false));

    public static void _eraseTmpFiles(final String suffix, File dir) throws IllegalArgumentException {
        if (!suffix.matches("\\..*")) {
            throw new IllegalArgumentException("suffix must be \".someextension\"");
        }
        if (dir.isDirectory()) {
            for (File f : dir.listFiles(new FilenameFilter(){

                @Override
                public boolean accept(File dir, String name) {
                    return name.endsWith(suffix);
                }
            })) {
                FileHelper._eraseTmpFiles(suffix, f);
            }
        } else if (dir.isFile() && FileHelper._accessFilePermitted(dir, 4) && dir.getName().endsWith(suffix)) {
            dir.delete();
        }
    }

    public static String _quotedFileSeparator() {
        String splitter = File.separator;
        if (splitter.equals("\\")) {
            splitter = "\\\\";
        }
        return splitter;
    }

    public static void _fileCopy(File src, File dst, boolean progress, boolean bigBuffer) throws FileNotFoundException, IOException {
        long id = 0L;
        FileHelper._fileCopy(src, dst, progress, id, bigBuffer);
    }

    public static void _fileCopy(InputStream src, File dst, boolean progress, boolean bigBuffer) throws FileNotFoundException, IOException {
        long id = 0L;
        FileHelper._fileCopy(src, dst, progress, id, bigBuffer);
    }

    public static void _fileCopy(URL src, File dst, boolean progress, boolean bigBuffer) throws FileNotFoundException, IOException, HttpException {
        long id = 0L;
        FileHelper._fileCopy(src, dst, progress, id, bigBuffer);
    }

    public static void _fileCopy(File src, File dst, boolean progress, long progressID, boolean bigBuffer) throws IOException {
        Copy.__fileCopy(src, dst, progress, progressID, bigBuffer);
    }

    public static void _fileCopy(InputStream src, File dst, boolean progress, long progressID, boolean bigBuffer) throws IOException {
        Copy.__fileCopy(src, dst, progress, progressID, bigBuffer);
    }

    public static void _fileCopy(URL src, File dst, boolean progress, long progressID, boolean bigBuffer) throws IOException {
        Copy.__fileCopy(src, dst, progress, progressID, bigBuffer);
    }

    public static void _makeReadable(File fd) {
        FileHelper.__makeReadable(fd, false);
    }

    private static boolean __makeWritable(File fd, boolean ownerOnly) {
        try {
            if (!FileHelper._accessFilePermitted(fd, 2) && !env.JAVA_VERSION_5.isEnv()) {
                boolean bl = (Boolean)JXAenvUtils._callback("setWritable", fd, new Object[]{true, ownerOnly}, new Class[]{Boolean.TYPE, Boolean.TYPE});
                return bl;
            }
            if (fd.getAbsolutePath().endsWith(File.separator)) {
                fd.mkdirs();
            }
            if (!fd.isDirectory() && !fd.exists()) {
                fd.getParentFile().mkdirs();
                fd.createNewFile();
                boolean bl = true;
                return bl;
            }
            if (DebugMap._getInstance().isDebugLevelEnabled(DebugMap._getInstance()._VOID)) {
                System.err.println("File " + fd + " is not writeable.");
            }
        }
        catch (NoSuchMethodException ex) {
            ex.printStackTrace();
        }
        catch (IllegalAccessException ex) {
            ex.printStackTrace();
        }
        catch (InvocationTargetException ex) {
            ex.printStackTrace();
        }
        catch (IOException ex) {
            ex.printStackTrace();
        }
        finally {
            return false;
        }
    }

    public static File _findFreeDirectory(List<File> freeList) {
        File freeDir = null;
        for (File f : freeList) {
            File access;
            if (!f.isDirectory() || !FileHelper._accessFilePermitted(access = f, 3)) continue;
            freeDir = f;
            break;
        }
        if (freeDir == null) {
            if (JXAenvUtils._debugSys) {
                System.err.println(JXAenvUtils.log("Sorry ! It's unable to find a writeable directory. Leaving now.", JXAenvUtils.LVL.SYS_ERR, null));
            }
            System.exit(1);
        }
        return freeDir;
    }

    private static boolean __makeReadable(File fd, boolean ownerOnly) {
        block6: {
            if (!env.JAVA_VERSION_5.isEnv()) {
                try {
                    return (Boolean)JXAenvUtils._callback("setReadable", fd, new Object[]{true, ownerOnly}, new Class[]{Boolean.TYPE, Boolean.TYPE});
                }
                catch (NoSuchMethodException ex) {
                    ex.printStackTrace();
                    break block6;
                }
                catch (IllegalAccessException ex) {
                    ex.printStackTrace();
                    break block6;
                }
                catch (InvocationTargetException ex) {
                    ex.printStackTrace();
                    break block6;
                }
            }
            if (DebugMap._getInstance().isDebugLevelEnabled(DebugMap._getInstance()._VOID)) {
                System.out.println("setReadable not available from this version of Java. " + fd);
            }
        }
        return false;
    }

    public static void _makeWritable(File fd) {
        FileHelper.__makeWritable(fd, false);
    }

    public static void _makeReadableOwnerOnly(File fd) {
        FileHelper.__makeReadable(fd, true);
    }

    public static void _makeWritableOwnerOnly(File fd) {
        FileHelper.__makeWritable(fd, true);
    }

    public static void ___rawfileCopy(File s, File d, boolean syncFlush) throws IOException {
        FileChannel source = null;
        FileChannel destination = null;
        if (!d.exists()) {
            d.getParentFile().mkdirs();
            d.createNewFile();
        }
        RandomAccessFile raf = new RandomAccessFile(d, "rw");
        source = new FileInputStream(s).getChannel();
        destination = new FileOutputStream(raf.getFD()).getChannel();
        destination.transferFrom(source, 0L, source.size());
        source.close();
        destination.force(syncFlush);
        destination.close();
        raf.close();
    }

    public static boolean _accessFilePermitted(final File file, final int fileMode) {
        return AccessController.doPrivileged(new PrivilegedAction<Boolean>(){

            @Override
            public Boolean run() {
                return FileHelper.__accessFilePermitted(file, fileMode);
            }
        }, JXAenvUtils.acc);
    }

    public static String _getURLFilename(URL url) {
        return url.getFile().substring(url.getFile().lastIndexOf("/") + 1);
    }

    private static File _makeStoreDirectory(final File base) {
        try {
            return AccessController.doPrivileged(new PrivilegedExceptionAction<File>(){

                @Override
                public File run() throws IOException {
                    String basePath;
                    block5: {
                        basePath = base.getPath();
                        if (!base.isDirectory()) {
                            basePath = base.getParent();
                        }
                        if (env.OS_WINDOWS.isEnv()) {
                            try {
                                File userAppData = new File(System.getenv("APPDATA"), "Java");
                                if (userAppData.canWrite()) {
                                    basePath = userAppData.getPath();
                                }
                            }
                            catch (SecurityException e) {
                                if (!JXAenvUtils._debugSys) break block5;
                                e.printStackTrace();
                            }
                        }
                    }
                    File store = new File(basePath, ".JXAStore");
                    store.mkdirs();
                    FileHelper._makeWritable(new File(basePath));
                    return store;
                }
            }, JXAenvUtils.acc);
        }
        catch (PrivilegedActionException ex) {
            if (JXAenvUtils._debugSys) {
                ex.getException().printStackTrace();
            }
            return null;
        }
    }

    static boolean __accessFilePermitted(File file, int fileMode) {
        if (file == null || fileMode == 0) {
            return false;
        }
        if (!file.exists()) {
            return FileHelper.__accessFilePermitted(file.getParentFile(), fileMode);
        }
        ArrayList<String> actions = new ArrayList<String>();
        if ((fileMode & 1) != 0) {
            actions.add("read");
        }
        if ((fileMode & 2) != 0) {
            actions.add("write");
        }
        if ((fileMode & 4) != 0) {
            actions.add("delete");
        }
        if ((fileMode & 8) != 0) {
            actions.add("execute");
        }
        String mode = "";
        String sep = "";
        for (String action : actions) {
            mode = mode + sep + action;
            sep = ",";
        }
        if (file.isDirectory()) {
            file = new File(file.getAbsolutePath() + File.separator + "*");
        }
        FilePermission fp = new FilePermission(file.getAbsolutePath(), mode);
        try {
            fp.checkGuard(null);
            return true;
        }
        catch (Exception e) {
            if (JXAenvUtils._debugSys) {
                System.err.println(JXAenvUtils.log((file.isDirectory() ? "Folder " : "File ") + fp.getName() + " is not allowed for accessing one or more actions : " + fp.getActions() + " " + e.getMessage(), JXAenvUtils.LVL.SYS_ERR, (Throwable)e));
            }
            return false;
        }
    }

    public static void _erase(File path) {
        block2: {
            try {
                FileHelper._erase(path, false);
            }
            catch (IOException ex) {
                if (!JXAenvUtils._debugSys) break block2;
                ex.printStackTrace();
            }
        }
    }

    public static void _erase(File path, boolean reportException) throws IOException {
        if (FileHelper._accessFilePermitted(path, 4)) {
            if (path.isDirectory()) {
                for (File f : path.listFiles()) {
                    FileHelper._erase(f, reportException);
                }
            }
            path.delete();
            if (JXAenvUtils._debugSys) {
                System.out.println("erased file path " + path);
            }
        } else if (path.exists()) {
            System.err.println("unable to erase " + path);
            if (reportException) {
                throw new IOException("File " + path + " cannot be deleted");
            }
        } else if (JXAenvUtils._debugSys) {
            System.err.println("unable to delete a file that does not exist " + path);
        }
    }

    public static void _setImageIOCacheEnabled(boolean b, File cacheDirectory) {
        try {
            _ImageIOUseCache = b;
            ImageIO.setUseCache(_ImageIOUseCache);
            if (b) {
                cacheDirectory.mkdirs();
                FileHelper._makeWritable(cacheDirectory);
                ImageIO.setCacheDirectory(cacheDirectory);
                _ImageIOCache = cacheDirectory;
            }
        }
        catch (Exception e) {
            if (JXAenvUtils._debugSys) {
                e.printStackTrace();
            }
            _ImageIOUseCache = false;
            ImageIO.setUseCache(false);
        }
    }

    static File _findTempDirectory() {
        File f = AccessController.doPrivileged(new PrivilegedAction<File>(){

            @Override
            public File run() {
                ArrayList<File> tempPath = new ArrayList<File>();
                if (JXAenvUtils.rb.getString("tempPathEnabled").equalsIgnoreCase("true")) {
                    tempPath.add(new File(JXAenvUtils._getSysValue("java.io.tmpdir")));
                }
                tempPath.add(new File("."));
                return FileHelper._findFreeDirectory(tempPath);
            }
        }, JXAenvUtils.acc);
        if (f == null) {
            f = new File(".");
        }
        return f;
    }

    static File _findHomeDirectory() {
        File f = AccessController.doPrivileged(new PrivilegedAction<File>(){

            @Override
            public File run() {
                ArrayList<File> tempPath = new ArrayList<File>();
                if (JXAenvUtils.rb.getString("homePathEnabled").equalsIgnoreCase("true")) {
                    tempPath.add(new File(JXAenvUtils._getSysValue("user.home")));
                }
                tempPath.add(new File("."));
                return FileHelper._findFreeDirectory(tempPath);
            }
        }, JXAenvUtils.acc);
        if (f == null) {
            f = new File(".");
        }
        return f;
    }

    public static String _convertToResourceString(File filePath) {
        String resource = "";
        String sep = "";
        String splitter = FileHelper._quotedFileSeparator();
        if (filePath.getPath().startsWith(splitter)) {
            sep = "/";
        }
        for (String s : filePath.getPath().split(splitter)) {
            resource = resource + sep + s;
            sep = "/";
        }
        return resource.replaceAll(splitter + splitter, splitter);
    }

    public static boolean _isImageIOCacheEnabled() {
        return _ImageIOUseCache;
    }

    public static File _createTempFile(String prefix, File dir, boolean deleteOnExit) throws IOException {
        File f = File.createTempFile(prefix, _tmpFilesSuffix, dir);
        _tmpDir.add(dir);
        FileHelper._makeReadable(f);
        FileHelper._makeWritable(f);
        if (deleteOnExit) {
            f.deleteOnExit();
        }
        SpritesCacheManager._cleanup();
        return f;
    }

    public static class Copy {
        public static final String _key_reading = "reading";
        public static final String _key_read_string = "string";
        public static final String _key_read_pgs_val = "value";
        public static final String _key_read_pgs_max = "max";
        public static final Map<Long, Map<String, Boolean>> readSync = new HashMap<Long, Map<String, Boolean>>();
        public static final Map<Long, Map<String, String>> readProgress = new HashMap<Long, Map<String, String>>();

        private static void __fileCopy_r(RandomAccessFile src, int r, byte[] b, int rBytes, RandomAccessFile JXAtmpPath, boolean progress) throws IOException {
            r = src.read(b);
            if (r == -1) {
                return;
            }
            Copy.__fileCopy_write(r, b, rBytes, JXAtmpPath);
            if (progress) {
                readProgress.get(Thread.currentThread().getId()).put(_key_read_pgs_val, String.valueOf(rBytes));
                readProgress.get(Thread.currentThread().getId()).put(_key_read_pgs_max, String.valueOf((int)src.length()));
            }
            Copy.__fileCopy_r(src, r, b, rBytes, JXAtmpPath, progress);
        }

        private static void __fileCopy_r(InputStream src, HttpClient HTTPConnection, URLConnection connection, int r, byte[] b, int rBytes, RandomAccessFile JXAtmpPath, boolean progress) throws IOException {
            r = src.read(b);
            if (r == -1) {
                return;
            }
            Copy.__fileCopy_write(r, b, rBytes, JXAtmpPath);
            if (progress) {
                readProgress.get(Thread.currentThread().getId()).put(_key_read_string, Matcher.quoteReplacement((HTTPConnection instanceof HttpClient ? "downloaded " : "copied ") + FileUtils.byteCountToDisplaySize((long)rBytes)) + " (%1$s remaining)");
                readProgress.get(Thread.currentThread().getId()).put(_key_read_pgs_val, String.valueOf(rBytes));
                readProgress.get(Thread.currentThread().getId()).put(_key_read_pgs_max, String.valueOf(connection instanceof URLConnection ? connection.getContentLength() : src.available()));
            }
            Copy.__fileCopy_r(src, HTTPConnection, connection, r, b, rBytes, JXAtmpPath, progress);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private static void __fileCopy_write(int r, byte[] b, int rBytes, RandomAccessFile JXAtmpPath) throws IOException {
            if (abortedThreads.contains(Thread.currentThread().getId())) {
                abortedThreads.remove(Thread.currentThread().getId());
                throw new IOException("File Copy was aborted by another Thread");
            }
            Monitor monitor = fileThreads;
            synchronized (monitor) {
                fileThreads.notify();
            }
            JXAtmpPath.write(b, 0, r);
            rBytes += r;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private static void __fileCopy_tStart(Runnable copyRunnable, Object src, File dst, boolean progress, long id, boolean bigBuffer) {
            try {
                Thread tCopy = new Thread(copyRunnable, "file copy " + src + " -> " + dst);
                tCopy.setPriority(10);
                boolean retryRequested = false;
                Monitor monitor = fileThreads;
                synchronized (monitor) {
                    readSync.put(tCopy.getId(), Collections.synchronizedMap(new HashMap<String, Boolean>(Collections.singletonMap(_key_reading, false))));
                    readProgress.put(tCopy.getId(), Collections.synchronizedMap(new HashMap()));
                    readProgress.get(tCopy.getId()).put(_key_read_string, "");
                    readProgress.get(tCopy.getId()).put(_key_read_pgs_val, "0");
                    readProgress.get(tCopy.getId()).put(_key_read_pgs_max, "100");
                    if (progress) {
                        readProgress.get(tCopy.getId()).put(_key_read_string, "loading " + dst.getName());
                    }
                    readSync.get(tCopy.getId()).put(_key_reading, true);
                    tCopy.start();
                    while (readSync.get(tCopy.getId()).get(_key_reading).booleanValue()) {
                        long time = System.currentTimeMillis();
                        fileThreads.wait(_streamsTimeout);
                        if (progress) {
                            // empty if block
                        }
                        if (System.currentTimeMillis() - time < _streamsTimeout) continue;
                        abortedThreads.add(tCopy.getId());
                        tCopy.interrupt();
                        if (JXAenvUtils._debugSys) {
                            System.out.println("attempting a retry...");
                        }
                        if (progress) {
                            readProgress.get(tCopy.getId()).put(_key_read_string, "lost connection, retry attempt...");
                        }
                        retryRequested = true;
                    }
                }
                if (retryRequested) {
                    Copy.__fileCopy(src, dst, progress, id, bigBuffer);
                }
            }
            catch (Exception ex) {
                if (JXAenvUtils._debugSys) {
                    ex.printStackTrace();
                }
            }
            finally {
                if (progress) {
                    // empty if block
                }
            }
        }

        protected static void __fileCopy(final Object src, final File dst, final boolean progress, final long id, final boolean bigBuffer) throws FileNotFoundException, IOException {
            if (JXAenvUtils._debugSys) {
                System.out.println("Local file copy");
            }
            try {
                AccessController.doPrivileged(new PrivilegedExceptionAction(){

                    public Object run() throws IOException {
                        Runnable copyRunnable = Copy.__preparefileCopy(src, dst, progress, id, bigBuffer);
                        Copy.__fileCopy_tStart(copyRunnable, src, dst, progress, id, bigBuffer);
                        return null;
                    }
                }, JXAenvUtils.acc);
            }
            catch (PrivilegedActionException ex) {
                throw (IOException)ex.getException();
            }
        }

        public static Runnable __preparefileCopy(final Object src, File dst, boolean progress, long id, boolean bigBuffer) throws FileNotFoundException, IOException {
            boolean closeBufferedStream;
            URLConnection connection;
            int BUFFER = bigBuffer ? _BIGBUFFER_SIZE : _SMALLBUFFFER_SIZE;
            RandomAccessFile JXAextension = src instanceof File ? new RandomAccessFile((File)src, "r") : null;
            final HttpClient HTTPConnection = src.toString().startsWith("http:") ? new HttpClient() : null;
            GetMethod getData = HTTPConnection instanceof HttpClient ? new GetMethod(src.toString()) : null;
            URLConnection uRLConnection = connection = src instanceof URL ? ((URL)src).openConnection() : null;
            final BufferedInputStream JXAextensionStream = connection instanceof URLConnection ? new BufferedInputStream(connection.getInputStream(), BUFFER) : (src instanceof BufferedInputStream ? (BufferedInputStream)src : (src instanceof InputStream ? new BufferedInputStream((InputStream)src, BUFFER) : null));
            boolean bl = closeBufferedStream = !(src instanceof InputStream);
            if (src instanceof File) {
                if (JXAenvUtils._debugSys) {
                    System.out.println("file copy " + ((File)src).getAbsolutePath() + " -> " + dst.getAbsolutePath());
                }
                if (!FileHelper._accessFilePermitted((File)src, 1)) {
                    throw new IOException("src path " + ((File)src).getAbsolutePath() + " is not readeable/doesn't exist");
                }
            } else if (JXAenvUtils._debugSys) {
                System.out.println("file copy " + (connection instanceof URLConnection ? connection.getContentLength() : JXAextensionStream.available()) + " -> " + dst.getAbsolutePath());
            }
            if (dst.getParentFile() != null) {
                dst.getParentFile().mkdirs();
                FileHelper._makeWritable(dst.getParentFile());
            }
            if (!FileHelper._accessFilePermitted(dst.getParentFile(), 3)) {
                throw new IOException("dst path " + dst.getAbsoluteFile().getParent() + " is not writeable");
            }
            File tmp = FileHelper._createTempFile("cp_", _TMPDIRECTORY, false);
            RandomAccessFile JXAtmpPath = new RandomAccessFile(tmp, "rw");
            if (JXAenvUtils._debugSys) {
                System.out.print("loading ");
            }
            return new Runnable((HttpMethod)getData, BUFFER, JXAextension, JXAtmpPath, progress, connection, closeBufferedStream, dst, tmp){
                final /* synthetic */ HttpMethod val$getData;
                final /* synthetic */ int val$BUFFER;
                final /* synthetic */ RandomAccessFile val$JXAextension;
                final /* synthetic */ RandomAccessFile val$JXAtmpPath;
                final /* synthetic */ boolean val$progress;
                final /* synthetic */ URLConnection val$connection;
                final /* synthetic */ boolean val$closeBufferedStream;
                final /* synthetic */ File val$dst;
                final /* synthetic */ File val$tmp;
                {
                    this.val$getData = httpMethod;
                    this.val$BUFFER = n;
                    this.val$JXAextension = randomAccessFile;
                    this.val$JXAtmpPath = randomAccessFile2;
                    this.val$progress = bl;
                    this.val$connection = uRLConnection;
                    this.val$closeBufferedStream = bl2;
                    this.val$dst = file;
                    this.val$tmp = file2;
                }

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public void run() {
                    boolean dstAltered = false;
                    InputStream inputStream = JXAextensionStream;
                    if (HTTPConnection instanceof HttpClient) {
                        if (JXAenvUtils._debugSys) {
                            System.out.println("Connection with " + HTTPConnection.getClass().getCanonicalName() + " to " + src.toString());
                        }
                        this.val$getData.getParams().setParameter("http.method.retry-handler", (Object)new DefaultHttpMethodRetryHandler(10, true));
                        try {
                            int executeMethod = HTTPConnection.executeMethod(this.val$getData);
                            if (executeMethod != 200) {
                                JXAenvUtils._popExceptionToUser(false, Thread.currentThread(), (Throwable)new HttpException(JXAenvUtils.log("Error occured with HTTP GET connection to " + src, JXAenvUtils.LVL.APP_ERR, null)));
                            }
                            inputStream.close();
                            inputStream = this.val$getData.getResponseBodyAsStream();
                        }
                        catch (Exception ex) {
                            if (JXAenvUtils._debugSys) {
                                ex.printStackTrace();
                            }
                            this.val$getData.releaseConnection();
                            return;
                        }
                    } else if (JXAenvUtils._debugSys) {
                        System.out.println("Connection with " + src.getClass().getCanonicalName() + " to " + src.toString());
                    }
                    byte[] b = new byte[this.val$BUFFER];
                    int r = 0;
                    int rBytes = 0;
                    try {
                        if (src instanceof File) {
                            Copy.__fileCopy_r(this.val$JXAextension, r, b, rBytes, this.val$JXAtmpPath, this.val$progress);
                        } else {
                            Copy.__fileCopy_r(inputStream, HTTPConnection, this.val$connection, r, b, rBytes, this.val$JXAtmpPath, this.val$progress);
                        }
                        this.val$JXAtmpPath.close();
                        if (src instanceof File) {
                            this.val$JXAextension.close();
                        } else if (this.val$closeBufferedStream) {
                            inputStream.close();
                        }
                        if (HTTPConnection instanceof HttpClient) {
                            this.val$getData.releaseConnection();
                        }
                        if (this.val$progress) {
                            readProgress.get(Thread.currentThread().getId()).put(Copy._key_read_string, "copying " + this.val$dst.getName());
                        }
                        FileHelper.___rawfileCopy(this.val$tmp, this.val$dst, true);
                        if (JXAenvUtils._debugSys) {
                            System.out.println("done.");
                        }
                    }
                    catch (IOException ex) {
                        if (JXAenvUtils._debugSys) {
                            ex.printStackTrace();
                        }
                        if (this.val$dst != null && this.val$dst.exists() && dstAltered) {
                            this.val$dst.delete();
                        }
                        JXAenvUtils._popExceptionToUser(false, Thread.currentThread(), ex);
                    }
                    finally {
                        if (this.val$tmp != null && this.val$tmp.exists()) {
                            this.val$tmp.delete();
                        }
                        Monitor monitor = fileThreads;
                        synchronized (monitor) {
                            readSync.get(Thread.currentThread().getId()).put(Copy._key_reading, false);
                            fileThreads.notify();
                        }
                    }
                }
            };
        }
    }
}

