/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jiga.xtended.kernel;

import java.io.Serializable;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Vector;
import net.sf.jiga.xtended.kernel.JXAenvUtils;

public class LongBitStack {
    protected final Map<Long, Long> _ALLBITS = Collections.synchronizedMap(new HashMap());
    private int _ALLBITSstack = 0;
    private static Long _TWO = 2L;
    private Long _ALLBITSRANGES = 0L;
    private Long _ALLBITSNORANGE = 0L;

    public LongBitStack() {
        this(0L);
    }

    public LongBitStack(Long offset) {
        while (offset.compareTo((long)Math.pow(_TWO.longValue(), this._ALLBITSstack + 1)) > 0) {
            ++this._ALLBITSstack;
        }
    }

    public int getBitsStackCurrentLevel() {
        return this._ALLBITSstack - 1;
    }

    public final Long _newBitRange() {
        Long newBit = (long)Math.pow(_TWO.longValue(), this._ALLBITSstack++);
        this._ALLBITSRANGES = this._ALLBITSRANGES | newBit;
        return newBit;
    }

    public final Long _newBit(Long range) {
        if ((this._ALLBITSRANGES & range) != range) {
            throw new IllegalArgumentException("invalid supplied range");
        }
        Long newBit = (long)Math.pow(_TWO.longValue(), this._ALLBITSstack++);
        if (!this._ALLBITS.containsKey(range)) {
            this._ALLBITS.put(range, 0L);
        }
        Long rangeMask = this._ALLBITS.get(range) | newBit;
        this._ALLBITS.put(range, rangeMask);
        this._ALLBITSNORANGE = this._ALLBITSNORANGE | newBit;
        return range | newBit;
    }

    public final Long _getAllBitRanges() {
        return this._ALLBITSRANGES;
    }

    public final Long _getAllBits() {
        return this._ALLBITSNORANGE;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final Long _getMask(Long forRange) {
        Long mask = 0L;
        Map<Long, Long> map = this._ALLBITS;
        synchronized (map) {
            for (Long range : this._ALLBITS.keySet()) {
                if ((forRange & range) == 0L) continue;
                mask = mask | this._ALLBITS.get(range);
            }
        }
        return mask;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final Long _getNotMask(Long forRange) {
        Long mask = 0L;
        Map<Long, Long> map = this._ALLBITS;
        synchronized (map) {
            for (Long range : this._ALLBITS.keySet()) {
                if ((forRange & range) == 0L) continue;
                mask = mask | this._ALLBITS.get(range);
            }
        }
        return mask;
    }

    public static String _toBitsString(Long integer) {
        Long s = integer;
        Vector<Character> sBits = new Vector<Character>();
        while (s.compareTo(1L) == 1) {
            int n = 0;
            while (Long.valueOf((long)Math.pow(_TWO.longValue(), n)).compareTo(s) <= 0) {
                ++n;
            }
            if (sBits.size() < --n + 1) {
                sBits.setSize(n + 1);
            }
            sBits.set(n, Character.valueOf('1'));
            s = s - (long)Math.pow(_TWO.longValue(), n);
        }
        if (s.equals(1L)) {
            if (sBits.isEmpty()) {
                sBits.add(Character.valueOf('1'));
            } else {
                sBits.set(0, Character.valueOf('1'));
            }
        }
        String bitsString = "";
        for (int i = 0; i < sBits.size(); ++i) {
            bitsString = (sBits.get(i) == null ? "0" : (Serializable)sBits.get(i)) + bitsString;
        }
        return bitsString;
    }

    public static String _toBitsString(Long integer, int fields) {
        String bitsString = LongBitStack._toBitsString(integer);
        for (int i = bitsString.length(); i < fields; ++i) {
            bitsString = "0" + bitsString;
        }
        return bitsString;
    }

    static {
        if (JXAenvUtils._debugSys) {
            System.err.println("BigBitStack test 7 bitsString: " + LongBitStack._toBitsString(7L, 4));
        }
    }
}

