/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jiga.xtended.kernel;

import java.math.BigInteger;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.zip.Checksum;
import net.sf.jiga.xtended.kernel.JXAenvUtils;

public abstract class SfChecksum
implements Checksum {
    MessageDigest md;
    boolean altered;
    long sum;

    public SfChecksum(String algorithm) {
        block2: {
            this.altered = false;
            this.sum = 0L;
            try {
                this.md = MessageDigest.getInstance(algorithm);
            }
            catch (NoSuchAlgorithmException ex) {
                if (!JXAenvUtils._debugSys) break block2;
                ex.printStackTrace();
            }
        }
    }

    @Override
    public void update(int b) {
        this.md.update((byte)b);
        this.altered = true;
    }

    @Override
    public void update(byte[] b, int off, int len) {
        this.md.update(b, off, len);
        this.altered = true;
    }

    @Override
    public long getValue() {
        this.sum = this.altered ? SfChecksum.decodeLong(this.md.digest()) : this.sum;
        this.altered = false;
        return this.sum;
    }

    @Override
    public void reset() {
        this.md.reset();
        this.altered = true;
    }

    public static long decodeLong(byte[] digestValue) {
        return new BigInteger(1, digestValue).longValue();
    }
}

