/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jiga.xtended.kernel;

import java.awt.event.ActionEvent;
import java.io.BufferedOutputStream;
import java.io.Closeable;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.PrintStream;
import java.io.PrintWriter;
import java.lang.reflect.InvocationTargetException;
import java.security.AccessControlContext;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.RejectedExecutionException;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.ScheduledThreadPoolExecutor;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.AbstractAction;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.SwingUtilities;
import net.sf.jiga.xtended.JXAException;
import net.sf.jiga.xtended.kernel.Console;
import net.sf.jiga.xtended.kernel.DebugMap;
import net.sf.jiga.xtended.kernel.ErrorListener;
import net.sf.jiga.xtended.kernel.FileHelper;
import net.sf.jiga.xtended.kernel.JXAenvUtils;
import net.sf.jiga.xtended.kernel.Monitor;
import net.sf.jiga.xtended.kernel.SpritesCacheManager;
import net.sf.jiga.xtended.kernel.Threaded;
import net.sf.jiga.xtended.ui.UIMessage;

public class ThreadWorks
implements Threaded {
    private static final AccessControlContext _acc = AccessController.getContext();
    public static final ThreadWorks securityTWKS = ThreadWorks._loadSecurityThreadWorks();
    long delay = 10L;
    TimeUnit timeunit = TimeUnit.MILLISECONDS;
    boolean isDaemon = false;
    String name;
    boolean highestPriority;
    private static UIMessage currentMessage = null;
    private static String previousMessage = "";
    public static Console c = new Console();
    protected static File cLogFile = null;
    public static PrintStream cLogFilePrintStream = c.getNewPrintStream(new ErrorListener(){

        @Override
        public void printStreamError(IOException e) {
            System.err.println(JXAenvUtils.log(cLogFile.getAbsolutePath() + " Kernel log file error : Printstream lost. " + e.getMessage() + " " + e.getCause(), JXAenvUtils.LVL.SYS_WRN));
        }
    });
    public final ThreadGroup workTG;
    private Monitor workMon;
    public ScheduledThreadPoolExecutor workDT;
    public static long _DEFAULT_TIMEOUT = 100L;
    public static TimeUnit _DEFAULT_TIMEOUT_UNIT = TimeUnit.SECONDS;

    private static <T> Callable<T> loaderRun(final Callable<T> r) {
        return new Callable<T>(){

            @Override
            public T call() {
                Object ret = null;
                try {
                    ret = r.call();
                    return ret;
                }
                catch (ExecutionException ex) {
                    throw ex;
                }
                finally {
                    return ret;
                }
            }
        };
    }

    @Override
    public boolean isMultiThreadingEnabled() {
        return JXAenvUtils._multiThreading;
    }

    @Override
    public void setMultiThreadingEnabled(boolean b) {
        JXAenvUtils._multiThreading = b;
    }

    @Override
    public Monitor[] getGroupMonitor() {
        return new Monitor[]{this.workMon};
    }

    @Override
    public void setGroupMonitor(Monitor ... tg) {
        this.workMon = tg[0];
    }

    private static ThreadWorks _loadSecurityThreadWorks() {
        return AccessController.doPrivileged(new PrivilegedAction<ThreadWorks>(){

            @Override
            public ThreadWorks run() {
                return new ThreadWorks("JXA_Security", true);
            }
        }, _acc);
    }

    public static final boolean isSDT() {
        return securityTWKS.isDT();
    }

    public static final void securizedInvokeAndWait(Runnable r) throws InterruptedException, TimeoutException, ExecutionException {
        securityTWKS.doAndWait(r);
    }

    public static final void securizedInvokeLater(Runnable r) {
        securityTWKS.doLater(r);
    }

    public static final void prioritizeThreadGroups(ThreadGroup up, ThreadGroup down) {
        if (up.getMaxPriority() > 1) {
            down.setMaxPriority(Math.min(down.getMaxPriority(), up.getMaxPriority() - 1));
            if (JXAenvUtils._debugSys) {
                System.out.println(down.toString() + " TG is pulled down to pty : " + down.getMaxPriority());
            }
        } else {
            up.setMaxPriority(Math.max(up.getMaxPriority(), down.getMaxPriority() + 1));
            if (JXAenvUtils._debugSys) {
                System.out.println(up.toString() + " TG is pushed up to pty : " + up.getMaxPriority());
            }
        }
    }

    private ScheduledThreadPoolExecutor newDispatcher(final String name) {
        int concurrentThreads = JXAenvUtils._multiThreading ? Runtime.getRuntime().availableProcessors() : 1;
        return new ScheduledThreadPoolExecutor(concurrentThreads, new ThreadFactory(){

            @Override
            public Thread newThread(Runnable r) {
                Thread t = new Thread(ThreadWorks.this.workTG, r, "TWKS-" + name + "-DT");
                t.setDaemon(ThreadWorks.this.isDaemon);
                return t;
            }
        });
    }

    protected void setDelay(long delay, TimeUnit timeunit) {
        this.delay = delay;
        this.timeunit = timeunit;
    }

    protected long getDelay() {
        return this.delay;
    }

    protected TimeUnit getTimeunit() {
        return this.timeunit;
    }

    public void setIsDaemon(boolean isDaemon) {
        boolean b = this.isDaemon;
        this.isDaemon = isDaemon;
        if (b != isDaemon) {
            this.cancelAllSchedules();
        }
    }

    public ThreadWorks(String name) {
        this(name, false, (Monitor)null);
    }

    public ThreadWorks(String name, Monitor monitor) {
        this(name, false, monitor);
    }

    private ThreadWorks(String name, boolean highestPriority, Monitor monitor) {
        this.workTG = new ThreadGroup("TWKS-" + name + "-TG");
        this.workMon = monitor;
        this.highestPriority = highestPriority;
        this.initThreadWorks(name);
    }

    private ThreadWorks(String name, boolean highestPriority) {
        this.workTG = new ThreadGroup("TWKS-" + name + "-TG");
        this.workMon = new Monitor();
        this.highestPriority = highestPriority;
        this.initThreadWorks(name);
    }

    public boolean checkAlive() {
        try {
            this.workDT.schedule(new Runnable(){

                @Override
                public void run() {
                }
            }, 0L, TimeUnit.MILLISECONDS);
            return true;
        }
        catch (RejectedExecutionException ex) {
            int n = this.workDT.shutdownNow().size();
            System.err.println(JXAenvUtils.log(n + " tasks have been purged because the timer was dead. (TWKS " + this.name + ")", JXAenvUtils.LVL.SYS_NOT));
            if (DebugMap._getInstance().isDebugLevelEnabled(DebugMap._getInstance()._VOID)) {
                ex.printStackTrace();
            }
            this.initThreadWorks(this.name);
            return false;
        }
    }

    private void initThreadWorks(String name) {
        this.workDT = this.newDispatcher(name);
        this.name = name;
        if (!this.highestPriority) {
            ThreadWorks.prioritizeThreadGroups(ThreadWorks.securityTWKS.workTG, this.workTG);
        }
    }

    public static void cLogFilePrintStackStrace(Throwable throwable) {
        throwable.printStackTrace(cLogFilePrintStream);
    }

    public static void _uncaughtException(final boolean modal, final Thread thread, final Throwable throwable) {
        ThreadWorks.cLogFilePrintStackStrace(throwable);
        Runnable r = new Runnable(){

            @Override
            public void run() {
                ThreadWorks.__uncaughtException(modal, thread, throwable);
            }
        };
        if (Swing.isEventDispatchThread()) {
            r.run();
        } else {
            Swing.invokeLater(r);
        }
    }

    private static void __uncaughtException(boolean modal, Thread thread, Throwable throwable) {
        throwable.printStackTrace();
        if (currentMessage instanceof UIMessage) {
            if (currentMessage.isShowing()) {
                currentMessage.dispose();
                previousMessage = previousMessage + "\r\n\r\n";
            } else {
                previousMessage = "";
            }
        } else {
            previousMessage = "";
        }
        String stack = "";
        for (StackTraceElement ste : throwable.getStackTrace()) {
            stack = stack + "\n" + ste;
        }
        String stack_c = "";
        if (throwable.getCause() instanceof Throwable) {
            for (StackTraceElement ste : throwable.getCause().getStackTrace()) {
                stack_c = stack_c + "\n" + ste;
            }
        }
        String msg = "an unexpected exception has been caught : " + throwable.getClass().getName() + " : " + throwable.getMessage() + " \n\r" + stack + " \n in Thread " + thread.getName() + (throwable.getCause() instanceof Throwable ? " caused by : " + throwable.getCause().getClass().getName() + " : " + throwable.getCause().getMessage() + "\n\r" + stack_c : "");
        previousMessage = previousMessage + msg;
        currentMessage = new UIMessage(modal, (Object)previousMessage, null, 1);
        currentMessage.setSize(500, 150);
        currentMessage.repaint();
    }

    protected static void cLogFile_open(String name) {
        FileOutputStream logOutput_fos = null;
        cLogFile = new File(FileHelper._USERHOMESTOREDIRECTORY, "log_" + name + ".txt");
        try {
            FileHelper._makeWritable(cLogFile);
            logOutput_fos = new FileOutputStream(cLogFile, true);
            logOutput_fos.getChannel().truncate(102400L);
            PrintWriter logOutput = new PrintWriter(new BufferedOutputStream(logOutput_fos));
            c.setOutput(logOutput);
            logOutput.println();
            logOutput.println("Log started on " + new Date(System.currentTimeMillis()).toString());
        }
        catch (IOException ex) {
            ex.printStackTrace();
        }
    }

    protected static void cLogFile_close() {
        PrintWriter p = c.setOutput(null);
        if (p instanceof Closeable) {
            try {
                ((Closeable)p).close();
            }
            catch (IOException ex) {
                ex.printStackTrace();
            }
        }
    }

    public void uncaughtException(Thread thread, Throwable throwable) {
        ThreadWorks._uncaughtException(true, thread, throwable);
    }

    public boolean isDT() {
        return Thread.currentThread().getThreadGroup().equals(this.workTG);
    }

    public void doAndWait(Runnable r) throws InterruptedException, TimeoutException, ExecutionException {
        this.doAndWait(r, null);
    }

    public static <T> T doAndWaitReturn(ThreadWorks twks, Callable<T> r) throws InterruptedException, InvocationTargetException, ExecutionException, TimeoutException {
        return ThreadWorks.doAndWaitReturn(twks, r, null);
    }

    public void doAndWait(Runnable r, SpritesCacheManager cacheHandler) throws InterruptedException, TimeoutException, ExecutionException {
        this.doAndWait(r, cacheHandler, _DEFAULT_TIMEOUT, _DEFAULT_TIMEOUT_UNIT);
    }

    public void doAndWait(final Runnable r, SpritesCacheManager cacheHandler, long timeout, TimeUnit timeoutunit) throws InterruptedException, TimeoutException, ExecutionException {
        ThreadWorks.doAndWaitReturn(this, new Callable<Runnable>(){

            @Override
            public Runnable call() {
                r.run();
                return r;
            }
        }, cacheHandler, timeout, timeoutunit);
    }

    public static <T> T doAndWaitReturn(ThreadWorks twks, Callable<T> r, SpritesCacheManager cacheHandler) throws ExecutionException, TimeoutException, InterruptedException {
        return ThreadWorks.doAndWaitReturn(twks, r, cacheHandler, _DEFAULT_TIMEOUT, _DEFAULT_TIMEOUT_UNIT);
    }

    public static <T> T doAndWaitReturn(ThreadWorks twks, final Callable<T> r, final SpritesCacheManager cacheHandler, long timeout, TimeUnit timeoutunit) throws ExecutionException, TimeoutException, InterruptedException {
        twks.checkAlive();
        if (twks.isDT()) {
            throw new JXAException("can't call doAndWait on the work Dispatcher Thread (DT).");
        }
        Callable<T> rCache = ThreadWorks.loaderRun(new Callable<T>(){

            @Override
            public T call() throws Exception {
                if (cacheHandler != null) {
                    try {
                        return cacheHandler.memorySensitiveCallback("call", r, new Object[0], new Class[0]);
                    }
                    catch (Throwable ex) {
                        throw new Exception(ex);
                    }
                }
                return r.call();
            }
        });
        ScheduledFuture<T> s = twks.workDT.schedule(rCache, 0L, twks.timeunit);
        return (T)s.get(timeout, timeoutunit);
    }

    public void doLater(Runnable r) {
        this.doLater(r, null);
    }

    public void doLater(final Runnable r, SpritesCacheManager cacheHandler) {
        this.doLaterReturn(new Callable(){

            public Object call() throws Exception {
                r.run();
                return null;
            }
        }, cacheHandler);
    }

    public <T> ScheduledFuture<T> doLaterReturn(final Callable<T> r, final SpritesCacheManager cacheHandler) {
        this.checkAlive();
        Callable<T> rCache = ThreadWorks.loaderRun(new Callable<T>(){

            @Override
            public T call() throws Exception {
                if (cacheHandler != null) {
                    try {
                        return cacheHandler.memorySensitiveCallback("call", r, new Object[0], new Class[0]);
                    }
                    catch (Throwable ex) {
                        ex.printStackTrace();
                    }
                } else {
                    return r.call();
                }
                return null;
            }
        });
        return this.workDT.schedule(rCache, this.delay, this.timeunit);
    }

    public void cancelAllSchedules() {
        ScheduledThreadPoolExecutor workDT = this.workDT;
        this.workDT = this.newDispatcher(this.name);
        workDT.shutdownNow();
    }

    public static class Lengthy {
        private long MILLIS_TO_SHOW_LENGTHY_OPERATION_POPUP = 5000L;

        public void setMillisToShowLengthyOperationPopup(long millis) {
            this.MILLIS_TO_SHOW_LENGTHY_OPERATION_POPUP = millis;
        }

        public long getMillisToShowLengthyOperationPopup() {
            return this.MILLIS_TO_SHOW_LENGTHY_OPERATION_POPUP;
        }

        public JDialog showPopupLengthyOperation(final Thread t, JComponent parent, int popupLocation) {
            return UIMessage.showLightPopupMessage(new JLabel("Running Task..."), new AbstractAction("Abort", UIMessage._getIcon(51, true)){

                @Override
                public void actionPerformed(ActionEvent e) {
                    t.interrupt();
                }
            }, parent, popupLocation);
        }
    }

    public static interface SwingStaticReturnException<T> {
        public T run() throws Throwable;
    }

    public static interface SwingStaticReturn<T> {
        public T run();
    }

    public static class Swing {
        public static boolean isEventDispatchThread() {
            return SwingUtilities.isEventDispatchThread();
        }

        public static void invokeLater(Runnable r) {
            SwingUtilities.invokeLater(r);
        }

        public static void invokeAndWait(Runnable r) throws InterruptedException, InvocationTargetException {
            if (Swing.isEventDispatchThread()) {
                throw new JXAException("Illegal call to invokeAndWait while being on the Event Dispatcher Thread.");
            }
            SwingUtilities.invokeAndWait(r);
        }

        public static <T> T invokeSwingAndReturnException(final SwingStaticReturnException<T> r) throws InterruptedException, InvocationTargetException {
            final HashMap ret = new HashMap();
            ret.put("return", null);
            ret.put("throw", null);
            Runnable rSw = new Runnable(){

                @Override
                public void run() {
                    try {
                        ret.put("return", r.run());
                    }
                    catch (Throwable ex1) {
                        ret.put("throw", ex1);
                    }
                }
            };
            if (Swing.isEventDispatchThread()) {
                try {
                    return r.run();
                }
                catch (Throwable ex) {
                    throw new InvocationTargetException(ex);
                }
            }
            Swing.invokeAndWait(rSw);
            if (ret.get("throw") instanceof Throwable) {
                throw new InvocationTargetException((Throwable)ret.get("throw"));
            }
            return (T)ret.get("return");
        }

        public static <T> T invokeSwingAndReturn(final SwingStaticReturn<T> r) throws InterruptedException, InvocationTargetException {
            final HashMap<String, Object> ret = new HashMap<String, Object>(Collections.singletonMap("return", null));
            Runnable rSw = new Runnable(){

                @Override
                public void run() {
                    ret.put("return", r.run());
                }
            };
            if (Swing.isEventDispatchThread()) {
                return r.run();
            }
            Swing.invokeAndWait(rSw);
            return (T)ret.get("return");
        }
    }

    public static abstract class DoStaticReturn<T>
    implements Callable<T> {
        public abstract T run() throws Throwable;

        @Override
        public final T call() throws Exception {
            try {
                return this.run();
            }
            catch (Throwable ex) {
                Logger.getLogger("jxa.logger").log(Level.SEVERE, null, ex);
                return null;
            }
        }
    }
}

