/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jiga.xtended.ui;

import java.awt.AlphaComposite;
import java.awt.Color;
import java.awt.Composite;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.MediaTracker;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.geom.AffineTransform;
import java.awt.image.BufferedImage;
import java.io.File;
import java.io.IOException;
import java.lang.ref.PhantomReference;
import java.lang.ref.Reference;
import java.lang.ref.ReferenceQueue;
import java.net.URISyntaxException;
import java.net.URL;
import javax.imageio.ImageIO;
import javax.swing.JComponent;
import net.sf.jiga.xtended.kernel.JXAenvUtils;
import net.sf.jiga.xtended.kernel.Monitor;
import net.sf.jiga.xtended.kernel.Resource;
import net.sf.jiga.xtended.kernel.Threaded;
import net.sf.jiga.xtended.ui.DisplayInterface;
import net.sf.jiga.xtended.ui.UIMessage;

public class Display
extends JComponent
implements Resource,
Threaded,
DisplayInterface {
    private MediaTracker mt;
    private Image display;
    private PhantomReference phantomImage;
    private AffineTransform tx;
    private Color background = Color.LIGHT_GRAY;
    private Dimension originalBox;
    private BufferedImage bgImg;
    private ReferenceQueue<? extends Image> refQueue = new ReferenceQueue();
    private String text = null;
    private int align = 0;
    private Point pad;
    private transient boolean valid = false;
    boolean opaque = super.isOpaque();
    private AffineTransform currentTx = new AffineTransform();
    private Dimension currentImageSize = new Dimension();
    long hash = System.nanoTime();
    private transient Monitor imageSynch;

    public void setPadding(Point pad) {
        this.pad = pad;
    }

    public void setAlign(int align) {
        this.align = align;
    }

    public void setText(String text) {
        this.text = text;
    }

    @Override
    public void setForeground(Color fg) {
        super.setForeground(fg);
    }

    @Override
    public void setFont(Font font) {
        super.setFont(font);
    }

    public String getText() {
        return this.text;
    }

    public static DisplayInterface _Display(String filename, AffineTransform tx) throws IOException {
        return new Display(filename, tx);
    }

    private Display(String filename, AffineTransform tx) throws IOException {
        this(ImageIO.read(new File(filename)), tx);
    }

    public static DisplayInterface _Display(URL filename, AffineTransform tx) throws IOException, URISyntaxException {
        return new Display(filename, tx);
    }

    private Display(URL filename, AffineTransform tx) throws IOException, URISyntaxException {
        this(ImageIO.read(filename), tx);
    }

    public static DisplayInterface _Display(String filename, AffineTransform tx, Dimension size) throws IOException {
        return new Display(filename, tx, size);
    }

    private Display(String filename, AffineTransform tx, Dimension size) throws IOException {
        this(ImageIO.read(new File(filename)), tx, size);
    }

    public static DisplayInterface _Display(URL filename, AffineTransform tx, Dimension size) throws IOException, URISyntaxException {
        return new Display(filename, tx, size);
    }

    private Display(URL filename, AffineTransform tx, Dimension size) throws IOException, URISyntaxException {
        this(ImageIO.read(filename), tx, size);
    }

    public static DisplayInterface _Display(Image pdisplay, AffineTransform ptx) {
        return new Display(pdisplay, ptx);
    }

    private Display(Image pdisplay, AffineTransform ptx) {
        this.setGroupMonitor(new Monitor());
        this.display = pdisplay;
        this.tx = ptx;
        this.loadResource();
        this.setPreferredSize(this.originalBox);
        this.setSize(this.getPreferredSize());
    }

    public static DisplayInterface _Display(Image pdisplay, AffineTransform ptx, Dimension psize) {
        return new Display(pdisplay, ptx, psize);
    }

    private Display(Image pdisplay, AffineTransform ptx, Dimension psize) {
        this.setPreferredSize(psize);
        this.setSize(this.getPreferredSize());
        this.setGroupMonitor(new Monitor());
        this.display = pdisplay;
        this.tx = ptx;
        this.loadResource();
    }

    public void finalize() {
        this.clearResource();
        try {
            super.finalize();
        }
        catch (Throwable ex) {
            ex.printStackTrace();
        }
    }

    public void setBGColor(Color color) {
        this.background = color;
    }

    @Override
    public Image getPicture() {
        return this.display;
    }

    public void setTX(AffineTransform tx) {
        this.tx = tx;
    }

    public AffineTransform getTX() {
        return this.tx;
    }

    @Override
    public void setOpaque(boolean isOpaque) {
        super.setOpaque(isOpaque);
        this.opaque = isOpaque;
    }

    @Override
    public boolean isOpaque() {
        return this.opaque;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void paintComponent(Graphics g1) {
        if (!this.valid) {
            return;
        }
        Monitor monitor = this.imageSynch;
        Rectangle clip = g1.getClipBounds();
        try {
            Monitor monitor2 = monitor;
            synchronized (monitor2) {
                Dimension currentSize = new Dimension(this.getWidth(), this.getHeight());
                Graphics2D g = (Graphics2D)g1;
                g.clipRect(0, 0, currentSize.width, currentSize.height);
                g.setBackground(this.background);
                Composite cps = g.getComposite();
                g.setColor(g.getBackground());
                if (this.isOpaque()) {
                    g.fillRect(0, 0, currentSize.width, currentSize.height);
                }
                g.setColor(Color.BLACK);
                AffineTransform bgResizeTx = AffineTransform.getScaleInstance((double)currentSize.width / (double)this.bgImg.getWidth(this), (double)currentSize.height / (double)this.bgImg.getHeight(this));
                AffineTransform dispResizeTx = AffineTransform.getScaleInstance((double)currentSize.width / (double)this.display.getWidth(this), (double)currentSize.height / (double)this.display.getHeight(this));
                if (!this.currentImageSize.equals(currentSize)) {
                    this.mt.addImage(this.bgImg, this.hashCode(), currentSize.width, currentSize.height);
                }
                if (!this.tx.equals(this.currentTx)) {
                    Rectangle box = this.tx.createTransformedShape(new Rectangle(0, 0, this.display.getWidth(this), this.display.getHeight(this))).getBounds();
                    if (!new Dimension(this.display.getWidth(this), this.display.getHeight(this)).equals(box.getSize())) {
                        this.mt.addImage(this.display, this.hashCode(), box.width, box.height);
                    }
                    this.mt.waitForAll();
                    cps = g.getComposite();
                    g.setComposite(AlphaComposite.getInstance(3, 0.33f));
                    if (this.opaque) {
                        g.drawImage(this.bgImg, bgResizeTx, this);
                    }
                    g.setComposite(cps);
                    g.drawImage(this.display, this.tx, this);
                    this.currentTx = this.tx;
                } else {
                    if (!this.currentImageSize.equals(currentSize)) {
                        this.mt.addImage(this.display, this.hashCode(), currentSize.width, currentSize.height);
                    }
                    this.mt.waitForAll();
                    cps = g.getComposite();
                    g.setComposite(AlphaComposite.getInstance(3, 0.33f));
                    if (this.opaque) {
                        g.drawImage(this.bgImg, bgResizeTx, this);
                    }
                    g.setComposite(cps);
                    g.drawImage(this.display, dispResizeTx, this);
                    this.currentImageSize = currentSize;
                }
                this.mt.removeImage(this.bgImg, this.hashCode());
                this.mt.removeImage(this.display, this.hashCode());
                monitor.notify();
            }
        }
        catch (InterruptedException ex) {
            block37: {
                try {
                    if (!JXAenvUtils._debugSys) break block37;
                    ex.printStackTrace();
                }
                catch (Throwable throwable) {
                    if (this.text instanceof String) {
                        g1.setClip(clip);
                        clip.grow(-this.pad.x, -this.pad.y);
                        FontMetrics fm = g1.getFontMetrics();
                        Point loc = new Point(clip.getLocation());
                        if ((this.align & UIMessage._RIGHT_) != 0) {
                            loc.x += clip.width - fm.stringWidth(this.text);
                        } else if ((this.align & UIMessage._LEFT_) == 0) {
                            loc.x += (int)clip.getCenterX() - Math.round((float)fm.stringWidth(this.text) / 2.0f);
                        }
                        if ((this.align & UIMessage._BOTTOM_) != 0) {
                            loc.y += clip.height - fm.getHeight();
                        } else if ((this.align & UIMessage._TOP_) == 0) {
                            loc.y += (int)clip.getCenterY() - Math.round((float)fm.getHeight() / 2.0f);
                        }
                        g1.setColor(this.getForeground());
                        g1.setFont(this.getFont());
                        g1.drawString(this.text, loc.x, loc.y);
                    }
                    g1.setClip(clip);
                    throw throwable;
                }
            }
            if (this.text instanceof String) {
                g1.setClip(clip);
                clip.grow(-this.pad.x, -this.pad.y);
                FontMetrics fm = g1.getFontMetrics();
                Point loc = new Point(clip.getLocation());
                if ((this.align & UIMessage._RIGHT_) != 0) {
                    loc.x += clip.width - fm.stringWidth(this.text);
                } else if ((this.align & UIMessage._LEFT_) == 0) {
                    loc.x += (int)clip.getCenterX() - Math.round((float)fm.stringWidth(this.text) / 2.0f);
                }
                if ((this.align & UIMessage._BOTTOM_) != 0) {
                    loc.y += clip.height - fm.getHeight();
                } else if ((this.align & UIMessage._TOP_) == 0) {
                    loc.y += (int)clip.getCenterY() - Math.round((float)fm.getHeight() / 2.0f);
                }
                g1.setColor(this.getForeground());
                g1.setFont(this.getFont());
                g1.drawString(this.text, loc.x, loc.y);
            }
            g1.setClip(clip);
        }
        if (this.text instanceof String) {
            g1.setClip(clip);
            clip.grow(-this.pad.x, -this.pad.y);
            FontMetrics fm = g1.getFontMetrics();
            Point loc = new Point(clip.getLocation());
            if ((this.align & UIMessage._RIGHT_) != 0) {
                loc.x += clip.width - fm.stringWidth(this.text);
            } else if ((this.align & UIMessage._LEFT_) == 0) {
                loc.x += (int)clip.getCenterX() - Math.round((float)fm.stringWidth(this.text) / 2.0f);
            }
            if ((this.align & UIMessage._BOTTOM_) != 0) {
                loc.y += clip.height - fm.getHeight();
            } else if ((this.align & UIMessage._TOP_) == 0) {
                loc.y += (int)clip.getCenterY() - Math.round((float)fm.getHeight() / 2.0f);
            }
            g1.setColor(this.getForeground());
            g1.setFont(this.getFont());
            g1.drawString(this.text, loc.x, loc.y);
        }
        g1.setClip(clip);
    }

    public boolean equals(Object o) {
        return o == null ? false : this.hashCode() == o.hashCode();
    }

    public int hashCode() {
        return (int)this.hash;
    }

    @Override
    public boolean isMultiThreadingEnabled() {
        return JXAenvUtils._multiThreading;
    }

    @Override
    public void setMultiThreadingEnabled(boolean b) {
        JXAenvUtils._multiThreading = b;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Object loadResource() {
        Monitor monitor = this.imageSynch;
        try {
            Monitor monitor2 = monitor;
            synchronized (monitor2) {
                block11: {
                    if (this.display != null) break block11;
                    Object var3_4 = null;
                }
                this.phantomImage = new PhantomReference<Image>(this.display, this.refQueue);
                String icon = "images/duke.gif";
                this.bgImg = ImageIO.read(this.getClass().getResourceAsStream(icon));
                this.mt = new MediaTracker(this);
                this.mt.addImage(this.bgImg, this.hashCode());
                this.mt.addImage(this.display, this.hashCode());
                this.mt.waitForAll();
                this.mt.removeImage(this.bgImg, this.hashCode());
                this.mt.removeImage(this.display, this.hashCode());
                this.tx = this.tx != null ? this.tx : AffineTransform.getScaleInstance(1.0, 1.0);
                this.originalBox = new Dimension(this.display.getWidth(this), this.display.getHeight(this));
                this.valid = true;
                monitor.notify();
                // MONITOREXIT @DISABLED, blocks:[0, 3, 5] lbl23 : MonitorExitStatement: MONITOREXIT : var2_2
            }
        }
        catch (Exception ex) {
            if (JXAenvUtils._debugSys) {
                ex.printStackTrace();
            }
        }
        finally {
            return this.display;
        }
    }

    @Override
    public Object clearResource() {
        Reference<? extends Image> ref;
        while ((ref = this.refQueue.poll()) instanceof Reference) {
            ref.clear();
        }
        return null;
    }

    @Override
    public boolean isResourceLoaded() {
        return true;
    }

    @Override
    public JComponent getJComponentDisplay() {
        return this;
    }

    @Override
    public Monitor[] getGroupMonitor() {
        return new Monitor[]{this.imageSynch};
    }

    @Override
    public void setGroupMonitor(Monitor ... tg) {
        this.imageSynch = tg[0];
    }
}

