/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jiga.xtended.ui;

import java.awt.Cursor;
import java.awt.datatransfer.Clipboard;
import java.awt.datatransfer.ClipboardOwner;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.Transferable;
import java.awt.datatransfer.UnsupportedFlavorException;
import java.awt.dnd.DragSource;
import java.awt.dnd.DropTarget;
import java.awt.dnd.DropTargetAdapter;
import java.awt.dnd.DropTargetDragEvent;
import java.awt.dnd.DropTargetDropEvent;
import java.awt.dnd.DropTargetEvent;
import java.io.IOException;
import java.util.Arrays;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.JComponent;
import javax.swing.TransferHandler;
import net.sf.jiga.xtended.kernel.JXAenvUtils;
import net.sf.jiga.xtended.ui.Ant;
import net.sf.jiga.xtended.ui.UIMessage;

public final class DnDHandler
extends TransferHandler
implements ClipboardOwner {
    Ant ant;
    long hash = System.nanoTime();
    DataFlavor[] dfs = new DataFlavor[]{DataFlavor.imageFlavor, DataFlavor.javaFileListFlavor, DataFlavor.stringFlavor};

    public DnDHandler(Ant ant) {
        this.ant = ant;
        this.setImportedDataFlavors(ant.getTransferDataFlavors());
    }

    public int hashCode() {
        return (int)this.hash;
    }

    public boolean equals(Object o) {
        return o != null ? o.hashCode() == this.hashCode() : false;
    }

    @Override
    public void exportToClipboard(JComponent pcomp, Clipboard pclip, int action) throws IllegalStateException {
        Clipboard clip = pclip;
        JComponent comp = pcomp;
        TransferHandler th = comp.getTransferHandler();
        if (th != null && th.hashCode() == this.hashCode() && this.ant instanceof Transferable) {
            switch (action) {
                case 1: {
                    clip.setContents(this.ant, this);
                    break;
                }
            }
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean importData(JComponent comp, Transferable t) {
        boolean ret = false;
        if (this.ant instanceof Transferable) {
            DataFlavor df = null;
            for (DataFlavor tdf : t.getTransferDataFlavors()) {
                if (!this.ant.isDataFlavorSupported(tdf)) continue;
                df = tdf;
                break;
            }
            if (df == null) {
                ret = false;
                System.err.println(JXAenvUtils.log("unsupported object : " + Arrays.toString(t.getTransferDataFlavors()), JXAenvUtils.LVL.SYS_NOT));
            } else {
                long wait = UIMessage.displayWaiting("dropping...", comp);
                try {
                    this.ant.open(t.getTransferData(df));
                    ret = true;
                }
                catch (UnsupportedFlavorException ex) {
                    Logger.getLogger("jxa.logger").log(Level.ALL, null, ex);
                    ret = false;
                }
                catch (IOException ex) {
                    Logger.getLogger("jxa.logger").log(Level.ALL, null, ex);
                    ret = false;
                }
                finally {
                    UIMessage.kill(wait);
                }
            }
        }
        return ret;
    }

    public void addDropTarget(final JComponent comp) {
        this.addDropTarget(comp, new DropTargetAdapter(){

            @Override
            public void dragExit(DropTargetEvent dte) {
                super.dragExit(dte);
                dte.getDropTargetContext().getComponent().setCursor(Cursor.getDefaultCursor());
            }

            @Override
            public void dragOver(DropTargetDragEvent dtde) {
                int dragAct = dtde.getDropAction();
                dtde.acceptDrag(dragAct);
                System.err.println("Drag ev : " + Arrays.toString(dtde.getTransferable().getTransferDataFlavors()));
                dtde.getDropTargetContext().getComponent().setCursor(dragAct == 0x40000000 ? DragSource.DefaultLinkDrop : (dragAct == 1 ? DragSource.DefaultCopyDrop : (dragAct == 0x40000000 ? DragSource.DefaultLinkDrop : DragSource.DefaultMoveDrop)));
            }

            @Override
            public void drop(DropTargetDropEvent dtde) {
                System.err.println("Drop ev : " + dtde);
                dtde.acceptDrop(dtde.getDropAction());
                dtde.dropComplete(DnDHandler.this.importData(comp, dtde.getTransferable()));
                dtde.getDropTargetContext().getComponent().setCursor(Cursor.getDefaultCursor());
            }
        });
    }

    public void addDropTarget(JComponent comp, DropTargetAdapter dtadp) {
        String dataFlavors = "";
        String sep = "";
        for (DataFlavor df : this.getImportedDataFlavors()) {
            if (df.equals(DataFlavor.stringFlavor) || df.equals(DataFlavor.javaFileListFlavor)) continue;
            dataFlavors = dataFlavors + sep + df.getHumanPresentableName();
            sep = ", ";
        }
        comp.setToolTipText("Please drop here " + dataFlavors + " !");
        comp.setDropTarget(new DropTarget(comp, dtadp));
    }

    public void setImportedDataFlavors(DataFlavor[] dfs) {
        this.dfs = dfs;
    }

    public DataFlavor[] getImportedDataFlavors() {
        return this.dfs;
    }

    @Override
    public void lostOwnership(Clipboard clipboard, Transferable contents) {
    }
}

