/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jiga.xtended.ui;

import java.awt.Dimension;
import java.awt.DisplayMode;
import java.awt.GraphicsConfiguration;
import java.awt.GraphicsDevice;
import java.awt.GraphicsEnvironment;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.UnsupportedFlavorException;
import java.awt.event.ActionEvent;
import java.io.File;
import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.net.URL;
import java.security.AccessControlContext;
import java.security.AccessController;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import java.util.ArrayList;
import java.util.List;
import java.util.logging.LogManager;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import net.sf.jiga.xtended.kernel.ExtensionsClassLoader;
import net.sf.jiga.xtended.kernel.ExtensionsInstaller;
import net.sf.jiga.xtended.kernel.JXAenvUtils;
import net.sf.jiga.xtended.kernel.ThreadWorks;
import net.sf.jiga.xtended.kernel.env;
import net.sf.jiga.xtended.ui.AntFrame;
import net.sf.jiga.xtended.ui.AntHandler;
import net.sf.jiga.xtended.ui.Display;
import net.sf.jiga.xtended.ui.DisplayInterface;
import net.sf.jiga.xtended.ui.UIMessage;

public final class JFCFrame
extends JFrame
implements AntFrame {
    static AccessControlContext _acc = AccessController.getContext();
    private static boolean restartingEnv;
    JXAenvUtils envUtils = new JXAenvUtils(Thread.currentThread().getContextClassLoader());
    AntFrame targetFrame = null;
    static String[] appClasspath;
    String[] args = null;

    @Override
    public final void destroyComponents() {
        if (this.targetFrame != null && this.targetFrame.isInitialized()) {
            this.targetFrame.destroyComponents();
        }
        this.getContentPane().removeAll();
        this.getContentPane().validate();
        this.uninstall();
    }

    @Override
    public final boolean isInitialized() {
        if (this.targetFrame != null) {
            return this.targetFrame.isInitialized();
        }
        return false;
    }

    private void uninstall() {
        this.envUtils.unloadEnvironment(!restartingEnv);
    }

    private void install() {
        this.envUtils.loadEnvironment();
    }

    private JFCFrame() {
        super(JXAenvUtils._defaultGC);
        LogManager.getLogManager().addLogger(this.envUtils);
    }

    public JFCFrame(String antframe, String[] args) {
        this();
        this.args = args;
        this.envUtils.antClassName = antframe;
    }

    public JFCFrame(AntFrame antframe, String[] args) {
        this();
        this.targetFrame = antframe;
        this.args = args;
        this.envUtils.antClassName = antframe.getClass().getName();
    }

    public JFCFrame(String[] args) {
        this();
        this.args = args;
        this.envUtils.antClassName = JXAenvUtils._getSysValue("antframe");
    }

    @Override
    public final JFrame getFrame() {
        if (this.targetFrame == null) {
            return this;
        }
        return this.targetFrame.getFrame();
    }

    public static void _restart(AntFrame f) {
        restartingEnv = true;
        JFrame j = f.getFrame();
        if (j != null && j instanceof JFCFrame) {
            f = (JFCFrame)j;
        }
        f.stop();
        f.destroyComponents();
        f.initComponents();
        f.start();
        restartingEnv = false;
    }

    @Override
    public final void initComponents() {
        try {
            this.getContentPane().removeAll();
            this.validate();
            File path = new File(this.envUtils.getJXAenvPath() + File.separator + this.envUtils.antClassName);
            path.mkdirs();
            this.envUtils.setJXAenvPath(path.getAbsolutePath());
            if (appClasspath == null) {
                appClasspath = this.envUtils.getClasspathArray();
                ArrayList<URL> urls = new ArrayList<URL>();
                for (String jar : appClasspath) {
                    File n = new File(jar);
                    if (!n.isFile()) continue;
                    urls.add(n.toURI().toURL());
                }
                this.envUtils.addEnvJars(urls.toArray(new URL[0]));
            }
            this.envUtils.showSplash();
            this.install();
            this.envUtils.hideSplash();
            if (this.targetFrame == null) {
                this.targetFrame = AccessController.doPrivileged(new PrivilegedExceptionAction<AntFrame>(){

                    @Override
                    public AntFrame run() throws ClassNotFoundException, InstantiationException, IllegalAccessException, NoSuchMethodException, IllegalArgumentException, InvocationTargetException {
                        AntFrame a = ExtensionsClassLoader._proxyClass(ExtensionsClassLoader.forName(JFCFrame.this.envUtils.antClassName).getConstructor(String[].class).newInstance(new Object[]{JFCFrame.this.args}), AntFrame.class);
                        return a;
                    }
                }, _acc);
            } else if (this.targetFrame.isInitialized()) {
                return;
            }
            if (this.targetFrame.shutdownHook() != null) {
                this.envUtils.addPreUEnvLayer(this.targetFrame.shutdownHook());
            }
            this.targetFrame.setFrame(this);
            JXAenvUtils._switchToClassLoader(ExtensionsClassLoader.getInstance().getClassLoader());
            AntHandler._load(this.targetFrame, this.targetFrame.getSplash(), null, this.targetFrame.getLoadLayers());
            this.targetFrame.initComponents();
        }
        catch (Exception ex) {
            if (ex instanceof PrivilegedActionException) {
                ex = ((PrivilegedActionException)ex).getException();
            }
            JXAenvUtils._popExceptionToUser(true, Thread.currentThread(), ex);
        }
    }

    @Override
    public final boolean open(Object data) {
        if (this.targetFrame != null && this.targetFrame.isInitialized()) {
            return this.targetFrame.open(data);
        }
        return false;
    }

    @Override
    public final boolean save(String file) {
        if (this.targetFrame != null && this.targetFrame.isInitialized()) {
            return this.targetFrame.save(file);
        }
        return false;
    }

    @Override
    public final void start() {
        if (this.targetFrame != null) {
            assert (this.targetFrame.isInitialized()) : "Maybe an error occured while init() was called or set the variable \"AntFrame.initialized\" to true).  Set -Djxa.debugSys=true to log system errors !";
            this.targetFrame.start();
        }
    }

    @Override
    public final void stop() {
        if (this.targetFrame != null && this.targetFrame.isInitialized()) {
            this.targetFrame.stop();
        }
    }

    @Override
    public final DataFlavor[] getTransferDataFlavors() {
        if (this.targetFrame != null && this.targetFrame.isInitialized()) {
            return this.targetFrame.getTransferDataFlavors();
        }
        return null;
    }

    @Override
    public final boolean isDataFlavorSupported(DataFlavor flavor) {
        if (this.targetFrame != null && this.targetFrame.isInitialized()) {
            return this.targetFrame.isDataFlavorSupported(flavor);
        }
        return false;
    }

    @Override
    public final Object getTransferData(DataFlavor flavor) throws UnsupportedFlavorException, IOException {
        if (this.targetFrame != null && this.targetFrame.isInitialized()) {
            return this.targetFrame.getTransferData(flavor);
        }
        return null;
    }

    @Override
    public final void setFrame(JFrame frame) {
        if (this.targetFrame != null) {
            this.targetFrame.setFrame(frame);
        }
    }

    @Override
    public final Runnable shutdownHook() {
        if (this.targetFrame != null) {
            return this.targetFrame.shutdownHook();
        }
        return null;
    }

    public static boolean parseJVMArgs(String[] args, int index) {
        String arg = args[index];
        if (arg != null && arg.matches("-D.*")) {
            int i = arg.indexOf("=");
            String property = arg.substring(2, i != -1 ? i : arg.length());
            String value = arg.substring(i + 1);
            if (!value.equals(System.getProperty(property))) {
                JXAenvUtils._setSysValue(property, value);
                return true;
            }
        }
        return false;
    }

    public static JFCFrame launchFrame(String[] args) {
        String antframe = null;
        Dimension size = new Dimension(600, 500);
        if (args.length == 1) {
            args = args[0].split("\\s");
        }
        boolean showCommandline = false;
        for (int i = 0; i < args.length; ++i) {
            if ("-antframe".equals(args[i]) && i + 1 < args.length) {
                antframe = args[i + 1];
                JXAenvUtils._setSysValue(env.APP_FRAME.propertyName(), env.APP_FRAME.propertyValue());
            }
            if ("-width".equals(args[i]) && i + 1 < args.length) {
                size.width = Integer.parseInt(args[i + 1]);
            }
            if ("-height".equals(args[i]) && i + 1 < args.length) {
                size.height = Integer.parseInt(args[i + 1]);
            }
            if ("-device".equals(args[i]) && i + 1 < args.length) {
                int dev = Integer.parseInt(args[i + 1]);
                GraphicsDevice[] devs = GraphicsEnvironment.getLocalGraphicsEnvironment().getScreenDevices();
                GraphicsConfiguration graphicsConfiguration = JXAenvUtils._defaultGC = devs.length > dev ? devs[dev].getDefaultConfiguration() : devs[0].getDefaultConfiguration();
                if (devs.length < dev) {
                    JXAenvUtils._popExceptionToUser(true, Thread.currentThread(), new IllegalArgumentException("-device argument value is invalid " + devs.length + " screens were detected"));
                }
            }
            if (!JFCFrame.parseJVMArgs(args, i)) continue;
            showCommandline |= true;
        }
        if (showCommandline) {
            final String[] argsArr = args;
            AbstractAction showmore = new AbstractAction("Show more..."){

                @Override
                public void actionPerformed(ActionEvent e) {
                    String argsLine = "";
                    for (String a : argsArr) {
                        argsLine = argsLine + a + " ";
                    }
                    JScrollPane jsp = new JScrollPane(new JTextArea(argsLine, 5, 45));
                    UIMessage.showPopupMessage(jsp, null, null, UIMessage.UI_BOTTOM_LEFT);
                }
            };
            UIMessage.showLightPopupMessage(new JLabel("Unset JVM properties were added ."), showmore, null, UIMessage.UI_BOTTOM_LEFT);
        }
        assert (antframe != null) : "Please set AntFrame implementation -antframe package.antframeimplementation !";
        JFCFrame frame = new JFCFrame(antframe, args);
        DisplayMode dm = JXAenvUtils._defaultGC.getDevice().getDisplayMode();
        frame.setLocation((int)Math.round((double)(dm.getWidth() - size.width) / 2.0), (int)Math.round((double)(dm.getHeight() - size.height) / 2.0));
        frame.setPreferredSize(size);
        frame.setSize(size);
        frame.setDefaultCloseOperation(3);
        frame.initComponents();
        frame.pack();
        frame.setVisible(true);
        frame.start();
        return frame;
    }

    public static void main(final String[] args) {
        ThreadWorks.Swing.invokeLater(new Runnable(){

            @Override
            public void run() {
                JFCFrame.launchFrame(args);
            }
        });
    }

    @Override
    public DisplayInterface getSplash() {
        if (this.targetFrame != null) {
            return this.targetFrame.getSplash();
        }
        try {
            return Display._Display(ExtensionsInstaller.splashPic, null);
        }
        catch (Exception ex) {
            if (JXAenvUtils._debugSys) {
                ex.printStackTrace();
            }
            return null;
        }
    }

    @Override
    public List<Action> getLoadLayers() {
        if (this.targetFrame != null) {
            return this.targetFrame.getLoadLayers();
        }
        return null;
    }

    static {
        JPopupMenu.setDefaultLightWeightPopupEnabled(false);
        restartingEnv = false;
        appClasspath = null;
    }
}

