/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jiga.xtended.ui;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.image.BufferedImage;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Collection;
import java.util.WeakHashMap;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.FutureTask;
import java.util.logging.Level;
import java.util.logging.Logger;
import javafx.application.Application;
import javafx.application.Platform;
import javafx.beans.value.ChangeListener;
import javafx.beans.value.ObservableValue;
import javafx.collections.ListChangeListener;
import javafx.concurrent.Worker;
import javafx.embed.swing.JFXPanel;
import javafx.event.Event;
import javafx.event.EventHandler;
import javafx.geometry.HPos;
import javafx.geometry.Pos;
import javafx.geometry.VPos;
import javafx.scene.Node;
import javafx.scene.Parent;
import javafx.scene.Scene;
import javafx.scene.control.Button;
import javafx.scene.control.ComboBox;
import javafx.scene.control.Hyperlink;
import javafx.scene.image.Image;
import javafx.scene.image.ImageView;
import javafx.scene.layout.HBox;
import javafx.scene.layout.Priority;
import javafx.scene.layout.Region;
import javafx.scene.paint.Color;
import javafx.scene.paint.Paint;
import javafx.scene.web.PopupFeatures;
import javafx.scene.web.WebEngine;
import javafx.scene.web.WebErrorEvent;
import javafx.scene.web.WebEvent;
import javafx.scene.web.WebHistory;
import javafx.scene.web.WebView;
import javafx.stage.Stage;
import javafx.util.Callback;
import javax.imageio.ImageIO;
import javax.swing.AbstractAction;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JProgressBar;
import net.sf.jiga.xtended.JXAException;
import net.sf.jiga.xtended.kernel.JXAenvUtils;
import net.sf.jiga.xtended.kernel.Monitor;
import net.sf.jiga.xtended.ui.LocalizedResources;
import net.sf.jiga.xtended.ui.UIMessage;
import netscape.javascript.JSObject;
import org.w3c.dom.Document;

public class JXAWebView
extends Application {
    protected Browser browser = null;
    static URL homepage;
    static Dimension preferredSize;
    static Object javaApp;
    private static final Monitor monitorInit;
    static LocalizedResources bundle;
    static String back_bunkey;
    static URL[] linksImages;
    static String[] linksCaptions_bunkey;
    static String[] linksUrls_bunkey;
    static URL securizedLock_open;
    static URL securizedLock_locked;
    private static boolean initialized;
    private static WeakHashMap<URL, BufferedImage> img_cache;

    public void start(final Stage stage) {
        this.browser = new Browser((Object)this, homepage, null);
        Scene scene = this.browser.createScene();
        stage.setScene(scene);
        this.browser.webEngine.titleProperty().addListener((ChangeListener)new ChangeListener<String>(){

            public void changed(ObservableValue<? extends String> ov, String t, String t1) {
                if (stage != null) {
                    stage.setTitle(t1);
                }
            }
        });
        stage.show();
        initialized = true;
    }

    public static final void main(String[] args) throws InterruptedException, ExecutionException {
        boolean embed = false;
        for (int i = 0; i < args.length; ++i) {
            if (args[i].equals("-homepage")) {
                try {
                    homepage = new URL(args[++i]);
                }
                catch (MalformedURLException ex) {
                    Logger.getLogger(JXAenvUtils.class.getName()).log(Level.SEVERE, null, ex);
                }
                continue;
            }
            if (args[i].equals("-javaApp")) {
                try {
                    javaApp = Class.forName(args[++i]).newInstance();
                }
                catch (ClassNotFoundException ex) {
                    Logger.getLogger(JXAenvUtils.class.getName()).log(Level.SEVERE, null, ex);
                }
                catch (InstantiationException ex) {
                    Logger.getLogger(JXAenvUtils.class.getName()).log(Level.SEVERE, null, ex);
                }
                catch (IllegalAccessException ex) {
                    Logger.getLogger(JXAenvUtils.class.getName()).log(Level.SEVERE, null, ex);
                }
                continue;
            }
            if (args[i].equals("-width")) {
                JXAWebView.preferredSize.width = Integer.parseInt(args[++i]);
                continue;
            }
            if (args[i].equals("-height")) {
                JXAWebView.preferredSize.height = Integer.parseInt(args[++i]);
                continue;
            }
            if (!args[i].equals("-embed")) continue;
            embed = true;
        }
        JXAWebView.initVars(homepage, javaApp, preferredSize);
        if (!embed) {
            JXAWebView.launch((String[])args);
        } else {
            JXAWebView.newBrowser(homepage);
        }
    }

    public static Monitor initVars(URL homepage, Object javaApp, Dimension preferredSize) {
        JXAWebView.preferredSize = preferredSize;
        JXAWebView.javaApp = javaApp;
        JXAWebView.homepage = homepage;
        JXAWebView.setLocalizedBundle(new LocalizedResources(), "back", new int[]{51, 37, 43, 44}, new String[]{"url_logout_cap", "url_contactus_cap", "url_privacy_cap", "url_purchase_cap"}, new String[]{"url_logout", "url_contactus", "url_privacy", "url_purchase"});
        securizedLock_locked = UIMessage._getIconResourceURL(8, true);
        securizedLock_open = UIMessage._getIconResourceURL(46, true);
        return monitorInit;
    }

    public static LocalizedResources getBundle() {
        return bundle;
    }

    public static String[] getLinksCaptions_bunkey() {
        return linksCaptions_bunkey;
    }

    public static URL[] getLinksImages() {
        return linksImages;
    }

    public static String[] getLinksUrls_bunkey() {
        return linksUrls_bunkey;
    }

    public static String getBack_bunkey() {
        return back_bunkey;
    }

    public static void setLocalizedBundle(LocalizedResources bundle, String back_bunkey, int[] linksUIMessage_Type, String[] linksCaptions_bunkey, String[] linksUrls_bunkey) {
        URL[] imagesFiles = new URL[linksUIMessage_Type.length];
        for (int i = 0; i < linksUIMessage_Type.length; ++i) {
            imagesFiles[i] = UIMessage._getIconResourceURL(linksUIMessage_Type[i], true);
        }
        JXAWebView.setLocalizedBundle(bundle, back_bunkey, imagesFiles, linksCaptions_bunkey, linksUrls_bunkey);
    }

    public static void setLocalizedBundle(LocalizedResources bundle, String back_bunkey, URL[] linksImages, String[] linksCaptions_bunkey, String[] linksUrls_bunkey) {
        JXAWebView.bundle = bundle;
        JXAWebView.back_bunkey = back_bunkey;
        JXAWebView.linksImages = linksImages;
        JXAWebView.linksCaptions_bunkey = linksCaptions_bunkey;
        JXAWebView.linksUrls_bunkey = linksUrls_bunkey;
    }

    public static void setSecurizedLock(URL securizedLock_locked_image, URL securizedLock_open_image) {
        securizedLock_locked = securizedLock_locked_image;
        securizedLock_open = securizedLock_open_image;
    }

    public static Browser newEmbeddedBrowser(URL load) throws ExecutionException {
        return JXAWebView.newEmbeddedBrowser(load, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static BufferedImage getImageSmallIcon(int uimessage_type) {
        URL url = UIMessage._getIconResourceURL(uimessage_type, true);
        BufferedImage img = img_cache.get(url);
        try {
            if (img == null) {
                img = ImageIO.read(url);
                img_cache.put(url, img);
            }
        }
        catch (IOException ex) {
            Logger.getLogger("jxa.logger").log(Level.WARNING, null, ex);
        }
        finally {
            return img;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Browser newEmbeddedBrowser(final URL load, final PopupFeatures config) throws ExecutionException {
        final JFXPanel stage = new JFXPanel();
        final FutureTask<Browser> javafx = new FutureTask<Browser>(new Callable<Browser>(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public Browser call() throws Exception {
                Browser browser = new Browser(stage, load, config);
                stage.setScene(browser.createScene());
                Monitor monitor = monitorInit;
                synchronized (monitor) {
                    monitorInit.notify();
                    return browser;
                }
            }
        });
        if (initialized) {
            throw new JXAException("Platform JavaFX was alreay initialized and cannot be reset.");
        }
        if (Platform.isFxApplicationThread()) {
            javafx.run();
        } else {
            Platform.runLater((Runnable)new Runnable(){

                @Override
                public void run() {
                    javafx.run();
                }
            });
        }
        try {
            Monitor monitor = monitorInit;
            synchronized (monitor) {
                while (!javafx.isDone()) {
                    monitorInit.wait(100L);
                }
                return javafx.get();
            }
        }
        catch (InterruptedException ex) {
            Logger.getLogger(JXAWebView.class.getName()).log(Level.SEVERE, null, ex);
            return null;
        }
    }

    public static JProgressBar newProgressBar(final Browser browser) {
        final JProgressBar progressBar = new JProgressBar();
        progressBar.setStringPainted(false);
        Runnable javafx = new Runnable(){

            @Override
            public void run() {
                browser.webEngine.getLoadWorker().progressProperty().addListener((ChangeListener)new ChangeListener<Number>(){

                    public void changed(ObservableValue<? extends Number> ov, Number t, Number t1) {
                        if (browser.webEngine.getLoadWorker().getProgress() != -1.0) {
                            progressBar.setValue((int)Math.round(browser.webEngine.getLoadWorker().getProgress() * 100.0));
                        }
                    }
                });
                browser.webEngine.getLoadWorker().runningProperty().addListener((ChangeListener)new ChangeListener<Boolean>(){

                    public void changed(ObservableValue<? extends Boolean> ov, Boolean t, Boolean t1) {
                        progressBar.setVisible(t1);
                    }
                });
            }
        };
        if (Platform.isFxApplicationThread()) {
            javafx.run();
        } else {
            Platform.runLater((Runnable)javafx);
        }
        return progressBar;
    }

    public static Browser newBrowser(URL load) throws ExecutionException {
        return JXAWebView.newBrowser(load, null);
    }

    public static Browser newBrowser(URL load, PopupFeatures config) throws ExecutionException {
        return JXAWebView.newBrowser(load, config, null);
    }

    public static Browser newBrowser(URL load, PopupFeatures config, Window parent) throws ExecutionException {
        final JFrame frame = new JFrame();
        JPanel panel = new JPanel(new BorderLayout(), true);
        final Browser browser = JXAWebView.newEmbeddedBrowser(load, config);
        frame.setContentPane(panel);
        if (config != null && !config.isResizable()) {
            frame.setResizable(false);
        }
        if (config == null || config.hasStatus()) {
            JProgressBar progressBar = JXAWebView.newProgressBar(browser);
            panel.add((Component)progressBar, "North");
        }
        panel.add((Component)browser.getJFXPanel(), "Center");
        frame.setPreferredSize(preferredSize);
        frame.setUndecorated(false);
        frame.setModalExclusionType(Dialog.ModalExclusionType.APPLICATION_EXCLUDE);
        frame.pack();
        frame.setLocationRelativeTo(parent);
        frame.setVisible(true);
        Runnable javafx = new Runnable(){

            @Override
            public void run() {
                browser.webEngine.titleProperty().addListener((ChangeListener)new ChangeListener<String>(){

                    public void changed(ObservableValue<? extends String> ov, String t, String t1) {
                        if (frame != null) {
                            frame.setTitle(t1);
                            if (browser.webEngine.getLocation().startsWith("https")) {
                                frame.setIconImage(JXAWebView.getImageSmallIcon(8));
                            } else {
                                frame.setIconImage(JXAWebView.getImageSmallIcon(46));
                            }
                        }
                    }
                });
            }
        };
        if (Platform.isFxApplicationThread()) {
            javafx.run();
        } else {
            Platform.runLater((Runnable)javafx);
        }
        return browser;
    }

    static {
        preferredSize = new Dimension(750, 400);
        monitorInit = new Monitor();
        initialized = false;
        img_cache = new WeakHashMap();
    }

    public static class Browser
    extends Region {
        String stylesheet = "net/sf/jiga/xtended/ui/BrowserToolbar.css";
        Color sceneColor = Color.web((String)"#666970");
        private HBox toolBar;
        final ImageView selectedImage = new ImageView();
        Hyperlink[] hpls;
        Image[] images;
        final WebView view = new WebView();
        final WebEngine webEngine = this.view.getEngine();
        Button showPrevDoc;
        Button securizedLock;
        final WebView smallView = new WebView();
        final ComboBox comboBox = new ComboBox();
        Application application = null;
        LocalizedResources text;
        private JFXPanel jfxPanel = null;

        public WebView getView() {
            return this.view;
        }

        public WebEngine getWebEngine() {
            return this.webEngine;
        }

        public void setSceneColor(Color sceneColor) {
            this.sceneColor = sceneColor;
        }

        public void setStylesheet(String resourcepath) {
            this.stylesheet = resourcepath;
        }

        private Scene createScene() {
            Scene scene = new Scene((Parent)this, (double)JXAWebView.preferredSize.width, (double)JXAWebView.preferredSize.height, (Paint)this.sceneColor);
            scene.getStylesheets().add((Object)this.stylesheet);
            this.webEngine.getLoadWorker().stateProperty().addListener((ChangeListener)new ChangeListener<Worker.State>(){

                public void changed(ObservableValue<? extends Worker.State> ov, Worker.State oldState, Worker.State newState) {
                    if (newState == Worker.State.SUCCEEDED) {
                        Document d = Browser.this.webEngine.getDocument();
                        if (d != null) {
                            String u = d.getDocumentURI();
                            Browser.this.toggleSecurizedLock(u.startsWith("https"));
                        }
                        if (javaApp != null) {
                            JSObject win = (JSObject)Browser.this.webEngine.executeScript("window");
                            win.setMember("sf3jxakn_app", javaApp);
                        }
                    }
                }
            });
            this.webEngine.locationProperty().addListener((ChangeListener)new ChangeListener<String>(){

                public void changed(ObservableValue<? extends String> ov, String t, String t1) {
                    Logger.getLogger("jxa.logger").log(Level.INFO, "WebView browsing to " + t1);
                }
            });
            return scene;
        }

        public Browser(final Object parent, URL load, PopupFeatures config) {
            if (parent instanceof Application) {
                this.application = (Application)parent;
            }
            if (parent instanceof JFXPanel) {
                this.jfxPanel = (JFXPanel)parent;
            }
            this.localizedBundle(bundle, back_bunkey, linksImages, linksCaptions_bunkey, linksUrls_bunkey);
            this.getStyleClass().add((Object)"browser");
            this.webEngine.setCreatePopupHandler((Callback)new Callback<PopupFeatures, WebEngine>(){

                public WebEngine call(PopupFeatures config) {
                    try {
                        if (parent instanceof Window) {
                            return JXAWebView.newBrowser((URL)JXAWebView.homepage, (PopupFeatures)config, (Window)((Window)parent)).webEngine;
                        }
                        return JXAWebView.newBrowser((URL)JXAWebView.homepage, (PopupFeatures)config).webEngine;
                    }
                    catch (Exception ex) {
                        Logger.getLogger(JXAWebView.class.getName()).log(Level.SEVERE, null, ex);
                        return null;
                    }
                }
            });
            this.webEngine.setOnAlert((EventHandler)new EventHandler<WebEvent<String>>(){

                public void handle(WebEvent<String> t) {
                    UIMessage.showLightPopupMessage(new JLabel((String)t.getData()), null, (Container)Browser.this.jfxPanel, 0);
                }
            });
            this.webEngine.setOnError((EventHandler)new EventHandler<WebErrorEvent>(){

                public void handle(final WebErrorEvent t) {
                    UIMessage.showPopupMessage(new JLabel("<html><u>Error :</u> " + t.getMessage() + "</html>"), new AbstractAction("More..."){

                        @Override
                        public void actionPerformed(ActionEvent e) {
                            JXAenvUtils._popExceptionToUser(false, Thread.currentThread(), t.getException());
                        }
                    }, (Container)Browser.this.jfxPanel, 0);
                }
            });
            final WebHistory history = this.webEngine.getHistory();
            history.getEntries().addListener((ListChangeListener)new ListChangeListener<WebHistory.Entry>(){

                public void onChanged(ListChangeListener.Change<? extends WebHistory.Entry> c) {
                    c.next();
                    for (WebHistory.Entry e : c.getRemoved()) {
                        Browser.this.comboBox.getItems().remove((Object)e.getUrl());
                    }
                    for (WebHistory.Entry e : c.getAddedSubList()) {
                        Browser.this.comboBox.getItems().add((Object)e.getUrl());
                    }
                }
            });
            this.comboBox.setPrefWidth(150.0);
            this.comboBox.setOnAction((EventHandler)new EventHandler<javafx.event.ActionEvent>(){

                public void handle(javafx.event.ActionEvent ev) {
                    int offset = Browser.this.comboBox.getSelectionModel().getSelectedIndex() - history.getCurrentIndex();
                    history.go(offset);
                }
            });
            this.webEngine.getLoadWorker().stateProperty().addListener((ChangeListener)new ChangeListener<Worker.State>(){

                public void changed(ObservableValue<? extends Worker.State> ov, Worker.State oldState, Worker.State newState) {
                    Browser.this.toolBar.getChildren().remove((Object)Browser.this.showPrevDoc);
                    if (newState == Worker.State.SUCCEEDED) {
                        JSObject win = (JSObject)Browser.this.webEngine.executeScript("window");
                        win.setMember("sf3jxakn_app", javaApp);
                        Browser.this.toolBar.getChildren().add((Object)Browser.this.showPrevDoc);
                    }
                }
            });
            this.webEngine.load(load.toExternalForm());
            if (config == null || config.hasToolbar()) {
                this.getChildren().add((Object)this.toolBar);
            }
            this.getChildren().add((Object)this.view);
        }

        public final void localizedBundle(LocalizedResources bundle, String back_bunkey, URL[] linksImages, String[] linksCaptions_bunkey, String[] linksUrls_bunkey) {
            this.text = bundle;
            if (linksUrls_bunkey.length != linksCaptions_bunkey.length) {
                throw new JXAException("invalid parameters length");
            }
            this.makeToolbar(back_bunkey, linksImages, linksCaptions_bunkey, linksUrls_bunkey);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void makeToolbar(String back_bunkey, URL[] linksImages, String[] linksCaptions_bunkey, String[] linksUrls_bunkey) {
            this.hpls = new Hyperlink[linksCaptions_bunkey.length];
            this.images = new Image[linksImages.length];
            for (int i = 0; i < linksCaptions_bunkey.length; ++i) {
                String url;
                Hyperlink hpl = this.hpls[i] = new Hyperlink(this.text.bundle.getString(linksCaptions_bunkey[i]));
                try {
                    Image image = this.images[i] = new Image(linksImages[i].openStream());
                    hpl.setGraphic((Node)new ImageView(image));
                    url = this.text.bundle.getString(linksUrls_bunkey[i]);
                }
                catch (IOException ex) {
                    try {
                        Logger.getLogger("jxa.logger").log(Level.SEVERE, null, ex);
                        url = this.text.bundle.getString(linksUrls_bunkey[i]);
                    }
                    catch (Throwable throwable) {
                        String url2 = this.text.bundle.getString(linksUrls_bunkey[i]);
                        hpl.setOnAction((EventHandler)new EventHandler<javafx.event.ActionEvent>(url2){
                            final /* synthetic */ String val$url;
                            {
                                this.val$url = string;
                            }

                            public void handle(javafx.event.ActionEvent e) {
                                if (this.val$url.equals("jxa://stop")) {
                                    Browser.this.webEngine.getLoadWorker().cancel();
                                } else {
                                    Browser.this.webEngine.load(this.val$url);
                                }
                            }
                        });
                        throw throwable;
                    }
                    hpl.setOnAction((EventHandler)new /* invalid duplicate definition of identical inner class */);
                    continue;
                }
                hpl.setOnAction((EventHandler)new /* invalid duplicate definition of identical inner class */);
                continue;
            }
            if (this.toolBar != null) {
                this.toolBar.getChildren().removeAll((Collection)this.toolBar.getChildren());
            } else {
                this.toolBar = new HBox();
                this.toolBar.getStyleClass().add((Object)"browser-toolbar");
            }
            this.toolBar.setAlignment(Pos.CENTER);
            this.securizedLock = new Button();
            this.toggleSecurizedLock(false);
            this.toolBar.getChildren().add((Object)this.securizedLock);
            this.toolBar.getChildren().add((Object)this.createSpacer());
            this.toolBar.getChildren().add((Object)this.comboBox);
            this.toolBar.getChildren().addAll((Object[])this.hpls);
            this.toolBar.getChildren().add((Object)this.createSpacer());
            this.showPrevDoc = new Button(this.text.bundle.getString(back_bunkey));
            this.showPrevDoc.setOnAction(new EventHandler(){

                public void handle(Event t) {
                    if (Browser.this.webEngine.getHistory().getCurrentIndex() > 0) {
                        Browser.this.webEngine.getHistory().go(-1);
                    }
                }
            });
        }

        public void toggleSecurizedLock(boolean locked) {
            try {
                if (!locked) {
                    this.securizedLock.setGraphic((Node)new ImageView(new Image(securizedLock_open.openStream())));
                } else {
                    this.securizedLock.setGraphic((Node)new ImageView(new Image(securizedLock_locked.openStream())));
                }
            }
            catch (IOException ex) {
                Logger.getLogger(JXAenvUtils.class.getName()).log(Level.SEVERE, null, ex);
            }
        }

        public ComboBox getComboBox() {
            return this.comboBox;
        }

        public Application getApplication() {
            return this.application;
        }

        private Node createSpacer() {
            Region spacer = new Region();
            HBox.setHgrow((Node)spacer, (Priority)Priority.ALWAYS);
            return spacer;
        }

        protected void layoutChildren() {
            double w = this.getWidth();
            double h = this.getHeight();
            double tbHeight = this.toolBar.prefHeight(w);
            this.layoutInArea((Node)this.view, 0.0, 0.0, w, h - tbHeight, 0.0, HPos.CENTER, VPos.CENTER);
            this.layoutInArea((Node)this.toolBar, 0.0, h - tbHeight, w, tbHeight, 0.0, HPos.CENTER, VPos.CENTER);
        }

        protected double computePrefWidth(double width) {
            return preferredSize.getWidth();
        }

        protected double computePrefHeight(double height) {
            return preferredSize.getHeight();
        }

        private JFXPanel getJFXPanel() {
            return this.jfxPanel;
        }
    }
}

