/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jiga.xtended.ui;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.DisplayMode;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseMotionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.lang.reflect.InvocationTargetException;
import java.net.URL;
import java.util.Collections;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.BorderFactory;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JProgressBar;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.SwingUtilities;
import net.sf.jiga.xtended.kernel.BitStack;
import net.sf.jiga.xtended.kernel.JXAenvUtils;
import net.sf.jiga.xtended.kernel.Resource;
import net.sf.jiga.xtended.kernel.ThreadWorks;
import net.sf.jiga.xtended.ui.TransparentBackground;

public class UIMessage
extends JDialog
implements Resource {
    public static final int QUESTION_TYPE = 2;
    public static final int INFO_TYPE = 0;
    public static final int ERROR_TYPE = 1;
    public static final int DELETE_TYPE = 3;
    public static final int DISABLED_TYPE = 4;
    public static final int ENABLED_TYPE = 5;
    public static final int INPUT_TYPE = 6;
    public static final int LOAD_TYPE = 7;
    public static final int LOCK_TYPE = 8;
    public static final int REFRESH_TYPE = 9;
    public static final int SEARCH_TYPE = 10;
    public static final int SOUNDOFF_TYPE = 11;
    public static final int SOUNDON_TYPE = 12;
    public static final int STORE_TYPE = 13;
    public static final int WAIT_TYPE = 14;
    public static final int OPENGL_TYPE = 15;
    public static final int DIRECTX_TYPE = 16;
    public static final int PLAYER_PLAY_TYPE = 17;
    public static final int PLAYER_STOP_TYPE = 18;
    public static final int PLAYER_PAUSE_TYPE = 19;
    public static final int PLAYER_FF_TYPE = 20;
    public static final int PLAYER_FB_TYPE = 21;
    public static final int PLAYER_NEXT_TYPE = 22;
    public static final int PLAYER_PREVIOUS_TYPE = 23;
    public static final int MODEL_TYPE = 24;
    public static final int TEMPLATE_TYPE = 25;
    public static final int DROPTARGET_TYPE = 26;
    public static final int MULTITHREADING_TYPE = 27;
    public static final int LWJGL_TYPE = 28;
    public static final int EXIT_TYPE = 29;
    public static final int PICTURE_TYPE = 30;
    public static final int PRINT_TYPE = 31;
    public static final int BACK_TYPE = 32;
    public static final int NEXT_TYPE = 33;
    public static final int STAT_TYPE = 34;
    public static final int STAT_ROUND_TYPE = 35;
    public static final int STAT_HISTORY_TYPE = 36;
    public static final int MAIL_TYPE = 37;
    public static final int COMMENT_TYPE = 38;
    public static final int IMPORT_TYPE = 39;
    public static final int EXPORT_TYPE = 40;
    public static final int AUDIO_TYPE = 41;
    public static final int CD_TYPE = 42;
    public static final int DOCUMENT_TYPE = 43;
    public static final int DONATE_TYPE = 44;
    public static final int WEBCAM_TYPE = 45;
    public static final int WEB_TYPE = 46;
    public static final int TERMINAL_TYPE = 47;
    public static final int NEW_WINDOW_TYPE = 48;
    public static final int PLUS_TYPE = 49;
    public static final int MINUS_TYPE = 50;
    public static final int ABORT_TYPE = 51;
    static Map<Long, JProgressBar> jpb = Collections.synchronizedMap(new Hashtable());
    static Map<Long, JDialog> display = Collections.synchronizedMap(new Hashtable());
    private static final BitStack _placement = new BitStack();
    protected static final int _BOTTOM_ = _placement._newBitRange();
    protected static final int _TOP_ = _placement._newBitRange();
    protected static final int _RIGHT_ = _placement._newBitRange();
    protected static final int _LEFT_ = _placement._newBitRange();
    public static final int _BOTTOM_RIGHT;
    public static final int UI_BOTTOM_RIGHT;
    public static final int _BOTTOM_LEFT;
    public static final int UI__BOTTOM_LEFT;
    public static final int UI_BOTTOM_LEFT;
    public static final int _TOP_RIGHT;
    public static final int UI_TOP_RIGHT;
    public static final int _TOP_LEFT;
    public static final int UI_TOP_LEFT;
    public static final int UI_CENTER = 0;

    public static int showConfirmDialog(Component parent, Object message, String title, int options) {
        if (parent == null) {
            parent = new JFrame(JXAenvUtils._defaultGC);
            ((JFrame)parent).setLocationRelativeTo(null);
        }
        return JOptionPane.showConfirmDialog(parent, message, title, options, 3, UIMessage._getIcon(2, false));
    }

    public static <T> T showSelectDialog(Component parent, Object message, String title, T[] selection, T initial) {
        Object o;
        if (parent == null) {
            parent = new JFrame(JXAenvUtils._defaultGC);
            ((JFrame)parent).setLocationRelativeTo(null);
        }
        if ((o = JOptionPane.showInputDialog(parent, message, title, 3, UIMessage._getIcon(2, false), selection, initial)) == null) {
            return null;
        }
        return (T)o;
    }

    public UIMessage(boolean modal, Object message, Frame parent) {
        this(modal, message, parent, 0);
    }

    public UIMessage(boolean modal, Object message, Frame parent, boolean show) {
        this(modal, message, parent, show, 0);
    }

    public UIMessage(boolean modal, Object message, Frame parent, int type) {
        this(modal, message, parent, true, type);
    }

    public UIMessage(boolean modal, Object message, Frame parent, boolean show, int type) {
        super(parent, "Information Message", modal, parent == null ? JXAenvUtils._defaultGC : parent.getGraphicsConfiguration());
        int pty = Thread.currentThread().getPriority();
        Thread.currentThread().setPriority(10);
        GridBagConstraints c = new GridBagConstraints();
        c.insets = new Insets(10, 10, 10, 10);
        c.fill = 1;
        c.weightx = 1.0;
        c.weighty = 1.0;
        JPanel pane = new JPanel(true);
        this.getContentPane().setLayout(new GridBagLayout());
        this.getContentPane().add((Component)pane, c);
        GridBagLayout g = new GridBagLayout();
        pane.setLayout(g);
        c.weightx = 0.0;
        c.fill = 0;
        pane.add((Component)new JLabel(UIMessage._getIcon(type, false)), c);
        c.weightx = 1.0;
        if (message instanceof Component) {
            c.fill = 1;
            c.gridwidth = 0;
            pane.add((Component)message, c);
        } else {
            JXAenvUtils.LVL envType;
            JXAenvUtils.LVL lVL = envType = type == 1 ? JXAenvUtils.LVL.USR_ERR : JXAenvUtils.LVL.USR_NOT;
            if (JXAenvUtils._debugSys) {
                System.out.println(JXAenvUtils.log("UIMessage : " + message, envType));
            }
            JTextArea msg = new JTextArea(message.toString());
            msg.setEditable(false);
            msg.setDragEnabled(true);
            msg.setWrapStyleWord(true);
            msg.setLineWrap(true);
            msg.setDoubleBuffered(true);
            c.fill = 1;
            c.gridwidth = 0;
            JScrollPane sp = new JScrollPane(msg);
            pane.add((Component)sp, c);
            sp.setWheelScrollingEnabled(true);
            sp.setPreferredSize(new Dimension(150, 150));
        }
        JButton ok = new JButton(new AbstractAction("OK"){

            @Override
            public void actionPerformed(ActionEvent e) {
                UIMessage.this.dispose();
            }
        });
        c.gridwidth = 2;
        c.fill = 0;
        c.weighty = 0.0;
        pane.add((Component)ok, c);
        ok.setRequestFocusEnabled(true);
        this.pack();
        this.getToolkit().beep();
        this.setLocationRelativeTo(parent);
        this.setAlwaysOnTop(true);
        this.setVisible(show);
        this.repaint();
        Thread.currentThread().setPriority(pty);
    }

    private static Object _getIconResource(int type, boolean small, boolean rsrcMode) {
        String icon = "";
        String s = small ? "_small" : "";
        String spng = small ? "png-24" : "png-48";
        switch (type) {
            case 28: {
                icon = "images/lwjgl" + s + ".png";
                break;
            }
            case 27: {
                icon = "images/" + spng + "/Run.png";
                break;
            }
            case 26: {
                icon = "images/" + spng + "/Add.png";
                break;
            }
            case 25: {
                icon = "images/sf364px-doc-tmp" + s + ".png";
                break;
            }
            case 24: {
                icon = "images/sf364px-doc" + s + ".png";
                break;
            }
            case 22: {
                icon = "images/" + spng + "/Play.png";
                break;
            }
            case 23: {
                icon = "images/" + spng + "/Play Back.png";
                break;
            }
            case 17: {
                icon = "images/" + spng + "/Play Green Button.png";
                break;
            }
            case 18: {
                icon = "images/" + spng + "/Stop Green Button.png";
                break;
            }
            case 19: {
                icon = "images/" + spng + "/Pause Green Button.png";
                break;
            }
            case 20: {
                icon = "images/" + spng + "/Play All.png";
                break;
            }
            case 21: {
                icon = "images/" + spng + "/Rewind.png";
                break;
            }
            case 16: {
                icon = "images/DirectX" + s + ".gif";
                break;
            }
            case 15: {
                icon = "images/opengl_animated" + s + ".gif";
                break;
            }
            case 0: {
                icon = "images/" + spng + "/Info.png";
                break;
            }
            case 1: {
                icon = "images/" + spng + "/Warning.png";
                break;
            }
            case 2: {
                icon = "images/" + spng + "/Help Blue Button.png";
                break;
            }
            case 3: {
                icon = "images/" + spng + "/Delete.png";
                break;
            }
            case 4: {
                icon = "images/" + spng + "/Green Ball.png";
                break;
            }
            case 5: {
                icon = "images/" + spng + "/Clear Green Button.png";
                break;
            }
            case 6: {
                icon = "images/" + spng + "/Modify.png";
                break;
            }
            case 7: {
                icon = "images/" + spng + "/Load.png";
                break;
            }
            case 8: {
                icon = "images/dialog_lock" + s + ".gif";
                break;
            }
            case 9: {
                icon = "images/" + spng + "/History.png";
                break;
            }
            case 10: {
                icon = "images/" + spng + "/Search.png";
                break;
            }
            case 11: {
                icon = "images/dialog_soundoff" + s + ".gif";
                break;
            }
            case 12: {
                icon = "images/dialog_soundon" + s + ".gif";
                break;
            }
            case 13: {
                icon = "images/" + spng + "/Save.png";
                break;
            }
            case 14: {
                icon = "images/" + spng + "/Internet History.png";
                break;
            }
            case 34: {
                icon = "images/" + spng + "/Bar Chart.png";
                break;
            }
            case 35: {
                icon = "images/" + spng + "/Pie Chart.png";
                break;
            }
            case 36: {
                icon = "images/" + spng + "/Line Chart.png";
                break;
            }
            case 30: {
                icon = "images/" + spng + "/Picture Document.png";
                break;
            }
            case 31: {
                icon = "images/" + spng + "/Print.png";
                break;
            }
            case 32: {
                icon = "images/" + spng + "/Back.png";
                break;
            }
            case 33: {
                icon = "images/" + spng + "/Next.png";
                break;
            }
            case 29: {
                icon = "images/" + spng + "/Exit.png";
                break;
            }
            case 37: {
                icon = "images/" + spng + "/Email.png";
                break;
            }
            case 38: {
                icon = "images/" + spng + "/Comment.png";
                break;
            }
            case 39: {
                icon = "images/" + spng + "/Import Document.png";
                break;
            }
            case 40: {
                icon = "images/" + spng + "/Export To Document.png";
                break;
            }
            case 41: {
                icon = "images/" + spng + "/Audio Document.png";
                break;
            }
            case 42: {
                icon = "images/" + spng + "/CD.png";
                break;
            }
            case 43: {
                icon = "images/" + spng + "/Document.png";
                break;
            }
            case 44: {
                icon = "images/" + spng + "/Donate.png";
                break;
            }
            case 45: {
                icon = "images/" + spng + "/iChat.png";
                break;
            }
            case 46: {
                icon = "images/" + spng + "/Web Browser.png";
                break;
            }
            case 48: {
                icon = "images/" + spng + "/Coherence.png";
                break;
            }
            case 47: {
                icon = "images/" + spng + "/Terminal.png";
                break;
            }
            case 49: {
                icon = "images/" + spng + "/Add_0.png";
                break;
            }
            case 50: {
                icon = "images/" + spng + "/Remove.png";
                break;
            }
            case 51: {
                icon = "images/" + spng + "/Cancel Red Button.png";
                break;
            }
            default: {
                icon = "images/" + spng + "/iChat Alt.png";
            }
        }
        return rsrcMode ? UIMessage.class.getResource(icon) : new ImageIcon(icon);
    }

    public static URL _getIconResourceURL(int type, boolean small) {
        return (URL)UIMessage._getIconResource(type, small, true);
    }

    public static String _getIconResourcePath(int type, boolean small) {
        return (String)UIMessage._getIconResource(type, small, true);
    }

    public static Icon _getIcon(int type, boolean small) {
        return new ImageIcon(UIMessage._getIconResourceURL(type, small));
    }

    public static JDialog _getDisplayFrame(long id) {
        return display.get(id);
    }

    public static void _makeUncloseable(JDialog frame) {
        frame.setDefaultCloseOperation(0);
        UIMessage.__makeUncloseable(frame);
    }

    public static void _makeUncloseable(JFrame frame) {
        frame.setDefaultCloseOperation(0);
        UIMessage.__makeUncloseable(frame);
    }

    private static void __makeUncloseable(final Window frame) {
        frame.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent e) {
                ThreadWorks.Swing.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        frame.setVisible(true);
                    }
                });
            }
        });
    }

    public static long displayWaiting(String message, Container parent) {
        return UIMessage.displayWaiting(message, null, parent);
    }

    public static long displayWaiting(final String message, final JComponent label, final Container parent) {
        try {
            return ThreadWorks.Swing.invokeSwingAndReturn(new ThreadWorks.SwingStaticReturn<Long>(){

                @Override
                public Long run() {
                    if (label != null) {
                        return UIMessage._displayWaiting(message, label, parent);
                    }
                    return UIMessage._displayWaiting(message, parent);
                }
            });
        }
        catch (Exception ex) {
            if (JXAenvUtils._debugSys) {
                ex.printStackTrace();
            }
            return 0L;
        }
    }

    private static long _displayWaiting(String message, Container parent) {
        return UIMessage._displayWaiting(message, new JLabel(UIMessage._getIcon(14, true)), parent);
    }

    private static long _displayWaiting(String message, JComponent label, Container parent) {
        JDialog display = UIMessage._showLightPopupMessage(label, null, parent, 0, false);
        long id = System.nanoTime();
        UIMessage.display.put(id, display);
        JProgressBar jpb = JXAenvUtils._JTimeProgressBar();
        UIMessage.jpb.put(id, jpb);
        jpb.setStringPainted(false);
        jpb.setDoubleBuffered(true);
        jpb.setIndeterminate(true);
        UIMessage._makeUncloseable(display);
        display.setTitle("Please wait !");
        display.setResizable(false);
        display.setAlwaysOnTop(true);
        display.getContentPane().setLayout(new GridBagLayout());
        GridBagConstraints c = new GridBagConstraints();
        c.insets = new Insets(5, 5, 5, 5);
        c.gridwidth = 0;
        c.fill = 2;
        c.weightx = 0.5;
        display.getContentPane().add((Component)new JLabel(message), c);
        c.gridwidth = 1;
        display.getContentPane().add((Component)label, c);
        c.gridwidth = 0;
        c.weightx = 1.0;
        display.getContentPane().add((Component)jpb, c);
        display.pack();
        display.setVisible(true);
        display.update(display.getGraphics());
        return id;
    }

    public static JProgressBar getProgressBar(long id) {
        if (jpb.containsKey(id)) {
            return jpb.get(id);
        }
        if (JXAenvUtils._debugSys) {
            System.err.println(JXAenvUtils.log("Progress bar id unknown " + id, JXAenvUtils.LVL.SYS_WRN));
        }
        return JXAenvUtils._JTimeProgressBar();
    }

    public static long newProgress(final int current, final int total, final Component parent) {
        try {
            return ThreadWorks.Swing.invokeSwingAndReturn(new ThreadWorks.SwingStaticReturn<Long>(){

                @Override
                public Long run() {
                    return UIMessage._newProgress(current, total, parent);
                }
            });
        }
        catch (Exception e) {
            if (JXAenvUtils._debugSys) {
                e.printStackTrace();
            }
            return 0L;
        }
    }

    private static long _newProgress(int current, int total, Component parent) {
        JProgressBar jpb = JXAenvUtils._JTimeProgressBar("                 %1$s                 ");
        long ct = System.nanoTime();
        UIMessage.jpb.put(ct, jpb);
        jpb.setMaximum(total);
        jpb.setValue(current);
        jpb.setDoubleBuffered(true);
        return ct;
    }

    public static long displayProgress(String message, long id, int current, int total, Container parent) {
        return UIMessage.displayProgress(message, null, id, current, total, parent);
    }

    public static long displayProgress(final String message, final JComponent label, final long id, final int current, final int total, final Container parent) {
        try {
            return ThreadWorks.Swing.invokeSwingAndReturn(new ThreadWorks.SwingStaticReturn<Long>(){

                @Override
                public Long run() {
                    if (label != null) {
                        return UIMessage._displayProgress(message, label, id, current, total, parent);
                    }
                    return UIMessage._displayProgress(message, id, current, total, parent);
                }
            });
        }
        catch (Exception e) {
            if (JXAenvUtils._debugSys) {
                e.printStackTrace();
            }
            return 0L;
        }
    }

    private static long _displayProgress(String message, long id, int current, int total, Container parent) {
        return UIMessage._displayProgress(message, new JLabel(UIMessage._getIcon(14, true)), id, current, total, parent);
    }

    private static long _displayProgress(String message, JComponent label, long id, int current, int total, Container parent) {
        JProgressBar jpb;
        long ct = id;
        JDialog display = UIMessage._showLightPopupMessage(label, null, parent, UI_BOTTOM_RIGHT, true);
        UIMessage.display.put(ct, display);
        if (UIMessage.jpb.containsKey(ct)) {
            jpb = UIMessage.getProgressBar(id);
        } else {
            jpb = JXAenvUtils._JTimeProgressBar();
            UIMessage.jpb.put(ct, jpb);
        }
        jpb.setMaximum(total);
        jpb.setStringPainted(true);
        jpb.setDoubleBuffered(true);
        jpb.setIndeterminate(false);
        UIMessage._makeUncloseable(display);
        display.setTitle("Please wait !");
        display.setResizable(false);
        display.setAlwaysOnTop(true);
        display.getContentPane().setLayout(new GridBagLayout());
        GridBagConstraints c = new GridBagConstraints();
        c.insets = new Insets(5, 5, 5, 5);
        c.gridwidth = 0;
        c.fill = 2;
        c.weightx = 0.5;
        if (message != null) {
            display.getContentPane().add((Component)new JLabel(message), c);
        }
        c.gridwidth = 1;
        display.getContentPane().add((Component)label, c);
        c.gridwidth = 0;
        c.weightx = 1.0;
        display.getContentPane().add((Component)jpb, c);
        display.pack();
        display.setVisible(true);
        display.update(display.getGraphics());
        return ct;
    }

    public static long displayProgress(int current, int total, Container parent) {
        return UIMessage.displayProgress(null, System.nanoTime(), current, total, parent);
    }

    public static long updateProgress(long id, int value, int total) {
        int pty = Thread.currentThread().getPriority();
        Thread.currentThread().setPriority(10);
        assert (jpb.containsKey(id)) : "UIMessage : you must call int displayProgress() before updateProgress(int) (or maybe the progress bar has been killed by another one)!";
        JProgressBar jpb = UIMessage.jpb.get(id);
        if (jpb != null) {
            jpb.setIndeterminate(false);
            jpb.setMaximum(total);
            jpb.setValue(value);
            if (ThreadWorks.Swing.isEventDispatchThread()) {
                jpb.paintImmediately(jpb.getBounds());
            } else {
                jpb.repaint();
            }
        }
        return id;
    }

    public static long hideProgress(long id) {
        return UIMessage.setProgressVisibility(id, false, false);
    }

    public static long showProgress(long id) {
        return UIMessage.setProgressVisibility(id, true, false);
    }

    private static long setProgressVisibility(final long id, final boolean visibility, final boolean dispose) {
        try {
            return ThreadWorks.Swing.invokeSwingAndReturn(new ThreadWorks.SwingStaticReturn<Long>(){

                @Override
                public Long run() {
                    return UIMessage._setProgressVisibility(id, visibility, dispose);
                }
            });
        }
        catch (Exception e) {
            if (JXAenvUtils._debugSys) {
                e.printStackTrace();
            }
            return 0L;
        }
    }

    private static long _setProgressVisibility(long id, boolean visibility, boolean dispose) {
        if (id == 0L) {
            return 0L;
        }
        if (!jpb.containsKey(id) && !display.containsKey(id)) {
            System.err.println(JXAenvUtils.log("UIMessage : you must call int displayProgress() before setProgressVisibility(int) or maybe the progressBar has been killed by another one!", JXAenvUtils.LVL.APP_WRN));
            return id;
        }
        JDialog display = UIMessage.display.get(id);
        JProgressBar jpb = UIMessage.jpb.get(id);
        if (jpb != null) {
            jpb.setVisible(visibility);
        }
        if (display != null) {
            display.setVisible(visibility);
            if (dispose) {
                display.dispose();
            } else {
                display.repaint();
            }
        }
        return id;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void killAllStaticWindows() {
        Set<Long> set0 = display.keySet();
        Set<Long> set1 = jpb.keySet();
        Map<Long, Container> map = jpb;
        synchronized (map) {
            Iterator<Long> jpb = set1.iterator();
            while (jpb.hasNext()) {
                UIMessage.setProgressVisibility(jpb.next(), false, true);
                jpb.remove();
            }
        }
        map = display;
        synchronized (map) {
            Iterator<Long> display = set0.iterator();
            while (display.hasNext()) {
                UIMessage.setProgressVisibility(display.next(), false, true);
                display.remove();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void setAllStaticWindowsVisibility(boolean b, boolean dispose) {
        Set<Long> set0 = display.keySet();
        Set<Long> set1 = jpb.keySet();
        Map<Long, Container> map = jpb;
        synchronized (map) {
            Iterator<Long> jpb = set1.iterator();
            while (jpb.hasNext()) {
                UIMessage.setProgressVisibility(jpb.next(), b, dispose);
                if (!dispose) continue;
                jpb.remove();
            }
        }
        map = display;
        synchronized (map) {
            Iterator<Long> display = set0.iterator();
            while (display.hasNext()) {
                UIMessage.setProgressVisibility(display.next(), b, dispose);
                if (!dispose) continue;
                display.remove();
            }
        }
    }

    public static void hideAllStaticWindows() {
        UIMessage.setAllStaticWindowsVisibility(false, false);
    }

    public static void showAllStaticWindows() {
        UIMessage.setAllStaticWindowsVisibility(true, false);
    }

    public static void kill(long id) {
        UIMessage.setProgressVisibility(id, false, true);
        jpb.remove(id);
        display.remove(id);
    }

    public boolean isMultiThreadingEnabled() {
        return JXAenvUtils._multiThreading;
    }

    public void setMultiThreadingEnabled(boolean b) {
        JXAenvUtils._multiThreading = true;
    }

    @Override
    public Object loadResource() {
        return null;
    }

    @Override
    public Object clearResource() {
        return null;
    }

    @Override
    public boolean isResourceLoaded() {
        return true;
    }

    public static JDialog showLightPopupMessage(final JComponent contents, final Action actionButton, final Container parent, final int popupLocation) {
        try {
            return ThreadWorks.Swing.invokeSwingAndReturn(new ThreadWorks.SwingStaticReturn<JDialog>(){

                @Override
                public JDialog run() {
                    return UIMessage._showLightPopupMessage(contents, actionButton, parent, popupLocation, false);
                }
            });
        }
        catch (InterruptedException ex) {
            if (JXAenvUtils._debugSys) {
                ex.printStackTrace();
            }
            return null;
        }
        catch (InvocationTargetException ex) {
            if (JXAenvUtils._debugSys) {
                ex.printStackTrace();
            }
            return null;
        }
    }

    public static JDialog showLightModalPopupMessage(final JComponent contents, final Action actionButton, final Container parent, final int popupLocation) {
        try {
            return ThreadWorks.Swing.invokeSwingAndReturn(new ThreadWorks.SwingStaticReturn<JDialog>(){

                @Override
                public JDialog run() {
                    return UIMessage._showLightPopupMessage(contents, actionButton, parent, popupLocation, true);
                }
            });
        }
        catch (InterruptedException ex) {
            if (JXAenvUtils._debugSys) {
                ex.printStackTrace();
            }
            return null;
        }
        catch (InvocationTargetException ex) {
            if (JXAenvUtils._debugSys) {
                ex.printStackTrace();
            }
            return null;
        }
    }

    public static JDialog showPopupMessage(final JComponent contents, final Action actionButton, final Container parent, final int popupLocation) {
        try {
            return ThreadWorks.Swing.invokeSwingAndReturn(new ThreadWorks.SwingStaticReturn<JDialog>(){

                @Override
                public JDialog run() {
                    return UIMessage._showPopupMessage(contents, actionButton, parent, popupLocation);
                }
            });
        }
        catch (InterruptedException ex) {
            if (JXAenvUtils._debugSys) {
                ex.printStackTrace();
            }
            return null;
        }
        catch (InvocationTargetException ex) {
            if (JXAenvUtils._debugSys) {
                ex.printStackTrace();
            }
            return null;
        }
    }

    private static JDialog _showPopupMessage(JComponent contents, Action a, Container parent, int popupLocation) {
        return UIMessage._showPopupMessage(contents, a, parent, popupLocation, true, true);
    }

    private static JDialog _showLightPopupMessage(JComponent contents, Action a, Container parent, int popupLocation, boolean modal) {
        return UIMessage._showPopupMessage(contents, a, parent, popupLocation, modal, false);
    }

    private static JPanel _Popup_newPanel(JComponent contents, JButton button, JHoverIcon closeLab, int popupLocation) {
        JPanel panel = new JPanel(true);
        panel.setBorder(BorderFactory.createLineBorder(Color.BLACK));
        panel.setLayout(new GridBagLayout());
        GridBagConstraints c = new GridBagConstraints();
        c.insets = new Insets(5, 5, 5, 5);
        c.gridwidth = 0;
        c.fill = 0;
        c.weightx = 0.5;
        int n = (popupLocation & _RIGHT_) != 0 ? 17 : (c.anchor = 13);
        if (closeLab != null) {
            panel.add((Component)closeLab, c);
        }
        c.anchor = (popupLocation & _RIGHT_) != 0 ? 13 : 17;
        c.weightx = 1.0;
        c.weighty = 1.0;
        c.fill = 1;
        if (button != null) {
            c.gridwidth = -1;
        }
        panel.add((Component)contents, c);
        if (button != null) {
            c.gridwidth = 0;
            c.fill = 0;
            c.weightx = 0.5;
            panel.add((Component)button, c);
        }
        return panel;
    }

    private static Point _Popup_compLocation(JPanel popupPanel, Container parent, int popupLocation) {
        JFrame jf = new JFrame(parent != null ? parent.getGraphicsConfiguration() : JXAenvUtils._defaultGC);
        jf.setContentPane(popupPanel);
        jf.setUndecorated(true);
        jf.pack();
        DisplayMode dm = jf.getGraphicsConfiguration().getDevice().getDisplayMode();
        Dimension contentSize = jf.getSize();
        jf.dispose();
        Rectangle displayBounds = new Rectangle(parent != null ? parent.getSize() : new Dimension(dm.getWidth(), dm.getHeight()));
        Point loc = new Point(0, 0);
        if ((popupLocation & _RIGHT_) != 0) {
            loc.x += displayBounds.width - contentSize.width;
        } else if ((popupLocation & _LEFT_) == 0) {
            loc.x += (int)displayBounds.getCenterX() - Math.round((float)contentSize.width / 2.0f);
        }
        if ((popupLocation & _BOTTOM_) != 0) {
            loc.y += displayBounds.height - contentSize.height;
        } else if ((popupLocation & _TOP_) == 0) {
            loc.y += (int)displayBounds.getCenterY() - Math.round((float)contentSize.height / 2.0f);
        }
        return loc;
    }

    private static JDialog _showPopupMessage(JComponent contents, Action a, Container parent, int popupLocation, boolean modal, boolean decorated) {
        JButton button = a != null ? new JButton(a) : null;
        JHoverIcon closeLab = decorated ? null : UIMessage.newCloseSquareIcon();
        JPanel panel = UIMessage._Popup_newPanel(contents, button, closeLab, popupLocation);
        Component cpeer = null;
        if (parent != null) {
            cpeer = SwingUtilities.getRoot(parent);
        }
        Point loc = UIMessage._Popup_compLocation(panel, parent, popupLocation);
        final JDialog popup = new JDialog(cpeer instanceof Window ? (Window)cpeer : null);
        popup.setUndecorated(!decorated);
        popup.setModal(modal);
        popup.setLocationRelativeTo(parent);
        popup.setLocation(loc);
        popup.setContentPane(panel);
        popup.pack();
        ActionListener close = new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                popup.setVisible(false);
            }
        };
        if (!decorated) {
            DragPopup dragPopup = new DragPopup(popup, panel, closeLab.getHeight());
            if (cpeer != null) {
                cpeer.addMouseListener(dragPopup);
            }
            panel.addMouseListener(dragPopup);
            panel.addMouseMotionListener(dragPopup);
            closeLab.setOnclick(close);
        }
        if (a != null) {
            button.addActionListener(close);
        }
        popup.setVisible(true);
        return popup;
    }

    public static JHoverIcon newCloseSquareIcon() {
        ImageIcon icon = new ImageIcon(UIMessage.class.getResource("images/close-12.png"));
        ImageIcon inv = new ImageIcon(UIMessage.class.getResource("images/close-inv-12.png"));
        return new JHoverIcon((Icon)icon, inv);
    }

    static {
        UI_BOTTOM_RIGHT = _BOTTOM_RIGHT = _BOTTOM_ | _RIGHT_;
        UI_BOTTOM_LEFT = UI__BOTTOM_LEFT = (_BOTTOM_LEFT = _BOTTOM_ | _LEFT_);
        UI_TOP_RIGHT = _TOP_RIGHT = _TOP_ | _RIGHT_;
        UI_TOP_LEFT = _TOP_LEFT = _TOP_ | _LEFT_;
    }

    public static class JHoverIcon
    extends JLabel {
        ActionListener onClickAction = new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
            }
        };

        public JHoverIcon(final Icon icon, final Icon inv) {
            super(icon, 0);
            this.addMouseListener(new MouseAdapter(){

                @Override
                public void mouseExited(MouseEvent e) {
                    super.mouseExited(e);
                    JHoverIcon.this.setIcon(icon);
                    JHoverIcon.this.paintImmediately(new Rectangle(JHoverIcon.this.getSize()));
                }

                @Override
                public void mouseEntered(MouseEvent e) {
                    super.mouseEntered(e);
                    JHoverIcon.this.setIcon(inv);
                    JHoverIcon.this.paintImmediately(new Rectangle(JHoverIcon.this.getSize()));
                }

                @Override
                public void mouseClicked(MouseEvent e) {
                    super.mouseClicked(e);
                    JHoverIcon.this.setIcon(icon);
                    JHoverIcon.this.paintImmediately(new Rectangle(JHoverIcon.this.getSize()));
                    JHoverIcon.this.onClickAction.actionPerformed(new ActionEvent(e.getSource(), e.getID(), e.paramString()));
                }
            });
        }

        public void setOnclick(ActionListener closePopup) {
            this.onClickAction = closePopup;
        }
    }

    private static class DragPopup
    extends MouseAdapter
    implements MouseMotionListener {
        JPanel panel;
        int moveTabHeight;
        JDialog d;
        MouseEvent dragEvent = null;
        TransparentBackground dDragImage = new TransparentBackground(new BorderLayout(), true);

        public DragPopup(JDialog d, JPanel panel, int moveTabHeight) {
            this.d = d;
            this.panel = panel;
            this.moveTabHeight = moveTabHeight;
        }

        @Override
        public void mouseReleased(MouseEvent e) {
            super.mouseReleased(e);
            this.dragEvent = null;
        }

        @Override
        public void mouseMoved(MouseEvent e) {
            this.dragEvent = null;
            if (e.getComponent().equals(this.panel)) {
                if (e.getY() < this.moveTabHeight) {
                    e.getComponent().setCursor(Cursor.getPredefinedCursor(13));
                } else {
                    e.getComponent().setCursor(Cursor.getDefaultCursor());
                }
            }
        }

        @Override
        public void mouseDragged(MouseEvent e) {
            if (this.dragEvent != null) {
                this.d.setLocation(this.d.getLocation().x + (e.getX() - this.dragEvent.getX()), this.d.getLocation().y + (e.getY() - this.dragEvent.getY()));
            }
            this.dragEvent = e;
        }
    }
}

