/*
 * To change this template, choose Tools | Templates
 * and open the template in the editor.
 */
package net.sf.jiga.xtended.ui;

import java.awt.BorderLayout;
import java.awt.Container;
import java.awt.Image;
import java.awt.event.ActionEvent;
import java.awt.event.MouseEvent;
import java.awt.event.MouseWheelEvent;
import java.net.MalformedURLException;
import javax.swing.JApplet;
import java.awt.Dimension;
import java.awt.GraphicsDevice;
import java.awt.GraphicsEnvironment;
import java.awt.Toolkit;
import java.awt.datatransfer.Clipboard;
import java.awt.datatransfer.ClipboardOwner;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.Transferable;
import java.awt.datatransfer.UnsupportedFlavorException;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseWheelListener;
import java.io.File;
import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.net.URL;
import java.security.AccessControlContext;
import java.security.AccessController;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import java.util.Arrays;
import java.util.LinkedList;
import java.util.List;
import java.util.Vector;
import java.util.logging.LogManager;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.ImageIcon;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.SwingConstants;
import javax.swing.WindowConstants;
import net.sf.jiga.xtended.kernel.Console;
import net.sf.jiga.xtended.kernel.DebugMap;
import net.sf.jiga.xtended.kernel.ExtensionsClassLoader;
import net.sf.jiga.xtended.kernel.ExtensionsClassLoaderImpl;
import net.sf.jiga.xtended.kernel.ExtensionsInstaller;
import net.sf.jiga.xtended.kernel.InputLogListener;
import net.sf.jiga.xtended.kernel.JXAenvUtils;
import net.sf.jiga.xtended.kernel.SpritesCacheManager;
import net.sf.jiga.xtended.kernel.ThreadWorks;
import static net.sf.jiga.xtended.kernel.ThreadWorks.Swing.invokeSwingAndReturn;
import net.sf.jiga.xtended.kernel.ThreadWorks.SwingStaticReturn;
import net.sf.jiga.xtended.kernel.env;
import static net.sf.jiga.xtended.ui.JFCFrame.parseJVMArgs;

/**
 * JFCApplet extends the JApplet class to make it possible to load
 * {@linkplain Ant#getLoadLayers() stuff} before to
 * {@linkplain AntApplet#init() initialize} the user app. Short example of using
 * JXA Kernel to load any applet. <b>In build-youros-yourarch.xml, specified
 * native libraries are first loaded in temp in this way</b>. <a
 * href="http://sourceforge.net/apps/mediawiki/sf3jswing/index.php?title=Main_Page">see
 * also JIGAxtended API MediaWiki pages about installing your own project native
 * libraries</a>
 * <br> null {@code
 * <APPLET archive="jxa-kernel_signed.jar"
 * code="net.sf.jiga.xtended.ui.JFCApplet" width=400 height=300>
 * Your browser does not support Java, so nothing is displayed.
 * <param name="antapplet" value="myPackage.myApplet"/>
 * <param name="antargs" value="-somearg=value"/>
 * <PARAM name="java_arguments" value="-Xmx=300M"/>
 * <param name="separate_jvm" value="true"/>
 * </APPLET>}
 * <br> It is possible to load the Applet in a JFrame, for testing it or simply
 * to make it available on a desktop installation context see
 * {@link #main(String[])}.
 * <br>
 * <i>JFCApplet overridden methods init(), start(), stop(), destroy() are
 * non-blocking, synchronized on the JFCApplet.ThreadWorks and run on the Swing
 * Thread automatically.</i>
 *
 * @author www.b23prodtm.info
 */
public final class JFCApplet extends JApplet implements AntApplet {

        static AccessControlContext _acc = AccessController.getContext();

        static {
                JPopupMenu.setDefaultLightWeightPopupEnabled(false);
        }

        /**
         *
         */
        public static final String LOCAL = "jxa.localApplet";

        /**
         *
         */
        public static final String APPLET_CLASSPATH = "applet.classpath";
        /**
         * is the System.property or Applet &lt;param&gt; applet.classpath=${os
         * specific classpath string} to set the classpath (Manifest Class-Path:
         * attribute will be read, too)
         */
        public static String _appletClasspath = JXAenvUtils._getSysValue(APPLET_CLASSPATH);
        /**
         * -Djxa.localApplet
         *
         * @default false
         */
        public static boolean _localApplet = JXAenvUtils._getSysBoolean(LOCAL);
        private AntApplet targetApplet = null;

        private static void _parseSystemArgs(final String[] args) {
                for (int i = 0; i < args.length; i++) {
                        JFCFrame.parseJVMArgs(args, i);
                }
        }

        /**
         * "destroys" the applet contents. Actually all Component's are removed
         * from the current content pane. this method cannot be overriden.
         *
         * @see JApplet#getContentPane()
         */
        @Override
        public final void destroy() {
                jfcApplet.doLater(new Runnable() {
                        public void run() {
                                try {
                                        invokeSwingAndReturn(new SwingStaticReturn() {
                                                public Object run() {
                                                        _destroy();
                                                        return null;
                                                }
                                        });
                                } catch (Exception ex) {
                                        if (JXAenvUtils._debugSys) {
                                                ex.printStackTrace();
                                        }
                                }
                        }
                });
        }

        private void _destroy() {
                if (targetApplet != null) {
                        targetApplet.destroy();
                }
                getContentPane().removeAll();
                getContentPane().validate();
                uninstall();
        }

        /**
         * starts the applet
         */
        @Override
        public final void start() {
                jfcApplet.doLater(new Runnable() {
                        public void run() {
                                try {
                                        invokeSwingAndReturn(new SwingStaticReturn() {
                                                public Object run() {
                                                        if (targetApplet != null) {
                                                                assert targetApplet.isInitialized() : "Maybe an error occured while init() was called or set the variable \"AntApplet.initialized\" to true. Set -Djxa.debugSys=true to log system errors !";
                                                                targetApplet.start();
                                                        }
                                                        restartingEnv = false;
                                                        return null;
                                                }
                                        });
                                } catch (Exception ex) {
                                        if (JXAenvUtils._debugSys) {
                                                ex.printStackTrace();
                                        }
                                }
                        }
                });
        }

        /**
         * returns the targetApplet initialized value
         */
        public final boolean isInitialized() {
                if (targetApplet != null) {
                        return targetApplet.isInitialized();
                }
                return false;
        }

        /**
         * stops the applet
         */
        @Override
        public final void stop() {
                jfcApplet.doLater(new Runnable() {
                        public void run() {
                                try {
                                        invokeSwingAndReturn(new SwingStaticReturn() {
                                                public Object run() {
                                                        if (targetApplet != null) {
                                                                if (targetApplet.isInitialized()) {
                                                                        targetApplet.stop();
                                                                }
                                                        }
                                                        return null;
                                                }
                                        });
                                } catch (Exception ex) {
                                        if (JXAenvUtils._debugSys) {
                                                ex.printStackTrace();
                                        }
                                }
                        }
                });
        }
        JXAenvUtils envUtils;
        private static boolean restartingEnv = false;

        private void uninstall() {
                envUtils.unloadEnvironment(!restartingEnv);
        }

        /**
         *
         */
        protected JDialog popup = null;

        /**
         *
         */
        protected Console log = new Console();

        private void install() {
                try {
                        /**
                         * log.setLogStderrEnabled(true);
                         * log.setLogStdoutEnabled(true); buggy, thread lock !!!
                         */
                        envUtils.loadEnvironment();
                        log.setLogStderrEnabled(false);
                        log.setLogStdoutEnabled(false);
                        if (popup != null) {
                                popup.setVisible(false);
                        }
                } catch (IOException ex) {
                        ex.printStackTrace();
                }

        }

        /**
         *
         * @param args
         */
        public JFCApplet(String[] args) {
                this();
                this.args = args;
        }

        /**
         *
         * @param antapplet
         * @param args
         */
        public JFCApplet(String antapplet, String[] args) {
                this();
                this.args = args;
                /**
                 * UID for the application
                 */
                envUtils.antClassName = antapplet;
        }

        /**
         *
         * @param antapplet
         * @param args
         */
        public JFCApplet(AntApplet antapplet, String[] args) {
                this();
                this.targetApplet = antapplet;
                this.args = args;
                /**
                 * UID for the application
                 */
                envUtils.antClassName = antapplet.getClass().getName();
        }

        /**
         * creates an instance with a {@link #envUtils JXAenvUtils} instance. This the default no argument constructor.
         */
        public JFCApplet() {
                super();
                envUtils = new JXAenvUtils(Thread.currentThread().getContextClassLoader());
                LogManager.getLogManager().addLogger(envUtils);
        }

        /**
         *
         * @return
         */
        @Override
        public String[][] getParameterInfo() {
                LinkedList<String[]> p = new LinkedList<String[]>();
                p.add(new String[]{JXA_DEBUG_RENDER, "boolean", "enable render-level debugging (system property overrides it)"});
                p.add(new String[]{ANT_APPLET, "String", "AntApplet class binary name (system property overrides it)"});
                p.add(new String[]{JXA_DEBUG, "boolean", "enable api-level debugging (system property overrides it)"});
                p.add(new String[]{JXA_DEBUG_SYS, "boolean", "enable kernel-level debugging (system property overrides it)"});
                p.add(new String[]{JXA_DEBUG_CSL, "boolean", "enable Console.class-level debugging (system property overrides it)"});
                p.add(new String[]{JXA_DEBUG_SPM, "boolean", "enable SpritesCacheManager.class-level debugging (system property overrides it)"});
                p.add(new String[]{JXA_DEBUG_ECL, "boolean", "enable ExtensionsClassLoader debugging (system property overrides it)"});
                p.add(new String[]{JXA_DEBUG_VOID, "boolean", "enable Void (useless traces) debugging (system property overrides it)"});
                p.add(new String[]{ANT_ARGS_LINE, "String", "args passed to the underlying AntApplet constructor (will handle -D system properties only)"});
                p.add(new String[]{LOCAL, "boolean", "run applet locally (jar extensions won't be downloaded remotely) (system property overrides it)"});
                p.add(new String[]{APPLET_CLASSPATH, "String", "',' (comma) separated classpath (will be handled like if it was the <Applet archive=....> contents) (system property overrides it)"});
                p.add(new String[]{APPLET_KEEP_REMOTE, "boolean", "the kernel classloader to load everything from remotely based resources, using standard java Jar cache (only natives are downloaded)"});
                return p.toArray(new String[][]{});
        }
        /**
         * defines the param "antargs" that may contain arguments sent to the
         * underlying antapplet contructor
         */
        public static final String ANT_ARGS_LINE = "antargs";
        /**
         * defines the param "keepremote" which tells the kernel classloader to
         * load everything from remotely based resources, using standard java
         * Jar cache (only natives are downloaded)
         *
         * @see JXAenvUtils#keepReadingOnRemoteJarResources
         */
        public static final String APPLET_KEEP_REMOTE = "keepremote";

        private static void __restartIfNoContext(AntApplet aA) {
                aA.stop();
                aA.destroy();
                aA.init();
                aA.start();
        }

        /**
         * @param a an AntApplet instance; for a deep restart, it should return
         * the root JFCApplet in the overriding method
         * {@link AntApplet#getApplet()} (set by default on loading by
         * {@link AntApplet#setApplet(JApple)}
         */
        public static void _restart(AntApplet a) {
                restartingEnv = true;
                JApplet aA = a.getApplet();
                if (aA != null && !(aA instanceof JFCApplet ? ((JFCApplet) aA).noStub : false)) {
                        aA.getAppletContext().showDocument(aA.getDocumentBase());
                } else {
                        __restartIfNoContext(a);
                }
        }

        /**
         * inits the applet
         */
        @Override
        public final void init() {
                jfcApplet.doLater(new Runnable() {
                        public void run() {
                                try {
                                        invokeSwingAndReturn(new SwingStaticReturn() {
                                                public Object run() {
                                                        _init();
                                                        return null;
                                                }
                                        });
                                } catch (Exception ex) {
                                        if (JXAenvUtils._debugSys) {
                                                ex.printStackTrace();
                                        }
                                }
                        }
                });
        }

        private void _init() {
                if (targetApplet != null) {
                        if (targetApplet.isInitialized()) {
                                return;
                        }
                }
                JXAenvUtils._defaultGC = getGraphicsConfiguration();
                getContentPane().removeAll();
                validate();
                /**
                 * copy Applet parameters into current instance
                 */
                if (targetApplet == null) {
                        /**
                         * UID for the application
                         */
                        if (envUtils.antClassName == null) {
                                envUtils.antClassName = getParameter(ANT_APPLET);
                        }
                        JXAenvUtils._setSysValue(env.APP_APPLET.propertyName(), env.APP_APPLET.propertyValue());
                        /*
             * BEGIN system properties
                         */
                        if (getParameter(JXA_DEBUG) != null && JXAenvUtils._getSysValue(JXA_DEBUG) == null) {
                                JXAenvUtils._debug = Boolean.parseBoolean(getParameter(JXA_DEBUG)) || JXAenvUtils._debug;
                        }
                        if (getParameter(JXA_DEBUG_SYS) != null && JXAenvUtils._getSysValue(JXA_DEBUG_SYS) == null) {
                                JXAenvUtils._debugSys = Boolean.parseBoolean(getParameter(JXA_DEBUG_SYS)) || JXAenvUtils._debugSys;
                        }
                        if (getParameter(JXA_DEBUG_RENDER) != null && JXAenvUtils._getSysValue(JXA_DEBUG_RENDER) == null) {
                                JXAenvUtils._setSysValue(JXA_DEBUG_RENDER, getParameter(JXA_DEBUG_RENDER));
                        }
                        if (getParameter(JXA_DEBUG_CSL) != null && JXAenvUtils._getSysValue(JXA_DEBUG_CSL) == null) {
                                JXAenvUtils._setSysValue(JXA_DEBUG_CSL, getParameter(JXA_DEBUG_CSL));
                                DebugMap._getInstance().setJXADebugSysEnabled(JXAenvUtils._getSysBoolean(JXA_DEBUG_CSL), Console.class);
                        }
                        if (getParameter(JXA_DEBUG_SPM) != null && JXAenvUtils._getSysValue(JXA_DEBUG_SPM) == null) {
                                JXAenvUtils._setSysValue(JXA_DEBUG_SPM, getParameter(JXA_DEBUG_SPM));
                                DebugMap._getInstance().setJXADebugSysEnabled(JXAenvUtils._getSysBoolean(JXA_DEBUG_SPM), SpritesCacheManager.class);
                        }
                        if (getParameter(JXA_DEBUG_ECL) != null && JXAenvUtils._getSysValue(JXA_DEBUG_ECL) == null) {
                                JXAenvUtils._setSysValue(JXA_DEBUG_ECL, getParameter(JXA_DEBUG_ECL));
                                DebugMap._getInstance().setJXADebugSysEnabled(JXAenvUtils._getSysBoolean(JXA_DEBUG_ECL), ExtensionsClassLoaderImpl.class);
                        }
                        if (getParameter(JXA_DEBUG_VOID) != null && JXAenvUtils._getSysValue(JXA_DEBUG_VOID) == null) {
                                JXAenvUtils._setSysValue(JXA_DEBUG_VOID, getParameter(JXA_DEBUG_VOID));
                                DebugMap._getInstance().setDebugLevelEnabled(JXAenvUtils._getSysBoolean(JXA_DEBUG_VOID), DebugMap._getInstance()._VOID);
                        }
                        if (getParameter(LOCAL) != null && JXAenvUtils._getSysValue(LOCAL) == null) {
                                _localApplet = Boolean.parseBoolean(getParameter(LOCAL)) || _localApplet;
                        }
                        if (getParameter(APPLET_KEEP_REMOTE) != null) {
                                envUtils.keepReadingOnRemoteJarResources = Boolean.parseBoolean(getParameter(APPLET_KEEP_REMOTE));
                        }
                        /**
                         * APPLET CLASS PATH CONFIGURATION
                         */
                        if (getParameter(APPLET_CLASSPATH) != null) {
                                _appletClasspath = getParameter(APPLET_CLASSPATH);
                        }
                        /*
             * END system properties
                         */
                        if (getParameter(ANT_ARGS_LINE) != null) {
                                Vector<String> appletArgs = new Vector<String>();
                                for (String t : getParameter(ANT_ARGS_LINE).split("\\s")) {
                                        appletArgs.add(t);
                                }
                                args = appletArgs.toArray(new String[]{});
                                _parseSystemArgs(args);
                        }
                }
                if (_appletClasspath != null) {
                        JXAenvUtils._setSysValue(env.APP_REMOTE.propertyName(), env.APP_REMOTE.propertyValue());
                        List<URL> classPathAddUrls = new LinkedList<URL>();
                        URL kernelCS = getClass().getProtectionDomain().getCodeSource().getLocation();
                        URL CS;
                        try {
                                CS = new URL(kernelCS.toExternalForm().substring(0, Math.max(0, kernelCS.toExternalForm().lastIndexOf("/api"))) + "/");
                                for (String jar : _appletClasspath.split(",")) {
                                        try {
                                                classPathAddUrls.add(new URL(CS, jar));
                                        } catch (MalformedURLException ex) {
                                                if (JXAenvUtils._debugSys) {
                                                        ex.printStackTrace();
                                                }
                                        }
                                }
                        } catch (MalformedURLException ex) {
                                if (JXAenvUtils._debugSys) {
                                        ex.printStackTrace();
                                }
                        } finally {
                                /**
                                 * per-app install folder
                                 */
                                File path = new File(envUtils.getJXAenvPath() + File.separator + envUtils.antClassName);
                                path.mkdirs();
                                envUtils.setJXAenvPath(path.getAbsolutePath());
                                envUtils.setSplashPicture(new DisplayInterface() {
                                        public Image getPicture() {
                                                return null;
                                        }
                                        JComponent comp = null;

                                        public JComponent getJComponentDisplay() {
                                                if (comp == null) {
                                                        comp = new JLabel("downloading...", new ImageIcon(JFCApplet.class.getResource("/net/sf/jiga/xtended/ui/images/ajax-loader.gif")), SwingConstants.LEADING);
                                                        comp.addMouseListener(new MouseAdapter() {
                                                                @Override
                                                                public void mouseClicked(MouseEvent e) {
                                                                        super.mouseClicked(e);
                                                                        try {
                                                                                final JTextArea logging = new JTextArea(10, 30);

                                                                                final JScrollPane jsp = new JScrollPane(logging);
                                                                                log.addInputLogListener(new InputLogListener() {
                                                                                        public void newLogPacket(String message) {
                                                                                                int max = jsp.getVerticalScrollBar().getMaximum() - jsp.getVerticalScrollBar().getVisibleAmount();
                                                                                                /**
                                                                                                 * append
                                                                                                 */
                                                                                                logging.append(message);
                                                                                                /*
                                                 * scroll... *
                                                                                                 */
                                                                                                if (!jsp.getVerticalScrollBar().getValueIsAdjusting() && jsp.getVerticalScrollBar().getValue() >= max) {
                                                                                                        /**
                                                                                                         * ...to
                                                                                                         * bottom
                                                                                                         * of
                                                                                                         * the
                                                                                                         * log
                                                                                                         */
                                                                                                        jsp.getVerticalScrollBar().setValue(jsp.getVerticalScrollBar().getMaximum() - jsp.getVerticalScrollBar().getVisibleAmount());
                                                                                                }
                                                                                        }
                                                                                });
                                                                                logging.addMouseWheelListener(new MouseWheelListener() {
                                                                                        public void mouseWheelMoved(MouseWheelEvent e) {
                                                                                                int val = jsp.getVerticalScrollBar().getValue();
                                                                                                if (e.getScrollType() == MouseWheelEvent.WHEEL_UNIT_SCROLL) {
                                                                                                        val += e.getUnitsToScroll() * jsp.getVerticalScrollBar().getUnitIncrement();
                                                                                                }
                                                                                                if (e.getScrollType() == MouseWheelEvent.WHEEL_BLOCK_SCROLL) {
                                                                                                        val += e.getScrollAmount() * jsp.getVerticalScrollBar().getBlockIncrement();
                                                                                                }
                                                                                                jsp.getVerticalScrollBar().setValue(Math.max(jsp.getVerticalScrollBar().getMinimum(), Math.min(val, jsp.getVerticalScrollBar().getMaximum() - jsp.getVerticalScrollBar().getVisibleAmount())));
                                                                                        }
                                                                                });
                                                                                popup = UIMessage.showLightPopupMessage(jsp, new AbstractAction("copy to clipboard") {
                                                                                        public void actionPerformed(ActionEvent e) {
                                                                                                Clipboard c = Toolkit.getDefaultToolkit().getSystemClipboard();
                                                                                                c.setContents(new Transferable() {
                                                                                                        public DataFlavor[] getTransferDataFlavors() {
                                                                                                                return new DataFlavor[]{DataFlavor.stringFlavor};
                                                                                                        }

                                                                                                        public boolean isDataFlavorSupported(DataFlavor flavor) {
                                                                                                                return DataFlavor.stringFlavor.equals(flavor);
                                                                                                        }

                                                                                                        public Object getTransferData(DataFlavor flavor) throws UnsupportedFlavorException, IOException {
                                                                                                                return logging.getText();
                                                                                                        }
                                                                                                }, new ClipboardOwner() {
                                                                                                        public void lostOwnership(Clipboard clipboard, Transferable contents) {
                                                                                                        }
                                                                                                });
                                                                                        }
                                                                                }, JFCApplet.this.getRootPane(), UIMessage.UI_TOP_LEFT);
                                                                                comp.setToolTipText("watch log...");
                                                                                log.setLogStdoutEnabled(true);
                                                                                log.setLogStderrEnabled(true);
                                                                        } catch (IOException ex) {
                                                                                ex.printStackTrace();
                                                                        }
                                                                }
                                                        });
                                                }
                                                return comp;
                                        }
                                });
                                /**
                                 * CLASS LOADER CONFIGURATION
                                 */
                                if (!envUtils.keepReadingOnRemoteJarResources) {
                                        /**
                                         * download everything before to launch
                                         * the applet
                                         */
                                        envUtils.addEnvJars(classPathAddUrls.toArray(new URL[]{}));
                                }
                        }
                }
                jfcApplet.doLater(new Runnable() {
                        public void run() {
                                try {
                                        if (targetApplet == null) {
                                                envUtils.setAntApplet(JFCApplet.this);
                                                envUtils.showSplash();
                                                /**
                                                 * DOWNLOAD and INSTALL
                                                 * jigaxtended env CLASS PATH
                                                 * FILES ARE DOWNLOADED
                                                 */
                                                install();
                                        }
                                        invokeSwingAndReturn(new SwingStaticReturn() {
                                                public Object run() {

                                                        try {
                                                                if (targetApplet == null) {
                                                                        envUtils.hideSplash();
                                                                        /**
                                                                         * CLIENT
                                                                         * ANTAPPLET
                                                                         * IS
                                                                         * INSTANCIED
                                                                         */
                                                                        targetApplet = AccessController.doPrivileged(new PrivilegedExceptionAction<AntApplet>() {
                                                                                public AntApplet run() throws ClassNotFoundException, NoSuchMethodException, InstantiationException, IllegalAccessException, IllegalArgumentException, InvocationTargetException {
                                                                                        Object o = ExtensionsClassLoader.forName(envUtils.antClassName).getConstructor(new Class[]{String[].class}).newInstance(new Object[]{args});
                                                                                        AntApplet a = ExtensionsClassLoader._proxyClass(o, AntApplet.class);
                                                                                        return a;
                                                                                }
                                                                        }, _acc);
                                                                        envUtils.setAntApplet(targetApplet);
                                                                }
                                                                if (targetApplet != null) {
                                                                        if (targetApplet.shutdownHook() != null) {
                                                                                envUtils.addPreUEnvLayer(targetApplet.shutdownHook());
                                                                        }
                                                                        targetApplet.setApplet(JFCApplet.this);
                                                                        envUtils._switchToClassLoader(ExtensionsClassLoader.getInstance().getClassLoader());
                                                                        AntHandler._load(targetApplet, targetApplet.getSplash(), null, targetApplet.getLoadLayers());
                                                                        targetApplet.init();
                                                                }
                                                        } catch (Throwable ex) {
                                                                if (ex instanceof PrivilegedActionException) {
                                                                        ex = ((PrivilegedActionException) ex).getException();
                                                                }
                                                                if (JXAenvUtils._debugSys) {
                                                                        ex.printStackTrace();
                                                                }

                                                                // a reloading is made (classpath fix)
                                                                if (!noStub) {
                                                                        getAppletContext().showDocument(getDocumentBase(), "_self");
                                                                } else {
                                                                        JXAenvUtils._popExceptionToUser(true, Thread.currentThread(), ex);
                                                                        __restartIfNoContext(JFCApplet.this);
                                                                }
                                                        } finally {
                                                                return null;
                                                        }
                                                }
                                        });
                                } catch (Throwable ex) {
                                        if (JXAenvUtils._debugSys) {
                                                ex.printStackTrace();
                                        }
                                }
                        }
                });
        }
        private ThreadWorks jfcApplet = new ThreadWorks("applet");

        /**
         * allows to check for any parameter without throwing a NPException
         * @param name
         * @return 
         */
        @Override
        public String getParameter(String name) {
                if (noStub) {
                        return null;
                }
                return super.getParameter(name); //To change body of generated methods, choose Tools | Templates.
        }

        /**
         * does nothing
         */
        public final void setApplet(final JApplet owner) {
                if (targetApplet != null) {
                        targetApplet.setApplet(owner);
                }
        }

        public final boolean open(final Object data) {
                if (targetApplet != null) {
                        if (targetApplet.isInitialized()) {
                                return targetApplet.open(data);
                        }
                }
                return false;
        }

        /**
         * returns this instance
         */
        public final JApplet getApplet() {
                if (targetApplet != null) {
                        return targetApplet.getApplet();
                }
                return JFCApplet.this;
        }

        public final boolean save(final String file) {
                if (targetApplet != null) {
                        if (targetApplet.isInitialized()) {
                                return targetApplet.save(file);
                        }
                }
                return false;
        }

        /**
         *
         * @return
         */
        public final DataFlavor[] getTransferDataFlavors() {
                if (targetApplet != null) {
                        if (targetApplet.isInitialized()) {
                                return targetApplet.getTransferDataFlavors();
                        }
                }
                return null;
        }

        /**
         *
         * @param flavor
         * @return
         */
        public final boolean isDataFlavorSupported(final DataFlavor flavor) {
                if (targetApplet != null) {
                        if (targetApplet.isInitialized()) {
                                return targetApplet.isDataFlavorSupported(flavor);
                        }
                }
                return false;
        }

        /**
         *
         * @param flavor
         * @return
         * @throws UnsupportedFlavorException
         * @throws IOException
         */
        public final Object getTransferData(final DataFlavor flavor) throws UnsupportedFlavorException, IOException {
                if (targetApplet != null) {
                        if (targetApplet.isInitialized()) {
                                return targetApplet.getTransferData(flavor);
                        }
                }
                return null;
        }

        public final Runnable shutdownHook() {
                if (targetApplet != null) {
                        return targetApplet.shutdownHook();
                }
                return null;
        }

        /**
         * @param args valid options are -antapplet [Japplet class binary name]
         * -width [px size] -height [px size] -device [device id]
         * @return 
         */
        public static JFCApplet launchAppletFrame(String[] args) {
                String antapplet = null;
                final Dimension size = new Dimension(600, 500);
                /**
                 * in case the arguments were inline (MacOS bundle)
                 */
                if (args.length == 1) {
                        args = args[0].split("\\s");
                }
                
                for (int i = 0; i < args.length; i++) {
                        if ("-antapplet".equals(args[i]) && i + 1 < args.length) {
                                antapplet = args[i + 1];
                                JXAenvUtils._setSysValue(env.APP_APPLET.propertyName(), env.APP_APPLET.propertyValue());
                        }
                        if ("-width".equals(args[i]) && i + 1 < args.length) {
                                size.width = Integer.parseInt(args[i + 1]);
                        }
                        if ("-height".equals(args[i]) && i + 1 < args.length) {
                                size.height = Integer.parseInt(args[i + 1]);
                        }
                        if ("-device".equals(args[i]) && i + 1 < args.length) {
                                int dev = Integer.parseInt(args[i + 1]);
                                GraphicsDevice[] devs = GraphicsEnvironment.getLocalGraphicsEnvironment().getScreenDevices();
                                JXAenvUtils._defaultGC = devs.length > dev ? devs[dev].getDefaultConfiguration() : devs[0].getDefaultConfiguration();
                                if (devs.length < dev) {
                                        JXAenvUtils._popExceptionToUser(true, Thread.currentThread(), new IllegalArgumentException("-device argument value is invalid " + devs.length + " screens were detected"));
                                }
                        }
                        if (DebugMap._getInstance().isJXADebugSysEnabled()) {
                                UIMessage.showLightPopupMessage(new JLabel("args " + Arrays.toString(args)), null, null, UIMessage.UI_TOP_LEFT);
                        }
                        /**
                         * jwrapper parameters stored in classpath file
                         */
                        parseJVMArgs(args, i);
                }
                assert antapplet != null : "Please set AntApplet implementation -antapplet package.antappletimplementation !";
                final JFCApplet applet = new JFCApplet(antapplet, args);
                applet.noStub = true;
                final JFrame frame = new JFrame(JXAenvUtils._defaultGC);
                Container c = frame.getContentPane();
                c.setLayout(new BorderLayout());
                c.add(applet, BorderLayout.CENTER);
                frame.setPreferredSize(size);
                frame.setSize(size);
                frame.setDefaultCloseOperation(WindowConstants.EXIT_ON_CLOSE);
                /*
         * frame.setLocationByPlatform(true);
                 */
                frame.setLocationRelativeTo(null);
                applet.init();
                frame.pack();
                frame.setVisible(true);
                applet.start();
                return applet;
        }
        /**
         * it is set to true if no AppletStub is available (in case the applet
         * was not launched by any applet viewer or any browser)
         */
        protected boolean noStub = false;

        /**
         * @param args at least "-antframe package.theantframe" must be
         * specified
         */
        public static void main(final String[] args) {
                ThreadWorks.Swing.invokeLater(new Runnable() {
                        public void run() {
                                launchAppletFrame(args);
                        }
                });
        }
        String[] args = null;

        public DisplayInterface getSplash() {
                try {
                        return invokeSwingAndReturn(new SwingStaticReturn<DisplayInterface>() {
                                public DisplayInterface run() {
                                        if (targetApplet != null) {
                                                return ExtensionsClassLoader._proxyClass(targetApplet.getSplash(), DisplayInterface.class);
                                        } else {
                                                try {
                                                        return Display._Display(ExtensionsInstaller.splashPic, null);
                                                } catch (Exception ex) {
                                                        if (JXAenvUtils._debugSys) {
                                                                ex.printStackTrace();
                                                        }
                                                        return null;
                                                }
                                        }
                                }
                        });
                } catch (Exception ex) {
                        if (JXAenvUtils._debugSys) {
                                ex.printStackTrace();
                        }
                        return null;
                }
        }

        public List<Action> getLoadLayers() {
                try {
                        return invokeSwingAndReturn(new SwingStaticReturn<List<Action>>() {
                                public List<Action> run() {
                                        if (targetApplet != null) {
                                                return targetApplet.getLoadLayers();
                                        } else {
                                                return null;
                                        }
                                }
                        });
                } catch (Exception ex) {
                        if (JXAenvUtils._debugSys) {
                                ex.printStackTrace();
                        }
                        return null;
                }
        }
}
