package net.sf.sido.array;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

public class ArrayEvent<T> implements Iterable<ArrayEventElement<T>>,
		Serializable {

	/**
	 * Version number
	 */
	private static final long serialVersionUID = 1;

	public static <E> ArrayEvent<E> from(List<E> list, ArrayEventType type,
			int... indexes) {
		ArrayEvent<E> e = new ArrayEvent<E>();
		for (int index : indexes) {
			E value = list.get(index);
			e.add(index, type, value);
		}
		return e;
	}

	private final List<ArrayEventElement<T>> eventElements = new ArrayList<ArrayEventElement<T>>();

	public ArrayEvent<T> add(int index, ArrayEventType type, T value) {
		this.eventElements.add(new ArrayEventElement<T>(index, type, value));
		return this;
	}

	public List<ArrayEventElement<T>> getEventElements() {
		return this.eventElements;
	}

	@Override
	public Iterator<ArrayEventElement<T>> iterator() {
		return this.eventElements.iterator();
	}

}
