package net.sf.sido.array;

import java.io.Serializable;

public class ArrayEventElement<T> implements Serializable {

	/**
	 * Version number
	 */
	private static final long serialVersionUID = 1;

	private final int index;
	private final ArrayEventType type;
	private final T value;

	public ArrayEventElement(int index, ArrayEventType type, T value) {
		this.index = index;
		this.type = type;
		this.value = value;
	}

	public int getIndex() {
		return this.index;
	}

	public ArrayEventType getType() {
		return this.type;
	}

	public T getValue() {
		return this.value;
	}

}
