package net.sf.sido.spring.mvc;

import java.io.IOException;

import net.sf.sido.DataFactory;
import net.sf.sido.DataObject;
import net.sf.sido.io.DataObjectReader;
import net.sf.sido.io.DataObjectWriter;

import org.springframework.http.HttpInputMessage;
import org.springframework.http.HttpOutputMessage;
import org.springframework.http.MediaType;
import org.springframework.http.converter.AbstractHttpMessageConverter;
import org.springframework.http.converter.HttpMessageNotReadableException;
import org.springframework.http.converter.HttpMessageNotWritableException;

public class AbstractDataObjectHttpMessageConverter<T, N> extends AbstractHttpMessageConverter<DataObject> {

	private final DataFactory factory;
	private final DataObjectReader<T> doReader;
	private final DataObjectWriter<T, N> doWriter;

	public AbstractDataObjectHttpMessageConverter(MediaType mediaType, DataFactory factory, DataObjectReader<T> doReader, DataObjectWriter<T, N> doWriter) {
		super(mediaType);
		this.factory = factory;
		this.doReader = doReader;
		this.doWriter = doWriter;
	}

	@Override
	protected DataObject readInternal(Class<? extends DataObject> clazz, HttpInputMessage inputMessage) throws IOException, HttpMessageNotReadableException {
		return doReader.read(inputMessage.getBody(), factory);
	}

	@Override
	protected boolean supports(Class<?> clazz) {
		return DataObject.class.isAssignableFrom(clazz);
	}

	@Override
	protected void writeInternal(DataObject t, HttpOutputMessage outputMessage) throws IOException, HttpMessageNotWritableException {
		doWriter.write(outputMessage.getBody(), t);
	}

}
