package net.sf.sido.spring.mvc;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;

import javax.annotation.PostConstruct;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.converter.HttpMessageConverter;
import org.springframework.stereotype.Component;
import org.springframework.web.bind.support.WebArgumentResolver;
import org.springframework.web.servlet.mvc.annotation.AnnotationMethodHandlerAdapter;

@Component
public class SiDOSpringMVCAdapter {

	private final AnnotationMethodHandlerAdapter adapter;

	private final List<HttpMessageConverter<?>> extMessageConverterList;
	private final List<WebArgumentResolver> extArgumentResolverList;

	@Autowired
	public SiDOSpringMVCAdapter(AnnotationMethodHandlerAdapter adapter,
			List<HttpMessageConverter<?>> extMessageConverterList, List<WebArgumentResolver> extArgumentResolverList) {
		this.adapter = adapter;
		this.extMessageConverterList = extMessageConverterList;
		this.extArgumentResolverList = extArgumentResolverList;
	}

	@PostConstruct
	public void init() {
		// Registers the new message converters
		HttpMessageConverter<?>[] messageConverters = adapter.getMessageConverters();
		List<HttpMessageConverter<?>> messageConverterList = new ArrayList<HttpMessageConverter<?>>(
				Arrays.asList(messageConverters));
		messageConverterList.addAll(0, extMessageConverterList);
		adapter.setMessageConverters(messageConverterList.toArray(new HttpMessageConverter<?>[messageConverterList.size()]));
		// Registers the new argument resolvers
		adapter.setCustomArgumentResolvers(extArgumentResolverList.toArray(new WebArgumentResolver[extArgumentResolverList.size()]));
	}

}
