/*
 * Decompiled with CFR 0.152.
 */
package net.sf.sido.spring.mvc;

import java.io.IOException;
import java.io.InputStream;
import java.util.Map;
import javax.servlet.ServletInputStream;
import javax.servlet.ServletRequest;
import net.sf.sido.DOTypeNotFoundException;
import net.sf.sido.DataFactory;
import net.sf.sido.DataObject;
import net.sf.sido.DataType;
import net.sf.sido.Property;
import net.sf.sido.ValidationResults;
import net.sf.sido.io.DataObjectReader;
import net.sf.sido.io.json.JSONDataObjectReader;
import net.sf.sido.io.xml.XMLDataObjectReader;
import net.sf.sido.spring.mvc.HasDataType;
import org.apache.commons.lang.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.core.MethodParameter;
import org.springframework.stereotype.Component;
import org.springframework.web.bind.support.WebArgumentResolver;
import org.springframework.web.context.request.NativeWebRequest;

@Component
public class DataObjectArgumentResolver
implements WebArgumentResolver {
    public static final String REQUEST_PARAMETER_TYPE = "sido:type";
    private final DataFactory dataFactory;

    @Autowired
    public DataObjectArgumentResolver(DataFactory dataFactory) {
        this.dataFactory = dataFactory;
    }

    protected void check(DataObject o, MethodParameter methodParameter) {
        ValidationResults results;
        HasDataType hasDataType = (HasDataType)methodParameter.getParameterAnnotation(HasDataType.class);
        if (hasDataType != null && hasDataType.validate() && !(results = o.validate()).isValid()) {
            throw new IllegalStateException(String.format("Cannot validate DataObject %s: %s", methodParameter.getParameterName(), results.getErrors()));
        }
    }

    protected DataType getType(MethodParameter methodParameter, NativeWebRequest webRequest, boolean typeRequired) {
        HasDataType hasDataType = (HasDataType)methodParameter.getParameterAnnotation(HasDataType.class);
        if (hasDataType != null) {
            String dataTypeName = hasDataType.value();
            return this.getTypeFromName(dataTypeName);
        }
        String typeName = webRequest.getParameter(REQUEST_PARAMETER_TYPE);
        if (StringUtils.isBlank((String)typeName)) {
            if (typeRequired) {
                throw new IllegalStateException(String.format("Type for DataObject %s is required. You can use a HasDataType annotation on the parameter or add a %s parameter in the request.", methodParameter.getParameterName(), REQUEST_PARAMETER_TYPE));
            }
            return null;
        }
        return this.getTypeFromName(typeName);
    }

    protected DataType getTypeFromName(String dataTypeName) {
        DataType dataType = this.dataFactory.getType(dataTypeName);
        if (dataType == null) {
            throw new DOTypeNotFoundException(dataTypeName);
        }
        return dataType;
    }

    public Object resolveArgument(MethodParameter methodParameter, NativeWebRequest webRequest) throws Exception {
        if (DataObject.class.equals((Object)methodParameter.getParameterType())) {
            return this.resolveInternal(methodParameter, webRequest);
        }
        return UNRESOLVED;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected <T> DataObject resolveArgumentFromInputStream(MethodParameter methodParameter, NativeWebRequest webRequest, DataObjectReader<T> reader) throws IOException {
        ServletRequest req = (ServletRequest)webRequest.getNativeRequest();
        ServletInputStream in = req.getInputStream();
        try {
            DataType dataType = this.getType(methodParameter, webRequest, false);
            DataObject o = reader.read((InputStream)in, this.dataFactory, dataType);
            this.check(o, methodParameter);
            DataObject dataObject = o;
            return dataObject;
        }
        finally {
            in.close();
        }
    }

    protected DataObject resolveArgumentFromParameters(MethodParameter methodParameter, NativeWebRequest webRequest) {
        DataType dataType = this.getType(methodParameter, webRequest, true);
        HasDataType hasDataType = (HasDataType)methodParameter.getParameterAnnotation(HasDataType.class);
        DataObject o = dataType.newInstance();
        if (hasDataType != null && hasDataType.init()) {
            o.init(true);
        }
        Map parameters = webRequest.getParameterMap();
        for (Map.Entry entry : parameters.entrySet()) {
            String name = (String)entry.getKey();
            String[] values = (String[])entry.getValue();
            Property property = dataType.getProperty(name);
            if (property == null) continue;
            o.setAsString(name, values);
        }
        this.check(o, methodParameter);
        return o;
    }

    protected DataObject resolveInternal(MethodParameter methodParameter, NativeWebRequest webRequest) throws IOException {
        ServletRequest req = (ServletRequest)webRequest.getNativeRequest(ServletRequest.class);
        String contentType = req.getContentType();
        if (contentType != null && contentType.startsWith("sido/json")) {
            return this.resolveArgumentFromInputStream(methodParameter, webRequest, (DataObjectReader)new JSONDataObjectReader());
        }
        if (contentType != null && contentType.startsWith("sido/xml")) {
            return this.resolveArgumentFromInputStream(methodParameter, webRequest, (DataObjectReader)new XMLDataObjectReader());
        }
        return this.resolveArgumentFromParameters(methodParameter, webRequest);
    }
}

